/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpRemoveDocTagQuickFix
implements LocalQuickFix {
    private final String myName;

    public PhpRemoveDocTagQuickFix(@NotNull String tagName) {
        if (tagName == null) {
            PhpRemoveDocTagQuickFix.$$$reportNull$$$0(0);
        }
        this.myName = tagName;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.remove.doc.tag.quick.fix.family.name", this.myName);
        if (string == null) {
            PhpRemoveDocTagQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpRemoveDocTagQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpRemoveDocTagQuickFix.$$$reportNull$$$0(3);
        }
        PhpRemoveDocTagQuickFix.remove((PhpDocTag)descriptor.getStartElement());
    }

    public static void remove(PhpDocTag docTag) {
        PhpDocComment comment = (PhpDocComment)PhpPsiUtil.getParentByCondition((PsiElement)docTag, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF);
        if (comment == null) {
            return;
        }
        if (PhpDocUtil.hasOnlyTagWithName(comment, docTag.getName())) {
            comment.delete();
        } else {
            docTag.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpRemoveDocTagQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpRemoveDocTagQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

