/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRedundantDocCommentInspection
extends PhpInspection {
    private static final LocalQuickFix REMOVE_PHP_DOC_COMMENT_FIX = new RemovePhpDocCommentQuickFix();
    private static final TokenSet NOT_MEANINGFUL_DOC_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpDocUtil.ALLOWED_PHP_DOC_TOKENS, TokenSet.WHITE_SPACE});
    private static final TokenSet MEANINGFUL_DOC_TOKENS = TokenSet.andNot((TokenSet)TokenSet.ANY, (TokenSet)NOT_MEANINGFUL_DOC_TOKENS);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpField(Field field) {
                if (field.isConstant() || field instanceof PhpDocProperty || PhpHierarchyChecksInspection.isGroupedDeclarations(field.getParentList())) {
                    return;
                }
                PhpDocComment docComment = field.getDocComment();
                if (docComment == null || !PhpRedundantDocCommentInspection.isRedundantPropertyDocComment(holder.getProject(), field, docComment)) {
                    return;
                }
                PsiElement nameIdentifier = field.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                TextRange nameRange = nameIdentifier.getTextRangeInParent().shiftRight(field.getTextRangeInParent().getStartOffset());
                holder.registerProblem(field.getParent(), TextRange.create((int)0, (int)nameRange.getEndOffset()), PhpBundle.message("inspection.redundant.phpdoc", new Object[0]), new LocalQuickFix[]{REMOVE_PHP_DOC_COMMENT_FIX});
            }

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }

            public void visitPhpFunction(Function function) {
                if (function.isClosure()) {
                    return;
                }
                PhpDocComment docComment = function.getDocComment();
                if (docComment == null || !PhpRedundantDocCommentInspection.isRedundantFunctionDocComment(holder.getProject(), function, docComment)) {
                    return;
                }
                PsiElement signatureLastChild = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(function.getLastChild(), true);
                if (signatureLastChild == null) {
                    return;
                }
                TextRange highlightTextRange = TextRange.create((int)0, (int)signatureLastChild.getTextRangeInParent().getEndOffset());
                holder.registerProblem((PsiElement)function, highlightTextRange, PhpBundle.message("inspection.redundant.phpdoc", new Object[0]), new LocalQuickFix[]{REMOVE_PHP_DOC_COMMENT_FIX});
            }
        };
    }

    public static boolean isRedundantPropertyDocComment(@NotNull Project project, @NotNull Field field, @NotNull PhpDocComment docComment) {
        ASTNode[] meaningfulNodes;
        if (project == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(1);
        }
        if (field == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(2);
        }
        if (docComment == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(3);
        }
        if ((meaningfulNodes = docComment.getNode().getChildren(MEANINGFUL_DOC_TOKENS)).length == 0) {
            return true;
        }
        if (meaningfulNodes.length != 1) {
            return false;
        }
        return PhpRedundantDocCommentInspection.isRedundantPropertyDocTag(project, field, meaningfulNodes[0].getPsi());
    }

    private static boolean isRedundantFunctionDocComment(@NotNull Project project, @NotNull Function function, @NotNull PhpDocComment docComment) {
        ASTNode[] meaningfulTags;
        if (project == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(4);
        }
        if (function == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(5);
        }
        if (docComment == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(6);
        }
        if ((meaningfulTags = docComment.getNode().getChildren(MEANINGFUL_DOC_TOKENS)).length == 0) {
            return true;
        }
        List paramTags = docComment.getParamTags();
        PhpDocReturnTag returnTag = docComment.getReturnTag();
        if (paramTags.size() + (returnTag == null ? 0 : 1) != meaningfulTags.length) {
            return false;
        }
        return PhpRedundantDocCommentInspection.isRedundantParamTags(project, Arrays.asList(function.getParameters()), paramTags) && PhpRedundantDocCommentInspection.isRedundantReturnTag(project, function, returnTag);
    }

    private static boolean isRedundantParamTags(@NotNull Project project, @NotNull List<Parameter> declaredParams, @NotNull List<PhpDocParamTag> paramTags) {
        if (project == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(7);
        }
        if (declaredParams == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(8);
        }
        if (paramTags == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(9);
        }
        if (declaredParams.size() != paramTags.size()) {
            return false;
        }
        for (Pair pair : ContainerUtil.zip(declaredParams, paramTags)) {
            Parameter parameter = (Parameter)pair.first;
            PhpDocParamTag paramTag = (PhpDocParamTag)pair.second;
            if (!StringUtil.isEmptyOrSpaces((String)paramTag.getTagValue())) {
                return false;
            }
            String docTagParameterName = paramTag.getVarName();
            if (docTagParameterName == null) {
                return false;
            }
            if (!docTagParameterName.equals(parameter.getName())) {
                return false;
            }
            if (parameter.isVariadic() != paramTag.isVariadic()) {
                return false;
            }
            if (PhpRedundantDocCommentInspection.isRedundantDocType(project, parameter.getDeclaredType(), (PhpDocTag)paramTag)) continue;
            return false;
        }
        return true;
    }

    private static boolean isRedundantReturnTag(@NotNull Project project, @NotNull Function function, @Nullable PhpDocReturnTag returnTag) {
        if (project == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(10);
        }
        if (function == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(11);
        }
        if (returnTag == null) {
            return true;
        }
        if (!StringUtil.isEmptyOrSpaces((String)returnTag.getTagValue())) {
            return false;
        }
        PhpReturnType functionReturnType = (PhpReturnType)function.getTypeDeclaration();
        if (functionReturnType == null) {
            return false;
        }
        return PhpRedundantDocCommentInspection.isRedundantDocType(project, functionReturnType.getDeclaredType(), (PhpDocTag)returnTag);
    }

    private static boolean isRedundantPropertyDocTag(@NotNull Project project, @NotNull Field field, @Nullable PsiElement tag) {
        PhpDocParamTag docTag;
        if (project == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(12);
        }
        if (field == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(13);
        }
        if ((docTag = (PhpDocParamTag)ObjectUtils.tryCast((Object)tag, PhpDocParamTag.class)) == null || !PhpRedundantDocCommentInspection.isTagApplicableForElement((PhpNamedElement)field, docTag)) {
            return false;
        }
        if (!StringUtil.isEmptyOrSpaces((String)docTag.getTagValue())) {
            return false;
        }
        String docTagFieldName = docTag.getVarName();
        if (StringUtil.isNotEmpty((String)docTagFieldName) && !docTagFieldName.equals(field.getName())) {
            return false;
        }
        return PhpRedundantDocCommentInspection.isRedundantDocType(project, field.getDeclaredType(), (PhpDocTag)docTag);
    }

    private static boolean isTagApplicableForElement(@NotNull PhpNamedElement element, @NotNull PhpDocParamTag docTag) {
        if (element == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(14);
        }
        if (docTag == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(15);
        }
        if (element instanceof Field) {
            String tagName = docTag.getName();
            return "@var".equals(tagName) || "@type".equals(tagName);
        }
        return false;
    }

    private static boolean isRedundantDocType(@NotNull Project project, @NotNull PhpType declaredType, @NotNull PhpDocTag docTag) {
        PhpType docType;
        if (project == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(16);
        }
        if (declaredType == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(17);
        }
        if (docTag == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(18);
        }
        if ((docType = docTag.getType()).isEmpty()) {
            return true;
        }
        if (declaredType.isEmpty()) {
            return false;
        }
        return declaredType.global(project).getTypes().containsAll(docType.global(project).getTypes()) && !PhpRedundantDocCommentInspection.isThirdPartyToolGenericType(docTag);
    }

    private static boolean isThirdPartyToolGenericType(@NotNull PhpDocTag docTag) {
        PhpDocType docType;
        if (docTag == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(19);
        }
        if ((docType = (PhpDocType)PhpPsiUtil.getChildByCondition((PsiElement)docTag, (Condition<? super PsiElement>)PhpDocType.INSTANCEOF)) == null) {
            return false;
        }
        return docType.getText().contains("<");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredParams";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramTags";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docTag";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpRedundantDocCommentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isRedundantPropertyDocComment";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isRedundantFunctionDocComment";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isRedundantParamTags";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isRedundantReturnTag";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isRedundantPropertyDocTag";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isTagApplicableForElement";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "isRedundantDocType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "isThirdPartyToolGenericType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RemovePhpDocCommentQuickFix
    implements LocalQuickFix {
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.remove.phpdoc", new Object[0]);
            if (string == null) {
                RemovePhpDocCommentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement docComment;
            if (project == null) {
                RemovePhpDocCommentQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemovePhpDocCommentQuickFix.$$$reportNull$$$0(2);
            }
            if ((docComment = RemovePhpDocCommentQuickFix.getDocComment(descriptor.getPsiElement())) == null) {
                return;
            }
            docComment.delete();
        }

        @Nullable
        private static PsiElement getDocComment(@Nullable PsiElement element) {
            if (PhpPsiUtil.isOfType(element, PhpElementTypes.CLASS_FIELDS)) {
                Field field = (Field)PhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)Field.INSTANCEOF);
                return field != null ? field.getDocComment() : null;
            }
            if (element instanceof PhpNamedElement) {
                return ((PhpNamedElement)element).getDocComment();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpRedundantDocCommentInspection$RemovePhpDocCommentQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpRedundantDocCommentInspection$RemovePhpDocCommentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

