/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpRemoveDocTagQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpInappropriateInheritDocUsageInspection
extends PhpInspection {
    private static final LocalQuickFix FIX = new PhpRemoveDocTagQuickFix("@inheritDoc");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpInappropriateInheritDocUsageInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpDocTag(PhpDocTag tag) {
                if (StringUtil.equalsIgnoreCase((CharSequence)"@inheritDoc", (CharSequence)tag.getName())) {
                    PhpDocComment comment = (PhpDocComment)PhpPsiUtil.getParentByCondition((PsiElement)tag, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF);
                    if (comment == null) {
                        return;
                    }
                    PsiElement owner = comment.getOwner();
                    if (owner == null) {
                        return;
                    }
                    if (!(owner instanceof PhpClassMember)) {
                        holder.registerProblem((PsiElement)tag, PhpBundle.message("inspection.php.inappropriate.inherit.doc.usage.description2", new Object[0]), new LocalQuickFix[]{FIX});
                        return;
                    }
                    PhpClass containingClass = ((PhpClassMember)owner).getContainingClass();
                    if (containingClass == null) {
                        return;
                    }
                    if (PhpInappropriateInheritDocUsageInspection.hasSuperMemberWithDocComment((PhpClassMember)owner) == Boolean.FALSE) {
                        holder.registerProblem((PsiElement)tag, PhpBundle.message("inspection.php.inappropriate.inherit.doc.usage.description", new Object[0]), new LocalQuickFix[]{FIX});
                    }
                }
            }
        };
    }

    @NotNull
    private static Boolean hasSuperMemberWithDocComment(PhpClassMember memberOwner) {
        Ref hasSuperDocComment = new Ref((Object)Boolean.FALSE);
        PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)memberOwner, (superMember, subClass, baseClass) -> {
            if (superMember.getDocComment() != null) {
                hasSuperDocComment.set((Object)Boolean.TRUE);
            }
            return hasSuperDocComment.get() == Boolean.FALSE;
        });
        Boolean bl = (Boolean)hasSuperDocComment.get();
        if (bl == null) {
            PhpInappropriateInheritDocUsageInspection.$$$reportNull$$$0(1);
        }
        return bl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpInappropriateInheritDocUsageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpInappropriateInheritDocUsageInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "hasSuperMemberWithDocComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

