/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocThrowsTag;
import com.jetbrains.php.lang.inspections.PhpThrownExceptionsAnalyzer;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFunctionDocCommentUpdater {
    private static final TokenSet PARAM_RETURN_THROWS_END = TokenSet.create((IElementType[])new IElementType[]{PhpDocElementTypes.phpDocParam, PhpDocElementTypes.phpDocReturn, PhpDocElementTypes.phpDocThrows, PhpDocTokenTypes.DOC_COMMENT_END});
    private final PhpDocComment myOriginal;
    private final Project myProject;
    private final boolean myUpdateExceptions;
    private final Function myFunction;
    private PhpPsiElement myUseOperatorScope;
    private final StringBuilder myTemplate;

    public PhpFunctionDocCommentUpdater(@NotNull Project project, @NotNull PhpDocComment original2) {
        if (project == null) {
            PhpFunctionDocCommentUpdater.$$$reportNull$$$0(0);
        }
        if (original2 == null) {
            PhpFunctionDocCommentUpdater.$$$reportNull$$$0(1);
        }
        this(project, original2, true);
    }

    public PhpFunctionDocCommentUpdater(@NotNull Project project, @NotNull PhpDocComment original2, boolean updateExceptions) {
        if (project == null) {
            PhpFunctionDocCommentUpdater.$$$reportNull$$$0(2);
        }
        if (original2 == null) {
            PhpFunctionDocCommentUpdater.$$$reportNull$$$0(3);
        }
        this.myTemplate = new StringBuilder();
        this.myOriginal = original2;
        this.myProject = project;
        this.myUpdateExceptions = updateExceptions;
        PsiElement owner = original2.getOwner();
        Function function = this.myFunction = owner instanceof Function ? (Function)owner : null;
        if (this.myFunction != null) {
            this.myUseOperatorScope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)this.myFunction);
        }
    }

    @Nullable
    public PhpDocComment constructUpdatedComment() {
        if (this.myFunction == null) {
            return null;
        }
        PsiElement paramPlace = this.findParameterPlace();
        if (paramPlace == null) {
            paramPlace = this.myOriginal.getFirstPsiChild();
            assert (paramPlace != null);
        }
        Map<Parameter, String> paramDocMap = this.collectExistingParamDoc();
        String returnDoc = this.collectExistingReturnDoc();
        Map<String, String> throwsDocMap = this.collectThrowsDoc();
        boolean skipTag = false;
        for (PsiElement nextChild = this.myOriginal.getFirstChild(); nextChild != null; nextChild = nextChild.getNextSibling()) {
            if (PhpFunctionDocCommentUpdater.isMultilineTagEnd(nextChild)) {
                skipTag = false;
            }
            if (nextChild instanceof PhpDocParamTag && !((PhpDocParamTag)nextChild).getName().equals("@global") || PhpPsiUtil.isOfType(nextChild, new IElementType[]{PhpDocElementTypes.phpDocReturn, PhpDocElementTypes.phpDocThrows})) {
                skipTag = true;
            } else if (PhpPsiUtil.isOfType(nextChild, PhpDocTokenTypes.DOC_COMMENT_END)) {
                PhpFunctionDocCommentUpdater.truncateEmptyLine(this.myTemplate);
                this.ensurePrevLineTerminated();
            }
            if (!skipTag) {
                this.myTemplate.append(nextChild.getText());
            }
            if (nextChild != paramPlace) continue;
            this.addParametersAndReturnTag(paramDocMap, throwsDocMap, returnDoc);
        }
        return PhpPsiElementFactory.createFromText(this.myProject, PhpDocComment.class, this.myTemplate.toString());
    }

    private String collectExistingReturnDoc() {
        PhpDocReturnTag returnTag = this.myOriginal.getReturnTag();
        if (returnTag != null) {
            StringBuilder builder = new StringBuilder();
            if (PhpDocSignatureInspection.returnTypesMatch(returnTag, this.myFunction) || this.myFunction.getDeclaredType().isEmpty() && !returnTag.getType().isEmpty()) {
                builder.append("* ").append(returnTag.getText());
            } else {
                builder.append("* @return ").append(this.getRetTypeString()).append(' ');
                PhpFunctionDocCommentUpdater.appendValue(builder, returnTag.getTagValue());
            }
            for (PsiElement next = returnTag.getNextSibling(); next != null && !PhpFunctionDocCommentUpdater.isMultilineTagEnd(next); next = next.getNextSibling()) {
                builder.append(next.getText());
            }
            PhpFunctionDocCommentUpdater.truncateEmptyLine(builder);
            return builder.toString();
        }
        return null;
    }

    private Map<String, String> collectThrowsDoc() {
        LinkedHashMap<String, String> throwsDocMap = new LinkedHashMap<String, String>();
        for (PsiElement child = this.myOriginal.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PhpDocThrowsTag)) continue;
            for (PsiElement throwsChild = child.getFirstChild(); throwsChild != null; throwsChild = throwsChild.getNextSibling()) {
                if (!(throwsChild instanceof PhpDocType)) continue;
                PhpType throwsType = ((PhpDocType)throwsChild).getType();
                PhpPsiElement ns = PhpCodeInsightUtil.findScopeForUseOperator(throwsChild);
                String typeText = PhpDocUtil.getTypePresentation(this.myProject, throwsType, ns);
                throwsDocMap.put(typeText, ((PhpDocTag)child).getTagValue());
            }
        }
        return throwsDocMap;
    }

    private static void truncateEmptyLine(StringBuilder template) {
        if (!StringUtil.endsWithChar((CharSequence)template, (char)'\n') && !StringUtil.equals((CharSequence)template, (CharSequence)"/**")) {
            String templateString = template.toString().trim();
            if (templateString.endsWith("*")) {
                templateString = templateString.substring(0, templateString.length() - 1).trim();
            }
            template.setLength(0);
            template.append(templateString);
        }
    }

    private Map<Parameter, String> collectExistingParamDoc() {
        HashMap<Parameter, String> paramDocMap = new HashMap<Parameter, String>();
        ParameterMatchInfo currParamMatchInfo = null;
        StringBuilder paramDocBuilder = new StringBuilder();
        for (PsiElement nextChild = this.myOriginal.getFirstChild(); nextChild != null; nextChild = nextChild.getNextSibling()) {
            if (currParamMatchInfo != null && PhpFunctionDocCommentUpdater.isMultilineTagEnd(nextChild)) {
                PhpFunctionDocCommentUpdater.truncateEmptyLine(paramDocBuilder);
                PhpFunctionDocCommentUpdater.addParamToMap(paramDocMap, currParamMatchInfo, paramDocBuilder.toString());
                currParamMatchInfo = null;
                paramDocBuilder = new StringBuilder();
            }
            if (nextChild instanceof PhpDocParamTag) {
                PhpDocParamTag docParamTag = (PhpDocParamTag)nextChild;
                currParamMatchInfo = this.getMatchingParameter(docParamTag);
                if (currParamMatchInfo == null) continue;
                paramDocBuilder.append("* ");
                if (PhpDocSignatureInspection.typesMatch(currParamMatchInfo.getParameter(), docParamTag, docParamTag.getType())) {
                    paramDocBuilder.append(nextChild.getText());
                    continue;
                }
                paramDocBuilder.append("@param ");
                PhpType parameterType = PhpDocUtil.getParameterType(currParamMatchInfo.myParameter);
                this.appendParamInfo(paramDocBuilder, currParamMatchInfo.myParameter, parameterType);
                PhpFunctionDocCommentUpdater.appendValue(paramDocBuilder, PhpDocUtil.getParamTagValue((PhpDocTag)docParamTag, this.myFunction));
                paramDocBuilder.append('\n');
                continue;
            }
            if (currParamMatchInfo == null) continue;
            paramDocBuilder.append(nextChild.getText());
        }
        if (currParamMatchInfo != null) {
            PhpFunctionDocCommentUpdater.truncateEmptyLine(paramDocBuilder);
            PhpFunctionDocCommentUpdater.addParamToMap(paramDocMap, currParamMatchInfo, paramDocBuilder.toString());
        }
        return paramDocMap;
    }

    private static void addParamToMap(Map<Parameter, String> paramMap, ParameterMatchInfo parameterMatchInfo, String paramDoc) {
        if (paramMap.containsKey(parameterMatchInfo.myParameter) && !parameterMatchInfo.isMatchedByName()) {
            return;
        }
        paramMap.put(parameterMatchInfo.getParameter(), paramDoc);
    }

    private static boolean isMultilineTagEnd(PsiElement element) {
        return element == null || PhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_COMMENT_END) || PhpFunctionDocCommentUpdater.isNonInlineTag(element);
    }

    private static boolean isNonInlineTag(@NotNull PsiElement element) {
        if (element == null) {
            PhpFunctionDocCommentUpdater.$$$reportNull$$$0(4);
        }
        if (element instanceof PhpDocTag) {
            PsiElement prev = element.getPrevSibling();
            if (prev instanceof PsiWhiteSpace) {
                prev = prev.getPrevSibling();
            }
            return PhpPsiUtil.isOfType(prev, PhpDocTokenTypes.DOC_LEADING_ASTERISK);
        }
        return false;
    }

    private void ensurePrevLineTerminated() {
        String lineStart;
        int lastLFPos = this.myTemplate.lastIndexOf("\n");
        String string = lineStart = lastLFPos > 0 ? this.myTemplate.substring(lastLFPos) : this.myTemplate.toString();
        if (!lineStart.trim().isEmpty()) {
            this.myTemplate.append('\n');
        }
    }

    private void appendParamInfo(StringBuilder template, Parameter param, PhpType paramType) {
        boolean isVariadic = param.isVariadic();
        String typeString = PhpDocUtil.getTypePresentation(this.myProject, isVariadic ? paramType.unpluralize() : paramType, this.myUseOperatorScope, param.getTypeDeclaration());
        if (!typeString.isEmpty()) {
            template.append(typeString);
            if (!PhpType.intersects((PhpType)paramType, (PhpType)PhpType.NULL) && PhpLangUtil.isNull(param.getDefaultValue())) {
                template.append("|null");
            }
            template.append(' ');
        }
        if (isVariadic) {
            template.append("...");
        }
        template.append('$').append(param.getName()).append(' ');
    }

    private static void appendValue(StringBuilder template, String value) {
        if (value.isEmpty()) {
            template.append('\n');
        } else {
            int eolPos = value.indexOf(10);
            template.append(value, 0, eolPos > 0 ? eolPos : value.length());
        }
    }

    @Nullable
    private ParameterMatchInfo getMatchingParameter(PhpDocParamTag paramTag) {
        Parameter[] parameters;
        String docParamName = PhpDocUtil.getParamName((PhpDocTag)paramTag, this.myFunction);
        PhpType docParamType = PhpDocUtil.getParamType((PhpDocTag)paramTag, this.myFunction);
        Parameter paramMatchedByType = null;
        int typeMatches = 0;
        for (Parameter param : parameters = this.myFunction.getParameters()) {
            if (param.getName().equals(docParamName)) {
                return new ParameterMatchInfo(param, true);
            }
            if (docParamName != null || !PhpDocSignatureInspection.typesMatch(paramTag.getProject(), docParamType, PhpDocUtil.getParameterType(param))) continue;
            paramMatchedByType = param;
            ++typeMatches;
        }
        if (paramMatchedByType != null && typeMatches == 1) {
            return new ParameterMatchInfo(paramMatchedByType, false);
        }
        return null;
    }

    @Nullable
    private PsiElement findParameterPlace() {
        PsiElement place = PhpPsiUtil.getChildOfType((PsiElement)this.myOriginal, PARAM_RETURN_THROWS_END);
        if (place != null) {
            if ((place = place.getPrevSibling()) instanceof PsiWhiteSpace) {
                place = place.getPrevSibling();
            }
            if (PhpPsiUtil.isOfType(place, PhpDocTokenTypes.DOC_LEADING_ASTERISK)) {
                place = place.getPrevSibling();
            }
            if (place instanceof PsiWhiteSpace) {
                place = place.getPrevSibling();
            }
        }
        return place;
    }

    private void addParametersAndReturnTag(Map<Parameter, String> paramDocMap, Map<String, String> throwsDocMap, @Nullable String returnDoc) {
        StringBuilder template = this.myTemplate;
        for (PhpDocCommentGenerator.AnchorInfo anchorInfo : PhpDocCommentGenerator.getAnchorInfoList((PsiElement)this.myFunction)) {
            if ("@param".equals(anchorInfo.tagName)) {
                for (Parameter parameter : this.myFunction.getParameters()) {
                    if (paramDocMap.containsKey(parameter)) {
                        template.append('\n').append(paramDocMap.get(parameter));
                        continue;
                    }
                    if (StringUtil.contains((CharSequence)template, (CharSequence)"@param")) {
                        PhpFunctionDocCommentUpdater.truncateEmptyLine(template);
                    }
                    template.append("\n* @param ");
                    PhpType type = PhpDocUtil.getParameterType(parameter);
                    this.appendParamInfo(template, parameter, type);
                }
                continue;
            }
            if ("@throws".equals(anchorInfo.tagName)) {
                Set<String> exceptionNames = this.myUpdateExceptions ? PhpThrownExceptionsAnalyzer.getDistinctExceptionNames((PhpScopeHolder)this.myFunction, this.myProject) : throwsDocMap.keySet();
                for (String typeKey : exceptionNames) {
                    template.append("\n* @throws ").append(typeKey);
                    if (!throwsDocMap.containsKey(typeKey)) continue;
                    String[] lines = throwsDocMap.get(typeKey).split("\n");
                    for (int lineNum = 0; lineNum < lines.length; ++lineNum) {
                        template.append(lineNum > 0 ? "\n*" : " ");
                        template.append(lines[lineNum]);
                    }
                }
                continue;
            }
            if (!"@return".equals(anchorInfo.tagName)) continue;
            Object returnTagElement = PhpPsiUtil.getChildByCondition((PsiElement)this.myOriginal, (Condition<? super PsiElement>)PhpDocReturnTag.INSTANCEOF);
            PhpDocReturnTag returnTag = returnTagElement instanceof PhpDocReturnTag ? (PhpDocReturnTag)returnTagElement : null;
            PhpType returnType = PhpDocUtil.getReturnType(this.myFunction);
            boolean needsRetTag = (!returnType.isEmpty() && !PhpType.VOID.equals((Object)returnType) || returnTag != null) && (!(this.myFunction instanceof Method) || ((Method)this.myFunction).getMethodType(false) != Method.MethodType.CONSTRUCTOR);
            if (!needsRetTag) continue;
            if (returnDoc != null) {
                template.append("\n").append(returnDoc);
                continue;
            }
            template.append("\n* @return ").append(this.getRetTypeString());
        }
    }

    @NotNull
    private String getRetTypeString() {
        if (this.myFunction != null) {
            PhpType type = PhpDocUtil.getReturnType(this.myFunction);
            String string = PhpDocUtil.getTypePresentation(this.myProject, type, this.myUseOperatorScope, this.myFunction.getTypeDeclaration());
            if (string == null) {
                PhpFunctionDocCommentUpdater.$$$reportNull$$$0(5);
            }
            return string;
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpFunctionDocCommentUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpFunctionDocCommentUpdater";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRetTypeString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isNonInlineTag";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ParameterMatchInfo {
        private final boolean isMatchedByName;
        private final Parameter myParameter;

        private ParameterMatchInfo(Parameter parameter, boolean isMatchedByName) {
            this.isMatchedByName = isMatchedByName;
            this.myParameter = parameter;
        }

        public boolean isMatchedByName() {
            return this.isMatchedByName;
        }

        public Parameter getParameter() {
            return this.myParameter;
        }
    }
}

