/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.exception.PhpExceptionAnalysisService;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocMissingThrowsInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class PhpFindCauseOfExceptionsQuickFix
implements LocalQuickFix {
    static final LocalQuickFix INSTANCE = new PhpFindCauseOfExceptionsQuickFix();
    private static final int MAX_LENGTH = 75;

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("find.cause", new Object[0]);
        if (string == null) {
            PhpFindCauseOfExceptionsQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Editor editor;
        if (project == null) {
            PhpFindCauseOfExceptionsQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpFindCauseOfExceptionsQuickFix.$$$reportNull$$$0(2);
        }
        if ((editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) == null) {
            return;
        }
        PhpDocComment docComment = (PhpDocComment)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF);
        if (docComment == null) {
            return;
        }
        Function function = (Function)ObjectUtils.tryCast((Object)docComment.getOwner(), Function.class);
        if (function == null) {
            return;
        }
        PsiFile file = function.getContainingFile();
        String fileText = file.getText();
        Set<PhpType> docExceptions = PhpDocMissingThrowsInspection.getDocExceptions(function, docComment);
        List ranges = ContainerUtil.filter(PhpDocMissingThrowsInspection.getExceptionClasses(function), item -> PhpFindCauseOfExceptionsQuickFix.isUndocumented(function, docExceptions, item));
        if (ranges.size() == 1) {
            PhpFindCauseOfExceptionsQuickFix.navigate(editor, file, (PhpExceptionAnalysisService.PhpThrownExceptionItem)((Object)ranges.get(0)));
            return;
        }
        JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(ranges).setSelectionMode(0).setTitle(PhpBundle.message("find.exception.cause.table.title", new Object[0])).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(cause -> PhpFindCauseOfExceptionsQuickFix.navigate(editor, file, cause)).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", item -> {
            @NlsSafe String causeText = StringUtil.first((String)item.getThrownRange().substring(fileText), (int)75, (boolean)true);
            return causeText;
        })).createPopup();
        popup.showInBestPositionFor(editor);
    }

    private static void navigate(Editor editor, PsiFile file, PhpExceptionAnalysisService.PhpThrownExceptionItem item) {
        int offset = item.getThrownRange().getStartOffset();
        PsiNavigationSupport.getInstance().createNavigatable(file.getProject(), file.getVirtualFile(), offset).navigate(true);
        PhpType exceptionType = item.getException().global(file.getProject());
        Function function = (Function)PhpPsiUtil.getParentByCondition(file.findElementAt(offset), (Condition<? super PsiElement>)Function.INSTANCEOF);
        String exceptionString = exceptionType.toStringRelativized(function != null ? function.getNamespaceName() : null);
        HintManager.getInstance().showInformationHint(editor, PhpBundle.message("php.find.clause.throws", StringUtil.escapeXmlEntities((String)exceptionString)));
    }

    private static boolean isUndocumented(Function function, Set<PhpType> docExceptions, PhpExceptionAnalysisService.PhpThrownExceptionItem item) {
        return PhpDocMissingThrowsInspection.getUndocumentedExceptions(Collections.singleton((PhpType)item.first), function, docExceptions).filter(t -> !t.isEmpty()).limit(1L).count() >= 1L;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpFindCauseOfExceptionsQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpFindCauseOfExceptionsQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

