/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocTagImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocSignatureIsNotCompleteInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpDocSignatureIsNotCompleteInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }

            public void visitPhpFunction(Function function) {
                PhpDocComment docComment = function.getDocComment();
                if (docComment == null || docComment.hasInheritDocTag() || PhpDocUtil.hasOnlyNoInspectionTag(docComment)) {
                    return;
                }
                PhpDocSignatureIsNotCompleteInspection.checkSignature(docComment, function, holder, isOnTheFly);
            }
        };
    }

    private static void checkSignature(PhpDocComment docComment, Function function, ProblemsHolder holder, boolean isOnTheFly) {
        boolean allTagsExtendInfo;
        PhpDocReturnTag returnTag = docComment.getReturnTag();
        boolean hasAllParamTags = PhpDocSignatureIsNotCompleteInspection.hasAllParamTags(docComment, function);
        if (hasAllParamTags && (returnTag != null || PhpDocSignatureIsNotCompleteInspection.isReturnTagUnnecessary(function))) {
            return;
        }
        boolean paramTagsExtendInfo = ContainerUtil.all((Collection)docComment.getParamTags(), t -> PhpDocSignatureIsNotCompleteInspection.isParameterExtendedByDocTag(function, t));
        boolean returnTagExtendInfo = PhpDocSignatureIsNotCompleteInspection.isReturnTypeExtendedByDocTag(function, returnTag);
        boolean bl = allTagsExtendInfo = paramTagsExtendInfo && (hasAllParamTags || returnTag == null || returnTagExtendInfo);
        if (allTagsExtendInfo && !isOnTheFly) {
            return;
        }
        ProblemHighlightType overriddenSeverity = allTagsExtendInfo ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        ArrayList<Object> fixes = new ArrayList<Object>();
        fixes.add(PhpDocSignatureInspection.UPDATE_PHP_DOC_QUICK_FIX);
        if (!allTagsExtendInfo) {
            fixes.add(RemovePhpDocSignatureTagsQuickFix.INSTANCE);
        }
        PhpDocSignatureIsNotCompleteInspection.registerProblem(docComment, holder, overriddenSeverity, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static boolean isParameterExtendedByDocTag(@NotNull Function function, @NotNull PhpDocParamTag paramTag) {
        if (function == null) {
            PhpDocSignatureIsNotCompleteInspection.$$$reportNull$$$0(1);
        }
        if (paramTag == null) {
            PhpDocSignatureIsNotCompleteInspection.$$$reportNull$$$0(2);
        }
        if (!paramTag.getTagValue().isEmpty()) {
            return true;
        }
        Parameter parameter = (Parameter)ContainerUtil.find((Object[])function.getParameters(), p -> p.getName().equalsIgnoreCase(paramTag.getVarName()));
        if (parameter == null) {
            return false;
        }
        return PhpDocSignatureIsNotCompleteInspection.isExtended(parameter.getTypeDeclaration(), (PhpDocTag)paramTag, function.getProject());
    }

    private static boolean isExtended(@Nullable PhpTypeDeclaration typeDeclaration, @NotNull PhpDocTag docTag, @NotNull Project project) {
        if (docTag == null) {
            PhpDocSignatureIsNotCompleteInspection.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PhpDocSignatureIsNotCompleteInspection.$$$reportNull$$$0(4);
        }
        PhpType docType = docTag.getType();
        if (typeDeclaration == null) {
            return !docTag.getType().isEmpty();
        }
        if (docType.isEmpty()) {
            return false;
        }
        PhpType declarationType = typeDeclaration.getGlobalType();
        if (docType.hasUnresolved()) {
            List declarationTypes;
            if (PhpDocSignatureIsNotCompleteInspection.hasNonPolymorphicUnresolvedTypes(docType)) {
                return true;
            }
            List docTypes = PsiTreeUtil.getChildrenOfAnyType((PsiElement)docTag, (Class[])new Class[]{PhpReference.class});
            if (docTypes.stream().anyMatch(t -> "$this".equalsIgnoreCase(t.getName()))) {
                return true;
            }
            if (docTypes.stream().anyMatch(t -> "static".equalsIgnoreCase(t.getName())) && !ContainerUtil.exists((Iterable)(declarationTypes = PsiTreeUtil.getChildrenOfAnyType((PsiElement)typeDeclaration, (Class[])new Class[]{PhpReference.class})), t -> "static".equalsIgnoreCase(t.getName()))) {
                return true;
            }
        }
        return !declarationType.equals((Object)docType.global(project));
    }

    private static boolean hasNonPolymorphicUnresolvedTypes(@NotNull PhpType type) {
        if (type == null) {
            PhpDocSignatureIsNotCompleteInspection.$$$reportNull$$$0(5);
        }
        return type.getTypes().stream().anyMatch(t -> StringUtil.startsWithChar((CharSequence)t, (char)'#') && !PhpTypeSignatureKey.POLYMORPHIC_CLASS.isSigned(t));
    }

    private static boolean isReturnTypeExtendedByDocTag(@NotNull Function function, @Nullable PhpDocReturnTag returnTag) {
        if (function == null) {
            PhpDocSignatureIsNotCompleteInspection.$$$reportNull$$$0(6);
        }
        if (returnTag == null) {
            return false;
        }
        if (!returnTag.getTagValue().isEmpty()) {
            return true;
        }
        Project project = function.getProject();
        return PhpDocSignatureIsNotCompleteInspection.isExtended(function.getTypeDeclaration(), (PhpDocTag)returnTag, project);
    }

    private static boolean hasAllParamTags(PhpDocComment docComment, Function function) {
        long numberOfExistedPhpDocParams = ContainerUtil.count((Iterable)docComment.getParamTags(), tag -> !tag.getName().equals("@global"));
        return numberOfExistedPhpDocParams >= (long)function.getParameters().length;
    }

    private static boolean isReturnTagUnnecessary(@NotNull Function function) {
        if (function == null) {
            PhpDocSignatureIsNotCompleteInspection.$$$reportNull$$$0(7);
        }
        PhpType returnType = function.getInferredType().global(function.getProject());
        return PhpDocSignatureIsNotCompleteInspection.isConstructor(function) || PhpDocSignatureIsNotCompleteInspection.isDestructor(function) || returnType.isEmpty() || PhpType.VOID.equals((Object)returnType);
    }

    private static boolean isConstructor(@NotNull Function function) {
        if (function == null) {
            PhpDocSignatureIsNotCompleteInspection.$$$reportNull$$$0(8);
        }
        return function instanceof Method && ((Method)function).getMethodType(false) == Method.MethodType.CONSTRUCTOR;
    }

    private static boolean isDestructor(Function function) {
        return "__destruct".equalsIgnoreCase(function.getName());
    }

    private static void registerProblem(@NotNull PhpDocComment docComment, @NotNull ProblemsHolder holder, @NotNull ProblemHighlightType overriddenSeverity, LocalQuickFix ... quickFixes) {
        if (docComment == null) {
            PhpDocSignatureIsNotCompleteInspection.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            PhpDocSignatureIsNotCompleteInspection.$$$reportNull$$$0(10);
        }
        if (overriddenSeverity == null) {
            PhpDocSignatureIsNotCompleteInspection.$$$reportNull$$$0(11);
        }
        for (TextRange range : PhpDocUtil.getRangesToHighlight(docComment)) {
            holder.registerProblem((PsiElement)docComment, PhpBundle.message("inspection.php.doc.is.not.complete.inspection.display.name", new Object[0]), overriddenSeverity, range, quickFixes);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramTag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docTag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overriddenSeverity";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocSignatureIsNotCompleteInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isParameterExtendedByDocTag";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isExtended";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNonPolymorphicUnresolvedTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isReturnTypeExtendedByDocTag";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isReturnTagUnnecessary";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstructor";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RemovePhpDocSignatureTagsQuickFix
    implements LocalQuickFix,
    LowPriorityAction {
        public static final RemovePhpDocSignatureTagsQuickFix INSTANCE = new RemovePhpDocSignatureTagsQuickFix();

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.remove.phpdoc.signature.tags", new Object[0]);
            if (string == null) {
                RemovePhpDocSignatureTagsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RemovePhpDocSignatureTagsQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemovePhpDocSignatureTagsQuickFix.$$$reportNull$$$0(2);
            }
            PhpDocComment docComment = (PhpDocComment)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PhpDocComment.class);
            assert (docComment != null);
            Function function = (Function)ObjectUtils.tryCast((Object)docComment.getOwner(), Function.class);
            if (function == null) {
                return;
            }
            PhpDocReturnTag returnTag = docComment.getReturnTag();
            if (returnTag != null && !PhpDocSignatureIsNotCompleteInspection.isReturnTypeExtendedByDocTag(function, returnTag)) {
                RemovePhpDocSignatureTagsQuickFix.removeTag((PhpDocTag)returnTag);
            }
            docComment.getParamTags().stream().filter(p -> !PhpDocSignatureIsNotCompleteInspection.isParameterExtendedByDocTag(function, p)).forEach(RemovePhpDocSignatureTagsQuickFix::removeTag);
            if (RemovePhpDocSignatureTagsQuickFix.isEmptyPhpDoc(docComment)) {
                docComment.delete();
            }
        }

        public static boolean isEmptyPhpDoc(@NotNull PhpDocComment docComment) {
            if (docComment == null) {
                RemovePhpDocSignatureTagsQuickFix.$$$reportNull$$$0(3);
            }
            return PsiTreeUtil.processElements((PsiElement)docComment, c -> c instanceof PhpDocComment || c instanceof PsiWhiteSpace || PhpPsiUtil.isOfType(c, PhpDocTokenTypes.DOC_COMMENT_START, PhpDocTokenTypes.DOC_LEADING_ASTERISK, PhpDocTokenTypes.DOC_COMMENT_END));
        }

        private static void removeTag(@NotNull PhpDocTag tag) {
            if (tag == null) {
                RemovePhpDocSignatureTagsQuickFix.$$$reportNull$$$0(4);
            }
            ((PhpDocTagImpl)tag).deleteWithLeadingAsterisk();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocSignatureIsNotCompleteInspection$RemovePhpDocSignatureTagsQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docComment";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocSignatureIsNotCompleteInspection$RemovePhpDocSignatureTagsQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isEmptyPhpDoc";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removeTag";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

