/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocTagImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureIsNotCompleteInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpUpdateSignatureFromPhpDocQuickFix;
import com.jetbrains.php.lang.inspections.phpdoc.UpdatePhpDocQuickFix;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpDocSignatureInspection
extends PhpInspection {
    static final UpdatePhpDocQuickFix UPDATE_PHP_DOC_QUICK_FIX = new UpdatePhpDocQuickFix();
    static final LocalQuickFix UPDATE_SIGNATURE_QUICK_FIX = new PhpUpdateSignatureFromPhpDocQuickFix();
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{UPDATE_PHP_DOC_QUICK_FIX};
    private static final LocalQuickFix[] FIXES_WITH_SIGNATURE = new LocalQuickFix[]{UPDATE_PHP_DOC_QUICK_FIX, UPDATE_SIGNATURE_QUICK_FIX};
    private static final PhpType TRUE_FALSE = PhpType.builder().add("true").add("false").build();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                PhpDocComment docComment = function.getDocComment();
                if (docComment == null || docComment.hasInheritDocTag() || PhpDocUtil.hasOnlyNoInspectionTag(docComment)) {
                    return;
                }
                PhpDocSignatureInspection.this.checkSignature(docComment, function, holder, isOnTheFly);
            }

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }
        };
    }

    private void checkSignature(@NotNull PhpDocComment comment, @NotNull Function function, ProblemsHolder holder, boolean isOnTheFly) {
        if (comment == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(1);
        }
        if (function == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(2);
        }
        Parameter[] parameters = function.getParameters();
        LinkedHashMap<String, PhpDocParamTag> paramTags = PhpDocSignatureInspection.getNonGlobalTags(comment, function, holder);
        LinkedHashMap parameterMap = new LinkedHashMap();
        for (Parameter parameter : parameters) {
            String paramName = parameter.getName();
            if (StringUtil.isEmpty((String)paramName)) continue;
            parameterMap.put(paramName, parameter);
            if (!paramTags.containsKey((Object)paramName)) continue;
            PhpDocParamTag paramTag = (PhpDocParamTag)paramTags.get((Object)paramName);
            PhpType docType = PhpDocUtil.getParamType((PhpDocTag)paramTag, function);
            if (!docType.isEmpty() && parameter.getTypeDeclaration() == null) {
                if (!isOnTheFly) continue;
                holder.registerProblem((PsiElement)paramTag, PhpBundle.message("inspection.php.doc.signature.description5", new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{UPDATE_SIGNATURE_QUICK_FIX});
                continue;
            }
            if (paramTag.getType().isEmpty() && parameter.getTypeDeclaration() != null) {
                holder.registerProblem((PsiElement)paramTag, PhpBundle.message("inspection.php.doc.signature.description5", new Object[0]), new LocalQuickFix[]{UPDATE_PHP_DOC_QUICK_FIX, RemovePhpDocTagQuickFix.REMOVE_PARAM_TAG});
                continue;
            }
            if (PhpDocSignatureInspection.typesMatch(parameter, paramTag, docType)) continue;
            LocalQuickFix[] fixes = PhpUpdateSignatureFromPhpDocQuickFix.getParameterTypeString(function, (PhpDocTag)paramTag) != null ? FIXES_WITH_SIGNATURE : FIXES;
            holder.registerProblem((PsiElement)paramTag, PhpBundle.message("inspection.php.doc.signature.description5", new Object[0]), fixes);
        }
        for (String name : paramTags.keySet()) {
            if (parameterMap.containsKey(name)) continue;
            holder.registerProblem((PsiElement)paramTags.get((Object)name), PhpBundle.message("inspection.php.doc.signature.description3", new Object[0]), FIXES_WITH_SIGNATURE);
        }
        PhpDocReturnTag returnTag = comment.getReturnTag();
        if (returnTag == null) {
            return;
        }
        if (!returnTag.getType().isEmpty() && function.getTypeDeclaration() == null) {
            if (!isOnTheFly) {
                return;
            }
            holder.registerProblem((PsiElement)returnTag, PhpBundle.message("inspection.php.doc.signature.description2", new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{UPDATE_SIGNATURE_QUICK_FIX});
        } else if (!PhpDocSignatureInspection.returnTypesMatch(returnTag, function)) {
            LocalQuickFix[] localQuickFixArray;
            String string = PhpBundle.message("inspection.php.doc.signature.description2", new Object[0]);
            if (returnTag.getType().isEmpty()) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
                localQuickFixArray2[0] = UPDATE_PHP_DOC_QUICK_FIX;
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[1] = RemovePhpDocTagQuickFix.REMOVE_RETURN_TAG;
            } else {
                localQuickFixArray = FIXES_WITH_SIGNATURE;
            }
            holder.registerProblem((PsiElement)returnTag, string, localQuickFixArray);
        }
    }

    public static boolean typesMatch(Parameter parameter, PhpDocParamTag paramTag, PhpType paramDocType) {
        boolean emptyPhpDocTagVariadic = paramTag.isVariadic() && PhpDocTagImpl.getTypeFromDeclaration((PhpDocTag)paramTag).isEmpty();
        return (!emptyPhpDocTagVariadic || ParameterImpl.getTypeFromDeclaration((PhpPsiElement)parameter).isEmpty()) && PhpDocSignatureInspection.typesMatch(parameter.getProject(), paramDocType, PhpDocUtil.getParameterType(parameter));
    }

    private static LinkedHashMap<String, PhpDocParamTag> getNonGlobalTags(PhpDocComment comment, Function function, ProblemsHolder holder) {
        LinkedHashMap nonGlobalTags = new LinkedHashMap();
        int paramIndex = 0;
        for (PhpDocParamTag paramTag : comment.getParamTags()) {
            if (paramTag.getName().equals("@global")) continue;
            String paramName = PhpDocUtil.getParamName((PhpDocTag)paramTag, function);
            if (paramName == null) {
                Parameter parameter = function.getParameter(paramIndex);
                String string = paramName = parameter != null ? parameter.getName() : null;
            }
            if (paramName != null && nonGlobalTags.put((Object)paramName, (Object)paramTag) != null) {
                holder.registerProblem((PsiElement)paramTag, PhpBundle.message("inspection.php.doc.signature.description", new Object[0]), FIXES);
            }
            ++paramIndex;
        }
        return nonGlobalTags;
    }

    static boolean typesMatch(Project project, PhpType docType, PhpType paramType) {
        return PhpDocSignatureInspection.typesMatch(project, docType, paramType, PhpIndex.getInstance((Project)project), true);
    }

    private static boolean typesMatch(@NotNull Project project, @NotNull PhpType docType, @NotNull PhpType paramType, PhpIndex index, boolean strict) {
        if (project == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(3);
        }
        if (docType == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(4);
        }
        if (paramType == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(5);
        }
        paramType = paramType.filterUnknown();
        if (!PhpLanguageFeature.NULLABLES.isSupported(project)) {
            paramType = paramType.filterNull();
        }
        boolean isUnionTypesSupported = PhpLanguageFeature.UNION_TYPES.isSupported(project);
        return paramType.isEmpty() || PhpType.intersects((PhpType)PhpType.MIXED, (PhpType)paramType) || PhpType.intersects((PhpType)PhpType.MIXED, (PhpType)docType) || docType.equals((Object)paramType) || !isUnionTypesSupported && PhpType.isSubType((PhpType)paramType, (PhpType)docType) || !strict && PhpType.isSubType((PhpType)docType, (PhpType)paramType) || PhpDocSignatureInspection.areCompatibleAsArrayTypes(project, paramType, docType, index, strict) || PhpDocSignatureInspection.areCompatibleAsArrayTypes(project, docType, paramType, index, strict) || PhpType.intersects((PhpType)TRUE_FALSE, (PhpType)docType) && PhpType.intersects((PhpType)PhpType.BOOLEAN, (PhpType)paramType) || PhpType.intersects((PhpType)PhpType.BOOLEAN, (PhpType)docType) && PhpType.intersects((PhpType)TRUE_FALSE, (PhpType)paramType) || PhpType.ITERABLE.equals((Object)paramType) && PhpType.ITERABLE.isConvertibleFrom(docType, index) || PhpDocSignatureInspection.isCompatibleByHierarchy(project, paramType, docType);
    }

    public static boolean isCompatibleByHierarchy(@NotNull Project project, @NotNull PhpType declaredType, @NotNull PhpType docType) {
        if (project == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(6);
        }
        if (declaredType == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(7);
        }
        if (docType == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(8);
        }
        if (PhpLanguageFeature.UNION_TYPES.isSupported(project) && declaredType.size() != docType.size()) {
            return false;
        }
        Set superTypes = declaredType.getTypes();
        Set types = docType.global(project).getTypes();
        PhpIndex index = PhpIndex.getInstance((Project)project);
        return ContainerUtil.and((Iterable)superTypes, s -> types.stream().anyMatch(c -> PhpType.findSuper((String)s, (String)c, (PhpIndex)index)));
    }

    private static boolean areCompatibleAsArrayTypes(@NotNull Project project, @NotNull PhpType type, PhpType docType, PhpIndex index, boolean strict) {
        if (project == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(9);
        }
        if (type == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(10);
        }
        for (String t1 : type.getTypes()) {
            for (String t2 : docType.getTypes()) {
                if (!PhpType.isPluralType((String)t2)) continue;
                if (PhpType.isArray((String)t1)) {
                    return true;
                }
                if (!PhpType.isPluralType((String)t1)) continue;
                return PhpDocSignatureInspection.typesMatch(project, new PhpType().add(docType).elementType(), new PhpType().add(t1).elementType(), index, strict);
            }
        }
        return false;
    }

    static boolean returnTypesMatch(@NotNull PhpDocReturnTag tag, @NotNull Function function) {
        PhpType tagType;
        if (tag == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(11);
        }
        if (function == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(12);
        }
        if ((tagType = tag.getGlobalType()).isEmpty()) {
            return false;
        }
        Project project = function.getProject();
        if (!PhpDocSignatureInspection.isReturnTypeSupported(tagType, project)) {
            return true;
        }
        PhpType declaredType = function.getDeclaredType().globalLocationAware((PsiElement)function);
        PhpIndex index = PhpIndex.getInstance((Project)project);
        if (!declaredType.isEmpty()) {
            if (PhpLanguageFeature.UNION_TYPES.isSupported(project) && declaredType.size() != tagType.size()) {
                return false;
            }
            if (tagType.isNotExtendablePrimitiveType()) {
                return PhpDocSignatureInspection.typesMatch(project, tagType, declaredType, index, false);
            }
            return declaredType.isConvertibleFrom(tagType, PhpIndex.getInstance((Project)project));
        }
        PhpType inferredType = function.getInferredType().globalLocationAware((PsiElement)function);
        return tagType.isConvertibleFrom(inferredType, index) || inferredType.isConvertibleFrom(tagType, index);
    }

    public static boolean isReturnTypeSupported(@NotNull PhpType type, @NotNull Project project) {
        if (type == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(13);
        }
        if (project == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(14);
        }
        if (PhpType.intersects((PhpType)type, (PhpType)PhpType.OBJECT) && !PhpLanguageFeature.OBJECT_TYPE_HINT.isSupported(project)) {
            return false;
        }
        if (PhpType.intersects((PhpType)type, (PhpType)PhpType.ITERABLE) && !PhpLanguageFeature.ITERABLE_TYPE_HINT.isSupported(project)) {
            return false;
        }
        if (PhpType.intersects((PhpType)type, (PhpType)PhpType.NULL) && !PhpLanguageFeature.NULLABLES.isSupported(project)) {
            return false;
        }
        if (PhpType.intersects((PhpType)type, (PhpType)PhpType.VOID) && !PhpLanguageFeature.RETURN_VOID.isSupported(project)) {
            return false;
        }
        if (!PhpLanguageFeature.UNION_TYPES.isSupported(project)) {
            PhpType nonNullableType = type.filterNull();
            if (PhpType.intersects((PhpType)PhpType.ARRAY, (PhpType)nonNullableType)) {
                return nonNullableType.filterPlurals().size() < 2;
            }
            return nonNullableType.size() < 2;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocSignatureInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSignature";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "typesMatch";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompatibleByHierarchy";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "areCompatibleAsArrayTypes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "returnTypesMatch";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isReturnTypeSupported";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RemovePhpDocTagQuickFix
    implements LocalQuickFix,
    LowPriorityAction {
        public static final RemovePhpDocTagQuickFix REMOVE_PARAM_TAG = new RemovePhpDocTagQuickFix(PhpDocParamTag.class);
        public static final RemovePhpDocTagQuickFix REMOVE_RETURN_TAG = new RemovePhpDocTagQuickFix(PhpDocReturnTag.class);
        private final Class<? extends PhpDocTag> myTagClass;

        private RemovePhpDocTagQuickFix(Class<? extends PhpDocTag> tagClass) {
            this.myTagClass = tagClass;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            if (this.myTagClass == PhpDocParamTag.class) {
                String string = PhpBundle.message("quickfix.remove.phpdoc.param.tag", new Object[0]);
                if (string == null) {
                    RemovePhpDocTagQuickFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = PhpBundle.message("quickfix.remove.phpdoc.return.tag", new Object[0]);
            if (string == null) {
                RemovePhpDocTagQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RemovePhpDocTagQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RemovePhpDocTagQuickFix.$$$reportNull$$$0(3);
            }
            PhpDocTag docTag = (PhpDocTag)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PhpDocTag.class);
            assert (docTag != null);
            PhpDocComment docComment = (PhpDocComment)PsiTreeUtil.getParentOfType((PsiElement)docTag, PhpDocComment.class);
            assert (docComment != null);
            ((PhpDocTagImpl)docTag).deleteWithLeadingAsterisk();
            if (PhpDocSignatureIsNotCompleteInspection.RemovePhpDocSignatureTagsQuickFix.isEmptyPhpDoc(docComment)) {
                docComment.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocSignatureInspection$RemovePhpDocTagQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocSignatureInspection$RemovePhpDocTagQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

