/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpInspectionsUtil;
import com.jetbrains.php.lang.inspections.PhpThrownExceptionsAnalyzer;
import com.jetbrains.php.lang.inspections.exception.PhpExceptionAnalysisService;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpFindCauseOfExceptionsQuickFix;
import com.jetbrains.php.lang.inspections.probablyBug.PhpUnhandledExceptionInspectionKt;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddThrowsTagQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpDocMissingThrowsInspection
extends PhpInspection {
    private static final LocalQuickFix[] UPDATE_PHP_DOC_QUICK_FIX = new LocalQuickFix[]{PhpDocSignatureInspection.UPDATE_PHP_DOC_QUICK_FIX};
    public boolean SKIP_ON_EMPTY_PHPDOC = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                PhpDocComment docComment = function.getDocComment();
                if (docComment == null || PhpDocUtil.hasOnlyNoInspectionTag(docComment)) {
                    return;
                }
                if (PhpDocMissingThrowsInspection.this.SKIP_ON_EMPTY_PHPDOC && docComment.getReturnTag() == null && docComment.getParamTags().isEmpty() && !PhpDocUtil.hasDocTagWithName(docComment, "@throws")) {
                    return;
                }
                Collection<PhpType> undocumentedExceptions = PhpDocMissingThrowsInspection.getAllUndocumentedExceptions(function);
                if (!undocumentedExceptions.isEmpty()) {
                    PhpDocTag lastThrowTag = PhpDocMissingThrowsInspection.getLastThrowTag(docComment);
                    LocalQuickFix[] fixes = PhpDocMissingThrowsInspection.getFixes(undocumentedExceptions, lastThrowTag, isOnTheFly);
                    Collection<TextRange> rangesToHighlight = lastThrowTag != null ? Collections.singleton(lastThrowTag.getTextRangeInParent()) : PhpDocUtil.getRangesToHighlight(docComment);
                    for (TextRange range : rangesToHighlight) {
                        holder.registerProblem((PsiElement)docComment, range, PhpDocMissingThrowsInspection.getMessage(), fixes);
                    }
                }
            }

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }
        };
    }

    @NotNull
    public static Collection<PhpType> getAllUndocumentedExceptions(Function function) {
        Set thrownExceptions = ContainerUtil.map2Set(PhpDocMissingThrowsInspection.getExceptionClasses(function), it -> (PhpType)it.first);
        Collection collection = PhpDocMissingThrowsInspection.getUndocumentedExceptions(thrownExceptions, function).collect(Collectors.toList());
        if (collection == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public static Collection<PhpExceptionAnalysisService.PhpThrownExceptionItem> getExceptionClasses(@NotNull Function function) {
        if (function == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(2);
        }
        Set<PhpExceptionAnalysisService.PhpThrownExceptionItem> exceptions = PhpThrownExceptionsAnalyzer.getExceptionClasses((PhpScopeHolder)function, null, null, true, false);
        Set<PhpExceptionAnalysisService.PhpThrownExceptionItem> set = PhpUnhandledExceptionInspectionKt.filterOutPhpUnitExpectedTypes((PhpScopeHolder)function, exceptions);
        if (set == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static PhpDocTag getLastThrowTag(PhpDocComment docComment) {
        return (PhpDocTag)ArrayUtil.getLastElement((Object[])docComment.getTagElementsByName("@throws"));
    }

    private static LocalQuickFix[] getFixes(Collection<PhpType> undocumentedExceptions, PhpDocTag lastThrowTag, boolean isOnTheFly) {
        ArrayList<Object> fixes = new ArrayList<Object>();
        if (undocumentedExceptions.size() == 1) {
            PhpType undocumentedException = undocumentedExceptions.iterator().next();
            fixes.add(new PhpAddThrowsTagQuickFix(undocumentedException));
            fixes.add(PhpDocSignatureInspection.UPDATE_PHP_DOC_QUICK_FIX);
            if (lastThrowTag != null) {
                fixes.add(new PhpAddToExistingThrowsTagQuickFix(undocumentedException));
            }
        } else {
            fixes.add(PhpDocSignatureInspection.UPDATE_PHP_DOC_QUICK_FIX);
        }
        if (isOnTheFly) {
            fixes.add(PhpFindCauseOfExceptionsQuickFix.INSTANCE);
        }
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    @NotNull
    public static Stream<PhpType> getUndocumentedExceptions(@NotNull Collection<PhpType> thrownExceptions, @NotNull Function function) {
        PhpDocComment comment;
        if (thrownExceptions == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(4);
        }
        if (function == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(5);
        }
        if ((comment = function.getDocComment()) == null) {
            Stream<PhpType> stream = thrownExceptions.stream();
            if (stream == null) {
                PhpDocMissingThrowsInspection.$$$reportNull$$$0(6);
            }
            return stream;
        }
        Set<PhpType> docExceptions = PhpDocMissingThrowsInspection.getDocExceptions(function, comment);
        return PhpDocMissingThrowsInspection.getUndocumentedExceptions(thrownExceptions, function, docExceptions);
    }

    @NotNull
    public static Stream<PhpType> getUndocumentedExceptions(@NotNull Collection<PhpType> thrownExceptions, @NotNull Function function, @NotNull Collection<PhpType> docExceptions) {
        if (thrownExceptions == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(7);
        }
        if (function == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(8);
        }
        if (docExceptions == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(9);
        }
        if (docExceptions.isEmpty()) {
            Stream<PhpType> stream = thrownExceptions.stream();
            if (stream == null) {
                PhpDocMissingThrowsInspection.$$$reportNull$$$0(10);
            }
            return stream;
        }
        PhpType docException = docExceptions.stream().map(type -> type.globalLocationAware((PsiElement)function)).reduce(new PhpType(), (acc, type) -> acc.add(type));
        PhpIndex index = PhpIndex.getInstance((Project)function.getProject());
        AbstractStreamEx abstractStreamEx = StreamEx.of(thrownExceptions).filter(thrownException -> !docException.isConvertibleFrom(thrownException, index));
        if (abstractStreamEx == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(11);
        }
        return abstractStreamEx;
    }

    static Set<PhpType> getDocExceptions(@NotNull Function function, PhpDocComment comment) {
        if (function == null) {
            PhpDocMissingThrowsInspection.$$$reportNull$$$0(12);
        }
        return StreamEx.of(PhpDocUtil.collectTagsConsideringInheritance(function, "@throws")).append((Object[])comment.getTagElementsByName("@expectedException")).map(PhpTypedElement::getType).toSet();
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    @InspectionMessage
    private static String getMessage() {
        return PhpBundle.message("inspection.doc.throws.problem", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocMissingThrowsInspection";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thrownExceptions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docExceptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocMissingThrowsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUndocumentedExceptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionClasses";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndocumentedExceptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionClasses";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUndocumentedExceptions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDocExceptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox mySkipOnEmpty;
        private JPanel myLinkPanel;

        private void createUIComponents() {
            this.myLinkPanel = PhpInspectionsUtil.createPanelWithSettingsLink(PhpBundle.message("exception.analysis.settings.path", new Object[0]), PhpProjectConfigurable.class, PhpProjectConfigurable::new, PhpProjectConfigurable::openAnalysisTab);
        }

        private OptionsPanel() {
            this.$$$setupUI$$$();
            this.mySkipOnEmpty.setSelected(PhpDocMissingThrowsInspection.this.SKIP_ON_EMPTY_PHPDOC);
            this.mySkipOnEmpty.getModel().addChangeListener(e -> {
                PhpDocMissingThrowsInspection.this.SKIP_ON_EMPTY_PHPDOC = this.mySkipOnEmpty.isSelected();
            });
        }

        private JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            this.createUIComponents();
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JBCheckBox jBCheckBox = new JBCheckBox();
            this.mySkipOnEmpty = jBCheckBox;
            jBCheckBox.setSelected(true);
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.doc.throws.option.skip.on.empty.phpdoc"));
            jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JPanel jPanel2 = this.myLinkPanel;
            jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static final class PhpAddToExistingThrowsTagQuickFix
    implements LocalQuickFix {
        private final PhpType myException;
        private final String myExceptionName;

        private PhpAddToExistingThrowsTagQuickFix(PhpType exception2) {
            this.myException = exception2;
            this.myExceptionName = PhpLangUtil.toShortName(this.myException.toString());
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.add.exception", this.myExceptionName);
            if (string == null) {
                PhpAddToExistingThrowsTagQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PhpDocComment comment;
            if (project == null) {
                PhpAddToExistingThrowsTagQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpAddToExistingThrowsTagQuickFix.$$$reportNull$$$0(2);
            }
            if ((comment = (PhpDocComment)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF)) == null) {
                return;
            }
            PhpDocTag lastThrowTag = PhpDocMissingThrowsInspection.getLastThrowTag(comment);
            if (lastThrowTag == null) {
                return;
            }
            PhpDocType lastPhpDocType = (PhpDocType)ContainerUtil.getLastItem(PhpPsiUtil.getChildren((PsiElement)lastThrowTag, (Condition<? super PsiElement>)PhpDocType.INSTANCEOF));
            if (lastPhpDocType == null) {
                return;
            }
            PsiElement addedPipe = lastThrowTag.addAfter(this.createDocPipe(project), (PsiElement)lastPhpDocType);
            lastThrowTag.addAfter(this.createDocType(project, comment), addedPipe);
        }

        @NotNull
        protected PsiElement createDocPipe(@NotNull Project project) {
            if (project == null) {
                PhpAddToExistingThrowsTagQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement psiElement = PhpPsiElementFactory.createPhpDocTag(project, "<?php /** @var string|int $f */ $f;").getNode().findChildByType(PhpDocTokenTypes.DOC_PIPE).getPsi();
            if (psiElement == null) {
                PhpAddToExistingThrowsTagQuickFix.$$$reportNull$$$0(4);
            }
            return psiElement;
        }

        @NotNull
        protected PsiElement createDocType(@NotNull Project project, PhpDocComment comment) {
            if (project == null) {
                PhpAddToExistingThrowsTagQuickFix.$$$reportNull$$$0(5);
            }
            PhpAddThrowsTagQuickFix fix = new PhpAddThrowsTagQuickFix(this.myException);
            PsiElement psiElement = (PsiElement)Objects.requireNonNull(PhpPsiUtil.getChildByCondition(fix.getTag(project, fix.getOwner((PsiElement)comment), (PsiElement)comment), (Condition<? super PsiElement>)PhpDocType.INSTANCEOF));
            if (psiElement == null) {
                PhpAddToExistingThrowsTagQuickFix.$$$reportNull$$$0(6);
            }
            return psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocMissingThrowsInspection$PhpAddToExistingThrowsTagQuickFix";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocMissingThrowsInspection$PhpAddToExistingThrowsTagQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDocPipe";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDocType";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createDocPipe";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createDocType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

