/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpUpdateSignatureFromPhpDocQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddTagBaseQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class PhpDocMissingReturnTagInspection
extends PhpInspection {
    private static final AddReturnTagQuickFix ADD_RETURN_TAG_QUICK_FIX = new AddReturnTagQuickFix();
    private static final LocalQuickFix REMOVE_RETURN_TYPE_CHANGE_SIGNATURE = new PhpUpdateSignatureFromPhpDocQuickFix(){

        @Override
        @Nullable
        protected String getReturnTypeText(Function function, PhpMethodDescriptor originalMethodDescriptor, PhpDocReturnTag tag) {
            if (tag == null) {
                return "";
            }
            return super.getReturnTypeText(function, originalMethodDescriptor, tag);
        }
    };
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{ADD_RETURN_TAG_QUICK_FIX, REMOVE_RETURN_TYPE_CHANGE_SIGNATURE};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDocMissingReturnTagInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                PhpDocComment docComment = function.getDocComment();
                if (docComment == null || function instanceof Method && docComment.hasInheritDocTag() || PhpDocUtil.hasOnlyNoInspectionTag(docComment)) {
                    return;
                }
                PhpDocReturnTag returnTag = docComment.getReturnTag();
                if (returnTag != null || docComment.getParamTags().isEmpty()) {
                    return;
                }
                if (function instanceof Method && (PhpDocMissingReturnTagInspection.isConstructor((Method)function) || PhpDocMissingReturnTagInspection.isDestructor(function))) {
                    return;
                }
                if (function.getTypeDeclaration() != null) {
                    return;
                }
                PhpType functionType = PhpDocUtil.getReturnType(function);
                if (PhpDocMissingReturnTagInspection.isPossibleToInsertToReturnTypeDeclaration(function, functionType)) {
                    return;
                }
                if (!functionType.isEmpty() && !PhpType.VOID.equals((Object)functionType.filterUnknown())) {
                    for (TextRange range : PhpDocUtil.getRangesToHighlight(docComment)) {
                        holder.registerProblem((PsiElement)docComment, range, PhpDocMissingReturnTagInspection.getMessage(), FIXES);
                    }
                }
            }

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }
        };
    }

    private static boolean isPossibleToInsertToReturnTypeDeclaration(@NotNull Function function, @NotNull PhpType type) {
        Project project;
        if (function == null) {
            PhpDocMissingReturnTagInspection.$$$reportNull$$$0(1);
        }
        if (type == null) {
            PhpDocMissingReturnTagInspection.$$$reportNull$$$0(2);
        }
        if (!PhpLanguageLevel.current(project = function.getProject()).isAtLeast(PhpLanguageLevel.PHP700)) {
            return false;
        }
        if (!PhpDocSignatureInspection.isReturnTypeSupported(type, project)) {
            return false;
        }
        return !(function instanceof Method) || !PhpDocMissingReturnTagInspection.hasSuperMethodWithReturnDocTagType((Method)function);
    }

    private static boolean hasSuperMethodWithReturnDocTagType(@NotNull Method method) {
        if (method == null) {
            PhpDocMissingReturnTagInspection.$$$reportNull$$$0(3);
        }
        Ref result = new Ref((Object)false);
        PhpClassHierarchyUtils.processSuperMethods((Method)method, (superMethod, subClass, baseClass) -> {
            PhpDocComment docComment = superMethod.getDocComment();
            result.set((Object)(docComment != null && docComment.getReturnTag() != null && !docComment.getReturnTag().getDocType().isEmpty() ? 1 : 0));
            return (Boolean)result.get() == false;
        });
        return (Boolean)result.get();
    }

    private static boolean isDestructor(Function function) {
        return "__destruct".equalsIgnoreCase(function.getName());
    }

    private static boolean isConstructor(Method function) {
        return function.getMethodType(false) == Method.MethodType.CONSTRUCTOR;
    }

    @InspectionMessage
    private static String getMessage() {
        return PhpBundle.message("inspection.doc.missing.return.tag.problem", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocMissingReturnTagInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPossibleToInsertToReturnTypeDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSuperMethodWithReturnDocTagType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AddReturnTagQuickFix
    extends PhpAddTagBaseQuickFix<Function> {
        private AddReturnTagQuickFix() {
        }

        @Override
        @NotNull
        protected String getTagName() {
            return "@return";
        }

        @Override
        @NotNull
        public Function getOwner(@NotNull PsiElement element) {
            if (element == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(0);
            }
            Function function = (Function)((PhpDocComment)element).getOwner();
            if (function == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(1);
            }
            return function;
        }

        @Override
        @NotNull
        protected PhpDocComment getDocComment(@NotNull PsiElement element) {
            if (element == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(2);
            }
            PhpDocComment phpDocComment = (PhpDocComment)element;
            if (phpDocComment == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(3);
            }
            return phpDocComment;
        }

        @Override
        @NotNull
        public PsiElement getTag(@NotNull Project project, @NotNull Function owner, @NotNull PsiElement element) {
            if (project == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(4);
            }
            if (owner == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(5);
            }
            if (element == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(6);
            }
            String template = "/**\n* @return " + PhpDocUtil.getTypePresentation(project, PhpDocUtil.getReturnType(owner), PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)owner)) + "\n*/";
            PhpDocReturnTag phpDocReturnTag = PhpPsiElementFactory.createFromText(project, PhpDocReturnTag.class, template);
            if (phpDocReturnTag == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(7);
            }
            return phpDocReturnTag;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocMissingReturnTagInspection$AddReturnTagQuickFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocMissingReturnTagInspection$AddReturnTagQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwner";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocComment";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getOwner";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDocComment";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getTag";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

