/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpUpdateFieldTypeFromPhpDocQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypeDeclarationImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocFieldTypeMismatchInspection
extends PhpInspection {
    private static final PhpDocUpdateFieldTypeQuickFix UPDATE_DOC_TYPE = new PhpDocUpdateFieldTypeQuickFix();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDocFieldTypeMismatchInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpField(Field field) {
                Project project = field.getProject();
                PhpDocComment docComment = field.getDocComment();
                PhpType declaredType = field.getDeclaredType();
                if (docComment == null || PhpDocUtil.hasOnlyNoInspectionTag(docComment) || declaredType.isEmpty()) {
                    return;
                }
                PhpDocParamTag varTag = docComment.getVarTag();
                if (varTag == null) {
                    return;
                }
                PhpType docType = varTag.getDocType().global(project);
                if (!PhpDocSignatureInspection.typesMatch(project, docType, declaredType.global(project))) {
                    holder.registerProblem((PsiElement)varTag, PhpBundle.message("inspection.doc.field.type.mismatch", new Object[0]), this.getFixes(project, docType, field));
                }
            }

            private LocalQuickFix[] getFixes(@NotNull Project project, @NotNull PhpType docType, @NotNull Field field) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (docType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (field == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (PhpUpdateFieldTypeFromPhpDocQuickFix.isSupported(docType) && (docType.filterNull().size() == 1 || PhpLanguageFeature.UNION_TYPES.isSupported(project))) {
                    String docTypePresentation = PhpTypeDeclarationImpl.createTypeToAdd((PsiElement)field, docType.size() > 1, docType);
                    PhpUpdateFieldTypeFromPhpDocQuickFix updateFieldTypeFix = new PhpUpdateFieldTypeFromPhpDocQuickFix(docTypePresentation);
                    return new LocalQuickFix[]{UPDATE_DOC_TYPE, updateFieldTypeFix};
                }
                return new LocalQuickFix[]{UPDATE_DOC_TYPE};
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "docType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "field";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocFieldTypeMismatchInspection$1";
                objectArray[2] = "getFixes";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP740;
    }

    @Nullable
    public static Field getTagOwner(@NotNull PhpDocParamTag tag) {
        PhpDocComment docComment;
        if (tag == null) {
            PhpDocFieldTypeMismatchInspection.$$$reportNull$$$0(1);
        }
        if ((docComment = (PhpDocComment)PhpPsiUtil.getParentByCondition((PsiElement)tag, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF)) == null) {
            return null;
        }
        return (Field)ObjectUtils.tryCast((Object)docComment.getOwner(), Field.class);
    }

    @Nls
    public static String getFixName() {
        return PhpBundle.message("quickfix.phpdoc.update.type", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocFieldTypeMismatchInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTagOwner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpDocUpdateFieldTypeQuickFix
    extends PhpQuickFixBase {
        private PhpDocUpdateFieldTypeQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpDocFieldTypeMismatchInspection.getFixName();
            if (string == null) {
                PhpDocUpdateFieldTypeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PhpDocParamTag varTag;
            if (project == null) {
                PhpDocUpdateFieldTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpDocUpdateFieldTypeQuickFix.$$$reportNull$$$0(2);
            }
            if ((varTag = (PhpDocParamTag)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PhpDocParamTag.class)) == null) {
                return;
            }
            Field field = PhpDocFieldTypeMismatchInspection.getTagOwner(varTag);
            if (field == null) {
                return;
            }
            PhpTypeDeclarationImpl.update((PhpDocTag)varTag, field.getDeclaredType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocFieldTypeMismatchInspection$PhpDocUpdateFieldTypeQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocFieldTypeMismatchInspection$PhpDocUpdateFieldTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

