/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocPropertyTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import gnu.trove.THashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpDocDuplicateTypeInspection
extends PhpInspection {
    static final LocalQuickFix REMOVE_PHP_DOC_REDUNDANT_TYPE_FIX = new RemovePhpDocRedundantTypeQuickFix();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDocDuplicateTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpDocTag(PhpDocTag tag) {
                if (tag instanceof PhpDocParamTag || tag instanceof PhpDocReturnTag || tag instanceof PhpDocPropertyTag) {
                    PhpDocDuplicateTypeInspection.checkTag(tag, holder);
                }
            }
        };
    }

    private static void checkTag(PhpDocTag tag, ProblemsHolder holder) {
        @NotNull List<PhpDocType> children = PhpPsiUtil.getChildren((PsiElement)tag, (Condition<? super PsiElement>)PhpDocType.INSTANCEOF);
        THashSet typeSet = new THashSet();
        for (PhpDocType child : children) {
            if (typeSet.add(child.getType())) continue;
            holder.registerProblem((PsiElement)child, PhpBundle.message("inspection.duplicate.phpdoc.type.problem", child.getText()), new LocalQuickFix[]{REMOVE_PHP_DOC_REDUNDANT_TYPE_FIX});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/phpdoc/PhpDocDuplicateTypeInspection", "buildVisitor"));
    }

    public static class RemovePhpDocRedundantTypeQuickFix
    implements LocalQuickFix {
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.duplicate.phpdoc.type.fix", new Object[0]);
            if (string == null) {
                RemovePhpDocRedundantTypeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement phpDocTag;
            if (project == null) {
                RemovePhpDocRedundantTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemovePhpDocRedundantTypeQuickFix.$$$reportNull$$$0(2);
            }
            if ((phpDocTag = descriptor.getPsiElement()) == null) {
                return;
            }
            PhpCodeEditUtil.removeStatementWithDelivery(phpDocTag, PhpDocTokenTypes.DOC_PIPE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocDuplicateTypeInspection$RemovePhpDocRedundantTypeQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocDuplicateTypeInspection$RemovePhpDocRedundantTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

