/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.inspections.PhpThrownExceptionsAnalyzer;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpDocCommentGenerator {
    private static final String CARET_MARKER = "${CARET}";
    protected final Project myProject;
    protected final String myNamespace;
    public static final String TYPE_HINT_ATTR = "TYPE_HINT";
    public static final String NAME_ATTR = "NAME";
    public static final String STATIC_ATTR = "STATIC";
    public static final String CLASS_NAME_ATTR = "CLASS_NAME";
    public static final String NAMESPACE_ATTR = "NAMESPACE";
    public static final String PARAM_DOC_ATTR = "PARAM_DOC";
    public static final String THROWS_DOC_ATTR = "THROWS_DOC";
    public static final String CARET_ATTR = "CARET";
    @Deprecated
    public static final String TYPE_TAG = "TYPE_TAG";
    public static final String DATE = "DATE";
    public static final String TIME = "TIME";
    private static FileTemplateManager ourTemplateManager;
    public static final String CLASS_TEMPLATE_NAME = "PHP Class Doc Comment";
    public static final String INTERFACE_TEMPLATE_NAME = "PHP Interface Doc Comment";
    public static final String TRAIT_TEMPLATE_NAME = "PHP Trait Doc Comment";
    public static final String FUNCTION_TEMPLATE_NAME = "PHP Function Doc Comment";
    public static final String FIELD_TEMPLATE_NAME = "PHP Property Doc Comment";

    protected void generateContent(StringBuilder builder, Map<String, String> additionalAttributes) {
        String docText;
        if (this.hasTemplate() && (docText = this.getTemplate(additionalAttributes)) != null && !PhpDocCommentGenerator.isEmptyDoc(docText)) {
            docText = docText.replaceAll("(\\s*\\n)+", "\n");
            builder.append(docText);
            return;
        }
        builder.append("/**\n *\n */");
    }

    private static boolean isEmptyDoc(@NotNull String docText) {
        String textToCheck;
        if (docText == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(0);
        }
        return (textToCheck = docText.trim()).isEmpty() || textToCheck.matches("/\\*[\\*\\s]*/");
    }

    private PhpDocCommentGenerator(PsiElement element) {
        this.myProject = element.getProject();
        this.myNamespace = element instanceof PhpNamedElement ? ((PhpNamedElement)element).getNamespaceName() : null;
    }

    @Nullable
    public static PhpDocComment constructDocComment(@NotNull Project project, @Nullable PsiElement element, boolean insertCaret) {
        if (project == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(1);
        }
        HashMap<String, String> additionalAttributes = new HashMap<String, String>();
        if (insertCaret) {
            additionalAttributes.put(CARET_MARKER, "");
        }
        return PhpDocCommentGenerator.constructDocComment(project, element, additionalAttributes);
    }

    public static Collection<AnchorInfo> getAnchorInfoList(@NotNull PsiElement element) {
        if (element == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(2);
        }
        String templateText = PhpDocCommentGenerator.getTemplateText(element);
        ArrayList<AnchorInfo> anchorInfoList = new ArrayList<AnchorInfo>();
        if (templateText != null) {
            anchorInfoList.add(new AnchorInfo("@param", templateText.indexOf(PARAM_DOC_ATTR)));
            anchorInfoList.add(new AnchorInfo("@return", templateText.indexOf(TYPE_HINT_ATTR)));
            anchorInfoList.add(new AnchorInfo("@throws", templateText.indexOf(THROWS_DOC_ATTR)));
        }
        anchorInfoList.sort((o1, o2) -> {
            if (o1.templateOffset < 0) {
                return 1;
            }
            if (o2.templateOffset < 0) {
                return -1;
            }
            return o1.templateOffset - o2.templateOffset;
        });
        return anchorInfoList;
    }

    public static boolean tryMoveCaretOnMarker(@NotNull Editor editor, @NotNull TextRange docRange) {
        if (editor == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(3);
        }
        if (docRange == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(4);
        }
        return PhpDocCommentGenerator.tryMoveCaretOnMarker(editor, docRange, Collections.emptySet());
    }

    public static boolean tryMoveCaretOnMarker(@NotNull Editor editor, @NotNull TextRange docRange, @NotNull Collection<? extends RangeMarker> ignored) {
        if (editor == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(5);
        }
        if (docRange == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(6);
        }
        if (ignored == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(7);
        }
        Document document = editor.getDocument();
        Set ignoredOffsets = StreamEx.of(ignored).map(marker -> marker.getStartOffset()).toSet();
        List caretMarkers = ContainerUtil.filter(PhpDocCommentGenerator.collectCaretMarkers(document, docRange), marker -> !ignoredOffsets.contains(marker.getStartOffset()));
        if (caretMarkers.isEmpty()) {
            return false;
        }
        editor.getCaretModel().moveToOffset(((RangeMarker)caretMarkers.get(0)).getStartOffset());
        caretMarkers.forEach(marker -> document.deleteString(marker.getStartOffset(), marker.getEndOffset()));
        Project project = editor.getProject();
        if (project != null) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        }
        return true;
    }

    @NotNull
    public static List<RangeMarker> collectCaretMarkers(@NotNull Document document, @NotNull TextRange docRange) {
        if (document == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(8);
        }
        if (docRange == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(9);
        }
        SmartList result = new SmartList();
        if (docRange.getStartOffset() < 0 || docRange.getEndOffset() > document.getTextLength() || docRange.getStartOffset() > docRange.getEndOffset()) {
            SmartList smartList = result;
            if (smartList == null) {
                PhpDocCommentGenerator.$$$reportNull$$$0(10);
            }
            return smartList;
        }
        String content = document.getText(docRange);
        for (int i = 0; i <= content.length() - CARET_MARKER.length(); ++i) {
            if (!StringUtil.startsWith((CharSequence)content, (int)i, (CharSequence)CARET_MARKER)) continue;
            result.add(document.createRangeMarker(new TextRange(i, i + CARET_MARKER.length()).shiftRight(docRange.getStartOffset())));
        }
        SmartList smartList = result;
        if (smartList == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    @Nullable
    public static String getTemplateText(@NotNull PsiElement element) {
        PhpDocCommentGenerator generator;
        FileTemplate template;
        if (element == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(12);
        }
        if ((template = (generator = PhpDocCommentGenerator.getInstance(element)).geFileTemplate()) != null) {
            return template.getText();
        }
        return null;
    }

    public static boolean isTemplateNullOrEmpty(PsiElement element) {
        return StringUtil.isEmpty((String)PhpDocCommentGenerator.getInstance(element).getTemplate(Collections.emptyMap()));
    }

    @Nullable
    public static PhpDocComment constructDocComment(@NotNull Project project, @Nullable PsiElement element, @Nullable Map<String, String> additionalAttributes) {
        if (project == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(13);
        }
        if (element == null || !element.isValid()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<?php\n");
        PhpDocCommentGenerator generator = PhpDocCommentGenerator.getInstance(element);
        generator.generateContent(builder, additionalAttributes);
        PhpDocComment docComment = PhpPsiElementFactory.createFromText(project, PhpDocComment.class, builder.toString());
        if (docComment == null) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                Notifications.Bus.notify((Notification)new Notification("PHP Doc Commenter", PhpBundle.message("invalid.php.doc.comment.template", new Object[0]), PhpBundle.message("can.not.build.a.php.doc.comment.from.the.template.which.evaluates.to.0", builder.toString()), NotificationType.ERROR));
            } else assert (false) : "Invalid PHP Doc Comment Template.";
            docComment = PhpPsiElementFactory.createFromText(project, PhpDocComment.class, "/**\n *\n */");
        }
        return docComment;
    }

    @NotNull
    public static PhpDocCommentGenerator getInstance(@NotNull PsiElement element) {
        List fields;
        if (element == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(14);
        }
        PsiElement parent = element.getParent();
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.CLASS_CONSTANTS) || PhpPsiUtil.isOfType(parent, PhpElementTypes.CLASS_CONSTANTS)) {
            return new DefaultDocCommentGenerator(element);
        }
        if (element instanceof PhpClass) {
            return new ClassDocCommentGenerator((PhpClass)element);
        }
        if (element instanceof Method) {
            if (((Method)element).getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
                return new ConstructorDocCommentGenerator((Method)element);
            }
            return new MethodDocCommentGenerator((Method)element);
        }
        if (element instanceof Function) {
            return new FunctionDocCommentGenerator((Function)element);
        }
        if (element instanceof Field) {
            return new FieldDocCommentGenerator((Field)element);
        }
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.CLASS_FIELDS) && !(fields = PhpPsiUtil.getChildren(element, (Condition<? super PsiElement>)Field.INSTANCEOF)).isEmpty()) {
            return new FieldDocCommentGenerator((Field)fields.get(0));
        }
        return new DefaultDocCommentGenerator(element);
    }

    @Nullable
    private String getTemplate(Map<String, String> additionalAttributes) {
        String template;
        FileTemplate fileTemplate = this.geFileTemplate();
        if (fileTemplate == null) {
            return null;
        }
        try {
            Properties attributes = this.getTemplateAttributes();
            additionalAttributes.forEach((key, value) -> attributes.setProperty((String)key, (String)value));
            template = fileTemplate.getText(attributes);
        }
        catch (IOException e) {
            template = fileTemplate.getText();
        }
        return template;
    }

    @Nullable
    protected FileTemplate geFileTemplate() {
        String templateName = this.getTemplateName();
        if (templateName == null) {
            return null;
        }
        return ourTemplateManager == null ? FileTemplateManager.getInstance((Project)this.myProject).getPattern(templateName) : ourTemplateManager.getPattern(templateName);
    }

    private Properties getTemplateAttributes() {
        Properties attributes = FileTemplateManager.getInstance((Project)this.myProject).getDefaultProperties();
        if (this.myNamespace != null && !this.myNamespace.isEmpty() && !"\\".equals(this.myNamespace)) {
            String packageName = this.myNamespace;
            packageName = StringUtil.trimStart((String)packageName, (String)"\\");
            packageName = StringUtil.trimEnd((String)packageName, (String)"\\");
            attributes.setProperty(NAMESPACE_ATTR, packageName);
        }
        this.setTemplateAttributes(attributes);
        return attributes;
    }

    protected void setTemplateAttributes(Properties attributes) {
    }

    @Nullable
    protected String getTemplateName() {
        return null;
    }

    public final boolean hasTemplate() {
        return this.getTemplateName() != null;
    }

    public static void setTemplateManager(@Nullable FileTemplateManager templateManager) {
        ourTemplateManager = templateManager;
    }

    @NotNull
    public static PhpType globalPreserving$This(@NotNull PhpType type, @NotNull PsiElement context) {
        if (type == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(16);
        }
        PhpType global = new PhpType();
        for (String s : type.getTypes()) {
            global.add(PhpTypeSignatureKey.POLYMORPHIC_CLASS.isSigned(s) || PhpTypeSignatureKey.SELF_CLASS.isSigned(s) ? (context instanceof Method && ((Method)context).isStatic() ? "static" : "$this") : s);
        }
        PhpType phpType = global;
        if (phpType == null) {
            PhpDocCommentGenerator.$$$reportNull$$$0(17);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docText";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docRange";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocCommentGenerator";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocCommentGenerator";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCaretMarkers";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "globalPreserving$This";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyDoc";
                break;
            }
            case 1: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "constructDocComment";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorInfoList";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryMoveCaretOnMarker";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectCaretMarkers";
                break;
            }
            case 10: 
            case 11: 
            case 17: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "globalPreserving$This";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConstructorDocCommentGenerator
    extends MethodDocCommentGenerator {
        ConstructorDocCommentGenerator(Method constructor) {
            super(constructor);
        }

        @Override
        @Nullable
        protected FileTemplate geFileTemplate() {
            return FileTemplateManager.getInstance((Project)this.myProject).getCodeTemplate("PHP Constructor");
        }

        @Override
        protected void setTemplateAttributes(Properties attributes) {
            PhpClass phpClass = this.myMethod.getContainingClass();
            if (phpClass != null) {
                attributes.setProperty(PhpDocCommentGenerator.CLASS_NAME_ATTR, phpClass.getName());
            }
            attributes.setProperty(PhpDocCommentGenerator.PARAM_DOC_ATTR, this.getParameterDoc());
            attributes.setProperty(PhpDocCommentGenerator.THROWS_DOC_ATTR, this.getThrowsDoc());
        }
    }

    private static class FieldDocCommentGenerator
    extends PhpDocCommentGenerator {
        private final Field myClassField;

        FieldDocCommentGenerator(Field classField) {
            super((PsiElement)classField);
            this.myClassField = classField;
        }

        @Override
        @Nullable
        protected String getTemplateName() {
            return PhpDocCommentGenerator.FIELD_TEMPLATE_NAME;
        }

        @Override
        protected void setTemplateAttributes(Properties attributes) {
            String typeHint = PhpDocUtil.getTypePresentation(this.myClassField.getProject(), FieldDocCommentGenerator.globalPreserving$This(this.myClassField.getType(), (PsiElement)this.myClassField), PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)this.myClassField), this.myClassField.getTypeDeclaration());
            attributes.setProperty(PhpDocCommentGenerator.TYPE_HINT_ATTR, typeHint);
            attributes.setProperty(PhpDocCommentGenerator.STATIC_ATTR, this.myClassField.getModifier().isStatic() ? "static" : "");
            attributes.setProperty(PhpDocCommentGenerator.NAME_ATTR, this.myClassField.getName());
            attributes.setProperty(PhpDocCommentGenerator.TYPE_TAG, "@var");
            PhpClass phpClass = this.myClassField.getContainingClass();
            if (phpClass != null) {
                attributes.setProperty(PhpDocCommentGenerator.CLASS_NAME_ATTR, phpClass.getName());
            }
        }
    }

    private static class MethodDocCommentGenerator
    extends FunctionDocCommentGenerator {
        protected Method myMethod;

        MethodDocCommentGenerator(Method method) {
            super((Function)method);
            this.myMethod = method;
        }

        @Override
        protected void generateContent(StringBuilder builder, Map<String, String> additionalAttributes) {
            if ("__destruct".equalsIgnoreCase(this.myMethod.getName())) {
                builder.append("/**\n");
                int initialLength = builder.length();
                this.addParameters(builder);
                builder.append(this.getThrowsDoc());
                if (builder.length() == initialLength) {
                    builder.append("* \n");
                }
                builder.append(" */");
                return;
            }
            super.generateContent(builder, additionalAttributes);
        }

        @Override
        protected void setTemplateAttributes(Properties attributes) {
            super.setTemplateAttributes(attributes);
            attributes.setProperty(PhpDocCommentGenerator.STATIC_ATTR, this.myMethod.isStatic() ? "static" : "");
        }
    }

    private static class FunctionDocCommentGenerator
    extends PhpDocCommentGenerator {
        private final Function myFunction;

        FunctionDocCommentGenerator(Function function) {
            super((PsiElement)function);
            this.myFunction = function;
        }

        protected void addParameters(StringBuilder builder) {
            Project project = this.myFunction.getProject();
            PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)this.myFunction);
            for (Parameter parameter : this.myFunction.getParameters()) {
                builder.append("* @param ");
                PhpType type = parameter.isVariadic() ? parameter.getType().unpluralize() : parameter.getType();
                String typeStr = PhpDocUtil.getTypePresentation(project, type, scopeForUseOperator, parameter.getTypeDeclaration());
                if (!typeStr.isEmpty()) {
                    builder.append(typeStr);
                    String defaultValue = FunctionDocCommentGenerator.getDefault(parameter);
                    if (defaultValue != null && !PhpType.intersects((PhpType)type, (PhpType)PhpType.NULL)) {
                        builder.append('|').append(defaultValue);
                    }
                    builder.append(' ');
                }
                if (parameter.isVariadic()) {
                    builder.append("...");
                }
                builder.append('$').append(parameter.getName()).append('\n');
            }
        }

        @Nullable
        private static String getDefault(@NotNull Parameter parameter) {
            ConstantReference constantReference;
            String constName;
            if (parameter == null) {
                FunctionDocCommentGenerator.$$$reportNull$$$0(0);
            }
            PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)parameter.getContainingFile(), PhpCodeStyleSettings.class);
            PsiElement lastChild = parameter.getLastChild();
            if (PhpPsiUtil.isOfType(lastChild, PhpElementTypes.PARAMETER_DEFAULT_VALUE) && (lastChild = lastChild.getFirstChild()) instanceof ConstantReference && (constName = (constantReference = (ConstantReference)lastChild).getName()) != null && PhpLangUtil.isNull(constantReference)) {
                return FunctionDocCommentGenerator.adjustCase(settings.UPPER_CASE_NULL_CONST, settings.LOWER_CASE_NULL_CONST, constName);
            }
            return null;
        }

        private static String adjustCase(boolean toUpperCase, boolean toLowerCase, @NonNls @NotNull String constString) {
            if (constString == null) {
                FunctionDocCommentGenerator.$$$reportNull$$$0(1);
            }
            return toUpperCase ? StringUtil.toUpperCase((String)constString) : (toLowerCase ? StringUtil.toLowerCase((String)constString) : constString);
        }

        private String getTypeHint() {
            String retType = PhpDocUtil.getTypePresentation(this.myProject, FunctionDocCommentGenerator.globalPreserving$This(this.myFunction.getLocalType(true), (PsiElement)this.myFunction), PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)this.myFunction), this.myFunction.getTypeDeclaration());
            if (retType.isEmpty()) {
                retType = "mixed";
            }
            return retType;
        }

        protected String getParameterDoc() {
            StringBuilder builder = new StringBuilder();
            this.addParameters(builder);
            return builder.toString();
        }

        protected String getThrowsDoc() {
            StringBuilder builder = new StringBuilder();
            for (String typeName : PhpThrownExceptionsAnalyzer.getDistinctExceptionNames((PhpScopeHolder)this.myFunction, this.myProject)) {
                builder.append("* @throws ").append(typeName).append('\n');
            }
            return builder.toString();
        }

        @Override
        protected void setTemplateAttributes(Properties functionAttrs) {
            functionAttrs.setProperty(PhpDocCommentGenerator.NAME_ATTR, this.myFunction.getName());
            functionAttrs.setProperty(PhpDocCommentGenerator.TYPE_HINT_ATTR, this.getTypeHint());
            functionAttrs.setProperty(PhpDocCommentGenerator.PARAM_DOC_ATTR, this.getParameterDoc());
            functionAttrs.setProperty(PhpDocCommentGenerator.THROWS_DOC_ATTR, this.getThrowsDoc());
        }

        @Override
        @Nullable
        protected String getTemplateName() {
            return PhpDocCommentGenerator.FUNCTION_TEMPLATE_NAME;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constString";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocCommentGenerator$FunctionDocCommentGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDefault";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "adjustCase";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClassDocCommentGenerator
    extends PhpDocCommentGenerator {
        private final PhpClass myClass;

        ClassDocCommentGenerator(PhpClass phpClass) {
            super((PsiElement)phpClass);
            this.myClass = phpClass;
        }

        @Override
        @Nullable
        protected String getTemplateName() {
            if (this.myClass.isInterface()) {
                return PhpDocCommentGenerator.INTERFACE_TEMPLATE_NAME;
            }
            if (this.myClass.isTrait()) {
                return PhpDocCommentGenerator.TRAIT_TEMPLATE_NAME;
            }
            return PhpDocCommentGenerator.CLASS_TEMPLATE_NAME;
        }

        @Override
        protected void setTemplateAttributes(Properties attributes) {
            attributes.setProperty(PhpDocCommentGenerator.NAME_ATTR, this.myClass.getName());
        }
    }

    private static final class DefaultDocCommentGenerator
    extends PhpDocCommentGenerator {
        private DefaultDocCommentGenerator(PsiElement element) {
            super(element);
        }
    }

    public static class AnchorInfo {
        public final String tagName;
        public final int templateOffset;

        public AnchorInfo(String tagName, int templateOffset) {
            this.tagName = tagName;
            this.templateOffset = templateOffset;
        }
    }
}

