/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.actions.generation.PhpGeneratePhpDocBlocksAction;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAddDocCommentFromBaseQuickFix
implements LocalQuickFix {
    public static final PhpAddDocCommentFromBaseQuickFix INSTANCE = new PhpAddDocCommentFromBaseQuickFix();

    @Nullable
    static PhpDocComment getBaseDocComment(PsiElement element) {
        if (!(element instanceof PhpClassMember)) {
            return null;
        }
        Ref res = new Ref();
        PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)((PhpClassMember)element), (classMember, subClass, baseClass1) -> {
            res.set((Object)classMember.getDocComment());
            return res.isNull();
        });
        return (PhpDocComment)res.get();
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.copy.phpdoc.from.parent", new Object[0]);
        if (string == null) {
            PhpAddDocCommentFromBaseQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpAddDocCommentFromBaseQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpAddDocCommentFromBaseQuickFix.$$$reportNull$$$0(2);
        }
        PhpClassMember element = (PhpClassMember)PhpPsiUtil.getParentByCondition(descriptor.getPsiElement(), (Condition<? super PsiElement>)((Condition)PhpClassMember.class::isInstance));
        PhpDocComment docComment = PhpAddDocCommentFromBaseQuickFix.getBaseDocComment((PsiElement)element);
        if (docComment != null) {
            PsiElement docCopy = docComment.copy();
            assert (docCopy instanceof PhpDocComment) : "A copy of PSI element is expected to be PhpDocComment";
            PhpAddDocCommentFromBaseQuickFix.addDocCommentForElement((PsiElement)element, (PhpDocComment)docCopy);
        }
    }

    public static void addDocCommentForElement(PsiElement element, PhpDocComment docComment) {
        PsiElement before = PhpGeneratePhpDocBlocksAction.PhpGeneratePhpDocBlocksActionHandler.getBeforeElement(element);
        if (before != null) {
            PhpCodeEditUtil.insertDocCommentBeforeAndGetTextRange(before, docComment);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpAddDocCommentFromBaseQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpAddDocCommentFromBaseQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

