/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.parameterCountMismatch;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.io.DataExternalizer;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.stubs.indexes.StringSetDataExternalizer;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PhpFuncGetArgUsageProvider {
    private static final String GIST_ID = "PhpFuncGetArgUsageProvider";
    private static final int VERSION = 0;
    private static final Set<String> FUNC_GET_ARGS_NAMES = ContainerUtil.set((Object[])new String[]{"func_get_arg", "func_get_args"});
    private static final PsiFileGist<Set<String>> GIST = GistManager.getInstance().newPsiFileGist("PhpFuncGetArgUsageProvider", 0, (DataExternalizer)StringSetDataExternalizer.INSTANCE, file -> (Set)((StreamEx)PhpFuncGetArgUsageProvider.findTopLevelFunctions(file).filter(PhpFuncGetArgUsageProvider::containsGetArgFunctionCall)).map(PhpNamedElement::getFQN).toCollection(() -> new THashSet()));

    @NotNull
    public static StreamEx<? extends Function> findTopLevelFunctions(PsiFile psiFile) {
        StreamEx streamEx = psiFile instanceof PhpFile ? StreamEx.of((Collection)((PhpFile)psiFile).getTopLevelDefs().values()).flatMap(PhpFuncGetArgUsageProvider::getFunctions) : StreamEx.empty();
        if (streamEx == null) {
            PhpFuncGetArgUsageProvider.$$$reportNull$$$0(0);
        }
        return streamEx;
    }

    @NotNull
    public static Stream<? extends Function> getFunctions(PhpNamedElement topLevelNamedElement) {
        if (topLevelNamedElement instanceof Function) {
            StreamEx streamEx = StreamEx.of((Object)((Function)topLevelNamedElement));
            if (streamEx == null) {
                PhpFuncGetArgUsageProvider.$$$reportNull$$$0(1);
            }
            return streamEx;
        }
        if (topLevelNamedElement instanceof PhpClass) {
            StreamEx streamEx = StreamEx.of((Object[])((PhpClass)topLevelNamedElement).getOwnMethods());
            if (streamEx == null) {
                PhpFuncGetArgUsageProvider.$$$reportNull$$$0(2);
            }
            return streamEx;
        }
        StreamEx streamEx = StreamEx.empty();
        if (streamEx == null) {
            PhpFuncGetArgUsageProvider.$$$reportNull$$$0(3);
        }
        return streamEx;
    }

    public static boolean containsGetArgFunctionUsage(@NotNull Function function) {
        if (function == null) {
            PhpFuncGetArgUsageProvider.$$$reportNull$$$0(4);
        }
        PsiFile file = function.getContainingFile();
        return ((Set)CachedValuesManager.getCachedValue((PsiElement)function, () -> CachedValueProvider.Result.create((Object)((Set)GIST.getFileData(file)), (Object[])new Object[]{function}))).contains(function.getFQN());
    }

    private static boolean containsGetArgFunctionCall(@NotNull Function f) {
        if (f == null) {
            PhpFuncGetArgUsageProvider.$$$reportNull$$$0(5);
        }
        final Ref resultRef = new Ref((Object)false);
        PhpControlFlowUtil.processFlow(f.getControlFlow(), new PhpInstructionProcessor(){

            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                if (FUNC_GET_ARGS_NAMES.contains(instruction.getFunctionReference().getName())) {
                    resultRef.set((Object)true);
                    return false;
                }
                return true;
            }
        });
        return (Boolean)resultRef.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/parameterCountMismatch/PhpFuncGetArgUsageProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopLevelFunctions";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/parameterCountMismatch/PhpFuncGetArgUsageProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsGetArgFunctionUsage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsGetArgFunctionCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

