/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.exception;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataExternalizer;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConstructorCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpHostInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpThrowInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionDFAnalyzer;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.config.PhpAnalysisConfiguration;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpUnitMockBuilderTP;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionsWithNotCatchedDynamicPassedCallsIndex;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectIntHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExceptionAnalysisService {
    private static final Logger LOG = Logger.getInstance(PhpExceptionAnalysisService.class);
    private static final Key<ParameterizedCachedValue<Map<String, SignatureList>, PsiFile>> GIST_KEY = Key.create((String)"PhpExceptionAnalysisService.GIST_KEY");
    private static final DataExternalizer<Map<String, SignatureList>> EXTERNALIZER = new DataExternalizer<Map<String, SignatureList>>(){

        public void save(@NotNull DataOutput out, Map<String, SignatureList> value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (Map.Entry<String, SignatureList> entry : value.entrySet()) {
                out.writeUTF(entry.getKey());
                SignatureList list = entry.getValue();
                String[] exceptions = list.exceptions;
                out.writeInt(exceptions.length);
                for (String exception2 : exceptions) {
                    try {
                        out.writeUTF(exception2);
                    }
                    catch (UTFDataFormatException e) {
                        out.writeUTF("");
                        LOG.error("Signature is too long to analyze", (Throwable)e, new Attachment[]{new Attachment("signature.txt", exception2)});
                    }
                }
                Signature[] signatures = list.signatures;
                out.writeInt(signatures.length);
                for (Signature signature : signatures) {
                    this.writeTextRange(out, signature.thrownRange);
                    int[] thrownExceptions = signature.thrownExceptions;
                    out.writeInt(thrownExceptions.length);
                    for (int thrownException : thrownExceptions) {
                        out.writeInt(thrownException);
                    }
                    RangeCode[] coughExceptions = signature.coughExceptions;
                    out.writeInt(coughExceptions.length);
                    for (RangeCode coughException : coughExceptions) {
                        this.writeTextRange(out, coughException.range);
                        out.writeInt(coughException.code);
                    }
                    out.writeUTF(StringUtil.notNullize((String)signature.myData));
                }
            }
        }

        private void writeTextRange(@NotNull DataOutput out, @NotNull TextRange thrownRange) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(1);
            }
            if (thrownRange == null) {
                1.$$$reportNull$$$0(2);
            }
            out.writeInt(thrownRange.getStartOffset());
            out.writeInt(thrownRange.getEndOffset());
        }

        public Map<String, SignatureList> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(3);
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int valueSize = in.readInt();
            for (int i = 0; i < valueSize; ++i) {
                String name = in.readUTF();
                int exceptionsLength = in.readInt();
                String[] exceptions = ArrayUtil.newStringArray((int)exceptionsLength);
                for (int j = 0; j < exceptionsLength; ++j) {
                    exceptions[j] = in.readUTF();
                }
                int signaturesSize = in.readInt();
                Signature[] signatures = (Signature[])Signature.ARRAY_FACTORY.create(signaturesSize);
                for (int j = 0; j < signaturesSize; ++j) {
                    TextRange thrownRange = this.readTextRange(in);
                    int thrownExceptionsLength = in.readInt();
                    int[] thrownExceptions = ArrayUtil.newIntArray((int)thrownExceptionsLength);
                    for (int k = 0; k < thrownExceptionsLength; ++k) {
                        thrownExceptions[k] = in.readInt();
                    }
                    int coughExceptionsSize = in.readInt();
                    RangeCode[] coughExceptions = (RangeCode[])RangeCode.ARRAY_FACTORY.create(coughExceptionsSize);
                    for (int k = 0; k < coughExceptionsSize; ++k) {
                        coughExceptions[k] = new RangeCode(this.readTextRange(in), in.readInt());
                    }
                    String checkedReflectionCallData = StringUtil.nullize((String)in.readUTF());
                    signatures[j] = new Signature(thrownRange, thrownExceptions, coughExceptions, checkedReflectionCallData);
                }
                builder.put((Object)name, (Object)new SignatureList(exceptions, signatures));
            }
            return builder.build();
        }

        @NotNull
        private TextRange readTextRange(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(4);
            }
            TextRange textRange = TextRange.create((int)in.readInt(), (int)in.readInt());
            if (textRange == null) {
                1.$$$reportNull$$$0(5);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thrownRange";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$1";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readTextRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "writeTextRange";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "readTextRange";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final NullableFunction<PsiFile, Map<String, SignatureList>> PROVIDER = file -> {
        THashMap map = new THashMap();
        if (file instanceof PhpFile) {
            map.put(file.getName(), LocalControlFlowProcessor.calculateSignatures((PhpScopeHolder)((PhpFile)file)));
            for (PhpNamedElement element : ((PhpFile)file).getTopLevelDefs().values()) {
                if (element instanceof PhpNamespace || element instanceof Function) {
                    map.put(element.getFQN(), LocalControlFlowProcessor.calculateSignatures((PhpScopeHolder)element));
                    continue;
                }
                if (!(element instanceof PhpClass)) continue;
                for (Method method : ((PhpClass)element).getOwnMethods()) {
                    if (method instanceof PhpDocMethod) continue;
                    map.put(method.getFQN(), LocalControlFlowProcessor.calculateSignatures((PhpScopeHolder)method));
                }
            }
        }
        return map;
    };
    private static final PsiFileGist<Map<String, SignatureList>> GIST = GistManager.getInstance().newPsiFileGist("PhpExceptionAnalysisService.GIST", 14, EXTERNALIZER, PROVIDER);
    private static final RecursionGuard<PhpScopeHolder> GUARD = RecursionManager.createGuard((String)"PhpExceptionAnalysisService.GUARD");
    private static final Int2ObjectMap<Key<CachedValue<Set<PhpThrownExceptionItem>>>> KEY_MAP;
    private static final String DEPTH_EXCEEDED = "#DEPTH_EXCEEDED#";

    @NotNull
    public static Set<Pair<TextRange, String>> getThrownExceptionsWithRanges(@NotNull PhpScopeHolder scope, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean strictThrownRangeComparison) {
        if (scope == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(0);
        }
        THashSet exceptions = new THashSet();
        BiConsumer<TextRange, String> collector = (arg_0, arg_1) -> PhpExceptionAnalysisService.lambda$getThrownExceptionsWithRanges$1((Set)exceptions, arg_0, arg_1);
        PhpExceptionAnalysisService.collectThrownExceptions(collector, scope, 0, thrownRange, coughRange, strictThrownRangeComparison);
        THashSet tHashSet = exceptions;
        if (tHashSet == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(1);
        }
        return tHashSet;
    }

    @NotNull
    public static Set<PhpThrownExceptionItem> getThrownExceptions(@NotNull PhpScopeHolder scope, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean strictThrownRangeComparison) {
        if (scope == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(2);
        }
        return PhpExceptionAnalysisService.getThrownExceptions(scope, 0, thrownRange, coughRange, strictThrownRangeComparison);
    }

    @NotNull
    private static Set<PhpThrownExceptionItem> getThrownExceptions(@NotNull PhpScopeHolder scopeHolder, int level, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean strictThrownRangeComparison) {
        if (scopeHolder == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(3);
        }
        if (scopeHolder instanceof PhpDocMethod || GUARD.currentStack().contains(scopeHolder)) {
            Set<PhpThrownExceptionItem> set = Collections.emptySet();
            if (set == null) {
                PhpExceptionAnalysisService.$$$reportNull$$$0(4);
            }
            return set;
        }
        if (thrownRange != null || coughRange != null) {
            return PhpExceptionAnalysisService.getPreventingRecursion(scopeHolder, level, thrownRange, coughRange, strictThrownRangeComparison);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)scopeHolder.getProject()).getCachedValue((UserDataHolder)scopeHolder, (Key)KEY_MAP.get(level), () -> {
            Set<PhpThrownExceptionItem> exceptions = PhpExceptionAnalysisService.getPreventingRecursion(scopeHolder, level, null, null, false);
            return CachedValueProvider.Result.create(exceptions, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, PhpAnalysisConfiguration.getInstance(scopeHolder.getProject()).getTreeAnalysisDepthModificationTracker()});
        }, false);
        if (set == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    private static Set<PhpThrownExceptionItem> getPreventingRecursion(@NotNull PhpScopeHolder scope, int level, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean strictThrownRangeComparison) {
        if (scope == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(6);
        }
        Set set = (Set)GUARD.doPreventingRecursion((Object)scope, false, () -> {
            THashSet exceptions = new THashSet();
            BiConsumer<TextRange, String> collector = (arg_0, arg_1) -> PhpExceptionAnalysisService.lambda$getPreventingRecursion$3((Set)exceptions, arg_0, arg_1);
            PhpExceptionAnalysisService.collectThrownExceptions(collector, scope, level, thrownRange, coughRange, strictThrownRangeComparison);
            return !exceptions.isEmpty() ? exceptions : Collections.emptySet();
        });
        if (set == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(7);
        }
        return set;
    }

    private static void collectThrownExceptions(BiConsumer<TextRange, String> collector, @NotNull PhpScopeHolder scope, int level, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean strictThrownRangeComparison) {
        if (scope == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(8);
        }
        int depth = PhpAnalysisConfiguration.getInstance(scope.getProject()).getCallTreeAnalysisDepth();
        SignatureList list = PhpExceptionAnalysisService.loadSignatures(scope);
        Project project = scope.getProject();
        PhpIndex index = PhpIndex.getInstance((Project)project);
        for (Signature signature : list.signatures) {
            if (thrownRange != null && (strictThrownRangeComparison && !thrownRange.equals((Object)signature.thrownRange) || !strictThrownRangeComparison && !thrownRange.contains(signature.thrownRange))) continue;
            boolean resolved = false;
            for (int thrownExceptionCode : signature.thrownExceptions) {
                boolean isRethrownException;
                String thrownException = list.exceptions[thrownExceptionCode];
                if (StringUtil.endsWith((CharSequence)thrownException, (CharSequence)".__construct")) {
                    resolved = true;
                }
                if (thrownException.length() < 5 || thrownException.charAt(2) != '?') {
                    resolved = true;
                    PhpExceptionAnalysisService.addIfNotCough(collector, thrownException, signature, project, coughRange, list);
                    continue;
                }
                String kind = thrownException.substring(0, 2);
                String reference = thrownException.substring(3);
                boolean bl = isRethrownException = LocalControlFlowProcessor.SignatureKind.getKindFromData(signature.myData) == LocalControlFlowProcessor.SignatureKind.RETHROWN_EXCEPTION;
                if (level < depth || !"#C".equals(kind) || isRethrownException) {
                    Collection elements = PhpExceptionAnalysisService.getBySignature(reference, index);
                    if (isRethrownException && (level >= depth || elements.isEmpty())) {
                        elements = LocalControlFlowProcessor.SignatureKind.exceptionsFromCatchClause(list, signature.myData).flatMap(s -> index.getAnyByFQN(s).stream()).collect(Collectors.toList());
                    }
                    for (PhpNamedElement element : elements) {
                        resolved = true;
                        if (element instanceof PhpClass) {
                            PhpExceptionAnalysisService.addIfNotCough(collector, element.getFQN(), signature, project, coughRange, list);
                        }
                        if (!(element instanceof Function)) continue;
                        if ("#T".equals(kind)) {
                            for (String type : new PhpType().add(reference).global(project).getTypes()) {
                                PhpExceptionAnalysisService.addIfNotCough(collector, type, signature, project, coughRange, list);
                            }
                            continue;
                        }
                        if (!"#C".equals(kind)) continue;
                        List<PhpDocTag> tags2 = PhpDocUtil.collectTagsConsideringInheritance((Function)element, "@throws");
                        Set docExceptions = StreamEx.of(tags2).map(PhpTypedElement::getType).flatCollection(PhpType::getTypes).toSet();
                        if (!docExceptions.isEmpty()) {
                            for (String type : docExceptions) {
                                for (String globalType : PhpExceptionAnalysisService.global(type, (PsiElement)element)) {
                                    PhpExceptionAnalysisService.addIfNotCough(collector, globalType, signature, project, coughRange, list);
                                }
                            }
                            continue;
                        }
                        PhpScopeHolder newScope = (PhpScopeHolder)element;
                        for (PhpThrownExceptionItem e : PhpExceptionAnalysisService.getThrownExceptions(newScope, level + 1, null, null, strictThrownRangeComparison)) {
                            for (String type : e.getException().getTypes()) {
                                if (type.equals(DEPTH_EXCEEDED)) {
                                    if (!isRethrownException) continue;
                                    LocalControlFlowProcessor.SignatureKind.exceptionsFromCatchClause(list, signature.myData).forEach(s -> PhpExceptionAnalysisService.addIfNotCough(collector, s, signature, project, coughRange, list));
                                    continue;
                                }
                                PhpExceptionAnalysisService.addIfNotCough(collector, type, signature, project, coughRange, list);
                            }
                        }
                    }
                    continue;
                }
                PhpExceptionAnalysisService.addIfNotCough(collector, DEPTH_EXCEEDED, signature, project, coughRange, list);
            }
            if (resolved || thrownRange == null) continue;
            for (RangeCode coughException : signature.coughExceptions) {
                if (coughRange == null || !thrownRange.equals((Object)coughRange)) continue;
                collector.accept(signature.thrownRange, list.exceptions[coughException.code]);
            }
        }
    }

    @NotNull
    private static Collection<? extends PhpNamedElement> getBySignature(@NotNull String reference, @NotNull PhpIndex index) {
        if (reference == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(9);
        }
        if (index == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(10);
        }
        if (reference.indexOf(124) > 0) {
            THashSet result = new THashSet();
            for (String signature : reference.split("\\|")) {
                result.addAll(index.getBySignature(signature));
            }
            THashSet tHashSet = result;
            if (tHashSet == null) {
                PhpExceptionAnalysisService.$$$reportNull$$$0(11);
            }
            return tHashSet;
        }
        Collection collection = index.getBySignature(reference);
        if (collection == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    private static Set<String> global(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(14);
        }
        Set set = new PhpType().add(type).globalLocationAware(context).getTypes();
        if (set == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(15);
        }
        return set;
    }

    private static void addIfNotCough(@NotNull BiConsumer<TextRange, String> collector, @NotNull String exception2, @NotNull Signature signature, @NotNull Project project, @Nullable TextRange coughRange, @NotNull SignatureList list) {
        LocalControlFlowProcessor.SignatureKind kind;
        if (collector == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(16);
        }
        if (exception2 == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(17);
        }
        if (signature == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(18);
        }
        if (project == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(19);
        }
        if (list == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(20);
        }
        if (signature.myData != null && (kind = LocalControlFlowProcessor.SignatureKind.getKindFromData(signature.myData)) != null && (exception2 = kind.completeException(project, signature, list, exception2)) == null) {
            return;
        }
        PhpIndex index = PhpIndex.getInstance((Project)project);
        for (RangeCode coughException : signature.coughExceptions) {
            if (coughRange != null && !coughRange.contains(coughException.range) || !PhpType.findSuper((String)list.exceptions[coughException.code], (String)exception2, (PhpIndex)index)) continue;
            return;
        }
        collector.accept(signature.thrownRange, exception2);
    }

    private static SignatureList loadSignatures(@NotNull PhpScopeHolder scope) {
        if (scope == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(21);
        }
        if (scope instanceof Function && ((Function)scope).isClosure()) {
            return LocalControlFlowProcessor.calculateSignatures(scope);
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)scope.getProject());
        PsiFile containingFile = scope.getContainingFile();
        Map data = (Map)manager.getParameterizedCachedValue((UserDataHolder)containingFile, GIST_KEY, file -> CachedValueProvider.Result.create((Object)((Map)GIST.getFileData(file)), (Object[])new Object[]{file}), false, (Object)containingFile);
        return data.getOrDefault(scope instanceof PhpNamedElement ? ((PhpNamedElement)scope).getFQN() : scope.getName(), SignatureList.EMPTY);
    }

    public static boolean shouldSkipConstructorWithConstantArguments(NewExpression newExpression) {
        return PhpAnalysisConfiguration.getInstance(newExpression.getProject()).getSkipConstantParams() && Arrays.stream(newExpression.getParameters()).allMatch(it -> it instanceof StringLiteralExpression || it instanceof ClassConstantReference || it instanceof ConstantReference);
    }

    private static /* synthetic */ void lambda$getPreventingRecursion$3(Set exceptions, TextRange range, String exception2) {
        exceptions.add(new PhpThrownExceptionItem(exception2, range));
    }

    private static /* synthetic */ void lambda$getThrownExceptionsWithRanges$1(Set exceptions, TextRange range, String exception2) {
        exceptions.add(Pair.create((Object)range, (Object)exception2));
    }

    static {
        int depth = 3;
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap(depth);
        for (int i = 0; i <= depth; ++i) {
            map.put(i, (Object)Key.create((String)("PhpExceptionAnalysisService.KEY.LEVEL" + i)));
        }
        KEY_MAP = map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownExceptionsWithRanges";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownExceptions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreventingRecursion";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBySignature";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "global";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThrownExceptionsWithRanges";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getThrownExceptions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPreventingRecursion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectThrownExceptions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBySignature";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "global";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotCough";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadSignatures";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RangeCode {
        private static final RangeCode[] EMPTY_ARRAY = new RangeCode[0];
        private static final ArrayFactory<RangeCode> ARRAY_FACTORY = size -> size == 0 ? EMPTY_ARRAY : new RangeCode[size];
        private final TextRange range;
        private final int code;

        private RangeCode(@NotNull TextRange range, int code) {
            if (range == null) {
                RangeCode.$$$reportNull$$$0(0);
            }
            this.range = range;
            this.code = code;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$RangeCode", "<init>"));
        }
    }

    private static final class Signature {
        private static final Signature[] EMPTY_ARRAY = new Signature[0];
        private static final ArrayFactory<Signature> ARRAY_FACTORY = size -> size == 0 ? EMPTY_ARRAY : new Signature[size];
        private final TextRange thrownRange;
        private final int[] thrownExceptions;
        private final RangeCode[] coughExceptions;
        @Nullable
        private final String myData;

        private Signature(@NotNull TextRange thrownRange, int @NotNull [] thrownExceptions, RangeCode @NotNull [] coughExceptions, @Nullable String data) {
            if (thrownRange == null) {
                Signature.$$$reportNull$$$0(0);
            }
            if (thrownExceptions == null) {
                Signature.$$$reportNull$$$0(1);
            }
            if (coughExceptions == null) {
                Signature.$$$reportNull$$$0(2);
            }
            this.thrownRange = thrownRange;
            this.thrownExceptions = thrownExceptions;
            this.coughExceptions = coughExceptions;
            this.myData = data;
        }

        private Signature(@NotNull TextRange thrownRange, int @NotNull [] thrownExceptions, RangeCode @NotNull [] coughExceptions) {
            if (thrownRange == null) {
                Signature.$$$reportNull$$$0(3);
            }
            if (thrownExceptions == null) {
                Signature.$$$reportNull$$$0(4);
            }
            if (coughExceptions == null) {
                Signature.$$$reportNull$$$0(5);
            }
            this(thrownRange, thrownExceptions, coughExceptions, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "thrownRange";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "thrownExceptions";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "coughExceptions";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$Signature";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SignatureList {
        private static final SignatureList EMPTY = new SignatureList(ArrayUtilRt.EMPTY_STRING_ARRAY, Signature.EMPTY_ARRAY);
        private final String[] exceptions;
        private final Signature[] signatures;

        private SignatureList(String @NotNull [] exceptions, Signature @NotNull [] signatures) {
            if (exceptions == null) {
                SignatureList.$$$reportNull$$$0(0);
            }
            if (signatures == null) {
                SignatureList.$$$reportNull$$$0(1);
            }
            this.exceptions = exceptions;
            this.signatures = signatures;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exceptions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "signatures";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$SignatureList";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static final class LocalControlFlowProcessor
    extends PhpInstructionProcessor {
        private static final String THROW = "#T";
        private static final String CALL = "#C";
        private static final char SEPARATOR = '?';
        private static final String RETHROWN_EXCEPTIONS_SEPARATOR = ",";
        private final TObjectIntHashMap<String> exceptions;
        private final List<Signature> signatures = new ArrayList<Signature>();
        private final Collection<PhpRethrownException> myRethrownExceptions = new ArrayList<PhpRethrownException>();

        private LocalControlFlowProcessor(TObjectIntHashMap<String> exceptions) {
            this.exceptions = exceptions;
        }

        @NotNull
        private static SignatureList calculateSignatures(@NotNull PhpScopeHolder scope) {
            if (scope == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(0);
            }
            return LocalControlFlowProcessor.calculateSignatures(scope, (TObjectIntHashMap<String>)new TObjectIntHashMap());
        }

        @NotNull
        private static SignatureList calculateSignatures(@NotNull PhpScopeHolder scope, TObjectIntHashMap<String> exceptions) {
            if (scope == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(1);
            }
            LocalControlFlowProcessor processor = new LocalControlFlowProcessor(exceptions);
            PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges((PhpInstruction)scope.getControlFlow().getExitPoint(), false, processor);
            processor.signatures.addAll(LocalControlFlowProcessor.getRethrownExceptionsSignatures(processor));
            return new SignatureList(LocalControlFlowProcessor.toArray(processor.exceptions), (Signature[])ContainerUtil.toArray(processor.signatures, Signature.ARRAY_FACTORY));
        }

        @NotNull
        private static Collection<Signature> getRethrownExceptionsSignatures(LocalControlFlowProcessor processor) {
            ArrayList<Signature> rethrownExceptionsSignatures = new ArrayList<Signature>();
            for (PhpRethrownException rethrownException : processor.myRethrownExceptions) {
                TIntHashSet rethrownExceptions = LocalControlFlowProcessor.getRethrownExceptions(processor, rethrownException);
                Signature originalSignature = rethrownException.mySignature;
                if (!rethrownExceptions.isEmpty()) {
                    rethrownExceptionsSignatures.add(new Signature(originalSignature.thrownRange, rethrownExceptions.toArray(), originalSignature.coughExceptions, SignatureKind.RETHROWN_EXCEPTION.sign(StringUtil.join((int[])originalSignature.thrownExceptions, (String)RETHROWN_EXCEPTIONS_SEPARATOR))));
                    continue;
                }
                rethrownExceptionsSignatures.add(originalSignature);
            }
            ArrayList<Signature> arrayList = rethrownExceptionsSignatures;
            if (arrayList == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @NotNull
        private static TIntHashSet getRethrownExceptions(LocalControlFlowProcessor processor, PhpRethrownException rethrownException) {
            TIntHashSet rethrownExceptions = new TIntHashSet();
            for (Signature signature : processor.signatures) {
                if (!rethrownException.myTryRange.contains(signature.thrownRange)) continue;
                rethrownExceptions.addAll(signature.thrownExceptions);
            }
            TIntHashSet tIntHashSet = rethrownExceptions;
            if (tIntHashSet == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(3);
            }
            return tIntHashSet;
        }

        private static String @NotNull [] toArray(@NotNull TObjectIntHashMap<String> exceptions) {
            if (exceptions == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(4);
            }
            String[] array = ArrayUtil.newStringArray((int)exceptions.size());
            exceptions.forEachEntry((s, i) -> {
                array[i] = s;
                return true;
            });
            if (array == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(5);
            }
            return array;
        }

        public boolean processThrowInstruction(PhpThrowInstruction instruction) {
            Set types;
            TextRange thrownRange = instruction.getThrowExpression().getTextRange();
            PhpExpression argument = (PhpExpression)instruction.getArgument();
            if (argument instanceof NewExpression) {
                ClassReference thrownException = ((NewExpression)argument).getClassReference();
                if (thrownException != null) {
                    PhpPsiElement firstChild = thrownException.getFirstPsiChild();
                    TIntHashSet thrownExceptionsCodes = this.getThrownExceptionCodes((PsiElement)firstChild, thrownException.resolveLocalType().getTypes());
                    this.addSignatureRethrownAware(instruction, thrownRange, (PsiElement)firstChild, thrownExceptionsCodes);
                }
            } else if (argument instanceof FunctionReference || argument instanceof Variable) {
                Set<String> types2 = ((PhpReference)argument).resolveLocalType().getTypes().stream().filter(Predicates.not(PhpType::isNull)).collect(Collectors.toSet());
                if (types2.isEmpty()) {
                    List exceptions = StringUtil.split((String)((PhpReference)argument).getSignature(), (String)"|");
                    int[] thrownExceptions = new int[exceptions.size()];
                    for (int i = 0; i < exceptions.size(); ++i) {
                        thrownExceptions[i] = this.getCode("#T?" + (String)exceptions.get(i));
                    }
                    this.signatures.add(new Signature(thrownRange, thrownExceptions, this.getCoughExceptions(instruction.getCatchTargets())));
                } else {
                    TIntHashSet thrownExceptions = this.getThrownExceptionCodes((PsiElement)argument, types2);
                    if (!thrownExceptions.isEmpty()) {
                        this.addSignatureRethrownAware(instruction, thrownRange, (PsiElement)argument, thrownExceptions);
                    }
                }
            } else if (argument != null && !(types = argument.getType().getTypes()).isEmpty()) {
                TIntHashSet thrownExceptions = new TIntHashSet();
                for (String exception2 : types) {
                    if (PhpType.isUnresolved((String)exception2)) {
                        thrownExceptions.add(this.getCode("#T?" + exception2));
                        continue;
                    }
                    thrownExceptions.add(this.getCode(exception2));
                }
                this.signatures.add(new Signature(thrownRange, thrownExceptions.toArray(), this.getCoughExceptions(instruction.getCatchTargets())));
            }
            return true;
        }

        @NotNull
        public TIntHashSet getThrownExceptionCodes(PsiElement argument, Set<String> types) {
            TIntHashSet thrownExceptions = new TIntHashSet();
            for (String exception2 : types) {
                if (argument instanceof Variable && types.size() > 1 && "\\Exception".equals(exception2) && ((Variable)argument).resolveLocal().stream().anyMatch(v -> v.getParent() instanceof Catch)) continue;
                if (PhpType.isUnresolved((String)exception2)) {
                    thrownExceptions.add(this.getCode("#T?" + exception2));
                    continue;
                }
                thrownExceptions.add(this.getCode(exception2));
            }
            TIntHashSet tIntHashSet = thrownExceptions;
            if (tIntHashSet == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(6);
            }
            return tIntHashSet;
        }

        public void addSignatureRethrownAware(PhpThrowInstruction instruction, TextRange thrownRange, PsiElement argument, TIntHashSet thrownExceptions) {
            Signature signature = new Signature(thrownRange, thrownExceptions.toArray(), this.getCoughExceptions(instruction.getCatchTargets()));
            PhpRethrownException rethrownException = LocalControlFlowProcessor.getRethrownException(argument, signature);
            if (rethrownException != null) {
                this.myRethrownExceptions.add(rethrownException);
            } else {
                this.signatures.add(signature);
            }
        }

        private static PhpRethrownException getRethrownException(PsiElement throwExceptionArgument, Signature originalSignature) {
            Try aTry;
            Collection resolvedElements;
            if (throwExceptionArgument instanceof Variable && !(resolvedElements = ((Variable)throwExceptionArgument).resolveLocal()).isEmpty() && resolvedElements.stream().allMatch(v -> v.getParent() instanceof Catch) && (aTry = (Try)ObjectUtils.tryCast((Object)((PhpNamedElement)ContainerUtil.getFirstItem((Collection)resolvedElements)).getParent().getParent(), Try.class)) != null) {
                return new PhpRethrownException(originalSignature, aTry.getTextRange());
            }
            return null;
        }

        public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
            Function closure;
            if (!instruction.getAccess().isWrite()) {
                return true;
            }
            PsiElement value = ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue();
            Function function = closure = PhpPsiUtil.isOfType(value, PhpElementTypes.CLOSURE) ? (Function)PhpPsiUtil.getChildByCondition(value, (Condition<? super PsiElement>)Function.INSTANCEOF) : null;
            if (closure == null) {
                return true;
            }
            Signature[] closureSignatures = LocalControlFlowProcessor.calculateSignatures((PhpScopeHolder)closure, this.exceptions).signatures;
            if (closureSignatures.length == 0) {
                return true;
            }
            this.processSuccessorUsagesOfVariable(instruction, closureSignatures, this.signatures);
            return super.processAccessVariableInstruction(instruction);
        }

        public void processSuccessorUsagesOfVariable(PhpAccessVariableInstruction instruction, final Signature[] closureSignatures, final List<Signature> originalSignatures) {
            final CharSequence variableName = instruction.getVariableName();
            PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                    FunctionReference functionReference = instruction.getFunctionReference();
                    RangeCode[] coughExceptionsOnUsageCallSite = this.getCoughExceptions(instruction.getCatchTargets());
                    if (functionReference.getNameNode() == null) {
                        this.processDynamicCall(functionReference, coughExceptionsOnUsageCallSite);
                        return true;
                    }
                    this.processPassedFunctionAcceptingClosure(functionReference, coughExceptionsOnUsageCallSite);
                    return super.processPhpCallInstruction(instruction);
                }

                public void processDynamicCall(FunctionReference functionReference, RangeCode[] coughExceptions) {
                    Variable variable = (Variable)ObjectUtils.tryCast((Object)functionReference.getFirstPsiChild(), Variable.class);
                    if (variable != null && PhpLangUtil.equalsVariableNames(variable.getName(), variableName)) {
                        for (Signature signature : closureSignatures) {
                            originalSignatures.add(new Signature(signature.thrownRange, signature.thrownExceptions, coughExceptions, signature.myData));
                        }
                    }
                }

                public void processPassedFunctionAcceptingClosure(FunctionReference functionReference, RangeCode[] coughExceptions) {
                    int paramIndex = LocalControlFlowProcessor.findParameterIndexWithName(functionReference, variableName);
                    if (paramIndex >= 0) {
                        for (Signature signature : closureSignatures) {
                            originalSignatures.add(LocalControlFlowProcessor.createFunctionAcceptingClosureSignature(coughExceptions, functionReference.getSignature(), paramIndex, signature));
                        }
                    }
                }

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    if (!PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variableName)) {
                        return true;
                    }
                    return !instruction.getAccess().isWrite();
                }
            });
        }

        private static int findParameterIndexWithName(FunctionReference functionReference, CharSequence variableName) {
            PsiElement[] parameters = functionReference.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                if (!(parameters[i] instanceof Variable) || !PhpLangUtil.equalsVariableNames(((Variable)parameters[i]).getName(), variableName)) continue;
                return i;
            }
            return -1;
        }

        public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
            int i;
            FunctionReference functionReference = instruction.getFunctionReference();
            TextRange thrownRange = functionReference.getTextRange();
            String signature = functionReference.getSignature();
            List exceptions = StringUtil.split((String)signature, (String)"|");
            int size = exceptions.size();
            List<String> customException = LocalControlFlowProcessor.getCustomExceptions(functionReference);
            int[] thrownExceptions = new int[size + customException.size()];
            for (i = 0; i < size; ++i) {
                thrownExceptions[i] = this.getCode("#C?" + (String)exceptions.get(i));
            }
            for (i = size; i < thrownExceptions.length; ++i) {
                thrownExceptions[i] = this.getCode(customException.get(i - size));
            }
            RangeCode[] coughExceptions = this.getCoughExceptions(instruction.getCatchTargets());
            String checkedReflectionData = LocalControlFlowProcessor.getClassSignatureIfCheckedReflectionCall(instruction, functionReference);
            this.signatures.add(new Signature(thrownRange, thrownExceptions, coughExceptions, checkedReflectionData));
            this.signaturesFromClosureArguments(functionReference, signature, coughExceptions).forEach(this.signatures::add);
            return true;
        }

        @NotNull
        private StreamEx<Signature> signaturesFromClosureArguments(FunctionReference functionReference, String functionSignature, RangeCode[] coughExceptions) {
            StreamEx streamEx = ((StreamEx)StreamEx.of((Object[])functionReference.getParameters()).filter(parameter -> parameter instanceof PhpExpression && PhpPsiUtil.isOfType(parameter, PhpElementTypes.CLOSURE))).flatMap(parameter -> this.signaturesFromPassedClosures((PsiElement)parameter, coughExceptions, functionSignature));
            if (streamEx == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(7);
            }
            return streamEx;
        }

        private Stream<Signature> signaturesFromPassedClosures(PsiElement parameter, RangeCode[] coughExceptions, String functionSignature) {
            Function closure = (Function)ObjectUtils.tryCast((Object)((PhpExpression)parameter).getFirstPsiChild(), Function.class);
            if (closure == null) {
                return Stream.empty();
            }
            int index = PhpCodeInsightUtil.getParameterIndex(parameter);
            if (index < 0) {
                return Stream.empty();
            }
            return Arrays.stream(LocalControlFlowProcessor.calculateSignatures((PhpScopeHolder)closure, this.exceptions).signatures).map(signature -> LocalControlFlowProcessor.createFunctionAcceptingClosureSignature(coughExceptions, functionSignature, index, signature));
        }

        @NotNull
        private static Signature createFunctionAcceptingClosureSignature(RangeCode[] coughExceptions, String functionSignature, int parameterIndex, Signature originalSignature) {
            return new Signature(originalSignature.thrownRange, originalSignature.thrownExceptions, (RangeCode[])ArrayUtil.mergeArrays((Object[])originalSignature.coughExceptions, (Object[])coughExceptions), SignatureKind.FUNCTION_ACCEPTING_CLOSURE.sign(functionSignature + "." + parameterIndex));
        }

        @Nullable
        private static String getClassSignatureIfCheckedReflectionCall(PhpCallInstruction instruction, FunctionReference functionReference) {
            if (functionReference instanceof MethodReference) {
                PhpExpression classReference = ((MethodReference)functionReference).getClassReference();
                String name = functionReference.getName();
                if (classReference instanceof Variable && (PhpLangUtil.equalsMethodNames(name, "getMethod") || PhpLangUtil.equalsMethodNames(name, "getProperty"))) {
                    String classTypes;
                    String memberName;
                    if (LocalControlFlowProcessor.isCheckerReflectionCall(instruction, functionReference, (Variable)classReference)) {
                        return SignatureKind.CHECKED_REFLECTION_CALL.sign(((PhpReference)classReference).getSignature());
                    }
                    StringLiteralExpression memberNamePSI = (StringLiteralExpression)ObjectUtils.tryCast((Object)functionReference.getParameter(0), StringLiteralExpression.class);
                    String string = memberName = memberNamePSI != null ? memberNamePSI.getContents() : null;
                    if (memberName != null && !(classTypes = StreamEx.of((Collection)((Variable)classReference).resolveLocal()).map(PsiElement::getParent).select(AssignmentExpression.class).map(AssignmentExpression::getValue).select(NewExpression.class).map(ctor -> ctor.getParameter(0)).select(PhpTypedElement.class).flatMap(LocalControlFlowProcessor::classFqns).joining((CharSequence)"@@")).isEmpty()) {
                        String classReferenceSignature = SignatureKind.CHECKED_REFLECTION_CALL.sign(((PhpReference)classReference).getSignature());
                        String signature = memberName + "." + classTypes + classReferenceSignature;
                        if (PhpLangUtil.equalsMethodNames(name, "getMethod")) {
                            return SignatureKind.REFLECTION_GET_METHOD_FROM_REAL_CLASS.sign(signature);
                        }
                        return SignatureKind.REFLECTION_GET_PROPERTY_FROM_REAL_CLASS.sign(signature);
                    }
                }
            }
            return null;
        }

        private static Stream<String> classFqns(PhpTypedElement p) {
            String signature = PhpUnitMockBuilderTP.getParameterSignature((PsiElement)p);
            return signature != null ? Stream.of(signature) : p.getType().getTypes().stream();
        }

        @Nullable
        private static String getClassSignatureIfCheckedReflectionCall(NewExpression expression) {
            PhpType type;
            ClassReference reference = expression.getClassReference();
            if (reference == null || !PhpLangUtil.equalsClassNames(reference.getFQN(), "\\ReflectionClass")) {
                return null;
            }
            PhpTypedElement typedElement = (PhpTypedElement)ObjectUtils.tryCast((Object)expression.getParameter(0), PhpTypedElement.class);
            PhpType phpType = type = typedElement != null ? typedElement.getType() : PhpType.EMPTY;
            if (type.isEmpty() || type.getTypes().stream().anyMatch(PhpType::isNotExtendablePrimitiveType)) {
                return null;
            }
            return SignatureKind.SAFE_REFLECTION_CTOR.sign(StringUtil.join((Collection)type.getTypes(), (String)"@@"));
        }

        private static boolean isCheckerReflectionCall(PhpCallInstruction instruction, FunctionReference functionReference, Variable classReference) {
            String name = functionReference.getName();
            if (PhpLangUtil.equalsMethodNames(name, "getMethod")) {
                PsiElement methodNameParameter = functionReference.getParameter(0);
                return methodNameParameter != null && LocalControlFlowProcessor.isReflectionMethodCheckerReachable(instruction, classReference, methodNameParameter, "hasMethod");
            }
            if (PhpLangUtil.equalsMethodNames(name, "getProperty")) {
                PsiElement propertyNameParameter = functionReference.getParameter(0);
                return propertyNameParameter != null && LocalControlFlowProcessor.isReflectionMethodCheckerReachable(instruction, classReference, propertyNameParameter, "hasProperty");
            }
            return false;
        }

        private static boolean isReflectionMethodCheckerReachable(PhpCallInstruction instruction, final @NotNull Variable classReference, final @NotNull PsiElement parameter, final @NotNull String reflectionCheckerName) {
            if (classReference == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(8);
            }
            if (parameter == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(9);
            }
            if (reflectionCheckerName == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(10);
            }
            final Ref defined = new Ref((Object)Boolean.FALSE);
            final Ref undefined = new Ref((Object)Boolean.FALSE);
            PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                public boolean processConditionInstruction(PhpConditionInstruction conditionInstruction) {
                    return conditionInstruction.getCondition() == null || this.performDFA(conditionInstruction).apply((Ref<Boolean>)defined, (Ref<Boolean>)undefined);
                }

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    Variable targetParameterVariable;
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    if ((((PhpAccessInstructionImpl)instruction).isReadOrReadRefAccessLocalAware() || access.isWrite()) && PhpLangUtil.equalsVariableNames(instruction.getVariableName(), classReference.getName())) {
                        return false;
                    }
                    Variable variable = targetParameterVariable = parameter instanceof Variable ? (Variable)parameter : LocalControlFlowProcessor.getParameterVariableClassReference(parameter);
                    if (targetParameterVariable != null && access.isWrite() && PhpLangUtil.equalsVariableNames(instruction.getVariableName(), targetParameterVariable.getName())) {
                        undefined.set((Object)true);
                        return false;
                    }
                    return true;
                }

                public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                    if (!this.checkMemberReferenceIsActualAfterAccess((MemberReference)ObjectUtils.tryCast((Object)instruction.getFunctionReference(), MethodReference.class))) {
                        return false;
                    }
                    return super.processPhpCallInstruction(instruction);
                }

                public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                    if (instruction.getAccess().isWrite() && !this.checkMemberReferenceIsActualAfterAccess((MemberReference)ObjectUtils.tryCast((Object)instruction.getAnchor(), FieldReference.class))) {
                        return false;
                    }
                    return super.processAccessFieldByVariableInstruction(instruction);
                }

                private boolean checkMemberReferenceIsActualAfterAccess(MemberReference memberReference) {
                    Variable variableClassReference;
                    Variable parameterVariableClassReference = LocalControlFlowProcessor.getParameterVariableClassReference(parameter);
                    if (parameterVariableClassReference != null && memberReference != null && (variableClassReference = (Variable)ObjectUtils.tryCast((Object)memberReference.getClassReference(), Variable.class)) != null && PhpLangUtil.equalsVariableNames(variableClassReference.getName(), parameterVariableClassReference.getName())) {
                        undefined.set((Object)true);
                        return false;
                    }
                    return true;
                }

                @NotNull
                private PhpReachingDefinitionDFAnalyzer.Result performDFA(PhpConditionInstruction instruction) {
                    PhpReachingDefinitionDFAnalyzer.Result result = (PhpReachingDefinitionDFAnalyzer.Result)new PhpReachingDefinitionDFAnalyzer(){

                        @Override
                        @NotNull
                        public PhpReachingDefinitionDFAnalyzer.Result performDFA(@Nullable PsiElement condition, boolean result) {
                            if (condition instanceof MethodReference && PhpLangUtil.equalsMethodNames(((MethodReference)condition).getName(), reflectionCheckerName) && this.sameClassReferences((PsiElement)((MethodReference)condition).getClassReference()) && this.sameParameters(((MethodReference)condition).getParameter(0))) {
                                PhpReachingDefinitionDFAnalyzer.Result dfaResult = new PhpReachingDefinitionDFAnalyzer.Result();
                                if (result) {
                                    dfaResult.setDefined(Boolean.TRUE);
                                } else {
                                    dfaResult.setUndefined(Boolean.TRUE);
                                }
                                PhpReachingDefinitionDFAnalyzer.Result result2 = dfaResult;
                                if (result2 == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return result2;
                            }
                            PhpReachingDefinitionDFAnalyzer.Result result3 = (PhpReachingDefinitionDFAnalyzer.Result)super.performDFA(condition, result);
                            if (result3 == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return result3;
                        }

                        private boolean sameParameters(PsiElement checkerParameter) {
                            return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)parameter, (PsiElement)checkerParameter, (o1, o2) -> 0, null, null, (boolean)false);
                        }

                        private boolean sameClassReferences(PsiElement checkerClassReference) {
                            return checkerClassReference instanceof Variable && PhpLangUtil.equalsVariableNames(((Variable)checkerClassReference).getName(), classReference.getName());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor$2$1", "performDFA"));
                        }
                    }.performDFA(instruction);
                    if (result == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return result;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor$2", "performDFA"));
                }
            });
            return (Boolean)defined.get() != false && (Boolean)undefined.get() == false;
        }

        private static Variable getParameterVariableClassReference(@NotNull PsiElement parameter) {
            if (parameter == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(11);
            }
            if (parameter instanceof MemberReference) {
                return (Variable)ObjectUtils.tryCast((Object)((MemberReference)parameter).getClassReference(), Variable.class);
            }
            return null;
        }

        private static List<String> getCustomExceptions(@NotNull FunctionReference functionReference) {
            if (functionReference == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(12);
            }
            if (!(functionReference instanceof MethodReference)) {
                Collection<PsiElement> unwrappedOperands;
                int jsonThrowOnErrorParameterIndex = LocalControlFlowProcessor.getJsonThrowOnErrorParameterIndex(functionReference.getName());
                if (jsonThrowOnErrorParameterIndex < 0) {
                    return ContainerUtil.emptyList();
                }
                PsiElement parameter = functionReference.getParameter(jsonThrowOnErrorParameterIndex);
                if (parameter == null) {
                    return ContainerUtil.emptyList();
                }
                Collection<PsiElement> collection = unwrappedOperands = parameter instanceof BinaryExpression ? PhpCompletionContributor.unwrapOperands((BinaryExpression)parameter) : Collections.singletonList(PhpPsiUtil.unparenthesize(parameter));
                if (unwrappedOperands.stream().anyMatch(LocalControlFlowProcessor::isJsonThrowOnErrorArgument)) {
                    return Collections.singletonList("\\JsonException");
                }
            }
            return ContainerUtil.emptyList();
        }

        private static boolean isJsonThrowOnErrorArgument(PsiElement argument) {
            return argument instanceof ConstantReference && PhpLangUtil.equalsClassNames("JSON_THROW_ON_ERROR", ((ConstantReference)argument).getName());
        }

        private static int getJsonThrowOnErrorParameterIndex(String functionName) {
            if (PhpLangUtil.equalsClassNames("json_decode", functionName)) {
                return 3;
            }
            if (PhpLangUtil.equalsClassNames("json_encode", functionName)) {
                return 1;
            }
            return -1;
        }

        public boolean processConstructorCallInstruction(PhpConstructorCallInstruction instruction) {
            NewExpression newExpression = instruction.getNewExpression();
            PsiElement parent = newExpression.getParent();
            if (parent instanceof PhpThrowExpression && ((PhpThrowExpression)parent).getArgument() == newExpression) {
                return true;
            }
            if (PhpExceptionAnalysisService.shouldSkipConstructorWithConstantArguments(newExpression)) {
                return true;
            }
            ClassReference classReference = newExpression.getClassReference();
            if (classReference != null) {
                TextRange thrownRange = newExpression.getTextRange();
                String signature = PhpTypeSignatureKey.METHOD.sign((CharSequence)(classReference.getSignature() + ".__construct"));
                int[] thrownExceptions = new int[]{this.getCode("#C?" + signature)};
                RangeCode[] coughExceptions = this.getCoughExceptions(instruction.getCatchTargets());
                this.signatures.add(new Signature(thrownRange, thrownExceptions, coughExceptions, LocalControlFlowProcessor.getClassSignatureIfCheckedReflectionCall(newExpression)));
            }
            return true;
        }

        private RangeCode[] getCoughExceptions(@NotNull Collection<PhpHostInstruction> catchTargets) {
            if (catchTargets == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(13);
            }
            SmartList coughExceptions = new SmartList();
            for (PhpHostInstruction catchTarget : catchTargets) {
                for (PhpInstruction successor : catchTarget.getSuccessors()) {
                    if (!(successor instanceof PhpCatchConditionInstruction)) continue;
                    PhpCatchConditionInstruction catchCondition = (PhpCatchConditionInstruction)successor;
                    Variable variable = catchCondition.getException();
                    TextRange coughRange = variable != null ? variable.getTextRange() : null;
                    for (ClassReference coughException : catchCondition.getExceptionTypes()) {
                        String fqn = coughException.getFQN();
                        if (fqn == null) continue;
                        coughExceptions.add(new RangeCode(coughRange != null ? coughRange : coughException.getTextRange(), this.getCode(fqn)));
                    }
                }
            }
            return (RangeCode[])ContainerUtil.toArray((Collection)coughExceptions, RangeCode.ARRAY_FACTORY);
        }

        private int getCode(@NotNull String exception2) {
            if (exception2 == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(14);
            }
            if (this.exceptions.containsKey((Object)exception2)) {
                return this.exceptions.get((Object)exception2);
            }
            int i = this.exceptions.size();
            this.exceptions.put((Object)exception2, i);
            return i;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptions";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classReference";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reflectionCheckerName";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionReference";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "catchTargets";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exception";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRethrownExceptionsSignatures";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRethrownExceptions";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThrownExceptionCodes";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "signaturesFromClosureArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "calculateSignatures";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isReflectionMethodCheckerReachable";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getParameterVariableClassReference";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getCustomExceptions";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getCoughExceptions";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getCode";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static final class PhpRethrownException
        extends Exception {
            private final Signature mySignature;
            private final TextRange myTryRange;

            private PhpRethrownException(Signature originalSignature, TextRange tryRange) {
                this.mySignature = originalSignature;
                this.myTryRange = tryRange;
            }
        }

        protected static abstract class SignatureKind
        extends Enum<SignatureKind> {
            public static final /* enum */ SignatureKind CHECKED_REFLECTION_CALL = new SignatureKind("@R"){

                @Override
                public String completeException(Project project, Signature signature, SignatureList list, String exception2) {
                    String data = signature.myData;
                    assert (data != null);
                    return this.isReflectionClass(project, data) ? null : exception2;
                }
            };
            public static final /* enum */ SignatureKind SAFE_REFLECTION_CTOR = new SignatureKind("@CTOR"){

                @Override
                public String completeException(Project project, Signature signature, SignatureList list, String exception2) {
                    String data = signature.myData;
                    assert (data != null);
                    PhpType type = new PhpType();
                    for (String s : StringUtil.split((String)this.unsignData(signature), (String)SignatureKind.SEPARATOR)) {
                        type.add(s);
                    }
                    PhpType reflectionClassCtorType = type.global(project);
                    return !reflectionClassCtorType.hasUnknown() && reflectionClassCtorType.getTypes().stream().noneMatch(PhpType::isNotExtendablePrimitiveType) ? null : exception2;
                }
            };
            public static final /* enum */ SignatureKind REFLECTION_GET_METHOD_FROM_REAL_CLASS = new SignatureKind("@GM"){

                @Override
                public String completeException(Project project, Signature signature, SignatureList list, String exception2) {
                    return this.realClassContainsEntry(project, signature, true) ? null : exception2;
                }
            };
            public static final /* enum */ SignatureKind REFLECTION_GET_PROPERTY_FROM_REAL_CLASS = new SignatureKind("@GP"){

                @Override
                public String completeException(Project project, Signature signature, SignatureList list, String exception2) {
                    return this.realClassContainsEntry(project, signature, false) ? null : exception2;
                }
            };
            public static final /* enum */ SignatureKind FUNCTION_ACCEPTING_CLOSURE = new SignatureKind("@C"){

                @Override
                public String completeException(Project project, Signature signature, SignatureList list, String exception2) {
                    int argumentIndex;
                    String data = signature.myData;
                    assert (data != null);
                    int separator = data.lastIndexOf(".");
                    assert (separator > 0);
                    PhpIndex index = PhpIndex.getInstance((Project)project);
                    Collection elements = StringUtil.split((String)data.substring(2, separator), (String)"|").stream().flatMap(s -> PhpExceptionAnalysisService.getBySignature(s, index).stream()).collect(Collectors.toSet());
                    return ContainerUtil.all((Collection)elements, arg_0 -> this.lambda$completeException$1(argumentIndex = Integer.parseInt(data.substring(separator + 1)), arg_0)) ? exception2 : null;
                }

                private boolean isCallingPassedClosureWithoutCatch(PhpNamedElement function, int index) {
                    Ref callsPassedClosureWithoutCatch = new Ref((Object)Boolean.FALSE);
                    FileBasedIndex.getInstance().processValues(PhpFunctionsWithNotCatchedDynamicPassedCallsIndex.KEY, (Object)function.getFQN(), null, (file, value) -> {
                        if (value.contains(index)) {
                            callsPassedClosureWithoutCatch.set((Object)Boolean.TRUE);
                            return false;
                        }
                        return true;
                    }, GlobalSearchScope.allScope((Project)function.getProject()));
                    return (Boolean)callsPassedClosureWithoutCatch.get();
                }

                private /* synthetic */ boolean lambda$completeException$1(int argumentIndex, PhpNamedElement f) {
                    return f instanceof Function && (!(f instanceof Method) && PhpLangUtil.isGlobalNamespaceFQN(f.getNamespaceName()) || this.isCallingPassedClosureWithoutCatch(f, argumentIndex));
                }
            };
            public static final /* enum */ SignatureKind RETHROWN_EXCEPTION = new SignatureKind("@T"){

                @Override
                public String completeException(Project project, Signature signature, SignatureList list, String exception2) {
                    String data = signature.myData;
                    assert (data != null);
                    return this.getExceptionsFromCatchClause(list, data).isConvertibleFrom(new PhpType().add(exception2), PhpIndex.getInstance((Project)project)) ? exception2 : null;
                }

                @NotNull
                private PhpType getExceptionsFromCatchClause(SignatureList list, String data) {
                    PhpType exceptionsFromCatch = new PhpType();
                    SignatureKind.exceptionsFromCatchClause(list, data).forEach(arg_0 -> ((PhpType)exceptionsFromCatch).add(arg_0));
                    PhpType phpType = exceptionsFromCatch;
                    if (phpType == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    return phpType;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor$SignatureKind$6", "getExceptionsFromCatchClause"));
                }
            };
            static final String SEPARATOR = "@@";
            @NotNull
            private static final PhpType REFLECTION_CLASS;
            protected final String myPrefix;
            private static final /* synthetic */ SignatureKind[] $VALUES;

            public static SignatureKind[] values() {
                return (SignatureKind[])$VALUES.clone();
            }

            public static SignatureKind valueOf(String name) {
                return Enum.valueOf(SignatureKind.class, name);
            }

            @NotNull
            private static Stream<String> exceptionsFromCatchClause(SignatureList list, String data) {
                Stream<String> stream = Arrays.stream(data.substring(2).split(LocalControlFlowProcessor.RETHROWN_EXCEPTIONS_SEPARATOR)).mapToInt(Integer::parseInt).mapToObj(code -> list.exceptions[code]);
                if (stream == null) {
                    SignatureKind.$$$reportNull$$$0(0);
                }
                return stream;
            }

            private SignatureKind(String prefix) {
                this.myPrefix = prefix;
            }

            @NotNull
            protected String unsignData(Signature signature) {
                assert (signature.myData != null);
                String string = signature.myData.substring(this.myPrefix.length());
                if (string == null) {
                    SignatureKind.$$$reportNull$$$0(1);
                }
                return string;
            }

            protected boolean realClassContainsEntry(Project project, Signature signature, boolean method) {
                String data = this.unsignData(signature);
                int dot = data.indexOf(46);
                String entryName = data.substring(0, dot);
                int classReferenceIndex = data.indexOf(SignatureKind.CHECKED_REFLECTION_CALL.myPrefix);
                if (!this.isReflectionClass(project, data.substring(classReferenceIndex))) {
                    return false;
                }
                PhpIndex index = PhpIndex.getInstance((Project)project);
                String classTypes = data.substring(dot + 1, classReferenceIndex);
                return StreamEx.of((Collection)StringUtil.split((String)classTypes, (String)SEPARATOR)).flatMap(s -> s.startsWith("#") ? index.getBySignature(s).stream() : index.getAnyByFQN(s).stream()).select(PhpClass.class).anyMatch(c -> (method ? c.findMethodByName((CharSequence)entryName) : c.findFieldByName((CharSequence)entryName, false)) != null);
            }

            public boolean isReflectionClass(Project project, String data) {
                return REFLECTION_CLASS.isConvertibleFromGlobal(project, new PhpType().add(data.substring(2)));
            }

            private String sign(String signature) {
                return this.myPrefix + signature;
            }

            public abstract String completeException(Project var1, Signature var2, SignatureList var3, String var4);

            @Nullable
            private static SignatureKind getKindFromData(String data) {
                if (data == null) {
                    return null;
                }
                return (SignatureKind)((Object)ContainerUtil.find((Object[])SignatureKind.values(), kind -> StringUtil.startsWith((CharSequence)data, (CharSequence)kind.myPrefix)));
            }

            static {
                $VALUES = new SignatureKind[]{CHECKED_REFLECTION_CALL, SAFE_REFLECTION_CTOR, REFLECTION_GET_METHOD_FROM_REAL_CLASS, REFLECTION_GET_PROPERTY_FROM_REAL_CLASS, FUNCTION_ACCEPTING_CLOSURE, RETHROWN_EXCEPTION};
                REFLECTION_CLASS = new PhpType().add("\\ReflectionClass");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor$SignatureKind";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "exceptionsFromCatchClause";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "unsignData";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }

    public static class PhpThrownExceptionItem
    extends Pair<PhpType, TextRange> {
        public PhpThrownExceptionItem(@NotNull String exceptionFQN, @NotNull TextRange range) {
            if (exceptionFQN == null) {
                PhpThrownExceptionItem.$$$reportNull$$$0(0);
            }
            if (range == null) {
                PhpThrownExceptionItem.$$$reportNull$$$0(1);
            }
            this(new PhpType().add(exceptionFQN), range);
        }

        public PhpThrownExceptionItem(@NotNull PhpType exceptionType, @NotNull TextRange range) {
            if (exceptionType == null) {
                PhpThrownExceptionItem.$$$reportNull$$$0(2);
            }
            if (range == null) {
                PhpThrownExceptionItem.$$$reportNull$$$0(3);
            }
            super((Object)exceptionType, (Object)range);
        }

        @NotNull
        public PhpType getException() {
            PhpType phpType = (PhpType)this.first;
            if (phpType == null) {
                PhpThrownExceptionItem.$$$reportNull$$$0(4);
            }
            return phpType;
        }

        @NotNull
        public TextRange getThrownRange() {
            TextRange textRange = (TextRange)this.second;
            if (textRange == null) {
                PhpThrownExceptionItem.$$$reportNull$$$0(5);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionFQN";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionType";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$PhpThrownExceptionItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$PhpThrownExceptionItem";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getException";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThrownRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

