/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode.local;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.deadcode.PhpUnusedDeclarationInspection;
import com.jetbrains.php.lang.inspections.deadcode.PhpUnusedDeclarationPresentation;
import com.jetbrains.php.lang.inspections.quickfix.PhpRemoveUnusedStatementQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnusedSymbolsInspection
extends PhpInspection
implements UnfairLocalInspectionTool {
    @NotNull
    public static final Key<CachedValue<Set<PsiElement>>> DEFINITIONS_TO_PROCESS_KEY = Key.create((String)"php.deadcode.symbols.definitions");
    @NotNull
    public static final LocalQuickFix QUICK_FIX = new PhpRemoveUnusedStatementQuickFix(PhpBundle.message("inspection.group.unused.quickfix.label", new Object[0]), (Condition<PsiElement>)PhpNamedElement.INSTANCEOF, PhpTokenTypes.opCOMMA);
    @NotNull
    public static final String SHORT_NAME = "PhpDeadCode";
    @NotNull
    private static final String DISPLAY_NAME = "Local dead code";

    @Override
    @NonNls
    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file;
        PhpUnusedDeclarationInspection inspectionTool;
        if (holder == null) {
            PhpUnusedSymbolsInspection.$$$reportNull$$$0(0);
        }
        if ((inspectionTool = PhpUnusedSymbolsInspection.getPhpDeadCodeGlobalTool((file = holder.getFile()).getProject(), file)) != null) {
            final Set definitions = (Set)CachedValuesManager.getCachedValue((PsiElement)file, DEFINITIONS_TO_PROCESS_KEY, PhpUnusedSymbolsInspection.getCachedSet(file));
            return new PhpElementVisitor(){

                private void enqueueDefinition(@NotNull PsiElement psiElement) {
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!PhpUnusedSymbolsInspection.this.isSuppressedFor(psiElement) && PhpUnusedDeclarationPresentation.compareVisibilities((UserDataHolder)psiElement, inspectionTool.getMembersToReportPanel()) && !PhpUnusedDeclarationPresentation.acceptedByPatterns(psiElement, inspectionTool)) {
                        definitions.add(psiElement);
                    }
                }

                public void visitPhpClass(PhpClass clazz) {
                    this.enqueueDefinition((PsiElement)clazz);
                }

                public void visitPhpField(Field field) {
                    this.enqueueDefinition((PsiElement)field);
                }

                public void visitPhpMethod(Method method) {
                    this.enqueueDefinition((PsiElement)method);
                }

                public void visitPhpConstant(Constant constant) {
                    this.enqueueDefinition((PsiElement)constant);
                }

                public void visitPhpFunction(Function function) {
                    this.enqueueDefinition((PsiElement)function);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedSymbolsInspection$1", "enqueueDefinition"));
                }
            };
        }
        PhpElementVisitor phpElementVisitor = PhpElementVisitor.EMPTY;
        if (phpElementVisitor == null) {
            PhpUnusedSymbolsInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    @NotNull
    static CachedValueProvider<Set<PsiElement>> getCachedSet(@NotNull PsiFile file) {
        if (file == null) {
            PhpUnusedSymbolsInspection.$$$reportNull$$$0(2);
        }
        CachedValueProvider cachedValueProvider = () -> CachedValueProvider.Result.createSingleDependency((Object)ContainerUtil.newConcurrentSet(), (Object)file);
        if (cachedValueProvider == null) {
            PhpUnusedSymbolsInspection.$$$reportNull$$$0(3);
        }
        return cachedValueProvider;
    }

    @NotNull
    public static HighlightSeverity getPhpDeadCodeSeverity(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            PhpUnusedSymbolsInspection.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PhpUnusedSymbolsInspection.$$$reportNull$$$0(5);
        }
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        HighlightDisplayKey toolKey = HighlightDisplayKey.find((String)"PhpUnused");
        HighlightSeverity highlightSeverity = profile.getErrorLevel(toolKey, element).getSeverity();
        if (highlightSeverity == null) {
            PhpUnusedSymbolsInspection.$$$reportNull$$$0(6);
        }
        return highlightSeverity;
    }

    static boolean isDeadCodeEnabled(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            PhpUnusedSymbolsInspection.$$$reportNull$$$0(7);
        }
        if (file == null) {
            PhpUnusedSymbolsInspection.$$$reportNull$$$0(8);
        }
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        HighlightDisplayKey toolKey = HighlightDisplayKey.find((String)"PhpUnused");
        return profile.isToolEnabled(toolKey, (PsiElement)file);
    }

    @Nullable
    static PhpUnusedDeclarationInspection getPhpDeadCodeGlobalTool(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            PhpUnusedSymbolsInspection.$$$reportNull$$$0(9);
        }
        if (file == null) {
            PhpUnusedSymbolsInspection.$$$reportNull$$$0(10);
        }
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        InspectionProfileEntry tool = profile.getUnwrappedTool("PhpUnused", (PsiElement)file);
        return (PhpUnusedDeclarationInspection)((Object)ObjectUtils.tryCast((Object)tool, PhpUnusedDeclarationInspection.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedSymbolsInspection";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedSymbolsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedSet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpDeadCodeSeverity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCachedSet";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPhpDeadCodeSeverity";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDeadCodeEnabled";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPhpDeadCodeGlobalTool";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

