/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode.local;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.inspections.deadcode.PhpUnusedDeclarationInspection;
import com.jetbrains.php.lang.inspections.deadcode.PhpUnusedDeclarationPresentation;
import com.jetbrains.php.lang.inspections.deadcode.local.PhpUnusedSymbolsCache;
import com.jetbrains.php.lang.inspections.deadcode.local.PhpUnusedSymbolsFilterVisitor;
import com.jetbrains.php.lang.inspections.deadcode.local.PhpUnusedSymbolsInspection;
import com.jetbrains.php.lang.inspections.reference.PhpEntryPointsManager;
import com.jetbrains.php.lang.inspections.reference.PhpEntryPointsManagerImpl;
import com.jetbrains.php.lang.inspections.reference.util.PhpRefScopeUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnusedGlobalSymbolsPass
extends TextEditorHighlightingPass {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpUnusedSymbolsInspection.QUICK_FIX};
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final List<PsiElement> myUnusedSymbols;

    PhpUnusedGlobalSymbolsPass(@NotNull PsiFile file, @NotNull Document document) {
        if (file == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(1);
        }
        super(file.getProject(), document);
        this.myUnusedSymbols = new SmartList();
        this.myFile = file;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(2);
        }
        if (!HighlightingLevelManager.getInstance((Project)this.myProject).shouldInspect((PsiElement)this.myFile)) {
            return;
        }
        PhpUnusedDeclarationInspection globalInspectionTool = PhpUnusedSymbolsInspection.getPhpDeadCodeGlobalTool(this.myProject, this.myFile);
        if (globalInspectionTool == null || !PhpUnusedSymbolsInspection.isDeadCodeEnabled(this.myProject, this.myFile)) {
            return;
        }
        PhpUnusedGlobalSymbolsPass.searchForUnusedSymbols(this.myFile, this.myUnusedSymbols, globalInspectionTool);
    }

    public void doApplyInformationToEditor() {
        TextRange dirtyScope = this.getDirtyScope();
        PhpUnusedDeclarationInspection globalInspectionTool = PhpUnusedSymbolsInspection.getPhpDeadCodeGlobalTool(this.myProject, this.myFile);
        if (globalInspectionTool == null || dirtyScope == null) {
            return;
        }
        ArrayList infos = new ArrayList(this.myUnusedSymbols.size());
        HighlightSeverity severity = PhpUnusedSymbolsInspection.getPhpDeadCodeSeverity(this.myProject, (PsiElement)this.myFile);
        if (severity != HighlightSeverity.INFORMATION) {
            this.convertUnusedSymbolsToHighlightInfo(severity, infos);
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)dirtyScope.getStartOffset(), (int)dirtyScope.getEndOffset(), infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    private void convertUnusedSymbolsToHighlightInfo(@NotNull HighlightSeverity severity, @NotNull List<? super HighlightInfo> infos) {
        if (severity == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(3);
        }
        if (infos == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(4);
        }
        for (PsiElement unusedSymbol : this.myUnusedSymbols) {
            HighlightInfo info;
            PhpUnusedSymbolProblemDescriptor unused = PhpUnusedGlobalSymbolsPass.registerProblem(unusedSymbol);
            if (unused == null || (info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.UNUSED_SYMBOL).range(unused.myIdentifier).descriptionAndTooltip(unused.myMessage).severity(severity).create()) == null) continue;
            ProblemDescriptor problemDescriptor = ProblemDescriptorUtil.toProblemDescriptor((PsiFile)this.myFile, (HighlightInfo)info);
            HighlightDisplayKey toolKey = HighlightDisplayKey.find((String)"PhpUnused");
            if (problemDescriptor == null || toolKey == null) continue;
            for (LocalQuickFix quickFix : unused.myFixes) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new LocalQuickFixAsIntentionAdapter(quickFix, problemDescriptor), (HighlightDisplayKey)toolKey);
            }
            infos.add((HighlightInfo)info);
        }
    }

    @Nullable
    private TextRange getDirtyScope() {
        return DaemonCodeAnalyzerEx.getInstanceEx((Project)this.myProject).getFileStatusMap().getFileDirtyScope(this.myDocument, this.getId());
    }

    private static void searchForUnusedSymbols(@NotNull PsiFile file, @NotNull List<PsiElement> outUnusedSymbols, @NotNull PhpUnusedDeclarationInspection inspectionTool) {
        if (file == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(5);
        }
        if (outUnusedSymbols == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(6);
        }
        if (inspectionTool == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(7);
        }
        Set candidates = (Set)CachedValuesManager.getCachedValue((PsiElement)file, PhpUnusedSymbolsInspection.DEFINITIONS_TO_PROCESS_KEY, PhpUnusedSymbolsInspection.getCachedSet(file));
        UnusedElementsData unusedElementsData = new UnusedElementsData(file);
        PhpUnusedSymbolsFilterVisitor inspectionVisitor = new PhpUnusedSymbolsFilterVisitor((x$0, x$1) -> unusedElementsData.addProcessedCandidate((PsiElement)x$0, (PsiElement)x$1));
        for (PsiElement candidate : candidates) {
            if (inspectionTool.isSuppressedFor(candidate) || !PhpUnusedDeclarationPresentation.compareVisibilities((UserDataHolder)candidate, inspectionTool.getMembersToReportPanel()) || PhpUnusedDeclarationPresentation.acceptedByPatterns(candidate, inspectionTool)) continue;
            candidate.accept((PsiElementVisitor)inspectionVisitor);
        }
        unusedElementsData.searchForCandidateReferencingFiles();
        unusedElementsData.searchInCandidateFiles();
        unusedElementsData.nullizeReferencesForRemainingCandidates();
        unusedElementsData.fillElementsToReport(outUnusedSymbols);
    }

    @Nullable
    private static String getNameToSearch(@NotNull PsiElement elementToSearch) {
        if (elementToSearch == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(8);
        }
        if (elementToSearch instanceof PhpNamedElement) {
            return ((PhpNamedElement)elementToSearch).getName();
        }
        Logger.getInstance(PhpUnusedSymbolsFilterVisitor.class).error("Unknown element passed: " + elementToSearch.getClass().getSimpleName());
        return null;
    }

    @Nullable
    private static GlobalSearchScope getScopeForSearch(@NotNull PsiElement elementToSearch) {
        if (elementToSearch == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(9);
        }
        Project project = elementToSearch.getProject();
        VirtualFile virtualFile = elementToSearch.getContainingFile().getVirtualFile();
        if (virtualFile == null || ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibrary(virtualFile) || PhpRefScopeUtil.isByBuiltInLibrary(virtualFile)) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        return PhpRefScopeUtil.getReferencesSearchScope(scope);
    }

    @Nullable
    private static PhpUnusedSymbolProblemDescriptor registerProblem(@NotNull PsiElement element) {
        if (element == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(10);
        }
        if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.VARIABLE, PhpTokenTypes.IDENTIFIER)) {
            return null;
        }
        PhpNamedElement namedElement = (PhpNamedElement)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)PhpNamedElement.INSTANCEOF);
        if (namedElement == null) {
            return null;
        }
        return new PhpUnusedSymbolProblemDescriptor(element, PhpBundle.message("inspection.group.unused.quickfix.message", PhpPresentationUtil.getPresentation(namedElement).getPresentableText()), PhpUnusedGlobalSymbolsPass.getFixes(namedElement));
    }

    @NotNull
    private static LocalQuickFix[] getFixes(PhpNamedElement namedElement) {
        Collection<String> tags2 = PhpUnusedDeclarationPresentation.getCustomDocTags(namedElement);
        if (tags2.isEmpty()) {
            if (FIXES == null) {
                PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(11);
            }
            return FIXES;
        }
        List<LocalQuickFix> fixes = tags2.stream().map(x$0 -> new PhpSuppressDocTagQuickFix((String)x$0)).limit(10L).collect(Collectors.toList());
        fixes.add(PhpUnusedSymbolsInspection.QUICK_FIX);
        LocalQuickFix[] localQuickFixArray = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(12);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outUnusedSymbols";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionTool";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToSearch";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedGlobalSymbolsPass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedGlobalSymbolsPass";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertUnusedSymbolsToHighlightInfo";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "searchForUnusedSymbols";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNameToSearch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getScopeForSearch";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PhpSuppressDocTagQuickFix
    implements LocalQuickFix {
        private final String myTagName;

        private PhpSuppressDocTagQuickFix(String tagName) {
            this.myTagName = tagName;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("suppress.if.annotated.by.tag", this.myTagName);
            if (string == null) {
                PhpSuppressDocTagQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpSuppressDocTagQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpSuppressDocTagQuickFix.$$$reportNull$$$0(2);
            }
            PhpEntryPointsManagerImpl manager = (PhpEntryPointsManagerImpl)PhpEntryPointsManager.getProjectInstance((Project)project);
            manager.getSuppressedAnnotations().add(this.myTagName);
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedGlobalSymbolsPass$PhpSuppressDocTagQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedGlobalSymbolsPass$PhpSuppressDocTagQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UnusedElementsData {
        @NotNull
        private final BidirectionalMap<PsiElement, PsiElement> processedCandidates;
        @NotNull
        private final MultiMap<VirtualFile, PsiElement> candidateReferencingFiles;
        @NotNull
        private final Set<PsiElement> definitelyUnusedElementsToReport;
        @NotNull
        private final PsiFile myFile;

        UnusedElementsData(@NotNull PsiFile baseFile) {
            if (baseFile == null) {
                UnusedElementsData.$$$reportNull$$$0(0);
            }
            this.processedCandidates = new BidirectionalMap();
            this.candidateReferencingFiles = MultiMap.create();
            this.definitelyUnusedElementsToReport = new HashSet<PsiElement>();
            this.myFile = baseFile;
        }

        private void addProcessedCandidate(@NotNull PsiElement elementToSearch, @Nullable PsiElement elementToReport) {
            if (elementToSearch == null) {
                UnusedElementsData.$$$reportNull$$$0(1);
            }
            if (elementToReport != null) {
                this.processedCandidates.put((Object)elementToReport, (Object)elementToSearch);
            }
        }

        private void searchForCandidateReferencingFiles() {
            HashSet<PsiElement> definitelyUsedElementsToReport = new HashSet<PsiElement>();
            PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)this.myFile.getProject());
            for (Map.Entry elementEntry : this.processedCandidates.entrySet()) {
                PsiElement elementToReport = (PsiElement)elementEntry.getKey();
                PsiElement elementToSearch = (PsiElement)elementEntry.getValue();
                ThreeState isUsed = PhpUnusedSymbolsCache.isUsedImplicitlyOrFromCache(elementToSearch);
                if (isUsed == ThreeState.YES || isUsed == ThreeState.NO) {
                    if (isUsed == ThreeState.YES) {
                        definitelyUsedElementsToReport.add(elementToReport);
                        continue;
                    }
                    this.definitelyUnusedElementsToReport.add(elementToReport);
                    continue;
                }
                GlobalSearchScope scope = PhpUnusedGlobalSymbolsPass.getScopeForSearch(elementToSearch);
                String name = PhpUnusedGlobalSymbolsPass.getNameToSearch(elementToSearch);
                if (scope == null || name == null || helper.isCheapEnoughToSearch(name, scope, this.myFile, null) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                    definitelyUsedElementsToReport.add(elementToReport);
                    continue;
                }
                helper.processCandidateFilesForText(scope, (short)255, true, name, virtualFile -> {
                    this.candidateReferencingFiles.putValue(virtualFile, (Object)elementToSearch);
                    return true;
                });
            }
            this.removeCandidateElementsToProcess(this.definitelyUnusedElementsToReport);
            this.removeCandidateElementsToProcess(definitelyUsedElementsToReport);
        }

        private void removeCandidateElementsToProcess(@Nullable Collection<PsiElement> elementsToReport) {
            if (elementsToReport != null) {
                elementsToReport.forEach(arg_0 -> this.processedCandidates.remove(arg_0));
            }
        }

        private void searchInCandidateFiles() {
            PsiManager manager = this.myFile.getManager();
            for (Map.Entry entry : this.candidateReferencingFiles.entrySet()) {
                PsiFile candidateReferencingFile;
                Collection elementsToSearch = (Collection)entry.getValue();
                elementsToSearch.retainAll(this.processedCandidates.values());
                if (elementsToSearch.isEmpty() || (candidateReferencingFile = manager.findFile((VirtualFile)entry.getKey())) == null) continue;
                this.searchAndCacheReferences(elementsToSearch, candidateReferencingFile);
            }
        }

        private void searchAndCacheReferences(@NotNull Collection<PsiElement> elementsToSearch, @NotNull PsiFile psiFile) {
            if (elementsToSearch == null) {
                UnusedElementsData.$$$reportNull$$$0(2);
            }
            if (psiFile == null) {
                UnusedElementsData.$$$reportNull$$$0(3);
            }
            GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)psiFile);
            for (PsiElement elementToSearch : elementsToSearch) {
                PsiReference reference = PhpUnusedSymbolsCache.findAnyReference(elementToSearch, (SearchScope)fileScope);
                if (reference == null) continue;
                PhpUnusedSymbolsCache.saveFoundReference(reference, elementToSearch);
                this.removeCandidateElementsToProcess(this.processedCandidates.getKeysByValue((Object)elementToSearch));
            }
        }

        private void fillElementsToReport(@NotNull Collection<PsiElement> outElementsToReport) {
            if (outElementsToReport == null) {
                UnusedElementsData.$$$reportNull$$$0(4);
            }
            outElementsToReport.addAll(this.definitelyUnusedElementsToReport);
            outElementsToReport.addAll(this.processedCandidates.keySet());
        }

        private void nullizeReferencesForRemainingCandidates() {
            for (PsiElement elementToSearch : this.processedCandidates.values()) {
                PhpUnusedSymbolsCache.saveFoundReference(null, elementToSearch);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToSearch";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementsToSearch";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outElementsToReport";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedGlobalSymbolsPass$UnusedElementsData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addProcessedCandidate";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "searchAndCacheReferences";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillElementsToReport";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpUnusedSymbolProblemDescriptor {
        @NotNull
        public final PsiElement myIdentifier;
        @NotNull
        public final @NlsContexts.DetailedDescription String myMessage;
        public final LocalQuickFix @NotNull [] myFixes;

        PhpUnusedSymbolProblemDescriptor(@NotNull PsiElement nameIdentifier, @NotNull @NlsContexts.DetailedDescription String message, LocalQuickFix ... fixes) {
            if (nameIdentifier == null) {
                PhpUnusedSymbolProblemDescriptor.$$$reportNull$$$0(0);
            }
            if (message == null) {
                PhpUnusedSymbolProblemDescriptor.$$$reportNull$$$0(1);
            }
            if (fixes == null) {
                PhpUnusedSymbolProblemDescriptor.$$$reportNull$$$0(2);
            }
            this.myIdentifier = nameIdentifier;
            this.myMessage = message;
            this.myFixes = fixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "nameIdentifier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fixes";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedGlobalSymbolsPass$PhpUnusedSymbolProblemDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

