/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode.coreDeclaration;

import com.jetbrains.php.lang.inspections.deadcode.coreDeclaration.PhpCoreArrayAccessProvider;
import com.jetbrains.php.lang.inspections.deadcode.coreDeclaration.PhpCoreHandler;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpCoreArrayTraversableProvider
implements PhpCoreHandler {
    private static final String ARRAY_ITERATOR = "ArrayIterator";
    private static final String ITERATOR = "Iterator";
    private static final String ITERATOR_AGGREGATE = "IteratorAggregate";
    private static final int[] ALLOWED_REF_HASHES = new int[]{4, 8, 32};
    private static final Set<String> ROOT_INTERFACES = Set.of("ArrayIterator", "Iterator", "IteratorAggregate");
    private static final Set<String> FOREACH_METHODS = Set.of("current", "key", "next", "rewind", "valid", "getIterator");

    @Override
    public boolean accepts(@NotNull PhpPsiElement psiElement, @NotNull PhpPsiElement context) {
        if (psiElement == null) {
            PhpCoreArrayTraversableProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpCoreArrayTraversableProvider.$$$reportNull$$$0(1);
        }
        return this.getArrayForHash(psiElement, context) > 0;
    }

    @Override
    public int getHash(@NotNull PhpPsiElement psiElement, @NotNull PhpPsiElement context) {
        if (psiElement == null) {
            PhpCoreArrayTraversableProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PhpCoreArrayTraversableProvider.$$$reportNull$$$0(3);
        }
        return this.getArrayForHash(psiElement, context);
    }

    @Override
    public boolean inferImplicitlyUsages(@NotNull PhpRefClass refClass, @NotNull String methodName) {
        if (refClass == null) {
            PhpCoreArrayTraversableProvider.$$$reportNull$$$0(4);
        }
        if (methodName == null) {
            PhpCoreArrayTraversableProvider.$$$reportNull$$$0(5);
        }
        if (this.isAllowed(refClass, ALLOWED_REF_HASHES)) {
            if (refClass.isCoreInterfacesImplemented(8)) {
                return PhpCoreArrayTraversableProvider.inferIteratorInterfaceUsages(methodName, refClass.getCoreMethodsReferencedFlag());
            }
            if (refClass.isCoreInterfacesImplemented(4) || refClass.isCoreInterfacesImplemented(32)) {
                return PhpCoreArrayTraversableProvider.inferArrayIteratorInterfaceUsages(methodName, refClass.getCoreMethodsReferencedFlag());
            }
        }
        return false;
    }

    @Override
    public boolean acceptsClass(@NotNull PhpRefClass refClass) {
        if (refClass == null) {
            PhpCoreArrayTraversableProvider.$$$reportNull$$$0(6);
        }
        return ROOT_INTERFACES.contains(refClass.getName());
    }

    @Override
    public int getClassHash(@NotNull PhpRefClass refClass) {
        String className;
        if (refClass == null) {
            PhpCoreArrayTraversableProvider.$$$reportNull$$$0(7);
        }
        if (ARRAY_ITERATOR.equals(className = refClass.getName())) {
            return 4;
        }
        if (ITERATOR.equals(className)) {
            return 8;
        }
        if (ITERATOR_AGGREGATE.equals(className)) {
            return 32;
        }
        return 0;
    }

    @Override
    public boolean accepts(@NotNull PhpRefClass refClass, @NotNull PhpRefMethod refMethod) {
        if (refClass == null) {
            PhpCoreArrayTraversableProvider.$$$reportNull$$$0(8);
        }
        if (refMethod == null) {
            PhpCoreArrayTraversableProvider.$$$reportNull$$$0(9);
        }
        return this.isAllowed(refClass, ALLOWED_REF_HASHES) && FOREACH_METHODS.contains(refMethod.getName());
    }

    public static boolean inferIteratorInterfaceUsages(@NotNull String methodName, int referencesHash) {
        if (methodName == null) {
            PhpCoreArrayTraversableProvider.$$$reportNull$$$0(10);
        }
        return FOREACH_METHODS.contains(methodName) && PhpCoreHandler.isMethodUsed(referencesHash, 4);
    }

    private static boolean inferArrayIteratorInterfaceUsages(@NotNull String methodName, int referencesHash) {
        if (methodName == null) {
            PhpCoreArrayTraversableProvider.$$$reportNull$$$0(11);
        }
        return PhpCoreArrayAccessProvider.inferArrayObjectInterfaceUsage(methodName, referencesHash);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClass";
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refMethod";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/coreDeclaration/PhpCoreArrayTraversableProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accepts";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getHash";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "inferImplicitlyUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsClass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassHash";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "inferIteratorInterfaceUsages";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "inferArrayIteratorInterfaceUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

