/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode.coreDeclaration;

import com.jetbrains.php.lang.inspections.deadcode.coreDeclaration.PhpCoreArrayTraversableProvider;
import com.jetbrains.php.lang.inspections.deadcode.coreDeclaration.PhpCoreHandler;
import com.jetbrains.php.lang.inspections.deadcode.coreDeclaration.PhpCoreReferenceHashProvider;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpCoreArrayAccessProvider
implements PhpCoreHandler {
    private static final String ARRAY_ACCESS = "ArrayAccess";
    private static final String ARRAY_OBJECT = "ArrayObject";
    private static final Set<String> ROOT_INTERFACES = Set.of("ArrayAccess", "ArrayObject");
    private static final int[] ALLOWED_REF_HASHES = new int[]{1, 2};
    private static final String ARRAY_EXISTS_OFFSET = "offsetExists";
    private static final String ARRAY_GET_OFFSET = "offsetGet";
    private static final String ARRAY_SET_OFFSET = "offsetSet";
    private static final String ARRAY_UNSET_OFFSET = "offsetUnset";

    @Override
    public boolean accepts(@NotNull PhpPsiElement psiElement, @NotNull PhpPsiElement context) {
        if (psiElement == null) {
            PhpCoreArrayAccessProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpCoreArrayAccessProvider.$$$reportNull$$$0(1);
        }
        if (context instanceof ArrayAccessExpression) {
            return this.getArrayAccessHash((ArrayAccessExpression)context) > 0;
        }
        return this.getArrayExistsHash(context, psiElement) > 0;
    }

    @Override
    public int getHash(@NotNull PhpPsiElement psiElement, @NotNull PhpPsiElement context) {
        if (psiElement == null) {
            PhpCoreArrayAccessProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PhpCoreArrayAccessProvider.$$$reportNull$$$0(3);
        }
        if (context instanceof ArrayAccessExpression) {
            return this.getArrayAccessHash((ArrayAccessExpression)context);
        }
        return this.getArrayExistsHash(context, psiElement);
    }

    @Override
    public boolean inferImplicitlyUsages(@NotNull PhpRefClass refClass, @NotNull String methodName) {
        if (refClass == null) {
            PhpCoreArrayAccessProvider.$$$reportNull$$$0(4);
        }
        if (methodName == null) {
            PhpCoreArrayAccessProvider.$$$reportNull$$$0(5);
        }
        if (this.isAllowed(refClass, ALLOWED_REF_HASHES)) {
            if (refClass.isCoreInterfacesImplemented(1)) {
                return PhpCoreArrayAccessProvider.inferArrayAccessInterfaceUsage(methodName, refClass.getCoreMethodsReferencedFlag());
            }
            if (refClass.isCoreInterfacesImplemented(2)) {
                return PhpCoreArrayAccessProvider.inferArrayObjectInterfaceUsage(methodName, refClass.getCoreMethodsReferencedFlag());
            }
        }
        return false;
    }

    @Override
    public boolean acceptsClass(@NotNull PhpRefClass refClass) {
        if (refClass == null) {
            PhpCoreArrayAccessProvider.$$$reportNull$$$0(6);
        }
        return ROOT_INTERFACES.contains(refClass.getName());
    }

    @Override
    public int getClassHash(@NotNull PhpRefClass refClass) {
        String className;
        if (refClass == null) {
            PhpCoreArrayAccessProvider.$$$reportNull$$$0(7);
        }
        if (ARRAY_ACCESS.equals(className = refClass.getName())) {
            return 1;
        }
        if (ARRAY_OBJECT.equals(className)) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean accepts(@NotNull PhpRefClass refClass, @NotNull PhpRefMethod refMethod) {
        if (refClass == null) {
            PhpCoreArrayAccessProvider.$$$reportNull$$$0(8);
        }
        if (refMethod == null) {
            PhpCoreArrayAccessProvider.$$$reportNull$$$0(9);
        }
        if (this.isAllowed(refClass, ALLOWED_REF_HASHES)) {
            String methodName = refMethod.getName();
            return ARRAY_EXISTS_OFFSET.equals(methodName) || ARRAY_UNSET_OFFSET.equals(methodName) || ARRAY_SET_OFFSET.equals(methodName) || ARRAY_GET_OFFSET.equals(methodName);
        }
        return false;
    }

    private static boolean inferArrayAccessInterfaceUsage(@NotNull String methodName, int referencesHash) {
        if (methodName == null) {
            PhpCoreArrayAccessProvider.$$$reportNull$$$0(10);
        }
        if (ARRAY_EXISTS_OFFSET.equals(methodName)) {
            return PhpCoreHandler.isMethodUsed(referencesHash, 64);
        }
        if (ARRAY_GET_OFFSET.equals(methodName)) {
            return PhpCoreHandler.isMethodUsed(referencesHash, 64) || PhpCoreHandler.isMethodUsed(referencesHash, 2);
        }
        if (ARRAY_SET_OFFSET.equals(methodName)) {
            return PhpCoreHandler.isMethodUsed(referencesHash, 1) || PhpCoreHandler.isMethodUsed(referencesHash, 128);
        }
        if (ARRAY_UNSET_OFFSET.equals(methodName)) {
            return PhpCoreHandler.isMethodUsed(referencesHash, 128);
        }
        return false;
    }

    public static boolean inferArrayObjectInterfaceUsage(@NotNull String methodName, int referencesHash) {
        if (methodName == null) {
            PhpCoreArrayAccessProvider.$$$reportNull$$$0(11);
        }
        return PhpCoreArrayAccessProvider.inferArrayAccessInterfaceUsage(methodName, referencesHash) || PhpCoreArrayTraversableProvider.inferIteratorInterfaceUsages(methodName, referencesHash) || PhpCoreReferenceHashProvider.inferCountableHashUsages(methodName, referencesHash);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClass";
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refMethod";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/coreDeclaration/PhpCoreArrayAccessProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accepts";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getHash";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "inferImplicitlyUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsClass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassHash";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "inferArrayAccessInterfaceUsage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "inferArrayObjectInterfaceUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

