/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode;

import com.google.common.base.Predicates;
import com.intellij.DynamicBundle;
import com.intellij.analysis.AnalysisBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.ui.AddEditRemovePanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.deadcode.coreDeclaration.PhpCoreHandler;
import com.jetbrains.php.lang.inspections.deadcode.filters.PhpCommonRefFilter;
import com.jetbrains.php.lang.inspections.deadcode.filters.PhpRefUnreachableFilter;
import com.jetbrains.php.lang.inspections.deadcode.filters.PhpStrictUnreferencedFilter;
import com.jetbrains.php.lang.inspections.deadcode.local.PhpUnusedSymbolsInspection;
import com.jetbrains.php.lang.inspections.deadcode.magicDeclaration.PhpMagicContext;
import com.jetbrains.php.lang.inspections.reference.PhpClassPatternsPanel;
import com.jetbrains.php.lang.inspections.reference.PhpEntryPointsManager;
import com.jetbrains.php.lang.inspections.reference.PhpEntryPointsManagerImpl;
import com.jetbrains.php.lang.inspections.reference.PhpGlobalInspectionContext;
import com.jetbrains.php.lang.inspections.reference.PhpMembersToReportOptionsPanel;
import com.jetbrains.php.lang.inspections.reference.PhpRefManager;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMember;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMemberImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefConstant;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefConstantImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElement;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElementImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefField;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFileImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunction;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunctionImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethodImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefNamespaceImpl;
import com.jetbrains.php.lang.inspections.reference.util.PhpRefScopeUtil;
import com.jetbrains.php.lang.inspections.reference.visitors.PhpRefVisitor;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnusedDeclarationInspection
extends GlobalInspectionTool {
    @NotNull
    @NonNls
    public static final String SHORT_NAME = "PhpUnused";
    @NotNull
    @NonNls
    public static final String ALTERNATIVE_ID = "PhpUnused";
    @NotNull
    @NonNls
    private static final String DEAD_CODE_TOOL = "com.intellij.phpDeadCode";
    @NotNull
    private static final Logger LOG = Logger.getInstance(PhpUnusedDeclarationInspection.class);
    @NotNull
    private final List<EntryPoint> myExtensions = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    private final PhpMembersToReportOptionsPanel myMembersToReportOptionsPanel = new PhpMembersToReportOptionsPanel();
    @NotNull
    private final PhpUnusedSymbolsInspection myUnusedSymbolsInspection = new PhpUnusedSymbolsInspection();
    public boolean SUPPRESS_GETTERS_AND_SETTERS = false;
    public boolean SUPPRESS_TEST_ENTRIES = true;
    public boolean SHOW_UNUSED_BY_ENTRIES = true;
    private int myPhase;
    private boolean wasGraphFullyTraversed;
    @Nullable
    private Set<RefElement> myProcessedSuspicious;

    public PhpUnusedDeclarationInspection() {
        this.initExtensions();
    }

    @NotNull
    public PhpMembersToReportOptionsPanel getMembersToReportPanel() {
        PhpMembersToReportOptionsPanel phpMembersToReportOptionsPanel = this.myMembersToReportOptionsPanel;
        if (phpMembersToReportOptionsPanel == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(0);
        }
        return phpMembersToReportOptionsPanel;
    }

    @NotNull
    public String getShortName() {
        return "PhpUnused";
    }

    @NotNull
    public LocalInspectionTool getSharedLocalInspectionTool() {
        PhpUnusedSymbolsInspection phpUnusedSymbolsInspection = this.myUnusedSymbolsInspection;
        if (phpUnusedSymbolsInspection == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(1);
        }
        return phpUnusedSymbolsInspection;
    }

    public void initExtensions() {
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint(DEAD_CODE_TOOL);
        SmartList deadCodeAddIns = new SmartList();
        for (EntryPoint entryPointTool : (EntryPoint[])point.getExtensions()) {
            try {
                deadCodeAddIns.add(entryPointTool.clone());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        ContainerUtil.sort((List)deadCodeAddIns, (o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName()));
        this.myExtensions.addAll((Collection<EntryPoint>)deadCodeAddIns);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(2);
        }
        super.readSettings(node);
        this.getMembersToReportPanel().readSettings(node);
        this.myExtensions.forEach(extension -> extension.readExternal(node));
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(3);
        }
        super.writeSettings(node);
        this.getMembersToReportPanel().writeSettings(node);
        this.myExtensions.forEach(extension -> extension.writeExternal(node));
    }

    public void runInspection(final @NotNull AnalysisScope scope, @NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (scope == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(5);
        }
        if (globalContext == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(6);
        }
        if (problemDescriptionsProcessor == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(7);
        }
        final RefManager refManager = globalContext.getRefManager();
        this.wasGraphFullyTraversed = PhpRefScopeUtil.containsProjectScope(globalContext.getProject(), (AnalysisScope)ObjectUtils.notNull((Object)refManager.getScope(), (Object)scope));
        refManager.iterate((RefVisitor)new PhpRefVisitor(){

            @Override
            public void visitRefClass(PhpRefClass refClass) {
                PhpRefClassImpl.acceptImplicitlyUsagesInfo((PhpRefClassImpl)refClass, PhpUnusedDeclarationInspection.this.wasGraphFullyTraversed, PhpUnusedDeclarationInspection.this.isWithTestEntries());
            }

            @Override
            public void visitRefMember(PhpRefClassMember refClassMember) {
                PhpRefClassMemberImpl.inferUsagesByInheritance(refClassMember);
            }
        });
        refManager.iterate((RefVisitor)new PhpRefVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (refEntity instanceof RefElementImpl) {
                    PsiFile file;
                    RefElementImpl refElement = (RefElementImpl)refEntity;
                    if (!refElement.isSuspicious()) {
                        return;
                    }
                    if (!refElement.isEntry()) {
                        this.acceptAsEntryTestElements(refElement);
                        this.acceptAsImplicitlyUsed(refElement);
                    }
                    if ((file = refElement.getContainingFile()) != null) {
                        this.suppressRefElementAsEntry(refElement, file);
                    }
                }
            }

            private void acceptAsImplicitlyUsed(@NotNull RefElementImpl refElement) {
                if (refElement == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (refElement instanceof PhpRefFunctionImpl) {
                    if (((PhpRefFunctionImpl)refElement).getImplicitlyUsed()) {
                        PhpRefManager.getEntryPointsManager((RefManager)refManager).addEntryPoint((RefElement)refElement, false);
                    }
                } else if (refElement instanceof PhpRefClassImpl && ((PhpRefClassImpl)refElement).isConstructorImplicitlyUsed()) {
                    PhpRefManager.getEntryPointsManager((RefManager)refManager).addEntryPoint((RefElement)refElement, false);
                }
            }

            private void acceptAsEntryTestElements(@NotNull RefElementImpl refElement) {
                if (refElement == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (refElement instanceof PhpRefMethod && ((PhpRefMethod)refElement).isTest()) {
                    PhpRefManager.getEntryPointsManager((RefManager)refManager).addEntryPoint((RefElement)refElement, false);
                } else if (refElement instanceof PhpRefClass && ((PhpRefClass)refElement).isTest()) {
                    PhpRefManager.getEntryPointsManager((RefManager)refManager).addEntryPoint((RefElement)refElement, false);
                }
            }

            private void suppressRefElementAsEntry(@NotNull RefElementImpl refElement, @NotNull PsiFile file) {
                if (refElement == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (!(!refElement.isSuppressed(new String[]{PhpUnusedDeclarationInspection.this.getShortName(), "PhpUnused"}) && ((GlobalInspectionContextBase)globalContext).isToCheckFile(file, (InspectionProfileEntry)PhpUnusedDeclarationInspection.this) || scope.contains((PsiElement)file))) {
                    PhpRefManager.getEntryPointsManager((RefManager)refManager).addEntryPoint((RefElement)refElement, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refEntity";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refElement";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationInspection$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptAsImplicitlyUsed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptAsEntryTestElements";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "suppressRefElementAsEntry";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myPhase = 1;
        this.myProcessedSuspicious = new HashSet<RefElement>();
    }

    public PhpCommonRefFilter getFilter(@NotNull GlobalInspectionContext globalContext, boolean firstPhase) {
        if (globalContext == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(8);
        }
        return firstPhase ? new PhpStrictUnreferencedFilter(this, globalContext) : new PhpRefUnreachableFilter(this, globalContext);
    }

    public boolean queryExternalUsagesRequests(@NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (manager == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(9);
        }
        if (globalContext == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(10);
        }
        if (problemDescriptionsProcessor == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(11);
        }
        this.checkForReachableRefs(globalContext);
        if (this.wasGraphFullyTraversed) {
            this.myPhase = 2;
            this.myProcessedSuspicious = null;
            return false;
        }
        final PhpCommonRefFilter refFilter = this.getFilter(globalContext, this.myPhase == 1);
        final Ref requestAdded = new Ref((Object)false);
        final AnalysisScope analysisScope = globalContext.getRefManager().getScope();
        final RefManager refManager = globalContext.getRefManager();
        refManager.iterate((RefVisitor)new PhpRefVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                boolean accepted;
                if (refEntity == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (analysisScope == null || !(refEntity instanceof PhpRefElementImpl)) {
                    return;
                }
                if (refEntity instanceof PhpRefClass && ((PhpRefClass)refEntity).isAnonymous()) {
                    return;
                }
                final PhpRefElementImpl refElement = (PhpRefElementImpl)refEntity;
                boolean bl = accepted = refManager.belongsToScope((PsiElement)refElement.getPhpElement()) && !refElement.isFromCommon() && refFilter.accepts(refElement);
                if (accepted && PhpUnusedDeclarationInspection.this.myProcessedSuspicious != null && !PhpUnusedDeclarationInspection.this.myProcessedSuspicious.contains((Object)refElement)) {
                    refElement.accept(new PhpRefVisitor(){
                        @NotNull
                        private final PhpGlobalInspectionContext.UsagesProcessor myUsagesProcessor = new PhpGlobalInspectionContext.UsagesProcessor(){

                            public boolean process(@Nullable PsiReference reference) {
                                PhpRefManager.getEntryPointsManager((RefManager)refManager).addEntryPoint((RefElement)refElement, false);
                                return false;
                            }

                            public boolean isSensibleToProcess() {
                                return !refElement.isEntry();
                            }
                        };

                        @Override
                        public void visitRefField(@NotNull PhpRefField refField) {
                            if (refField == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            PhpUnusedDeclarationInspection.this.myProcessedSuspicious.add((RefElement)refField);
                            PhpGlobalInspectionContext.getInstance((GlobalInspectionContext)globalContext).enqueueDerivedFieldUsagesProcessor(refField, member -> {
                                PhpRefManager.getEntryPointsManager((RefManager)refManager).addEntryPoint((RefElement)refField, false);
                                return false;
                            });
                            PhpGlobalInspectionContext.getInstance((GlobalInspectionContext)globalContext).enqueueFieldUsagesProcessor(refField, this.myUsagesProcessor);
                            requestAdded.set((Object)true);
                        }

                        @Override
                        public void visitRefFunction(@NotNull PhpRefFunction refFunction) {
                            if (refFunction == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            PhpUnusedDeclarationInspection.this.myProcessedSuspicious.add((RefElement)refFunction);
                            PhpGlobalInspectionContext.getInstance((GlobalInspectionContext)globalContext).enqueueFunctionUsagesProcessor(refFunction, this.myUsagesProcessor);
                            requestAdded.set((Object)true);
                        }

                        @Override
                        public void visitRefMethod(@NotNull PhpRefMethod refMethod) {
                            if (refMethod == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            PhpUnusedDeclarationInspection.this.myProcessedSuspicious.add((RefElement)refMethod);
                            if (!PhpMagicContext.canHaveExternalReferences(refMethod)) {
                                PhpRefManager.getEntryPointsManager((RefManager)refManager).addEntryPoint((RefElement)refMethod, false);
                            } else {
                                PhpGlobalInspectionContext.getInstance((GlobalInspectionContext)globalContext).enqueueDerivedMethodUsagesProcessor(refMethod, member -> {
                                    PhpRefManager.getEntryPointsManager((RefManager)refManager).addEntryPoint((RefElement)refMethod, false);
                                    return false;
                                });
                                PhpGlobalInspectionContext.getInstance((GlobalInspectionContext)globalContext).enqueueMethodUsagesProcessor(refMethod, this.myUsagesProcessor);
                            }
                            requestAdded.set((Object)true);
                        }

                        @Override
                        public void visitRefClass(@NotNull PhpRefClass refClass) {
                            if (refClass == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            PhpUnusedDeclarationInspection.this.myProcessedSuspicious.add((RefElement)refClass);
                            if (!refClass.isAnonymous()) {
                                PhpGlobalInspectionContext.getInstance((GlobalInspectionContext)globalContext).enqueueDerivedClassesProcessor(refClass, clazz -> {
                                    PhpRefManager.getEntryPointsManager((RefManager)refManager).addEntryPoint((RefElement)refClass, false);
                                    return false;
                                });
                                PhpGlobalInspectionContext.getInstance((GlobalInspectionContext)globalContext).enqueueClassUsagesProcessor(refClass, this.myUsagesProcessor);
                            }
                        }

                        @Override
                        public void visitRefConstant(PhpRefConstant refConstant) {
                            PhpUnusedDeclarationInspection.this.myProcessedSuspicious.add((RefElement)refConstant);
                            if (!refConstant.getName().isEmpty()) {
                                PhpGlobalInspectionContext.getInstance((GlobalInspectionContext)globalContext).enqueueConstantUsagesProcessor(refConstant, this.myUsagesProcessor);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "refField";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "refFunction";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "refMethod";
                                    break;
                                }
                                case 3: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "refClass";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationInspection$3$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitRefField";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitRefFunction";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitRefMethod";
                                    break;
                                }
                                case 3: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitRefClass";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationInspection$3", "visitElement"));
            }
        });
        if (!((Boolean)requestAdded.get()).booleanValue()) {
            if (this.myPhase == 2) {
                this.myProcessedSuspicious = null;
                return false;
            }
            this.myPhase = 2;
        }
        return true;
    }

    void checkForReachableRefs(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(12);
        }
        RefManager refManager = context.getRefManager();
        this.cleanRefsReachability(context, refManager);
        CodeScanner codeScanner = new CodeScanner();
        for (RefElement entry : PhpRefManager.getEntryPointsManager((RefManager)refManager).getEntryPoints(refManager)) {
            entry.accept((RefVisitor)codeScanner);
        }
        while (codeScanner.myInstantiatedClassesCount != 0) {
            codeScanner.myInstantiatedClassesCount = 0;
            codeScanner.processDelayedMethods();
        }
    }

    void cleanRefsReachability(final @NotNull GlobalInspectionContext context, @NotNull RefManager refManager) {
        if (context == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(13);
        }
        if (refManager == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(14);
        }
        refManager.iterate((RefVisitor)new PhpRefVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (refEntity instanceof PhpRefElementImpl && ((GlobalInspectionContextBase)context).isToCheckMember((RefElement)((PhpRefElementImpl)refEntity), (InspectionProfileEntry)PhpUnusedDeclarationInspection.this)) {
                    ((PhpRefElementImpl)refEntity).setReachable(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationInspection$4", "visitElement"));
            }
        });
    }

    public JobDescriptor[] getAdditionalJobs(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(15);
        }
        return new JobDescriptor[]{context.getStdJobDescriptors().BUILD_GRAPH, context.getStdJobDescriptors().FIND_EXTERNAL_USAGES};
    }

    public boolean isSuitedForEntryPoint(@NotNull RefElement refElement) {
        PsiElement psiElement;
        if (refElement == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(16);
        }
        if ((psiElement = refElement.getPsiElement()) != null) {
            return this.isSuitedForEntryPoint(psiElement);
        }
        return false;
    }

    public boolean isSuitedForEntryPoint(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PhpUnusedDeclarationInspection.$$$reportNull$$$0(17);
        }
        PhpEntryPointsManager pointsManager = PhpEntryPointsManager.getProjectInstance((Project)psiElement.getProject());
        return ContainerUtil.or(this.myExtensions, extension -> extension.isSelected() && extension.isEntryPoint(psiElement)) || pointsManager.isAcceptedByPattern(psiElement);
    }

    public boolean isSuppressedGettersSetters() {
        return this.SUPPRESS_GETTERS_AND_SETTERS;
    }

    public boolean isWithTestEntries() {
        return this.SUPPRESS_TEST_ENTRIES;
    }

    public boolean isShowUnusedByEntries() {
        return this.SHOW_UNUSED_BY_ENTRIES;
    }

    public JComponent createOptionsPanel() {
        JBTabbedPane tabs = new JBTabbedPane(1);
        tabs.add(PhpBundle.message("members.to.report", new Object[0]), ScrollPaneFactory.createScrollPane((Component)this.myMembersToReportOptionsPanel.createOptionsPanel(), (boolean)true));
        tabs.add(PhpBundle.message("entry.points", new Object[0]), ScrollPaneFactory.createScrollPane((Component)new OptionsPanel().getComponent(), (boolean)true));
        return tabs;
    }

    public boolean isWasGraphFullyTraversed() {
        return this.wasGraphFullyTraversed;
    }

    public static String getName() {
        return AnalysisBundle.message((String)"inspection.dead.code.display.name", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersToReportPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedLocalInspectionTool";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runInspection";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFilter";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "queryExternalUsagesRequests";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkForReachableRefs";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "cleanRefsReachability";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalJobs";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSuitedForEntryPoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySuppressedAnnotationModel
    extends AddEditRemovePanel.TableModel<String> {
        private MySuppressedAnnotationModel() {
        }

        public int getColumnCount() {
            return 1;
        }

        @Nullable
        public String getColumnName(int columnIndex) {
            return PhpBundle.message("column.name.annotation.name", new Object[0]);
        }

        public Object getField(String o, int columnIndex) {
            return o;
        }
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JBCheckBox mySuppressGettersSetters;
        private JButton myCodePatternsButton;
        private JCheckBox mySuppressTestsAsEntries;
        private JBRadioButton myShowUnusedByEntries;
        private JBRadioButton myShowStrictlyUnused;
        private JButton mySuppressedAnnotationsButton;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myShowUnusedByEntries.setSelected(PhpUnusedDeclarationInspection.this.SHOW_UNUSED_BY_ENTRIES);
            ChangeListener showUnusedChangeListener = e -> {
                PhpUnusedDeclarationInspection.this.SHOW_UNUSED_BY_ENTRIES = this.myShowUnusedByEntries.isSelected();
            };
            this.myShowStrictlyUnused.addChangeListener(showUnusedChangeListener);
            this.myShowUnusedByEntries.addChangeListener(showUnusedChangeListener);
            this.mySuppressTestsAsEntries.setSelected(PhpUnusedDeclarationInspection.this.SUPPRESS_TEST_ENTRIES);
            this.mySuppressTestsAsEntries.addChangeListener(e -> {
                PhpUnusedDeclarationInspection.this.SUPPRESS_TEST_ENTRIES = this.mySuppressTestsAsEntries.isSelected();
            });
            this.mySuppressGettersSetters.setSelected(PhpUnusedDeclarationInspection.this.SUPPRESS_GETTERS_AND_SETTERS);
            this.mySuppressGettersSetters.addChangeListener(e -> {
                PhpUnusedDeclarationInspection.this.SUPPRESS_GETTERS_AND_SETTERS = this.mySuppressGettersSetters.isSelected();
            });
            this.myCodePatternsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final Project project = ProjectUtil.guessCurrentProject((JComponent)OptionsPanel.this.myCodePatternsButton);
                    final PhpEntryPointsManagerImpl entryPointsManager = (PhpEntryPointsManagerImpl)PhpEntryPointsManager.getProjectInstance((Project)project);
                    final PhpClassPatternsPanel panel2 = new PhpClassPatternsPanel(entryPointsManager.getModifiablePatterns());
                    new DialogWrapper(project){
                        {
                            super(arg0);
                            this.init();
                            this.setTitle(PhpBundle.message("dialog.title.configure.code.patterns", new Object[0]));
                        }

                        protected JComponent createCenterPanel() {
                            return panel2;
                        }

                        protected void doOKAction() {
                            String error = panel2.getValidationError();
                            if (error != null) {
                                Messages.showErrorDialog((Component)panel2, (String)error);
                                return;
                            }
                            entryPointsManager.updatePatterns(panel2.getPatterns());
                            DaemonCodeAnalyzer.getInstance((Project)project).restart();
                            super.doOKAction();
                        }
                    }.show();
                }
            });
            this.mySuppressedAnnotationsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final Project project = ProjectUtil.guessCurrentProject((JComponent)OptionsPanel.this.mySuppressedAnnotationsButton);
                    ArrayList<String> annotationsList = new ArrayList<String>(((PhpEntryPointsManagerImpl)PhpEntryPointsManager.getProjectInstance((Project)project)).getSuppressedAnnotations());
                    AddEditRemovePanel<String> panel2 = new AddEditRemovePanel<String>((AddEditRemovePanel.TableModel)new MySuppressedAnnotationModel(), annotationsList){

                        @Nullable
                        protected String addItem() {
                            return Messages.showInputDialog((Project)project, (String)PhpBundle.message("enter.annotation", new Object[0]), (String)PhpBundle.message("suppressed.annotation.title", new Object[0]), null);
                        }

                        protected boolean removeItem(String o) {
                            return true;
                        }

                        @Nullable
                        protected String editItem(String o) {
                            return null;
                        }
                    };
                    new DialogWrapper(project, (AddEditRemovePanel)panel2, project){
                        final /* synthetic */ AddEditRemovePanel val$panel;
                        final /* synthetic */ Project val$project;
                        {
                            this.val$panel = addEditRemovePanel;
                            this.val$project = project;
                            super(arg0);
                            this.init();
                            this.setTitle(PhpBundle.message("configure.suppressed.annotations", new Object[0]));
                        }

                        protected JComponent createCenterPanel() {
                            return this.val$panel;
                        }

                        protected void doOKAction() {
                            ((PhpEntryPointsManagerImpl)PhpEntryPointsManager.getProjectInstance((Project)this.val$project)).updateSuppressedAnnotations(this.val$panel.getData());
                            DaemonCodeAnalyzer.getInstance((Project)this.val$project).restart();
                            super.doOKAction();
                        }
                    }.show();
                }
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JButton jButton;
            JButton jButton2;
            JBCheckBox jBCheckBox;
            JBRadioButton jBRadioButton;
            JBRadioButton jBRadioButton2;
            JCheckBox jCheckBox;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, 2, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.mySuppressTestsAsEntries = jCheckBox = new JCheckBox();
            jCheckBox.setLabel(ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.unused.declaration.option.test.entry_points"));
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unused.declaration.option.test.entry_points"));
            jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 0, 0, null, null, null));
            this.myShowUnusedByEntries = jBRadioButton2 = new JBRadioButton();
            jBRadioButton2.setSelected(false);
            this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unused.declaration.option.show.unused_from_entries"));
            jPanel3.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myShowStrictlyUnused = jBRadioButton = new JBRadioButton();
            this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unused.declaration.option.show_strictly_unused"));
            jPanel3.add((Component)jBRadioButton, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.mySuppressGettersSetters = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unused.declaration.option.test.suppressGettersAndSetters"));
            jPanel4.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 0, null, null, null));
            Spacer spacer3 = new Spacer();
            jPanel4.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new GridBagLayout());
            jPanel.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myCodePatternsButton = jButton2 = new JButton();
            this.$$$loadButtonText$$$(jButton2, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unusedd.description.code.patterns.button.label"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 17;
            jPanel5.add((Component)jButton2, gridBagConstraints);
            this.mySuppressedAnnotationsButton = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unused.description.code.suppressed.annotations"));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.anchor = 17;
            jPanel5.add((Component)jButton, gridBagConstraints2);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)jBRadioButton2);
            buttonGroup.add((AbstractButton)jBRadioButton);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static class CodeScanner
    extends PhpRefVisitor {
        @NotNull
        private final Map<PhpRefClass, Set<PhpRefMethod>> myClassIDtoMethods = new HashMap<PhpRefClass, Set<PhpRefMethod>>();
        @NotNull
        private final Set<PhpRefClass> myInstantiatedClasses = new HashSet<PhpRefClass>();
        @NotNull
        private final Set<PhpRefFunction> myProcessedFunctions = new HashSet<PhpRefFunction>();
        private int myInstantiatedClassesCount;

        private CodeScanner() {
        }

        @Override
        public void visitRefConstant(@NotNull PhpRefConstant refConstant) {
            if (refConstant == null) {
                CodeScanner.$$$reportNull$$$0(0);
            }
            this.makeContentReachable((PhpRefConstantImpl)refConstant);
        }

        @Override
        public void visitRefFile(@NotNull PhpRefFileImpl refFile) {
            if (refFile == null) {
                CodeScanner.$$$reportNull$$$0(1);
            }
            this.makeContentReachable((RefElementImpl)refFile);
        }

        @Override
        public void visitRefNamespace(@NotNull PhpRefNamespaceImpl refNamespace) {
            if (refNamespace == null) {
                CodeScanner.$$$reportNull$$$0(2);
            }
            this.makeContentReachable(refNamespace);
        }

        @Override
        public void visitRefFunction(@NotNull PhpRefFunction refFunction) {
            if (refFunction == null) {
                CodeScanner.$$$reportNull$$$0(3);
            }
            if (this.myProcessedFunctions.add(refFunction)) {
                this.makeContentReachable((PhpRefFunctionImpl)refFunction);
            }
        }

        @Override
        public void visitRefMethod(@NotNull PhpRefMethod refMethod) {
            if (refMethod == null) {
                CodeScanner.$$$reportNull$$$0(4);
            }
            if (!this.myProcessedFunctions.contains(refMethod)) {
                boolean allowedToProcess;
                boolean classWasInstantiated = this.isClassInstantiated(refMethod.getOwnerClass());
                boolean bl = allowedToProcess = !this.isDelayed(refMethod) || classWasInstantiated;
                if (refMethod.isWithStaticConstructor()) {
                    this.myProcessedFunctions.add((PhpRefFunction)refMethod);
                    this.addInstantiatedClassWithSubs(refMethod.getOwnerClass());
                    this.makeContentReachable((PhpRefMethodImpl)refMethod);
                    for (PhpRefMethod refDerived : refMethod.getDerivedMethods()) {
                        this.visitRefMethod(refDerived);
                    }
                } else if (refMethod.isConstructor() || refMethod.isStatic()) {
                    this.myProcessedFunctions.add((PhpRefFunction)refMethod);
                    this.addInstantiatedClass(refMethod.getOwnerClass());
                    this.makeContentReachable((PhpRefMethodImpl)refMethod);
                } else if (allowedToProcess) {
                    if (classWasInstantiated) {
                        this.myProcessedFunctions.add((PhpRefFunction)refMethod);
                        this.makeContentReachable((PhpRefMethodImpl)refMethod);
                    } else {
                        this.addDelayedMethod(refMethod);
                    }
                    this.traverseDerivedMembers((PhpRefClassMember)refMethod);
                }
                if (allowedToProcess) {
                    this.traverseDuplicates((PhpRefClassMemberImpl)refMethod);
                    if (refMethod.isTest()) {
                        this.traversePhpDocReferences((PhpRefElement)refMethod);
                    }
                }
            }
        }

        private void traverseDerivedMembers(@NotNull PhpRefClassMember refClassMember) {
            if (refClassMember == null) {
                CodeScanner.$$$reportNull$$$0(5);
            }
            if (!refClassMember.wasUsedBySelfOrParentOnly()) {
                for (PhpRefClassMember refDerived : refClassMember.getDerivedMembers()) {
                    this.apply((RefElement)refDerived);
                }
            }
        }

        private void traverseDuplicates(@NotNull PhpRefClassImpl aClass) {
            if (aClass == null) {
                CodeScanner.$$$reportNull$$$0(6);
            }
            if (aClass.isWithDuplicates()) {
                for (PhpRefClass duplicate : aClass.getDuplicates()) {
                    if (duplicate == aClass || duplicate.isReachable()) continue;
                    this.apply((RefElement)duplicate);
                }
            }
        }

        private void traverseDuplicates(@NotNull PhpRefClassMemberImpl member) {
            if (member == null) {
                CodeScanner.$$$reportNull$$$0(7);
            }
            for (PhpRefClassMember duplicate : member.getDuplicates()) {
                this.apply((RefElement)duplicate);
            }
        }

        private void traverseOutReferences(@NotNull RefElement refElement) {
            if (refElement == null) {
                CodeScanner.$$$reportNull$$$0(8);
            }
            for (RefElement refCallee : refElement.getOutReferences()) {
                refCallee.accept((RefVisitor)this);
            }
        }

        private void traverseSuperClasses(@NotNull PhpRefClass refClass) {
            if (refClass == null) {
                CodeScanner.$$$reportNull$$$0(9);
            }
            for (PhpRefClass refSuperClass : refClass.getSuperClasses()) {
                this.addInstantiatedClass(refSuperClass);
            }
        }

        private void traversePhpDocReferences(@NotNull PhpRefElement refElement) {
            if (refElement == null) {
                CodeScanner.$$$reportNull$$$0(10);
            }
            for (RefElement refCallee : refElement.getPhpDocReferences()) {
                refCallee.accept((RefVisitor)this);
            }
        }

        @Override
        public void visitRefClass(@NotNull PhpRefClass refClass) {
            if (refClass == null) {
                CodeScanner.$$$reportNull$$$0(11);
            }
            if (!refClass.isReachable()) {
                ((PhpRefClassImpl)refClass).setReachable(true);
                this.addInstantiatedClass(refClass);
            }
        }

        @Override
        public void visitRefField(@NotNull PhpRefField refField) {
            if (refField == null) {
                CodeScanner.$$$reportNull$$$0(12);
            }
            if (!refField.isReachable()) {
                this.makeContentReachable((PhpRefElementImpl)refField);
                this.makeClassInitializersReachable(refField.getOwnerClass());
                this.traverseDerivedMembers((PhpRefClassMember)refField);
                PhpRefField fieldMirror = refField.getRefMirror();
                if (fieldMirror != null) {
                    this.visitRefField(fieldMirror);
                }
                this.traverseDuplicates((PhpRefClassMemberImpl)refField);
            }
        }

        protected void addInstantiatedClass(@NotNull PhpRefClass refClass) {
            if (refClass == null) {
                CodeScanner.$$$reportNull$$$0(13);
            }
            if (this.myInstantiatedClasses.add(refClass)) {
                this.instantiateClass((PhpRefClassImpl)refClass);
                this.traverseSuperClasses(refClass);
            }
        }

        protected void addInstantiatedClassWithSubs(@NotNull PhpRefClass refClass) {
            if (refClass == null) {
                CodeScanner.$$$reportNull$$$0(14);
            }
            this.addInstantiatedClassWithSubsInternal(refClass, (Set<PhpRefClass>)new THashSet());
        }

        private void addInstantiatedClassWithSubsInternal(@NotNull PhpRefClass refClass, @NotNull Set<PhpRefClass> usedClasses) {
            if (refClass == null) {
                CodeScanner.$$$reportNull$$$0(15);
            }
            if (usedClasses == null) {
                CodeScanner.$$$reportNull$$$0(16);
            }
            if (usedClasses.add(refClass)) {
                if (this.myInstantiatedClasses.add(refClass)) {
                    this.instantiateClass((PhpRefClassImpl)refClass);
                }
                this.apply((RefElement)refClass.getConstructor());
                for (PhpRefClass subClass : refClass.getSubClasses()) {
                    this.addInstantiatedClassWithSubsInternal(subClass, usedClasses);
                }
            }
        }

        private void instantiateClass(@NotNull PhpRefClassImpl refClass) {
            if (refClass == null) {
                CodeScanner.$$$reportNull$$$0(17);
            }
            refClass.setReachable(true);
            ++this.myInstantiatedClassesCount;
            this.makeClassInitializersReachable(refClass);
            if (refClass.isTest()) {
                this.traversePhpDocReferences(refClass);
            }
            if (refClass.isWithDuplicates()) {
                this.traverseDuplicates(refClass);
            }
        }

        protected boolean isClassInstantiated(@Nullable PhpRefClass refClass) {
            return this.myInstantiatedClasses.contains(refClass);
        }

        protected void makeContentReachable(@NotNull RefElementImpl refElement) {
            if (refElement == null) {
                CodeScanner.$$$reportNull$$$0(18);
            }
            refElement.setReachable(true);
            this.traverseOutReferences((RefElement)refElement);
            this.makeUsedByStaticReferenceReachable(refElement);
        }

        private void makeUsedByStaticReferenceReachable(@NotNull RefElementImpl refElement) {
            if (refElement == null) {
                CodeScanner.$$$reportNull$$$0(19);
            }
            if (refElement instanceof PhpRefClassMember && ((PhpRefClassMember)refElement).wasUsedByStaticReference()) {
                this.makeClassMembersReachable((PhpRefClassMember)refElement);
            }
        }

        protected void makeClassMembersReachable(@Nullable PhpRefClassMember refClassMember) {
            this.makeClassMembersReachableInternal(refClassMember, (Set<PhpRefClassMember>)new THashSet());
        }

        private void makeClassMembersReachableInternal(@Nullable PhpRefClassMember refClassMember, @NotNull Set<PhpRefClassMember> members) {
            if (members == null) {
                CodeScanner.$$$reportNull$$$0(20);
            }
            if (refClassMember != null && members.add(refClassMember)) {
                if (CodeScanner.canToDescent(refClassMember)) {
                    for (PhpRefClassMember derivedMember : refClassMember.getDerivedMembers()) {
                        this.makeClassMembersReachableInternal(derivedMember, members);
                    }
                }
                this.apply((RefElement)refClassMember);
            }
        }

        private static boolean canToDescent(@NotNull PhpRefClassMember member) {
            if (member == null) {
                CodeScanner.$$$reportNull$$$0(21);
            }
            if (member instanceof PhpRefMethod) {
                return !((PhpRefMethod)member).isConstructor();
            }
            return true;
        }

        protected void makeClassInitializersReachable(@Nullable PhpRefClass refClass) {
            if (refClass instanceof PhpRefClassImpl) {
                PhpRefClassImpl refClassImpl = (PhpRefClassImpl)refClass;
                this.traverseOutReferences((RefElement)refClassImpl);
                this.makeImplicitlyUsedFieldsReachable(refClassImpl);
                this.makeImplicitlyUsedMethodsReachable(refClassImpl);
                this.makeImplicitlyUsedConstructorReachable(refClassImpl);
            }
        }

        private void makeImplicitlyUsedFieldsReachable(@NotNull PhpRefClassImpl refClass) {
            if (refClass == null) {
                CodeScanner.$$$reportNull$$$0(22);
            }
            if (refClass.isFieldsImplicitlyUsed()) {
                ((StreamEx)((StreamEx)((StreamEx)((StreamEx)refClass.getOwnFields().filter((Predicate)Predicates.not(RefElement::isReachable))).filter((Predicate)Predicates.not(PhpRefField::isConstant))).filter((Predicate)Predicates.not(PhpRefClassMember::isStatic))).filter(PhpRefClassMemberImpl::isPublic)).forEach(this::makeContentReachable);
            }
        }

        private void makeImplicitlyUsedMethodsReachable(@NotNull PhpRefClassImpl refClass) {
            if (refClass == null) {
                CodeScanner.$$$reportNull$$$0(23);
            }
            for (PhpRefMethodImpl phpRefMethod : refClass.getOwnMethods()) {
                if (PhpLangUtil.isMagicMethod(phpRefMethod.getName()) && PhpMagicContext.isMagicMethodReferenced(phpRefMethod, phpRefMethod.getName())) {
                    this.makeClassMembersReachable(phpRefMethod);
                    continue;
                }
                PhpCoreHandler coreHandler = PhpCoreHandler.getCoreDeclarationProvider(refClass, phpRefMethod);
                if (coreHandler == null || !coreHandler.inferImplicitlyUsages(refClass, phpRefMethod.getName())) continue;
                this.makeClassMembersReachable(phpRefMethod);
            }
        }

        private void makeImplicitlyUsedConstructorReachable(@NotNull PhpRefClass refClass) {
            if (refClass == null) {
                CodeScanner.$$$reportNull$$$0(24);
            }
            if (refClass.isConstructorImplicitlyUsed() && !refClass.isWithImplicitConstructor()) {
                this.makeClassMembersReachable((PhpRefClassMember)refClass.getConstructor());
            }
        }

        protected void addDelayedMethod(@NotNull PhpRefMethod refMethod) {
            if (refMethod == null) {
                CodeScanner.$$$reportNull$$$0(25);
            }
            PhpRefClass refClass = refMethod.getOwnerClass();
            Set methods = (Set)ObjectUtils.notNull(this.myClassIDtoMethods.get(refClass), HashSet::new);
            this.myClassIDtoMethods.putIfAbsent(refClass, methods);
            methods.add(refMethod);
        }

        protected boolean isDelayed(@NotNull PhpRefMethod refMethod) {
            Set<PhpRefMethod> refMethods;
            if (refMethod == null) {
                CodeScanner.$$$reportNull$$$0(26);
            }
            return (refMethods = this.myClassIDtoMethods.get(refMethod.getOwnerClass())) != null && refMethods.contains(refMethod);
        }

        protected void processDelayedMethods() {
            for (PhpRefClass refClass : this.myInstantiatedClasses.toArray(PhpRefClass.EMPTY_ARRAY)) {
                if (!this.isClassInstantiated(refClass)) continue;
                Set methods = (Set)ObjectUtils.notNull(this.myClassIDtoMethods.get(refClass), Collections.emptySet());
                for (PhpRefMethod method : methods.toArray(PhpRefMethod.EMPTY_ARRAY)) {
                    this.visitRefMethod(method);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refConstant";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refNamespace";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refFunction";
                    break;
                }
                case 4: 
                case 25: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refMethod";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refClassMember";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 7: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 8: 
                case 10: 
                case 18: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElement";
                    break;
                }
                case 9: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 22: 
                case 23: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refClass";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refField";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usedClasses";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "members";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationInspection$CodeScanner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRefConstant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRefFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRefNamespace";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRefFunction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRefMethod";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "traverseDerivedMembers";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "traverseDuplicates";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "traverseOutReferences";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "traverseSuperClasses";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "traversePhpDocReferences";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRefClass";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRefField";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addInstantiatedClass";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addInstantiatedClassWithSubs";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addInstantiatedClassWithSubsInternal";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "instantiateClass";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "makeContentReachable";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "makeUsedByStaticReferenceReachable";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[2] = "makeClassMembersReachableInternal";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canToDescent";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[2] = "makeImplicitlyUsedFieldsReachable";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[2] = "makeImplicitlyUsedMethodsReachable";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[2] = "makeImplicitlyUsedConstructorReachable";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addDelayedMethod";
                    break;
                }
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDelayed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

