/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow.dfa;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpIncludeInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;

public abstract class PhpInferredArrayEmptinessProcessorBase<T extends PhpInstruction>
extends PhpInstructionProcessor {
    protected final Ref<PhpInstruction> myAlwaysEmpty;
    protected final Ref<Boolean> myAmbiguous;
    protected final T myOriginal;

    public PhpInferredArrayEmptinessProcessorBase(Ref<PhpInstruction> alwaysEmpty, Ref<Boolean> ambiguous, T original2) {
        this.myAlwaysEmpty = alwaysEmpty;
        this.myAmbiguous = ambiguous;
        this.myOriginal = original2;
    }

    public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
        PhpAccessInstruction.Access access = instruction.getAccess();
        if (access.isWrite() || access.isWriteRef() || access.isReadRef()) {
            PhpPsiElement anchor = instruction.getAnchor();
            while (anchor instanceof ArrayAccessExpression) {
                anchor = ((ArrayAccessExpression)anchor).getValue();
            }
            if (this.sameElement((PsiElement)anchor)) {
                this.myAmbiguous.set((Object)true);
                return false;
            }
        }
        return super.processArrayAccessInstruction(instruction);
    }

    protected abstract boolean sameElement(PsiElement var1);

    public boolean processIncludeInstruction(PhpIncludeInstruction instruction) {
        this.myAmbiguous.set((Object)true);
        return false;
    }
}

