/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow.dfa;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpInferredArrayEmptinessProcessorBase;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;

class PhpInferredArrayEmptinessProcessor
extends PhpInferredArrayEmptinessProcessorBase<PhpAccessVariableInstruction> {
    PhpInferredArrayEmptinessProcessor(Ref<PhpInstruction> alwaysEmpty, Ref<Boolean> ambiguous, PhpAccessVariableInstruction original2) {
        super(alwaysEmpty, ambiguous, original2);
    }

    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
        PhpAccessInstruction.Access access;
        PhpPsiElement anchor = instruction.getAnchor();
        if (this.sameElement((PsiElement)anchor) && this.isModifyingAccess(anchor, access = instruction.getAccess())) {
            PsiElement value = ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue();
            if (value instanceof ArrayCreationExpression && ArrayCreationExpressionImpl.children((ArrayCreationExpression)value).isEmpty()) {
                this.myAlwaysEmpty.set((Object)instruction);
            } else {
                this.myAmbiguous.set((Object)true);
            }
            return false;
        }
        return super.processAccessVariableInstruction(instruction);
    }

    protected boolean isModifyingAccess(PhpPsiElement anchor, PhpAccessInstruction.Access access) {
        return access.isWrite() || access.isWriteRef() || access.isReadRef() || access instanceof PhpAccessInstruction.ReadOrReadRefAccess && PhpInferredArrayEmptinessProcessor.isUnresolvedCall(anchor);
    }

    public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
        Variable originalAnchor = (Variable)((PhpAccessVariableInstruction)this.myOriginal).getAnchor();
        if (ContainerUtil.exists((Object[])originalAnchor.multiResolve(false), e -> e.getElement() instanceof Parameter)) {
            this.myAmbiguous.set((Object)true);
        }
        return super.processEntryPointInstruction(instruction);
    }

    @Override
    protected boolean sameElement(PsiElement anchor) {
        return anchor instanceof Variable && PhpLangUtil.equalsVariableNames(((Variable)anchor).getName(), ((PhpAccessVariableInstruction)this.myOriginal).getVariableName());
    }

    private static boolean isUnresolvedCall(PhpPsiElement anchor) {
        FunctionReference call = (FunctionReference)PhpPsiUtil.getParentByCondition((PsiElement)anchor, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF);
        return call != null && call.multiResolve(false).length == 0;
    }
}

