/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow.dfa;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpConditionAlreadyCheckedInspection;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpArrayEmptinessDfaBasedAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpArrayEmptinessDfaBasedAnalyzerProcessorBase;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpFieldArrayEmptinessDfaBasedAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpInferredArrayEmptinessProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpInferredFieldArrayEmptinessProcessor;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpArrayIsAlwaysEmptyInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayIsAlwaysEmptyInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpForeach(ForeachStatement foreach) {
                this.doCheckArray(foreach.getArray());
            }

            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                if (!expression.isWriteAccess()) {
                    this.doCheckArray((PsiElement)expression.getValue());
                }
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.doCheckArray(PhpArrayIsAlwaysEmptyInspection.getArrayParameter(reference));
            }

            private void doCheckArray(PsiElement element) {
                PhpInstruction alwaysEmptyInstruction = PhpArrayIsAlwaysEmptyInspection.getAlwaysEmptyInstruction(element);
                if (alwaysEmptyInstruction != null) {
                    holder.registerProblem(element, PhpBundle.message("inspection.message.array.always.empty.at.this.point", new Object[0]), this.getFixes(alwaysEmptyInstruction));
                }
            }

            private LocalQuickFix[] getFixes(PhpInstruction instruction) {
                PsiElement anchor;
                if (isOnTheFly && (anchor = instruction.getAnchor()) != null) {
                    return new LocalQuickFix[]{new PhpConditionAlreadyCheckedInspection.PhpShowCauseInstructionQuickFix(anchor){

                        @Override
                        @NotNull
                        @Nls
                        protected String getHintMessage() {
                            String string = PhpBundle.message("hint.evaluation.makes.array.always.empty", new Object[0]);
                            if (string == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/dfa/PhpArrayIsAlwaysEmptyInspection$1$1", "getHintMessage"));
                        }
                    }};
                }
                return LocalQuickFix.EMPTY_ARRAY;
            }
        };
    }

    @Nullable
    private static PhpInstruction getAlwaysEmptyInstruction(PsiElement element) {
        PhpAccessFieldByVariableInstruction accessInstruction;
        PhpExpression classReference;
        if (element instanceof Variable) {
            PhpAccessVariableInstruction variableAccessInstruction;
            if (!PhpLangUtil.isSuperGlobal(((Variable)element).getName()) && (variableAccessInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)((Variable)element), PhpAccessVariableInstruction.class)) != null) {
                return PhpArrayIsAlwaysEmptyInspection.getAlwaysEmptyInstruction(variableAccessInstruction);
            }
        } else if (element instanceof FieldReference && (classReference = ((FieldReference)element).getClassReference()) instanceof Variable && (accessInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)element, PhpAccessFieldByVariableInstruction.class)) != null) {
            PhpFieldArrayEmptinessDfaBasedAnalyzerProcessor processor = new PhpFieldArrayEmptinessDfaBasedAnalyzerProcessor(((FieldReference)element).getName(), (Variable)classReference, (FieldReference)element);
            Ref alwaysEmpty = new Ref(null);
            Ref ambiguous = new Ref((Object)false);
            PhpControlFlowUtil.processPredecessors((PhpInstruction)accessInstruction, false, new PhpInferredFieldArrayEmptinessProcessor((Ref<PhpInstruction>)alwaysEmpty, (Ref<Boolean>)ambiguous, accessInstruction, (FieldReference)element, (Variable)classReference));
            if (!((Boolean)ambiguous.get()).booleanValue() && alwaysEmpty.get() != null) {
                return (PhpInstruction)alwaysEmpty.get();
            }
            return PhpArrayIsAlwaysEmptyInspection.getAlwaysEmptyFromDFAInstruction((PhpInstruction)accessInstruction, processor);
        }
        return null;
    }

    private static PhpInstruction getAlwaysEmptyInstruction(PhpAccessVariableInstruction original2) {
        PhpArrayEmptinessDfaBasedAnalyzerProcessor processor = new PhpArrayEmptinessDfaBasedAnalyzerProcessor(original2.getVariableName(), (Variable)original2.getAnchor());
        PhpInstruction instruction = PhpArrayIsAlwaysEmptyInspection.getAlwaysEmptyAssignmentInstruction(original2);
        return instruction == null ? PhpArrayIsAlwaysEmptyInspection.getAlwaysEmptyFromDFAInstruction((PhpInstruction)original2, processor) : instruction;
    }

    private static PhpInstruction getAlwaysEmptyFromDFAInstruction(PhpInstruction original2, PhpArrayEmptinessDfaBasedAnalyzerProcessorBase processor) {
        PhpControlFlowUtil.processPredecessors(original2, false, processor);
        PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction state = processor.getState();
        return state != null && state.getState() == PhpArrayEmptinessDfaBasedAnalyzerProcessorBase.PhpArrayEmptinessState.EMPTY ? state.getInstruction() : null;
    }

    private static PhpInstruction getAlwaysEmptyAssignmentInstruction(PhpAccessVariableInstruction original2) {
        Ref alwaysEmpty = new Ref(null);
        Ref ambiguous = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)original2, false, new PhpInferredArrayEmptinessProcessor((Ref<PhpInstruction>)alwaysEmpty, (Ref<Boolean>)ambiguous, original2));
        return (Boolean)ambiguous.get() == false ? (PhpInstruction)alwaysEmpty.get() : null;
    }

    @Nullable
    private static PsiElement getArrayParameter(FunctionReference reference) {
        String fqn = PhpArrayIsAlwaysEmptyInspection.resolveFQN(reference);
        if ("\\count".equals(fqn)) {
            return reference.getParameter(0);
        }
        if ("\\array_key_exists".equals(fqn)) {
            return reference.getParameter(1);
        }
        return null;
    }

    @Nullable
    private static String resolveFQN(FunctionReference reference) {
        return (String)ContainerUtil.getOnlyItem((Collection)Arrays.stream(reference.multiResolve(false)).map(e -> (Function)ObjectUtils.tryCast((Object)e.getElement(), Function.class)).filter(Objects::nonNull).map(PhpNamedElement::getFQN).collect(Collectors.toSet()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/controlFlow/dfa/PhpArrayIsAlwaysEmptyInspection", "buildVisitor"));
    }
}

