/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpExitPointInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionImpl;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpArgumentWithoutNamedIdentifierInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StatementWithArgument;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnusedLocalVariableInspection
extends PhpInspection {
    private static final String VARIABLE_ACCESS_FUNCTION = "get_defined_vars";
    private static final int DEPTH_LIMIT = 200;
    public boolean ENABLE_IN_FILE_SCOPE = false;
    public boolean DONT_REPORT_FOREACH_VALUE = true;
    public boolean DONT_REPORT_CATCH_EXCEPTION = true;
    public boolean DONT_REPORT_INSIDE_LIST = false;
    public boolean DONT_REPORT_ASSIGNMENT_TO_NULL = true;
    public boolean DONT_REPORT_INDIRECT_ACCESS = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                PhpUnusedLocalVariableInspection.this.analyzeScope((PhpScopeHolder)function, holder, isOnTheFly);
            }

            public void visitPhpMethod(Method method) {
                PhpUnusedLocalVariableInspection.this.analyzeScope((PhpScopeHolder)method, holder, isOnTheFly);
            }

            public void visitPhpNamespace(PhpNamespace namespace) {
                PhpUnusedLocalVariableInspection.this.analyzeScope((PhpScopeHolder)namespace, holder, isOnTheFly);
            }

            public void visitPhpFile(PhpFile PhpFile2) {
                if (PhpUnusedLocalVariableInspection.this.ENABLE_IN_FILE_SCOPE) {
                    PhpUnusedLocalVariableInspection.this.analyzeScope((PhpScopeHolder)PhpFile2, holder, isOnTheFly);
                } else {
                    super.visitPhpFile(PhpFile2);
                }
            }
        };
    }

    private void analyzeScope(final @NotNull PhpScopeHolder scopeHolder, final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (scopeHolder == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(2);
        }
        PhpControlFlow controlFlow = scopeHolder.getControlFlow();
        final HashSet unusedStatic = new HashSet();
        final Ref haveIndirectAccess = new Ref(null);
        final HashSet<String> usedVariablesNames = new HashSet<String>();
        if (scopeHolder instanceof Function) {
            for (Parameter parameter : ((Function)scopeHolder).getParameters()) {
                usedVariablesNames.add(parameter.getName());
            }
        }
        PhpControlFlowUtil.processSuccessors((PhpInstruction)controlFlow.getEntryPoint(), false, new PhpInstructionProcessor(){

            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                CharSequence variableName = PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction);
                if (variableName != null && instruction.getAccess().isWrite()) {
                    if (!usedVariablesNames.add(variableName)) {
                        return true;
                    }
                    if (PhpUnusedLocalVariableInspection.getFollowingVariableAssignmentsWithDifferentAnchors((PhpInstruction)instruction, variableName, null).length == 0) {
                        this.registerProblemIfEffectivelyUnused(instruction, variableName);
                    }
                }
                return true;
            }

            private void registerProblemIfEffectivelyUnused(PhpArrayAccessInstruction instruction, CharSequence variableName) {
                ArrayAccessExpression accessExpression = (ArrayAccessExpression)instruction.getAnchor();
                PhpPsiElement variable = accessExpression.getValue();
                while (variable instanceof ArrayAccessExpression) {
                    variable = ((ArrayAccessExpression)variable).getValue();
                }
                if (variable == null) {
                    return;
                }
                PhpAccessVariableInstruction variableAccessInstruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class);
                if (variableAccessInstruction == null) {
                    return;
                }
                if (this.isEffectivelyUnused((PhpInstruction)instruction, variableAccessInstruction, variableName, new HashSet<PsiElement>())) {
                    PhpUnusedLocalVariableInspection.registerProblem(variableAccessInstruction, (PsiElement)variable, PhpBundle.message("inspection.unused.local.variable.problem.case1", new Object[0]), isOnTheFly, holder, PhpUnusedLocalVariableInspection.canSafelyRemoveVariable((PsiElement)accessExpression));
                }
            }

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (instruction.getAccess().isWrite()) {
                    if (PhpUnusedLocalVariableInspection.this.isDontReportIndirectAccess() && this.haveIndirectAccess(instruction)) {
                        return true;
                    }
                    Variable variable = (Variable)ObjectUtils.tryCast((Object)instruction.getAnchor(), Variable.class);
                    if (variable == null) {
                        return true;
                    }
                    CharSequence variableName = instruction.getVariableName();
                    usedVariablesNames.add(variableName);
                    PhpAccessVariableInstruction[] followingVariableAccessInstructions = PhpUnusedLocalVariableInspection.getFollowingVariableAssignmentsWithDifferentAnchors((PhpInstruction)instruction, variableName, variable);
                    String caseDescription = followingVariableAccessInstructions.length == 0 ? PhpBundle.message("inspection.unused.local.variable.problem.case1", new Object[0]) : PhpBundle.message("inspection.unused.local.variable.problem.case2", new Object[0]);
                    SmartList readReferencesInUseList = new SmartList();
                    if (this.isEffectivelyUnused((PhpInstruction)instruction, instruction, variableName, (Collection<PsiElement>)readReferencesInUseList)) {
                        AssignmentExpression assignmentExpression;
                        PhpPsiElement value;
                        PhpAccessVariableInstruction staticAccess = PhpUnusedLocalVariableInspection.getStaticAccess(instruction);
                        if (staticAccess != null) {
                            if (staticAccess == instruction) {
                                unusedStatic.add(instruction);
                            } else if (!unusedStatic.contains(staticAccess)) {
                                return true;
                            }
                        }
                        PsiElement variableParent = variable.getParent();
                        if (PhpUnusedLocalVariableInspection.this.isDontReportUnusedCatchException(variable.getProject()) && variableParent instanceof Catch) {
                            return true;
                        }
                        if (PhpUnusedLocalVariableInspection.this.isDontReportForeachValue() && variableParent instanceof ForeachStatement) {
                            List variables = ((ForeachStatement)variableParent).getVariables();
                            if (variable != ((ForeachStatement)variableParent).getKey() && variables.size() > 1 && variables.contains(variable)) {
                                return true;
                            }
                        }
                        if (PhpUnusedLocalVariableInspection.this.isDontReportInsideList() && variableParent.getParent() instanceof MultiassignmentExpression) {
                            return true;
                        }
                        if (PhpUnusedLocalVariableInspection.this.isDontReportAssignmentToNull() && variableParent instanceof AssignmentExpression && PhpCodeInsightUtil.isNull((PsiElement)(value = (assignmentExpression = (AssignmentExpression)variableParent).getValue())) && this.isAssignedNonPrimitiveValuesBefore(instruction)) {
                            return true;
                        }
                        PhpUnusedLocalVariableInspection.registerProblem(instruction, (PsiElement)variable, caseDescription, isOnTheFly, holder, PhpUnusedLocalVariableInspection.canSafelyRemoveVariable((PsiElement)variable));
                        readReferencesInUseList.forEach(varInUseList -> PhpUnusedLocalVariableInspection.registerProblem(instruction, varInUseList, caseDescription, isOnTheFly, holder, true));
                    }
                } else if (instruction.getAccess().isWriteRef()) {
                    String caseDescription;
                    boolean unused;
                    CharSequence variableName;
                    Variable variable;
                    block19: {
                        variable = (Variable)ObjectUtils.tryCast((Object)instruction.getAnchor(), Variable.class);
                        variableName = instruction.getVariableName();
                        PhpAccessVariableInstruction[] followingVariableAccessInstructions = PhpUnusedLocalVariableInspection.getFollowingVariableAssignmentsWithDifferentAnchors((PhpInstruction)instruction, variableName, variable);
                        unused = true;
                        caseDescription = "";
                        if (followingVariableAccessInstructions.length == 0) {
                            caseDescription = PhpBundle.message("inspection.unused.local.variable.problem.case3", new Object[0]);
                        } else {
                            for (PhpAccessVariableInstruction followingAccess : followingVariableAccessInstructions) {
                                if (followingAccess.getAccess().isWriteRef() && !(followingAccess.getAnchor().getParent() instanceof ArrayAccessExpression)) continue;
                                unused = false;
                                break block19;
                            }
                            caseDescription = PhpBundle.message("inspection.unused.local.variable.problem.case4", new Object[0]);
                        }
                    }
                    if (unused && !PhpLangUtil.isSuperGlobal(variableName)) {
                        PhpUnusedLocalVariableInspection.registerProblem(instruction, (PsiElement)variable, caseDescription, isOnTheFly, holder, false);
                    }
                }
                return true;
            }

            private boolean isAssignedNonPrimitiveValuesBefore(final PhpAccessVariableInstruction instruction) {
                final HashSet<PsiElement> writeAccesses = new HashSet<PsiElement>();
                PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(){

                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction prevInstruction) {
                        PhpAccessInstruction.Access access = prevInstruction.getAccess();
                        if (prevInstruction != instruction && (access.isWrite() || access.isWriteRef() || access.isReadRef())) {
                            writeAccesses.add(prevInstruction.getAnchor());
                            return false;
                        }
                        return true;
                    }
                });
                PhpType assignedType = this.getType(writeAccesses);
                return !writeAccesses.isEmpty() && (assignedType.isAmbiguous() || !assignedType.isNotExtendablePrimitiveType());
            }

            private PhpType getType(Collection<PsiElement> writeAccesses) {
                PhpType assignedType = new PhpType();
                writeAccesses.forEach(arg_0 -> ((PhpType)assignedType).add(arg_0));
                return assignedType.global(holder.getProject());
            }

            private boolean isEffectivelyUnused(@NotNull PhpInstruction instruction, @NotNull PhpAccessVariableInstruction variableAccessInstruction, @NotNull CharSequence variableName, Collection<PsiElement> readReferencesInUseList) {
                if (instruction == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (variableAccessInstruction == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (variableName == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (PhpLangUtil.isThisReference(variableName)) {
                    return false;
                }
                boolean unused = PhpUnusedLocalVariableInspection.variableWriteIsUnused(String.valueOf(variableName), instruction, readReferencesInUseList, (Variable)ObjectUtils.tryCast((Object)variableAccessInstruction.getAnchor(), Variable.class), 0);
                return unused && !PhpControlFlowUtil.isReferenced(scopeHolder, variableAccessInstruction) && !PhpLangUtil.isSuperGlobal(variableName);
            }

            private boolean haveIndirectAccess(PhpAccessVariableInstruction instruction) {
                if (haveIndirectAccess.isNull()) {
                    PhpExitPointInstructionImpl tail = new PhpExitPointInstructionImpl();
                    haveIndirectAccess.set((Object)tail);
                    PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                        public boolean processInstruction(PhpInstruction instruction) {
                            FunctionReference reference;
                            CharSequence functionName;
                            if (instruction instanceof PhpCallInstruction && PhpLangUtil.equalsFunctionNames(functionName = (reference = ((PhpCallInstruction)instruction).getFunctionReference()).getNameCS(), PhpUnusedLocalVariableInspection.VARIABLE_ACCESS_FUNCTION)) {
                                haveIndirectAccess.set((Object)((PhpInstructionImpl)instruction));
                            }
                            return true;
                        }
                    });
                }
                return ((PhpInstructionImpl)haveIndirectAccess.get()).myNumber > ((PhpInstructionImpl)instruction).myNumber;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "instruction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "variableAccessInstruction";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "variableName";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection$2";
                objectArray[2] = "isEffectivelyUnused";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean canSafelyRemoveVariable(PsiElement variable) {
        AssignmentExpression assignment = (AssignmentExpression)PhpPsiUtil.getParentByCondition(variable, true, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF);
        if (assignment instanceof MultiassignmentExpression) {
            List variables = ((MultiassignmentExpression)assignment).getVariables();
            if (!variables.contains(variable)) {
                return false;
            }
            Collection<PhpPsiElement> keyedEntries = PhpAnnotatorVisitor.getKeyedEntries(variables);
            return keyedEntries.isEmpty() || ContainerUtil.getOnlyItem(keyedEntries) == variable;
        }
        if (assignment != null) {
            return assignment.getVariable() == variable;
        }
        PsiElement variableParent = variable.getParent();
        if (variableParent instanceof ForeachStatement && ((ForeachStatement)variableParent).getKey() == variable) {
            return true;
        }
        return variableParent instanceof PhpUseList || PhpLanguageFeature.NON_CAPTURING_CATCHES.isSupported(variableParent.getProject()) && variableParent instanceof Catch;
    }

    private static boolean variableWriteIsUnused(String variableName, PhpInstruction instructionToStartSearchFrom, Collection<PsiElement> readReferencesInUseListToCollect, @Nullable Variable variableAccess, int depth) {
        if (depth >= 200) {
            return false;
        }
        for (PhpAccessVariableInstruction instruction : PhpUnusedLocalVariableInspection.getFollowingVariableAssignmentsWithDifferentAnchors(instructionToStartSearchFrom, variableName, variableAccess)) {
            boolean read;
            Function closure = (Function)PhpPsiUtil.getParentByCondition((PsiElement)PhpUseImpl.getUseList((PsiElement)instruction.getAnchor()), (Condition<? super PsiElement>)Function.INSTANCEOF);
            boolean bl = read = !instruction.getAccess().isWrite() && !instruction.getAccess().isWriteRef();
            if (closure != null && closure.isClosure()) {
                readReferencesInUseListToCollect.add((PsiElement)instruction.getAnchor());
                if (!PhpUnusedLocalVariableInspection.variableWriteIsUnused(variableName, (PhpInstruction)closure.getControlFlow().getEntryPoint(), readReferencesInUseListToCollect, variableAccess, depth + 1)) {
                    return false;
                }
            }
            if (read) {
                if (closure == null) {
                    return false;
                }
                return PhpUnusedLocalVariableInspection.variableWriteIsUnused(variableName, (PhpInstruction)instruction, readReferencesInUseListToCollect, variableAccess, depth + 1);
            }
            if (!instruction.getAccess().isReadWrite() && !(instruction.getAnchor().getParent() instanceof ArrayAccessExpression)) continue;
            return false;
        }
        return true;
    }

    private static PhpAccessVariableInstruction[] getFollowingVariableAssignmentsWithDifferentAnchors(final PhpInstruction instructionToStartSearchFrom, final CharSequence variableName, final @Nullable Variable variableAccess) {
        PsiElement parent;
        PsiElement psiElement = parent = variableAccess != null ? variableAccess.getParent() : null;
        if (parent instanceof UnaryExpression && PhpPsiUtil.isOfType(parent, PhpElementTypes.INFIX_WRITE_EXPRESSION)) {
            return PhpControlFlowUtil.getFollowingVariableAccessInstructions(instructionToStartSearchFrom, variableName, true);
        }
        final ArrayList followingAccesses = new ArrayList();
        PhpControlFlowUtil.processSuccessors(instructionToStartSearchFrom, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName()) && (instruction.getAnchor() != variableAccess || instruction.num() < instructionToStartSearchFrom.num())) {
                    followingAccesses.add(instruction);
                    return false;
                }
                return true;
            }
        });
        return followingAccesses.isEmpty() ? PhpAccessVariableInstruction.EMPTY_ARRAY : followingAccesses.toArray(PhpAccessVariableInstruction.EMPTY_ARRAY);
    }

    private static void registerProblem(PhpAccessVariableInstruction instruction, PsiElement variable, String caseDescription, boolean isOnTheFly, @NotNull ProblemsHolder holder, boolean canSafelyRemoveVariable) {
        PsiElement operation;
        PsiElement parent;
        if (holder == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(3);
        }
        if ((parent = variable.getParent()) instanceof UnaryExpression && PhpPsiUtil.isOfType(parent, PhpElementTypes.POSTFIX_EXPRESSION) && (operation = ((UnaryExpression)parent).getOperation()) != null) {
            if (PhpUnusedLocalVariableInspection.isOnlyChildOfStatement(parent)) {
                PsiElement parentStatement = parent.getParent();
                holder.registerProblem(parentStatement, PhpBundle.message("inspection.message.results.postfix.expression.unused", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new PhpDeleteElementQuickFix(parentStatement)});
            } else {
                holder.registerProblem(operation, PhpBundle.message("inspection.message.results.postfix.expression.unused", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{PhpReplaceWithValueQuickFix.INSTANCE});
            }
            return;
        }
        LocalQuickFix[] fixes = PhpUnusedLocalVariableInspection.getFixes(instruction, variable, isOnTheFly, canSafelyRemoveVariable, parent).toArray(LocalQuickFix.EMPTY_ARRAY);
        holder.registerProblem(variable, PhpBundle.message("inspection.unused.local.variable.problem", instruction.getVariableName(), caseDescription), ProblemHighlightType.LIKE_UNUSED_SYMBOL, fixes);
    }

    @NotNull
    private static List<LocalQuickFix> getFixes(PhpAccessVariableInstruction instruction, PsiElement variable, boolean isOnTheFly, boolean canSafelyRemoveVariable, PsiElement parent) {
        LocalQuickFix addNameIdentifierQuickFix;
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        String variableName = instruction.getVariableName().toString();
        if (isOnTheFly && canSafelyRemoveVariable) {
            fixes.add(new PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix(variableName));
        }
        if (PhpLanguageFeature.NAMED_ARGUMENTS.isSupported(variable.getProject()) && variable instanceof Variable && parent instanceof AssignmentExpression && ((AssignmentExpression)parent).getVariable() == variable && (addNameIdentifierQuickFix = PhpUnusedLocalVariableInspection.getQuickFixToAddNamedIdentifiers(parent)) != null) {
            fixes.add(new PhpReplaceUnusedVariableWithNamedArgumentQuickFix(variableName));
        }
        ArrayList<LocalQuickFix> arrayList = fixes;
        if (arrayList == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    private static LocalQuickFix getQuickFixToAddNamedIdentifiers(PsiElement argument) {
        ParameterList plo = (ParameterList)PhpPsiUtil.getParentByCondition(argument, true, (Condition<? super PsiElement>)((Condition)ParameterList.class::isInstance), (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (plo == null || ParameterListImpl.getNameIdentifier(argument) != null) {
            return null;
        }
        List<PsiElement> arguments = Arrays.asList(plo.getParameters());
        int i = arguments.indexOf(argument);
        if (i < 0) {
            return null;
        }
        List<Parameter> parameters = PhpArgumentWithoutNamedIdentifierInspection.resolveParameters(plo);
        if (parameters == null) {
            return null;
        }
        Parameter param = PhpParamsInspection.getMappedParam(arguments, parameters, i);
        if (param == null) {
            return null;
        }
        int indexOfLastPositionalArgument = PhpArgumentWithoutNamedIdentifierInspection.getIndexOfLastPositionalArgument(arguments);
        return PhpArgumentWithoutNamedIdentifierInspection.getQuickFix(indexOfLastPositionalArgument, i, param);
    }

    private static boolean isOnlyChildOfStatement(PsiElement element) {
        PsiElement parent = element.getParent();
        return PhpPsiUtil.isOfType(parent, PhpElementTypes.STATEMENT) && parent.getChildren().length == 1 && parent.getChildren()[0] == element;
    }

    @Nullable
    private static PhpAccessVariableInstruction getStaticAccess(@NotNull PhpAccessVariableInstruction accessInstruction) {
        if (accessInstruction == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(5);
        }
        final Ref isStaticFound = new Ref();
        PhpControlFlowUtil.processPreviousVariableAccesses(accessInstruction, true, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpPsiElement anchor = instruction.getAnchor();
                PsiElement parent = anchor.getParent();
                if (parent != null && parent.getParent() instanceof PhpStaticStatement) {
                    isStaticFound.set((Object)instruction);
                    return false;
                }
                return true;
            }
        });
        return (PhpAccessVariableInstruction)isStaticFound.get();
    }

    public boolean isDontReportForeachValue() {
        return this.DONT_REPORT_FOREACH_VALUE;
    }

    public boolean isDontReportUnusedCatchException(@NotNull Project project) {
        if (project == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(6);
        }
        if (PhpLanguageFeature.NON_CAPTURING_CATCHES.isSupported(project)) {
            return false;
        }
        return this.DONT_REPORT_CATCH_EXCEPTION;
    }

    public boolean isDontReportInsideList() {
        return this.DONT_REPORT_INSIDE_LIST;
    }

    public boolean isDontReportAssignmentToNull() {
        return this.DONT_REPORT_ASSIGNMENT_TO_NULL;
    }

    public boolean isDontReportIndirectAccess() {
        return this.DONT_REPORT_INDIRECT_ACCESS;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    @InspectionMessage
    private static String getErrorBatch() {
        return PhpBundle.message("inspection.unused.local.variable.problem.batch", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessInstruction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "analyzeScope";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStaticAccess";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDontReportUnusedCatchException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox myEnableInFileScopeCheckBox;
        private JCheckBox myDontReportForeachValueCheckBox;
        private JCheckBox myDontReportInsideListCheckBox;
        private JCheckBox myDontReportAssignmentToNull;
        private JCheckBox myDontReportIndirectAccess;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myEnableInFileScopeCheckBox.setSelected(PhpUnusedLocalVariableInspection.this.ENABLE_IN_FILE_SCOPE);
            this.myEnableInFileScopeCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhpUnusedLocalVariableInspection.this.ENABLE_IN_FILE_SCOPE = OptionsPanel.this.myEnableInFileScopeCheckBox.isSelected();
                }
            });
            this.myDontReportForeachValueCheckBox.setSelected(PhpUnusedLocalVariableInspection.this.DONT_REPORT_FOREACH_VALUE);
            this.myDontReportForeachValueCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnusedLocalVariableInspection.this.DONT_REPORT_FOREACH_VALUE = OptionsPanel.this.myDontReportForeachValueCheckBox.isSelected();
                }
            });
            this.myDontReportInsideListCheckBox.setSelected(PhpUnusedLocalVariableInspection.this.DONT_REPORT_INSIDE_LIST);
            this.myDontReportInsideListCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnusedLocalVariableInspection.this.DONT_REPORT_INSIDE_LIST = OptionsPanel.this.myDontReportInsideListCheckBox.isSelected();
                }
            });
            this.myDontReportAssignmentToNull.setSelected(PhpUnusedLocalVariableInspection.this.DONT_REPORT_ASSIGNMENT_TO_NULL);
            this.myDontReportAssignmentToNull.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnusedLocalVariableInspection.this.DONT_REPORT_ASSIGNMENT_TO_NULL = OptionsPanel.this.myDontReportAssignmentToNull.isSelected();
                }
            });
            this.myDontReportIndirectAccess.setSelected(PhpUnusedLocalVariableInspection.this.DONT_REPORT_INDIRECT_ACCESS);
            this.myDontReportIndirectAccess.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnusedLocalVariableInspection.this.DONT_REPORT_INDIRECT_ACCESS = OptionsPanel.this.myDontReportIndirectAccess.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myDontReportForeachValueCheckBox = jCheckBox5 = new JCheckBox();
            jCheckBox5.setSelected(false);
            this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unused.local.variable.option.description.foreach"));
            jPanel.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myDontReportInsideListCheckBox = jCheckBox4 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unused.local.variable.option.description.list"));
            jPanel.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myEnableInFileScopeCheckBox = jCheckBox3 = new JCheckBox();
            jCheckBox3.setSelected(false);
            this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unused.local.variable.option.description.file.scope"));
            jPanel.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDontReportAssignmentToNull = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unused.local.variable.option.description.null"));
            jPanel.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDontReportIndirectAccess = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.unused.local.variable.option.indirect.access"));
            jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static class PhpReplaceWithValueQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpReplaceWithValueQuickFix();

        private PhpReplaceWithValueQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.remove.unused.postfix.operation", new Object[0]);
            if (string == null) {
                PhpReplaceWithValueQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpReplaceWithValueQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            UnaryExpression parent;
            PhpPsiElement value;
            if (project == null) {
                PhpReplaceWithValueQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PhpReplaceWithValueQuickFix.$$$reportNull$$$0(3);
            }
            if ((value = (parent = (UnaryExpression)descriptor.getStartElement().getParent()).getValue()) == null) {
                return;
            }
            parent.replace((PsiElement)value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection$PhpReplaceWithValueQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection$PhpReplaceWithValueQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix
    extends PhpQuickFixBase {
        private final String myVariableName;

        private PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix(String variableName) {
            this.myVariableName = variableName;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.remove.unused.local.variable.without.successor.quick.fix.family.name", this.myVariableName);
            if (string == null) {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Variable variable;
            if (project == null) {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.$$$reportNull$$$0(2);
            }
            if ((variable = (Variable)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), Variable.class)) == null) {
                return;
            }
            PsiElement parent = variable.getParent();
            if (parent instanceof Catch) {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.runWriteActionIfWritable(parent, () -> {
                    if (variable.getPrevSibling() instanceof PsiWhiteSpace) {
                        variable.getPrevSibling().delete();
                    }
                    variable.delete();
                });
                return;
            }
            if (parent instanceof ForeachStatement) {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.runWriteActionIfWritable(parent, () -> {
                    Variable key = ((ForeachStatement)parent).getKey();
                    PsiElement opHashArray = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)key, true);
                    if (PhpPsiUtil.isOfType(opHashArray, PhpTokenTypes.opHASH_ARRAY)) {
                        parent.deleteChildRange((PsiElement)key, opHashArray);
                    }
                });
                return;
            }
            AssignmentExpression assignment = (AssignmentExpression)PhpPsiUtil.getParentByCondition(parent, false, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            if (assignment != null) {
                Statement statement = (Statement)PhpPsiUtil.getParentByCondition((PsiElement)assignment, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                if (statement != null) {
                    PhpPsiElement value = assignment.getValue();
                    if (assignment instanceof SelfAssignmentExpression && PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.possibleArgument((PsiElement)assignment)) {
                        BinaryExpression binaryExpression = PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.createBinaryOperationFromSelfAssignment((SelfAssignmentExpression)assignment);
                        if (binaryExpression != null) {
                            PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.runWriteActionIfWritable((PsiElement)assignment, () -> PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.lambda$applyFix$2(assignment, (PsiElement)binaryExpression));
                        }
                    } else {
                        boolean replaceAssignmentWithValue = value != null && (!PhpUnusedLocalVariableInspection.isOnlyChildOfStatement((PsiElement)assignment) || PhpSideEffectDetector.canContainSideEffect((PsiElement)value) && !PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.askToDeleteAssignmentCompletely(project, variable));
                        this.deleteVariableInAssignment(variable, assignment, (PsiElement)statement, value, replaceAssignmentWithValue);
                    }
                }
            } else {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.runWriteActionIfWritable((PsiElement)variable, () -> PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.deleteFromUseList((PsiElement)variable));
            }
        }

        private static boolean isMultipleVariableAssignment(AssignmentExpression assignment) {
            return assignment instanceof MultiassignmentExpression && ((MultiassignmentExpression)assignment).getVariables().size() > 1;
        }

        public static void runWriteActionIfWritable(PsiElement element, Runnable runnable) {
            WriteAction.run(() -> {
                if (PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.ensureWritable(element)) {
                    runnable.run();
                }
            });
        }

        private static <T> T runWriteActionIfWritable(PsiElement element, Computable<T> runnable) {
            return (T)WriteAction.compute(() -> {
                if (PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.ensureWritable(element)) {
                    return runnable.compute();
                }
                return null;
            });
        }

        private static boolean ensureWritable(PsiElement variable) {
            return ReadonlyStatusHandler.ensureFilesWritable((Project)variable.getProject(), (VirtualFile[])new VirtualFile[]{variable.getContainingFile().getVirtualFile()});
        }

        @Nullable
        private static BinaryExpression createBinaryOperationFromSelfAssignment(@NotNull SelfAssignmentExpression assignment) {
            String operationText;
            if (assignment == null) {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement operation = assignment.getOperation();
            PhpPsiElement variable = assignment.getVariable();
            PhpPsiElement value = assignment.getValue();
            if (operation != null && variable != null && value != null && !StringUtil.isEmpty((CharSequence)(operationText = StringUtil.trimEnd((String)operation.getText(), (char)'=')))) {
                return PhpPsiElementFactory.createPhpPsiFromText(assignment.getProject(), BinaryExpression.class, String.format("%s %s %s", variable.getText(), operationText, value.getText()));
            }
            return null;
        }

        private static boolean possibleArgument(PsiElement expression) {
            PsiElement parent = expression.getParent();
            return parent instanceof PhpExpression || parent instanceof StatementWithArgument || parent instanceof ParameterList;
        }

        protected PsiElement deleteVariableInAssignment(Variable variable, AssignmentExpression assignment, PsiElement statement, PhpPsiElement assignmentValue, boolean replaceAssignmentWithValue) {
            return (PsiElement)PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.runWriteActionIfWritable((PsiElement)variable, () -> {
                PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
                if (instruction != null) {
                    SmartList readReferencesInUseList = new SmartList();
                    PhpUnusedLocalVariableInspection.variableWriteIsUnused(variable.getName(), (PhpInstruction)instruction, (Collection<PsiElement>)readReferencesInUseList, (Variable)ObjectUtils.tryCast((Object)instruction.getAnchor(), Variable.class), 0);
                    readReferencesInUseList.forEach(PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix::deleteFromUseList);
                }
                if (replaceAssignmentWithValue) {
                    PhpPsiElement valueToReplace;
                    PhpPsiElement phpPsiElement = valueToReplace = assignment instanceof MultiassignmentExpression ? assignmentValue.getFirstPsiChild() : assignmentValue;
                    if (valueToReplace == null) {
                        return null;
                    }
                    return assignment.replace((PsiElement)valueToReplace);
                }
                if (PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.isMultipleVariableAssignment(assignment)) {
                    PsiElement parent = variable.getParent();
                    if (PhpPsiUtil.isOfType(parent, PhpElementTypes.ARRAY_VALUE) && parent.getParent() instanceof ArrayHashElement) {
                        parent.getParent().delete();
                    } else {
                        parent.delete();
                    }
                } else {
                    statement.delete();
                }
                return null;
            });
        }

        private static void deleteFromUseList(PsiElement variable) {
            PhpCodeEditUtil.removeStatementWithDelivery(variable, PhpTokenTypes.opCOMMA);
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static boolean askToDeleteAssignmentCompletely(@NotNull Project project, Variable variable) {
            if (project == null) {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.$$$reportNull$$$0(4);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return false;
            }
            return Messages.showYesNoDialog((Project)project, (String)PhpBundle.message("inspection.unused.local.variable.problem.fix.side.effects.found.dialog.message", variable.getName()), (String)PhpBundle.message("inspection.unused.local.variable.problem.fix.side.effects.found.dialog.title", new Object[0]), (String)PhpBundle.message("remove", new Object[0]), (String)PhpBundle.message("transform", new Object[0]), (Icon)Messages.getWarningIcon()) == 0;
        }

        private static /* synthetic */ PsiElement lambda$applyFix$2(AssignmentExpression assignment, PsiElement binaryExpression) {
            return assignment.replace(binaryExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection$PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection$PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createBinaryOperationFromSelfAssignment";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "askToDeleteAssignmentCompletely";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpReplaceUnusedVariableWithNamedArgumentQuickFix
    extends PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix {
        private PhpReplaceUnusedVariableWithNamedArgumentQuickFix(String variableName) {
            super(variableName);
        }

        @Override
        protected PsiElement deleteVariableInAssignment(Variable variable, AssignmentExpression assignment, PsiElement statement, PhpPsiElement assignmentValue, boolean replaceAssignmentWithValue) {
            PsiElement replacedVariable = super.deleteVariableInAssignment(variable, assignment, statement, assignmentValue, replaceAssignmentWithValue);
            if (replacedVariable != null) {
                PhpReplaceUnusedVariableWithNamedArgumentQuickFix.runWriteActionIfWritable(replacedVariable, () -> PhpArgumentWithoutNamedIdentifierInspection.doAddNamedArguments(replacedVariable.getProject(), replacedVariable));
            }
            return replacedVariable;
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("replace.variable.assignment.with.named.argument", new Object[0]);
            if (string == null) {
                PhpReplaceUnusedVariableWithNamedArgumentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection$PhpReplaceUnusedVariableWithNamedArgumentQuickFix", "getFamilyName"));
        }
    }
}

