/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpLoop;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnnecessaryStopStatementInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnnecessaryStopStatementInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpReturn(PhpReturn returnStatement) {
                if (returnStatement.getArgument() != null) {
                    return;
                }
                Function parentFunction = (Function)PhpPsiUtil.getParentByCondition((PsiElement)returnStatement, (Condition<? super PsiElement>)Function.INSTANCEOF);
                if (parentFunction == null || !parentFunction.getInferredType().global(parentFunction.getProject()).equals((Object)PhpType.VOID)) {
                    return;
                }
                this.doCheck((PsiElement)returnStatement, (PsiElement)parentFunction);
            }

            public void visitPhpContinue(PhpContinue continueStatement) {
                if (continueStatement.getArgument() != null) {
                    return;
                }
                Object loop = PhpPsiUtil.getParentByCondition((PsiElement)continueStatement, (Condition<? super PsiElement>)((Condition)PhpLoop.class::isInstance));
                if (loop != null && !PhpUnnecessaryStopStatementInspection.isAlternativeSyntax(loop) && !PhpUnnecessaryStopStatementInspection.isSingleContinueInConditionWithFollowingBranches(continueStatement)) {
                    this.doCheck((PsiElement)continueStatement, (PsiElement)loop);
                }
            }

            private void doCheck(PsiElement stopStatement, PsiElement parentBlock) {
                if (PhpUnnecessaryStopStatementInspection.isUnnecessaryStopStatement(stopStatement, parentBlock)) {
                    holder.registerProblem(stopStatement, this.getMessage(stopStatement, parentBlock), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new PhpDeleteElementQuickFix(stopStatement)});
                }
            }

            @NotNull
            @Nls
            private String getMessage(PsiElement stopStatement, PsiElement parentBlock) {
                if (stopStatement instanceof PhpContinue) {
                    String string = PhpBundle.message("inspection.php.unnecessary.continue", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                String string = parentBlock instanceof Method ? PhpBundle.message("inspection.php.unnecessary.return.method", new Object[0]) : PhpBundle.message("inspection.php.unnecessary.return.function", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/PhpUnnecessaryStopStatementInspection$1", "getMessage"));
            }
        };
    }

    public static boolean isUnnecessaryStopStatement(PsiElement stopStatement, PsiElement parentBlock) {
        return PhpUnnecessaryStopStatementInspection.isLastStatement(stopStatement, parentBlock) || PhpUnnecessaryStopStatementInspection.insideIfWithAllReturnedBranches(stopStatement, parentBlock) || PhpUnnecessaryStopStatementInspection.insideDefaultCaseInLastSwitch(stopStatement, parentBlock);
    }

    private static boolean isAlternativeSyntax(PsiElement loop) {
        return PhpPsiUtil.getChildOfType(loop, PhpTokenTypes.opCOLON) != null;
    }

    private static boolean isSingleContinueInConditionWithFollowingBranches(PhpContinue continueStatement) {
        ControlStatement controlStatement = (ControlStatement)PhpPsiUtil.getParentByCondition((PsiElement)continueStatement, (Condition<? super PsiElement>)((Condition)a -> a instanceof If || a instanceof ElseIf));
        if (controlStatement != null) {
            Statement onlyStatement;
            Statement statement = controlStatement.getStatement();
            Object object = onlyStatement = statement instanceof GroupStatement ? ((GroupStatement)statement).getOnlyStatement() : statement;
            if (onlyStatement == continueStatement && PhpUnnecessaryStopStatementInspection.followingBranchExists(controlStatement)) {
                return true;
            }
        }
        return false;
    }

    private static boolean followingBranchExists(ControlStatement statement) {
        if (statement instanceof If) {
            return ((If)statement).getElseIfBranches().length > 0 || ((If)statement).getElseBranch() != null;
        }
        if (statement instanceof ElseIf) {
            PsiElement nextSibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)statement, true);
            return nextSibling instanceof ElseIf || nextSibling instanceof Else;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean insideIfWithAllReturnedBranches(PsiElement statement, PsiElement parentBlock) {
        If anIf = PhpUnnecessaryStopStatementInspection.getParentIfStatement(statement.getParent());
        if (anIf == null) {
            return false;
        }
        if (!PhpUnnecessaryStopStatementInspection.ifWithoutFollowingBranches(anIf) && !PhpUnnecessaryStopStatementInspection.ifWithElseBranch(anIf)) {
            if (anIf.getLastChild() != PhpPsiUtil.getParentByCondition(statement, (Condition<? super PsiElement>)((Condition)ElseIf.class::isInstance))) return false;
        }
        if (!PhpUnnecessaryStopStatementInspection.isLastStatement((PsiElement)anIf, parentBlock)) return false;
        return true;
    }

    private static boolean ifWithoutFollowingBranches(If anIf) {
        return anIf.getElseIfBranches().length == 0 && anIf.getElseBranch() == null;
    }

    private static boolean insideDefaultCaseInLastSwitch(PsiElement statement, PsiElement parentFunction) {
        PhpCase phpCase;
        PsiElement parent = statement.getParent();
        if (parent instanceof GroupStatement && PhpPsiUtil.isOfType((PsiElement)(phpCase = (PhpCase)ObjectUtils.tryCast((Object)parent.getParent(), PhpCase.class)), PhpElementTypes.CASE_DEFAULT)) {
            return PhpUnnecessaryStopStatementInspection.isLastStatement(phpCase.getParent(), parentFunction);
        }
        return false;
    }

    private static If getParentIfStatement(PsiElement parent) {
        if (parent instanceof GroupStatement) {
            return PhpUnnecessaryStopStatementInspection.getParentIfStatement(parent.getParent());
        }
        if (parent instanceof Else || parent instanceof ElseIf) {
            return (If)ObjectUtils.tryCast((Object)parent.getParent(), If.class);
        }
        if (parent instanceof If) {
            return (If)parent;
        }
        return null;
    }

    private static boolean ifWithElseBranch(@Nullable If anIf) {
        PhpPsiElement elseStatement;
        Else elseBranch = anIf != null ? anIf.getElseBranch() : null;
        PhpPsiElement phpPsiElement = elseStatement = elseBranch != null ? elseBranch.getStatement() : null;
        return elseStatement instanceof If ? PhpUnnecessaryStopStatementInspection.ifWithElseBranch((If)elseStatement) : elseStatement != null;
    }

    private static boolean isLastStatement(PsiElement statement, PsiElement parentFunction) {
        return PhpPsiUtil.getNextSibling(statement, e -> e instanceof PsiWhiteSpace || e instanceof PsiComment) == parentFunction.getLastChild().getLastChild();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/controlFlow/PhpUnnecessaryStopStatementInspection", "buildVisitor"));
    }
}

