/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.intentions.PhpInvertIfIntention;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.unwrap.PhpElseUnwrapper;
import org.jetbrains.annotations.NotNull;

public class PhpUnnecessaryElseBranchInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnnecessaryElseBranchInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpIf(If ifStatement) {
                PhpInvertIfIntention.PhpBlock block;
                Else elseBranch = ifStatement.getElseBranch();
                if (elseBranch != null && ifStatement.getElseIfBranches().length == 0 && (block = PhpInvertIfIntention.getBlock(ifStatement)) != null && PhpInvertIfIntention.alwaysReturned(ifStatement, block.getBlock(), true)) {
                    holder.registerProblem(elseBranch.getFirstChild(), PhpBundle.message("inspection.message.unnecessary.else", new Object[0]), new LocalQuickFix[]{PhpUnwrapElseQuickFix.INSTANCE});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/controlFlow/PhpUnnecessaryElseBranchInspection", "buildVisitor"));
    }

    private static class PhpUnwrapElseQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpUnwrapElseQuickFix();

        private PhpUnwrapElseQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.unwrap.else", new Object[0]);
            if (string == null) {
                PhpUnwrapElseQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpUnwrapElseQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpUnwrapElseQuickFix.$$$reportNull$$$0(2);
            }
            Else anElse = (Else)descriptor.getStartElement().getParent();
            new PhpElseUnwrapper().unwrap((PsiElement)anElse);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnnecessaryElseBranchInspection$PhpUnwrapElseQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnnecessaryElseBranchInspection$PhpUnwrapElseQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

