/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.intentions.PhpInvertIfIntention;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIfWithCommonPartsInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpIfWithCommonPartsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpIf(If ifStatement) {
                PsiElement parent = ifStatement.getParent();
                if (parent instanceof ControlStatement || parent instanceof Else) {
                    return;
                }
                ElseIf[] branches = ifStatement.getElseIfBranches();
                if (branches.length > 0) {
                    return;
                }
                Pair<List<PsiElement>, List<PsiElement>> thenElseStatements = PhpIfWithCommonPartsInspection.getThenElseStatements(ifStatement);
                List thenStatements = (List)thenElseStatements.first;
                List elseStatements = (List)thenElseStatements.second;
                if (elseStatements.isEmpty() || thenStatements.isEmpty()) {
                    return;
                }
                int longestCommonPrefix = PhpIfWithCommonPartsInspection.getLongestCommonPurePrefix(ifStatement, thenStatements, elseStatements);
                int longestCommonSuffix = PhpIfWithCommonPartsInspection.getLongestCommonSuffix(thenStatements, elseStatements, ifStatement.getElseBranch());
                if (longestCommonPrefix > 0 && !PhpIfWithCommonPartsInspection.allPhpDocs(thenStatements.subList(0, longestCommonPrefix)) || longestCommonSuffix > 0 && !PhpIfWithCommonPartsInspection.allPhpDocs(thenStatements.subList(thenStatements.size() - longestCommonSuffix, thenStatements.size()))) {
                    LocalQuickFix fix = PhpIfWithCommonPartsInspection.getFix(longestCommonPrefix, longestCommonSuffix, thenStatements.size(), elseStatements.size());
                    holder.registerProblem(ifStatement.getFirstChild(), PhpBundle.message("inspection.message.if.statement.with.common.parts", new Object[0]), new LocalQuickFix[]{fix});
                }
            }
        };
    }

    private static boolean allPhpDocs(List<PsiElement> elements) {
        return ContainerUtil.and(elements, PhpDocComment.class::isInstance);
    }

    private static Pair<List<PsiElement>, List<PsiElement>> getThenElseStatements(If ifStatement) {
        Else elseBranch = ifStatement.getElseBranch();
        List<PsiElement> thenStatements = PhpIfWithCommonPartsInspection.getStatements((PhpPsiElement)ifStatement.getStatement());
        List<Object> elseStatements = Collections.emptyList();
        if (elseBranch != null) {
            elseStatements = PhpIfWithCommonPartsInspection.getStatements(elseBranch.getStatement());
        } else {
            PsiElement lastIfStatement = (PsiElement)ContainerUtil.getLastItem(thenStatements);
            if (lastIfStatement instanceof PhpContinue || lastIfStatement instanceof PhpReturn || lastIfStatement instanceof PhpBreak) {
                elseStatements = PhpIfWithCommonPartsInspection.collectNextSiblingStatements(ifStatement);
                if (lastIfStatement instanceof PhpReturn && ((PhpReturn)lastIfStatement).getArgument() == null) {
                    thenStatements = thenStatements.subList(0, thenStatements.size() - 1);
                }
            }
        }
        return Pair.create(thenStatements, elseStatements);
    }

    private static List<PsiElement> collectNextSiblingStatements(If statement) {
        ArrayList<PsiElement> res = new ArrayList<PsiElement>();
        If nextSibling = statement;
        while ((nextSibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)nextSibling, true)) != null) {
            if (!(nextSibling instanceof PhpPsiElement)) continue;
            res.add((PsiElement)nextSibling);
        }
        return res;
    }

    private static LocalQuickFix getFix(int prefixSize, int suffixSize, int thenSize, int elseSize) {
        if (prefixSize == thenSize && prefixSize == elseSize) {
            return PhpExtractCommonPartsQuickFix.COLLAPSE_INSTANCE;
        }
        if (prefixSize == thenSize || prefixSize == elseSize || suffixSize == thenSize || suffixSize == elseSize) {
            return PhpExtractCommonPartsQuickFix.EXTRACT_COMMON_PARTS_REMOVING_BRANCH;
        }
        return PhpExtractCommonPartsQuickFix.EXTRACT_COMMON_PARTS;
    }

    private static int getLongestCommonSuffix(List<PsiElement> thenStatements, List<PsiElement> elseStatements, @Nullable Else elseBranch) {
        if (elseBranch == null) {
            return 0;
        }
        return PhpIfWithCommonPartsInspection.findLongestCommonPrefix(ContainerUtil.reverse(thenStatements), ContainerUtil.reverse(elseStatements), Collections.emptySet());
    }

    private static int getLongestCommonPurePrefix(If ifStatement, List<PsiElement> thenStatements, List<PsiElement> elseStatements) {
        Collection variablesNames = (Collection)PhpPsiUtil.findChildrenNonStrict((PsiElement)ifStatement.getCondition(), Variable.class).stream().map(PhpNamedElement::getName).collect(Collectors.toCollection(() -> new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE)));
        return PhpIfWithCommonPartsInspection.findLongestCommonPrefix(thenStatements, elseStatements, variablesNames);
    }

    @NotNull
    private static List<PsiElement> getStatements(PhpPsiElement statement) {
        List<PsiElement> list = PhpPsiUtil.getChildren((PsiElement)statement, (Condition<? super PsiElement>)((Condition)PhpPsiElement.class::isInstance));
        if (list == null) {
            PhpIfWithCommonPartsInspection.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static int findLongestCommonPrefix(List<PsiElement> first, List<PsiElement> other, Collection<String> variablesNames) {
        int i;
        for (i = 0; i < Math.min(first.size(), other.size()) && !PhpPsiUtil.isOfType(first.get(i), PhpElementTypes.HTML) && !PhpPsiUtil.isOfType(other.get(i), PhpElementTypes.HTML) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)first.get(i), (PsiElement)other.get(i), (o1, o2) -> 0, null, null, (boolean)true) && !PhpIfWithCommonPartsInspection.possibleConditionVariableChange(first.get(i), variablesNames); ++i) {
        }
        return i;
    }

    private static boolean possibleConditionVariableChange(PsiElement first, Collection<String> variablesNames) {
        return ContainerUtil.exists(PhpPsiUtil.findChildrenNonStrict(first, Variable.class), v -> variablesNames.contains(v.getName()) && PhpIfWithCommonPartsInspection.possibleVariableChange((PsiElement)v));
    }

    private static boolean possibleVariableChange(PsiElement v) {
        if (VariableImpl.isLocalWriteAccess(v) || PhpCodeInsightUtil.isPassByRefParameter(v, true)) {
            return true;
        }
        PsiElement parent = v.getParent();
        if ((parent instanceof FieldReference && ((FieldReference)parent).getClassReference() == v || parent instanceof ArrayAccessExpression && ((ArrayAccessExpression)parent).getValue() == v) && PhpIfWithCommonPartsInspection.possibleVariableChange(parent)) {
            return true;
        }
        FunctionReference functionCall = (FunctionReference)PhpPsiUtil.getParentByCondition(v, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF);
        return functionCall != null && (functionCall instanceof MethodReference && ((MethodReference)functionCall).getClassReference() == v || ArrayUtil.indexOfIdentity((Object[])functionCall.getParameters(), (Object)v) >= 0) && PhpSideEffectDetector.canContainSideEffect((PsiElement)functionCall, true, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpIfWithCommonPartsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpIfWithCommonPartsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class PhpExtractCommonPartsQuickFix
    implements LocalQuickFix {
        static final PhpExtractCommonPartsQuickFix COLLAPSE_INSTANCE = new PhpExtractCommonPartsQuickFix(){

            @IntentionFamilyName
            @NotNull
            public String getFamilyName() {
                String string = PhpBundle.message("intention.family.name.collapse.if.statement", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/PhpIfWithCommonPartsInspection$PhpExtractCommonPartsQuickFix$1", "getFamilyName"));
            }
        };
        static final PhpExtractCommonPartsQuickFix EXTRACT_COMMON_PARTS_REMOVING_BRANCH = new PhpExtractCommonPartsQuickFix(){

            @IntentionFamilyName
            @NotNull
            public String getFamilyName() {
                String string = PhpBundle.message("intention.family.name.extract.common.parts.with.removing.branch", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/PhpIfWithCommonPartsInspection$PhpExtractCommonPartsQuickFix$2", "getFamilyName"));
            }
        };
        static final PhpExtractCommonPartsQuickFix EXTRACT_COMMON_PARTS = new PhpExtractCommonPartsQuickFix(){

            @IntentionFamilyName
            @NotNull
            public String getFamilyName() {
                String string = PhpBundle.message("intention.family.name.extract.common.parts", new Object[0]);
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/PhpIfWithCommonPartsInspection$PhpExtractCommonPartsQuickFix$3", "getFamilyName"));
            }
        };

        private PhpExtractCommonPartsQuickFix() {
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            boolean emptyElse;
            if (project == null) {
                PhpExtractCommonPartsQuickFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                PhpExtractCommonPartsQuickFix.$$$reportNull$$$0(1);
            }
            If ifStatement = (If)descriptor.getStartElement().getParent();
            Pair<List<PsiElement>, List<PsiElement>> pair = PhpIfWithCommonPartsInspection.getThenElseStatements(ifStatement);
            List thenStatements = (List)pair.first;
            List elseStatements = (List)pair.second;
            int longestCommonPrefix = PhpIfWithCommonPartsInspection.getLongestCommonPurePrefix(ifStatement, thenStatements, elseStatements);
            Else elseBranch = ifStatement.getElseBranch();
            int longestCommonSuffix = PhpIfWithCommonPartsInspection.getLongestCommonSuffix(thenStatements, elseStatements, elseBranch);
            if (longestCommonPrefix > 0) {
                PhpExtractCommonPartsQuickFix.moveStatements(ifStatement, thenStatements.subList(0, longestCommonPrefix), true);
            }
            if (longestCommonSuffix > 0 && (longestCommonPrefix <= 0 || longestCommonPrefix != thenStatements.size())) {
                PhpExtractCommonPartsQuickFix.moveStatements(ifStatement, thenStatements.subList(thenStatements.size() - longestCommonSuffix, thenStatements.size()), false);
            }
            PhpExtractCommonPartsQuickFix.deleteStatements(thenStatements, longestCommonPrefix, longestCommonSuffix);
            PhpExtractCommonPartsQuickFix.deleteStatements(elseStatements, longestCommonPrefix, longestCommonSuffix);
            boolean emptyThen = PhpIfWithCommonPartsInspection.getStatements((PhpPsiElement)ifStatement.getStatement()).isEmpty();
            boolean bl = emptyElse = elseBranch != null && PhpIfWithCommonPartsInspection.getStatements(elseBranch.getStatement()).isEmpty();
            if (emptyThen && (emptyElse || elseBranch == null)) {
                ifStatement.delete();
            } else if (emptyElse) {
                elseBranch.delete();
            } else if (emptyThen) {
                PhpInvertIfIntention.flipIfElse(project, ifStatement);
            }
        }

        private static void moveStatements(If ifStatement, List<PsiElement> statements, boolean up) {
            If anchor = ifStatement;
            for (PsiElement statement : up ? ContainerUtil.reverse(statements) : statements) {
                PsiElement parent = anchor.getParent();
                if (up) {
                    anchor = parent.addBefore(statement, (PsiElement)anchor);
                    continue;
                }
                anchor = parent.addAfter(statement, (PsiElement)anchor);
            }
        }

        private static void deleteStatements(List<PsiElement> thenStatements, int longestCommonPrefix, int longestCommonSuffix) {
            for (int i = 0; i < thenStatements.size(); ++i) {
                if (i >= longestCommonPrefix && thenStatements.size() - i > longestCommonSuffix) continue;
                thenStatements.get(i).delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpIfWithCommonPartsInspection$PhpExtractCommonPartsQuickFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

