/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpGoto;
import com.jetbrains.php.lang.psi.elements.PhpGotoLabel;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpGotoIntoLoopInspection
extends PhpInspection {
    private static final int MAX_LOOPS = 5;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpGotoIntoLoopInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpGoto(PhpGoto element) {
                ResolveResult[] results;
                PsiElement psi;
                ASTNode node = element.getNameNode();
                PsiElement psiElement = psi = node == null ? null : node.getPsi();
                if (psi == null) {
                    return;
                }
                Set<PsiElement> gotoLoop = this.getAllParentLoops((PsiElement)element);
                for (ResolveResult result : results = element.multiResolve(false)) {
                    PsiElement loop;
                    PsiElement resultElement = result.getElement();
                    if (!(resultElement instanceof PhpGotoLabel) || (loop = this.getParentLoop(resultElement)) == null || gotoLoop.contains(loop)) continue;
                    holder.registerProblem(resultElement, PhpBundle.message("inspection.message.goto.labels.inside.loops.or.switch.statements.are.not.allowed", new Object[0]), new LocalQuickFix[0]);
                }
            }

            @NotNull
            private Set<PsiElement> getAllParentLoops(@Nullable PsiElement element) {
                THashSet loops = new THashSet();
                element = this.getParentLoop(element);
                while (element != null && loops.size() < 5) {
                    loops.add(element);
                    element = this.getParentLoop(element);
                }
                THashSet tHashSet = loops;
                if (tHashSet == null) {
                    1.$$$reportNull$$$0(0);
                }
                return tHashSet;
            }

            @Nullable
            private PsiElement getParentLoop(@Nullable PsiElement element) {
                return PhpPsiUtil.getParentByCondition(element, true, PhpCodeInsightUtil.LOOP_STATEMENTS, (Condition<? super PsiElement>)PhpScopeHolder.INSTANCE_OF);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/PhpGotoIntoLoopInspection$1", "getAllParentLoops"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/controlFlow/PhpGotoIntoLoopInspection", "buildVisitor"));
    }
}

