/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpNullSafeDerefConditionInstructionImpl;
import com.jetbrains.php.codeInsight.typeInference.PhpAmbiguousCompositeTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeStateInferredAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaDelegateBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpStrictVariableDfaState;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpScopeHolderVisitor;
import com.jetbrains.php.lang.inspections.codeSmell.PhpInstanceofIsAlwaysTrueInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.type.PhpExpressionAlwaysConstantInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpConditionAlreadyCheckedInspection
extends PhpInspection {
    private static final PhpStrictVariableDfaState STRICT_NOT_NULL = new PhpStrictVariableDfaState(PhpDfaBasedTypeState.NOT_NULL);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpConditionAlreadyCheckedInspection.$$$reportNull$$$0(0);
        }
        return new PhpScopeHolderVisitor(){

            @Override
            protected void check(@NotNull PhpScopeHolder scopeHolder) {
                if (scopeHolder == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpControlFlow flow = scopeHolder.getControlFlow();
                final HashSet checkedRanges = new HashSet();
                final Set conditionsPresentedInControlFlowConditions = ((StreamEx)StreamEx.of((Object[])flow.getInstructions()).select(PhpConditionInstruction.class).filter(PhpConditionInstruction::getResult)).map(PhpConditionInstruction::getCondition).nonNull().map(PsiElement::getTextRange).toSet();
                PhpControlFlowUtil.processFlow(flow, new PhpInstructionProcessor(){

                    public boolean processConditionInstruction(PhpConditionInstruction instruction) {
                        PsiElement condition;
                        PsiElement circuitRightOperand = ((PhpConditionInstructionImpl)instruction).getShortCircuitRightOperand();
                        if (circuitRightOperand != null && this.checkCondition(instruction, circuitRightOperand, true, ContainerUtil.union((Collection)conditionsPresentedInControlFlowConditions, (Collection)checkedRanges))) {
                            checkedRanges.add(circuitRightOperand.getTextRange());
                        }
                        if ((condition = instruction.getCondition()) == null || !instruction.getResult()) {
                            return true;
                        }
                        if (this.checkCondition(instruction, condition, false, checkedRanges)) {
                            checkedRanges.add(condition.getTextRange());
                        }
                        return super.processConditionInstruction(instruction);
                    }
                });
            }

            private boolean checkCondition(PhpConditionInstruction instruction, PsiElement condition, boolean searchFromSelf, Collection<TextRange> checkedRanges) {
                if (PhpSideEffectDetector.canContainSideEffect(condition, true, true)) {
                    return false;
                }
                if (checkedRanges.stream().anyMatch(t -> condition.getTextRange().contains(t))) {
                    return false;
                }
                PhpDfaBasedTypeStateInferredAnalyzerProcessor processor = new PhpDfaBasedTypeStateInferredAnalyzerProcessor(null, null, true);
                processor.processCondition(instruction, condition, searchFromSelf || instruction.getResult());
                PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> state = processor.getState();
                if (state != null && !StringUtil.isEmpty((CharSequence)state.getVariableName()) && state.getState() != PhpDfaBasedTypeState.UNKNOWN) {
                    boolean result;
                    if (PhpConditionAlreadyCheckedInspection.isLogicalExpr(condition) && !(state.getState() instanceof PhpAmbiguousCompositeTypeState)) {
                        return false;
                    }
                    Pair<PhpInstruction, Boolean> p = this.getAlreadyCheckedInstruction(instruction, condition, state, searchFromSelf);
                    if (p == null) {
                        return false;
                    }
                    PhpInstruction alreadyCheckedInstruction = (PhpInstruction)p.first;
                    PsiElement alreadyCoveredCondition = alreadyCheckedInstruction.getAnchor();
                    boolean prevInstructionIsCondition = alreadyCheckedInstruction instanceof PhpConditionInstruction;
                    boolean bl = result = !prevInstructionIsCondition || ((PhpConditionInstruction)alreadyCheckedInstruction).getResult();
                    if (alreadyCoveredCondition != null) {
                        int choice;
                        PhpExpressionAlwaysConstantInspection.ConstantValue value;
                        PhpExpressionAlwaysConstantInspection.ConstantValue constantValue = value = (Boolean)p.second != false ? PhpExpressionAlwaysConstantInspection.ConstantValue.TRUE : PhpExpressionAlwaysConstantInspection.ConstantValue.FALSE;
                        if (instruction instanceof PhpNullSafeDerefConditionInstructionImpl) {
                            this.handleNullSafeDeref(instruction.getAnchor(), alreadyCoveredCondition.getText(), value, prevInstructionIsCondition, result);
                            return true;
                        }
                        LocalQuickFix[] fixes = PhpConditionAlreadyCheckedInspection.getFixes(condition, alreadyCoveredCondition, isOnTheFly, value);
                        int n = choice = value == PhpExpressionAlwaysConstantInspection.ConstantValue.TRUE ? 1 : 0;
                        @Nls String message = prevInstructionIsCondition ? PhpBundle.message("inspection.message.always.true.because", choice, alreadyCoveredCondition.getText(), result ? 1 : 0) : PhpBundle.message("inspection.message.always.true.because.evaluated", choice, alreadyCoveredCondition.getText());
                        holder.registerProblem(condition, message, fixes);
                        return true;
                    }
                }
                return false;
            }

            private void handleNullSafeDeref(PsiElement classReference, String alreadyCoveredCondition, PhpExpressionAlwaysConstantInspection.ConstantValue value, boolean prevInstructionIsCondition, boolean prevInstructionResult) {
                String message;
                int choice;
                int n = choice = value == PhpExpressionAlwaysConstantInspection.ConstantValue.TRUE ? 1 : 0;
                if (classReference == null) {
                    return;
                }
                String string = prevInstructionIsCondition ? PhpBundle.message("inspection.nullsafe.deref.unnecessary.because", choice, alreadyCoveredCondition, prevInstructionResult ? 1 : 0) : (message = PhpBundle.message("inspection.nullsafe.deref.unnecessary.because.evaluated", choice, alreadyCoveredCondition));
                if (value == PhpExpressionAlwaysConstantInspection.ConstantValue.TRUE) {
                    PsiElement opQuest = PhpPsiUtil.getNextSiblingIgnoreWhitespace(classReference, true);
                    if (opQuest == null) {
                        return;
                    }
                    holder.registerProblem(opQuest, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new PhpDeleteElementQuickFix(opQuest)});
                }
            }

            private Pair<PhpInstruction, Boolean> getAlreadyCheckedInstruction(@NotNull PhpConditionInstruction instruction, PsiElement condition, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> currentState, boolean searchFromSelf) {
                CharSequence variableName;
                PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> previousStateFromDFA;
                Pair<PhpInstruction, Boolean> compatibleStateFromPreviousDFA;
                if (instruction == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((compatibleStateFromPreviousDFA = PhpConditionAlreadyCheckedInspection.getCompatibleState(condition, currentState, previousStateFromDFA = this.getStateFromPreviousDFA(instruction, condition, searchFromSelf, variableName = currentState.getVariableName()))) != null) {
                    return compatibleStateFromPreviousDFA;
                }
                PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> previousStateFromMethodAccess = this.getStateFromPreviousMethodAccess(instruction, variableName);
                return PhpConditionAlreadyCheckedInspection.getCompatibleState(condition, currentState, previousStateFromMethodAccess);
            }

            private PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> getStateFromPreviousMethodAccess(@NotNull PhpConditionInstruction instruction, final CharSequence variableName) {
                if (instruction == null) {
                    1.$$$reportNull$$$0(2);
                }
                final Ref memberAccess = new Ref(null);
                final Ref ambiguous = new Ref((Object)false);
                PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                        Variable variable;
                        MethodReference methodCall = (MethodReference)ObjectUtils.tryCast((Object)instruction.getFunctionReference(), MethodReference.class);
                        Variable variable2 = variable = methodCall != null ? (Variable)ObjectUtils.tryCast((Object)methodCall.getClassReference(), Variable.class) : null;
                        if (variable != null && PhpLangUtil.equalsVariableNames(variableName, variable.getName())) {
                            boolean insideSilenceOperator;
                            boolean bl = insideSilenceOperator = PhpPsiUtil.getParentByCondition((PsiElement)methodCall, true, (Condition<? super PsiElement>)((Condition)x$0 -> PhpConditionAlreadyCheckedInspection.isSilenceOperator(x$0)), (Condition<? super PsiElement>)Statement.INSTANCEOF) != null;
                            if (!insideSilenceOperator) {
                                memberAccess.set((Object)instruction);
                                return false;
                            }
                        }
                        return super.processPhpCallInstruction(instruction);
                    }

                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                        if (PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName()) && !instruction.getAccess().isRead()) {
                            ambiguous.set((Object)true);
                            return false;
                        }
                        return super.processAccessVariableInstruction(instruction);
                    }

                    public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                        ambiguous.set((Object)true);
                        return false;
                    }
                });
                return !memberAccess.isNull() && (Boolean)ambiguous.get() == false ? new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(variableName, PhpDfaDelegateBasedTypeState.NOT_FALSE_NOT_NULL, (PhpInstruction)memberAccess.get()) : null;
            }

            @Nullable
            private PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> getStateFromPreviousDFA(@NotNull PhpConditionInstruction instruction, PsiElement condition, boolean searchFromSelf, CharSequence variableName) {
                if (instruction == null) {
                    1.$$$reportNull$$$0(3);
                }
                final TextRange outerTextRange = condition.getTextRange();
                PhpDfaBasedTypeStateInferredAnalyzerProcessor dfaStateProcessor = new PhpDfaBasedTypeStateInferredAnalyzerProcessor(variableName, null, true){

                    @Override
                    public boolean processConditionInstruction(PhpConditionInstruction instruction) {
                        PsiElement prevCond = instruction.getCondition();
                        if (prevCond == null || outerTextRange.contains(prevCond.getTextRange())) {
                            return true;
                        }
                        return super.processConditionInstruction(instruction);
                    }

                    @Override
                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                        PhpAccessInstruction.Access access = instruction.getAccess();
                        if (this.sameVariableName(instruction.getVariableName()) && PhpConditionAlreadyCheckedInspection.isModifyingAccess(access)) {
                            this.setState(new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(instruction.getVariableName(), PhpDfaBasedTypeState.UNKNOWN, (PhpInstruction)instruction));
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                        if (this.sameVariableName(instruction.getVariableName()) && PhpConditionAlreadyCheckedInspection.isModifyingAccess(instruction.getAccess())) {
                            this.setState(new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(instruction.getVariableName(), PhpDfaBasedTypeState.UNKNOWN, (PhpInstruction)instruction));
                            return false;
                        }
                        return true;
                    }
                };
                PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, searchFromSelf, dfaStateProcessor);
                return dfaStateProcessor.getState();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scopeHolder";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "instruction";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpConditionAlreadyCheckedInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "check";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getAlreadyCheckedInstruction";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getStateFromPreviousMethodAccess";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getStateFromPreviousDFA";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isSilenceOperator(PsiElement p) {
        return p instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)p).getOperation(), PhpTokenTypes.opSILENCE);
    }

    @Nullable
    private static Pair<PhpInstruction, Boolean> getCompatibleState(PsiElement condition, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> currentState, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> previousState) {
        if (previousState == null) {
            return null;
        }
        PhpDfaBasedTypeState previousDfaState = (PhpDfaBasedTypeState)previousState.getState();
        if (previousDfaState.is(PhpDfaBasedTypeState.UNKNOWN) || previousDfaState.is(PhpDfaBasedTypeState.AMBIGUOUS)) {
            return null;
        }
        Boolean compatibleState = PhpConditionAlreadyCheckedInspection.isCompatibleState(condition, previousDfaState, (PhpDfaBasedTypeState)currentState.getState());
        if (compatibleState == null && currentState.getInstruction() instanceof PhpNullSafeDerefConditionInstructionImpl) {
            compatibleState = (Boolean)ObjectUtils.chooseNotNull((Object)PhpConditionAlreadyCheckedInspection.isCompatibleState(condition, previousDfaState, PhpDfaBasedTypeState.NOT_FALSE), (Object)PhpConditionAlreadyCheckedInspection.isCompatibleState(condition, previousDfaState, STRICT_NOT_NULL));
        }
        return compatibleState != null ? Pair.create((Object)previousState.getInstruction(), (Object)compatibleState) : null;
    }

    @Nullable
    private static Boolean isCompatibleState(PsiElement condition, PhpDfaBasedTypeState previousDfaState, PhpDfaBasedTypeState state) {
        if (previousDfaState.coveredBy(condition.getProject(), state, true)) {
            return Boolean.TRUE;
        }
        if (previousDfaState.excludedBy(condition.getProject(), state, true)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static boolean isModifyingAccess(PhpAccessInstruction.Access access) {
        return access.isWrite() || access.isWriteRef() || access.isReadRef() || access.isUnset();
    }

    private static boolean isLogicalExpr(PsiElement condition) {
        return (condition = PhpPsiUtil.unparenthesize(condition)) instanceof BinaryExpression && PhpTokenTypes.tsLOGICAL_OPS.contains(((BinaryExpression)condition).getOperationType());
    }

    private static LocalQuickFix @NotNull [] getFixes(PsiElement redundantCondition, PsiElement conditionToNavigate, boolean isOnTheFly, PhpExpressionAlwaysConstantInspection.ConstantValue constantValue) {
        ArrayList<Object> fixes = new ArrayList<Object>();
        fixes.add(PhpInstanceofIsAlwaysTrueInspection.getFix(constantValue, redundantCondition));
        if (isOnTheFly) {
            fixes.add((Object)new PhpShowCauseInstructionQuickFix(conditionToNavigate));
        }
        LocalQuickFix[] localQuickFixArray = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            PhpConditionAlreadyCheckedInspection.$$$reportNull$$$0(1);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpConditionAlreadyCheckedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpConditionAlreadyCheckedInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpShowCauseInstructionQuickFix
    extends LocalQuickFixOnPsiElement
    implements IntentionAction {
        public PhpShowCauseInstructionQuickFix(@NotNull PsiElement element) {
            if (element == null) {
                PhpShowCauseInstructionQuickFix.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpShowCauseInstructionQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpShowCauseInstructionQuickFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                PhpShowCauseInstructionQuickFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                PhpShowCauseInstructionQuickFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                PhpShowCauseInstructionQuickFix.$$$reportNull$$$0(5);
            }
        }

        @NotNull
        @IntentionFamilyName
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.navigate.to.cause", new Object[0]);
            if (string == null) {
                PhpShowCauseInstructionQuickFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                PhpShowCauseInstructionQuickFix.$$$reportNull$$$0(7);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            PsiElement condition;
            if (project == null) {
                PhpShowCauseInstructionQuickFix.$$$reportNull$$$0(8);
            }
            if ((condition = this.getStartElement()) == null) {
                return;
            }
            PsiNavigationSupport.getInstance().createNavigatable(project, condition.getContainingFile().getVirtualFile(), condition.getTextOffset()).navigate(true);
            HighlightManager.getInstance((Project)project).addOccurrenceHighlights(editor, new PsiElement[]{condition}, EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES, true, null);
            HintManager.getInstance().showInformationHint(editor, this.getHintMessage());
        }

        @NotNull
        @Nls
        protected String getHintMessage() {
            String string = PhpBundle.message("hint.evaluation.makes.subsequent.condition.always.true", new Object[0]);
            if (string == null) {
                PhpShowCauseInstructionQuickFix.$$$reportNull$$$0(9);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 6: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 6: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpConditionAlreadyCheckedInspection$PhpShowCauseInstructionQuickFix";
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpConditionAlreadyCheckedInspection$PhpShowCauseInstructionQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHintMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 6: 
                case 9: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 6: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

