/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpArrayWriteIsNotUsedInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayWriteIsNotUsedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                PhpArrayAccessInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)expression, PhpArrayAccessInstruction.class);
                if (instruction == null) {
                    return;
                }
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (!access.isWrite()) {
                    return;
                }
                CharSequence variableName = PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction);
                if (variableName == null || PhpLangUtil.isSuperGlobal(variableName)) {
                    return;
                }
                Parameter parameter = PhpArrayWriteIsNotUsedInspection.findNonPassByRefParameter(expression, variableName);
                if (parameter == null) {
                    return;
                }
                PhpType parameterType = parameter.getGlobalType();
                if (!parameterType.isEmpty() && !PhpType.isArray((PhpType)parameterType)) {
                    return;
                }
                if (PhpArrayWriteIsNotUsedInspection.writeArrayAccessExistsBefore(instruction, variableName)) {
                    return;
                }
                if (!this.followingReadAccessExists(instruction, variableName)) {
                    holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.message.array.write.access.unused", new Object[0]), new LocalQuickFix[]{new PhpAddByRefToParameterQuickFix(parameter)});
                }
            }

            private boolean followingReadAccessExists(PhpArrayAccessInstruction instruction, final CharSequence variableName) {
                final Ref variableReadAccessExists = new Ref((Object)false);
                PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                        PhpAccessInstruction.Access access;
                        if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variableName) && ((access = instruction.getAccess()).isRead() || access.isReadRef())) {
                            variableReadAccessExists.set((Object)true);
                            return false;
                        }
                        return super.processAccessVariableInstruction(instruction);
                    }
                });
                return (Boolean)variableReadAccessExists.get();
            }
        };
    }

    private static boolean writeArrayAccessExistsBefore(PhpArrayAccessInstruction instruction, final CharSequence variableName) {
        final Ref writeAccessExists = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpAccessInstruction.Access access;
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variableName) && ((access = instruction.getAccess()).isWrite() || access.isWriteRef() || access.isReadRef())) {
                    writeAccessExists.set((Object)true);
                    return false;
                }
                return true;
            }
        });
        return (Boolean)writeAccessExists.get();
    }

    private static Parameter findNonPassByRefParameter(ArrayAccessExpression expression, CharSequence variableName) {
        Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)expression, (Condition<? super PsiElement>)Function.INSTANCEOF);
        Parameter parameter = function != null ? (Parameter)ContainerUtil.find((Object[])function.getParameters(), p -> PhpLangUtil.equalsParameterNames(p.getName(), variableName)) : null;
        return parameter != null && !parameter.isPassByRef() ? parameter : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/controlFlow/PhpArrayWriteIsNotUsedInspection", "buildVisitor"));
    }

    private static class PhpAddByRefToParameterQuickFix
    extends LocalQuickFixOnPsiElement {
        @NotNull
        @NlsSafe
        private final String myName;

        private PhpAddByRefToParameterQuickFix(Parameter parameter) {
            super((PsiElement)parameter);
            this.myName = parameter.getName();
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = PhpBundle.message("intention.name.add.to.parameter", this.myName);
            if (string == null) {
                PhpAddByRefToParameterQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpAddByRefToParameterQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                PhpAddByRefToParameterQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                PhpAddByRefToParameterQuickFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                PhpAddByRefToParameterQuickFix.$$$reportNull$$$0(4);
            }
            if (((Parameter)startElement).isPassByRef()) {
                return;
            }
            PsiElement anchorToInsertRefBefore = PhpPsiUtil.getChildOfType(startElement, PhpTokenTypes.opVARIADIC);
            if (anchorToInsertRefBefore == null) {
                anchorToInsertRefBefore = ((Parameter)startElement).getNameIdentifier();
            }
            if (anchorToInsertRefBefore != null) {
                startElement.addBefore(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.opBIT_AND, "function a(&$f) {}"), anchorToInsertRefBefore);
            }
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.to.parameter", new Object[0]);
            if (string == null) {
                PhpAddByRefToParameterQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpArrayWriteIsNotUsedInspection$PhpAddByRefToParameterQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpArrayWriteIsNotUsedInspection$PhpAddByRefToParameterQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

