/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpIncludeInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpArrayUsedOnlyForWriteInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayUsedOnlyForWriteInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                if (!PhpArrayUsedOnlyForWriteInspection.arrayAssignmentByValue(assignmentExpression)) {
                    return;
                }
                this.check((Variable)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), Variable.class));
            }

            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                Variable variable = (Variable)ObjectUtils.tryCast((Object)expression.getValue(), Variable.class);
                if (variable != null && VariableImpl.isLocalWriteAccess((PsiElement)expression) && PhpArrayUsedOnlyForWriteInspection.firstArrayWrite(variable)) {
                    this.check(variable);
                }
            }

            private void check(@Nullable Variable variable) {
                if (variable == null || PhpLangUtil.isSuperGlobal(variable.getName())) {
                    return;
                }
                if (PhpPsiUtil.getParentByCondition((PsiElement)variable, (Condition<? super PsiElement>)PhpScopeHolder.INSTANCE_OF) instanceof PhpFile) {
                    return;
                }
                if (variable.resolveLocal().stream().anyMatch(x$0 -> PhpArrayUsedOnlyForWriteInspection.accessByRef(x$0))) {
                    return;
                }
                if (this.onlyWriteAccessesExists(variable)) {
                    holder.registerProblem((PsiElement)variable, PhpBundle.message("array.only.updated.but.never.queried", new Object[0]), new LocalQuickFix[0]);
                }
            }

            private boolean onlyWriteAccessesExists(final Variable assignedVariable) {
                PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)assignedVariable, PhpAccessVariableInstruction.class);
                if (instruction == null) {
                    return false;
                }
                final Ref readAccessExists = new Ref((Object)Boolean.FALSE);
                final Ref writeAccessExists = new Ref((Object)Boolean.FALSE);
                final String assignedVariableName = assignedVariable.getName();
                PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                    public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                        ArrayAccessExpression anchor = (ArrayAccessExpression)instruction.getAnchor();
                        if (anchor.getValue() == assignedVariable) {
                            return true;
                        }
                        CharSequence variableName = PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction);
                        if (this.isReadArrayAccess((PhpAccessInstruction)instruction, variableName)) {
                            readAccessExists.set((Object)Boolean.TRUE);
                            return false;
                        }
                        if (PhpLangUtil.equalsVariableNames(variableName, assignedVariableName)) {
                            writeAccessExists.set((Object)Boolean.TRUE);
                        }
                        return super.processArrayAccessInstruction(instruction);
                    }

                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                        if (this.isReadArrayAccess((PhpAccessInstruction)instruction, instruction.getVariableName())) {
                            readAccessExists.set((Object)Boolean.TRUE);
                            return false;
                        }
                        if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), assignedVariableName) && instruction.getAccess().isWrite()) {
                            return false;
                        }
                        return super.processAccessVariableInstruction(instruction);
                    }

                    public boolean processIncludeInstruction(PhpIncludeInstruction instruction) {
                        readAccessExists.set((Object)Boolean.TRUE);
                        return false;
                    }

                    private boolean isReadArrayAccess(PhpAccessInstruction instruction, CharSequence variableName) {
                        return PhpLangUtil.equalsVariableNames(variableName, assignedVariableName) && !(instruction.getAnchor().getParent() instanceof ArrayAccessExpression) && !instruction.getAccess().isWrite();
                    }
                });
                return (Boolean)readAccessExists.get() == false && (Boolean)writeAccessExists.get() != false;
            }
        };
    }

    private static boolean firstArrayWrite(Variable variable) {
        final PhpAccessVariableInstruction originalInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
        if (originalInstruction == null) {
            return false;
        }
        final Ref accessBeforeExists = new Ref((Object)false);
        PhpControlFlowUtil.processPreviousVariableAccesses(originalInstruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (instruction.num() < originalInstruction.num()) {
                    accessBeforeExists.set((Object)true);
                }
                return false;
            }
        });
        return (Boolean)accessBeforeExists.get() == false;
    }

    private static boolean accessByRef(PhpNamedElement element) {
        return element instanceof Parameter && ((Parameter)element).isPassByRef() || PhpCodeInsightUtil.getAccess((PhpPsiElement)element).isWriteRef();
    }

    private static boolean arrayAssignmentByValue(AssignmentExpression assignmentExpression) {
        PhpTypedElement value = (PhpTypedElement)ObjectUtils.tryCast((Object)assignmentExpression.getValue(), PhpTypedElement.class);
        return value != null && PhpType.isArray((PhpType)value.getGlobalType()) && !PhpWorkaroundUtil.isAssignByReference(assignmentExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/controlFlow/PhpArrayUsedOnlyForWriteInspection", "buildVisitor"));
    }
}

