/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpBaseImportQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpUnnecessaryLeadingBackslashInUseStatementInspection
extends PhpInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnnecessaryLeadingBackslashInUseStatementInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpUse(PhpUse expression) {
                PhpReference reference = expression.getTargetReference();
                if (PhpUnnecessaryLeadingBackslashInUseStatementInspection.isAbsoluteReference(reference) && !expression.isTraitImport()) {
                    holder.registerProblem((PsiElement)reference, PhpBundle.message("inspection.message.unnecessary.leading.slash", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, TextRange.create((int)0, (int)1), new LocalQuickFix[]{PhpRemoveLeadingSlashQuickFix.INSTANCE});
                }
            }
        };
    }

    private static boolean isAbsoluteReference(PhpReference reference) {
        return reference != null && StringUtil.startsWithChar((CharSequence)reference.getImmediateNamespaceName(), (char)'\\');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryLeadingBackslashInUseStatementInspection", "buildVisitor"));
    }

    private static class PhpRemoveLeadingSlashQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpRemoveLeadingSlashQuickFix();

        private PhpRemoveLeadingSlashQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.remove.leading", new Object[0]);
            if (string == null) {
                PhpRemoveLeadingSlashQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpRemoveLeadingSlashQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PhpReference classReference;
            if (project == null) {
                PhpRemoveLeadingSlashQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PhpRemoveLeadingSlashQuickFix.$$$reportNull$$$0(3);
            }
            if (!PhpUnnecessaryLeadingBackslashInUseStatementInspection.isAbsoluteReference(classReference = (PhpReference)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)PhpReference.INSTANCEOF))) {
                return;
            }
            classReference.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, PhpReference.class, String.format("use %s %s", PhpBaseImportQuickFix.getKeyword(classReference).getValue(), classReference.getText().substring(1))));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryLeadingBackslashInUseStatementInspection$PhpRemoveLeadingSlashQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryLeadingBackslashInUseStatementInspection$PhpRemoveLeadingSlashQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

