/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpUnnecessaryCurlyVarSyntaxInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUnnecessaryCurlyVarSyntaxInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
                if (expression.isSingleQuote()) {
                    return;
                }
                for (Variable variable : PhpPsiUtil.getChildren((PsiElement)expression, (Condition<? super PsiElement>)((Condition)Variable.class::isInstance))) {
                    PsiElement firstChild = variable.getFirstChild();
                    if ((!PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.chLBRACE) || !PhpUnnecessaryCurlyVarSyntaxInspection.isSimpleVariableExpression(variable)) && !PhpUnnecessaryCurlyVarSyntaxInspection.isSimpleVariable(variable)) continue;
                    if (isOnTheFly) {
                        TextRange firstChildRange = PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.DOLLAR_LBRACE) ? TextRange.create((int)1, (int)2) : TextRange.create((int)0, (int)1);
                        holder.registerProblem(firstChild, PhpBundle.message("inspection.message.unnecessary.curly.braces", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, firstChildRange, new LocalQuickFix[]{PhpUnwrapCurlyBracesQuickFix.INSTANCE});
                        PsiElement closingBrace = variable.getLastChild();
                        if (!PhpPsiUtil.isOfType(closingBrace, PhpTokenTypes.chRBRACE)) continue;
                        holder.registerProblem(closingBrace, PhpBundle.message("inspection.message.unnecessary.curly.braces", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{PhpUnwrapCurlyBracesQuickFix.INSTANCE});
                        continue;
                    }
                    holder.registerProblem((PsiElement)variable, PhpBundle.message("inspection.message.unnecessary.curly.braces", PhpUnwrapCurlyBracesQuickFix.INSTANCE), new LocalQuickFix[0]);
                }
            }
        };
    }

    private static boolean isSimpleVariableExpression(Variable variable) {
        PhpPsiElement child = variable.getFirstPsiChild();
        if (child instanceof ArrayAccessExpression) {
            if (((ArrayAccessExpression)child).getValue() instanceof Variable) {
                ArrayIndex index = ((ArrayAccessExpression)child).getIndex();
                if (index == null) {
                    return true;
                }
                PhpPsiElement value = index.getValue();
                return value instanceof Variable || PhpPsiUtil.isOfType((PsiElement)value, PhpElementTypes.NUMBER);
            }
            return false;
        }
        if (child instanceof FieldReference) {
            return ((FieldReference)child).getClassReference() instanceof Variable && !PhpUnnecessaryCurlyVarSyntaxInspection.nextCharIsPartOfIdentifier(variable);
        }
        return PhpUnnecessaryCurlyVarSyntaxInspection.isSimpleVariable(variable);
    }

    private static boolean isSimpleVariable(Variable variable) {
        PsiElement firstChild = variable.getFirstChild();
        PsiElement innerVariable = firstChild.getNextSibling();
        return variable.getFirstPsiChild() == null && PhpPsiUtil.isOfType(innerVariable, PhpTokenTypes.VARIABLE) && (!PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.DOLLAR_LBRACE) || !innerVariable.getText().startsWith("$")) && !PhpUnnecessaryCurlyVarSyntaxInspection.nextCharIsPartOfIdentifier(variable);
    }

    private static boolean nextCharIsPartOfIdentifier(Variable variable) {
        PsiElement sibling = variable.getNextSibling();
        if (sibling == null) {
            return false;
        }
        String text = sibling.getText();
        return !text.isEmpty() && Character.isJavaIdentifierPart(text.charAt(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryCurlyVarSyntaxInspection", "buildVisitor"));
    }

    private static class PhpUnwrapCurlyBracesQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpUnwrapCurlyBracesQuickFix();

        private PhpUnwrapCurlyBracesQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.unwrap.curly.braces", new Object[0]);
            if (string == null) {
                PhpUnwrapCurlyBracesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Variable variable;
            if (project == null) {
                PhpUnwrapCurlyBracesQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpUnwrapCurlyBracesQuickFix.$$$reportNull$$$0(2);
            }
            if ((variable = (Variable)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)Variable.INSTANCEOF)) == null) {
                return;
            }
            PsiElement innerVariable = variable.getFirstChild().getNextSibling();
            Object innerVariableText = PhpPsiUtil.isOfType(variable.getFirstChild(), PhpTokenTypes.DOLLAR_LBRACE) ? "$" + variable.getName() : innerVariable.getText();
            variable.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, Variable.class, "\"" + (String)innerVariableText + "\""));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryCurlyVarSyntaxInspection$PhpUnwrapCurlyBracesQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryCurlyVarSyntaxInspection$PhpUnwrapCurlyBracesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

