/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.intentions.PhpReplaceSwitchWithIfIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpPrintExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSwitchCanBeReplacedWithMatchExpressionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpSwitch(PhpSwitch switchStatement) {
                if (switchStatement.getArgument() == null) {
                    return;
                }
                List<PhpReplaceSwitchWithIfIntention.SwitchStatementBranch> branches = PhpReplaceSwitchWithIfIntention.collectBranches(holder.getProject(), switchStatement);
                if (branches.isEmpty()) {
                    return;
                }
                PhpReplaceSwitchWithIfIntention.SwitchStatementBranch firstBranch = branches.get(0);
                List<PsiElement> firstCaseBodyStatements = firstBranch.getBodyStatements();
                if (firstCaseBodyStatements.size() != 1) {
                    return;
                }
                PsiElement firstCaseLeftHandSide = (PsiElement)PhpSwitchCanBeReplacedWithMatchExpressionInspection.destructureStatement((PsiElement)firstCaseBodyStatements.get((int)0)).first;
                if (firstCaseLeftHandSide == null) {
                    return;
                }
                if (PhpSwitchCanBeReplacedWithMatchExpressionInspection.isDefaultCaseNeededForProperExtraction(firstCaseLeftHandSide) && switchStatement.getDefaultCase() == null) {
                    return;
                }
                for (PhpReplaceSwitchWithIfIntention.SwitchStatementBranch branch : branches) {
                    if (!branch.hasStatements()) {
                        return;
                    }
                    List<PsiElement> bodyStatements = branch.getBodyStatements();
                    if (bodyStatements.size() != 1) {
                        return;
                    }
                    PsiElement leftHandSide = (PsiElement)PhpSwitchCanBeReplacedWithMatchExpressionInspection.destructureStatement((PsiElement)bodyStatements.get((int)0)).first;
                    if (leftHandSide == null) {
                        return;
                    }
                    if (!(leftHandSide.getClass() == firstCaseLeftHandSide.getClass() || branch.isDefault() && leftHandSide instanceof PhpThrowExpression)) {
                        return;
                    }
                    if (!(leftHandSide instanceof AssignmentExpression) || PhpSwitchCanBeReplacedWithMatchExpressionInspection.isHomogeneousAssignments(firstCaseLeftHandSide, leftHandSide)) continue;
                    return;
                }
                holder.registerProblem(switchStatement.getFirstChild(), PhpBundle.message("inspection.message.switch.can.be.replaced.with.match", new Object[0]), new LocalQuickFix[]{PhpReplaceSwitchWithMatchExpressionFix.INSTANCE});
            }
        };
    }

    private static boolean isHomogeneousAssignments(PsiElement patternAssignment, PsiElement assignment) {
        if (patternAssignment instanceof SelfAssignmentExpression && assignment instanceof SelfAssignmentExpression && ((SelfAssignmentExpression)patternAssignment).getOperationType() != ((SelfAssignmentExpression)assignment).getOperationType()) {
            return false;
        }
        if (patternAssignment instanceof AssignmentExpression && assignment instanceof AssignmentExpression) {
            PhpPsiElement patternVariable = ((AssignmentExpression)patternAssignment).getVariable();
            PhpPsiElement variable = ((AssignmentExpression)assignment).getVariable();
            if (patternVariable instanceof FieldReference && variable instanceof FieldReference) {
                return StringUtil.equals((CharSequence)variable.getName(), (CharSequence)patternVariable.getName());
            }
            return patternVariable instanceof Variable && variable instanceof Variable && ((Variable)variable).getName().equals(((Variable)patternVariable).getName());
        }
        return false;
    }

    private static boolean isDefaultCaseNeededForProperExtraction(PsiElement firstCaseLeftHandSide) {
        return firstCaseLeftHandSide instanceof PhpReturn || firstCaseLeftHandSide instanceof PhpEchoStatement || firstCaseLeftHandSide instanceof PhpPrintExpression || firstCaseLeftHandSide instanceof PhpThrowExpression;
    }

    private static @NotNull Pair<@Nullable PsiElement, @Nullable PhpExpression> destructureStatement(@NotNull PsiElement statement) {
        PsiElement firstChild;
        if (statement == null) {
            PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(1);
        }
        if ((firstChild = statement.getFirstChild()) instanceof AssignmentExpression) {
            if (PhpSwitchCanBeReplacedWithMatchExpressionInspection.isNullCoalesceAssignment(firstChild) || PhpWorkaroundUtil.isAssignByReference((AssignmentExpression)firstChild)) {
                Pair pair = Pair.empty();
                if (pair == null) {
                    PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(2);
                }
                return pair;
            }
            PhpPsiElement variable = ((AssignmentExpression)firstChild).getVariable();
            Object object = variable = variable instanceof Variable ? (Variable)variable : (PhpPsiElement)ObjectUtils.tryCast((Object)variable, FieldReference.class);
            if (variable == null) {
                Pair pair = Pair.empty();
                if (pair == null) {
                    PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(3);
                }
                return pair;
            }
            PhpExpression value = (PhpExpression)ObjectUtils.tryCast((Object)((AssignmentExpression)firstChild).getValue(), PhpExpression.class);
            if (value == null) {
                Pair pair = Pair.empty();
                if (pair == null) {
                    PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(4);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)firstChild, (Object)value);
            if (pair == null) {
                PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(5);
            }
            return pair;
        }
        if (statement instanceof PhpReturn) {
            PhpExpression argument = (PhpExpression)ObjectUtils.tryCast((Object)((PhpReturn)statement).getArgument(), PhpExpression.class);
            if (argument == null) {
                Pair pair = Pair.empty();
                if (pair == null) {
                    PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(6);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)statement, (Object)argument);
            if (pair == null) {
                PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(7);
            }
            return pair;
        }
        if (firstChild instanceof PhpThrowExpression) {
            PhpExpression argument = (PhpExpression)ObjectUtils.tryCast((Object)((PhpThrowExpression)firstChild).getArgument(), PhpExpression.class);
            if (argument == null) {
                Pair pair = Pair.empty();
                if (pair == null) {
                    PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(8);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)firstChild, (Object)argument);
            if (pair == null) {
                PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(9);
            }
            return pair;
        }
        if (statement instanceof PhpEchoStatement) {
            PhpExpression argument = (PhpExpression)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])((PhpEchoStatement)statement).getArguments()), PhpExpression.class);
            if (argument == null) {
                Pair pair = Pair.empty();
                if (pair == null) {
                    PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(10);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)statement, (Object)argument);
            if (pair == null) {
                PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(11);
            }
            return pair;
        }
        if (firstChild instanceof PhpPrintExpression) {
            PhpExpression argument = (PhpExpression)ObjectUtils.tryCast((Object)((PhpPrintExpression)firstChild).getArgument(), PhpExpression.class);
            if (argument == null) {
                Pair pair = Pair.empty();
                if (pair == null) {
                    PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(12);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)firstChild, (Object)argument);
            if (pair == null) {
                PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(13);
            }
            return pair;
        }
        Pair pair = Pair.empty();
        if (pair == null) {
            PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(14);
        }
        return pair;
    }

    private static boolean isNullCoalesceAssignment(@NotNull PsiElement expr) {
        if (expr == null) {
            PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(15);
        }
        return expr instanceof SelfAssignmentExpression && ((SelfAssignmentExpression)expr).getOperationType() == PhpTokenTypes.opCOALESCE_ASGN;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpSwitchCanBeReplacedWithMatchExpressionInspection";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpSwitchCanBeReplacedWithMatchExpressionInspection";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "destructureStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "destructureStatement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isNullCoalesceAssignment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpReplaceSwitchWithMatchExpressionFix
    implements LocalQuickFix {
        private static final LocalQuickFix INSTANCE = new PhpReplaceSwitchWithMatchExpressionFix();

        private PhpReplaceSwitchWithMatchExpressionFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.switch.with.match.expression", new Object[0]);
            if (string == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(2);
            }
            PhpSwitch switchStatement = (PhpSwitch)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), (Condition<? super PsiElement>)PhpSwitch.INSTANCEOF);
            assert (switchStatement != null);
            List<PhpReplaceSwitchWithIfIntention.SwitchStatementBranch> branches = PhpReplaceSwitchWithIfIntention.collectBranches(project, switchStatement);
            if (branches.isEmpty()) {
                return;
            }
            String matchText = PhpReplaceSwitchWithMatchExpressionFix.getMatchExpressionText(switchStatement, branches);
            if (matchText == null) {
                return;
            }
            List<PsiElement> bodyStatements = branches.get(0).getBodyStatements();
            if (bodyStatements.isEmpty()) {
                return;
            }
            String leftHandSideText = PhpReplaceSwitchWithMatchExpressionFix.getLeftHandSideText((PsiElement)PhpSwitchCanBeReplacedWithMatchExpressionInspection.destructureStatement((PsiElement)bodyStatements.get((int)0)).first);
            if (leftHandSideText == null) {
                return;
            }
            PsiElement newStatement = switchStatement.replace((PsiElement)PhpPsiElementFactory.createStatement(project, leftHandSideText + matchText));
            PhpReplaceSwitchWithMatchExpressionFix.tryMoveOuterAssignmentToDefaultArm(newStatement);
        }

        private static void tryMoveOuterAssignmentToDefaultArm(@NotNull PsiElement statement) {
            AssignmentExpression expression;
            if (statement == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(3);
            }
            if ((expression = (AssignmentExpression)PhpPsiUtil.getChildByCondition(statement, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF)) == null || expression instanceof SelfAssignmentExpression) {
                return;
            }
            PhpMatchExpression matchExpression = (PhpMatchExpression)PhpPsiUtil.getChildByCondition((PsiElement)expression, (Condition<? super PsiElement>)((Condition)PhpMatchExpression.class::isInstance));
            assert (matchExpression != null);
            if (matchExpression.getDefaultMatchArm() != null) {
                return;
            }
            PhpPsiElement variable = expression.getVariable();
            if (!(variable instanceof Variable)) {
                return;
            }
            Object prevStatement = PhpPsiUtil.getPrevSiblingByCondition(statement, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            AssignmentExpression prevExpression = (AssignmentExpression)PhpPsiUtil.getChildByCondition(prevStatement, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF);
            if (prevExpression == null || prevExpression instanceof SelfAssignmentExpression) {
                return;
            }
            PhpPsiElement variableToMove = prevExpression.getVariable();
            if (variableToMove == null || !PhpLangUtil.equalsVariableNames(variable.getName(), variableToMove.getName())) {
                return;
            }
            PhpPsiElement value = prevExpression.getValue();
            if (value == null || PhpSideEffectDetector.canContainSideEffect((PsiElement)value)) {
                return;
            }
            PhpAnnotatorVisitor.PhpAddDefaultMatchArmQuickFix.appendDefaultMatchArmWithText(expression.getProject(), matchExpression, "match (1) { default => " + value.getText() + "}");
            prevStatement.delete();
        }

        @Nullable
        private static String getLeftHandSideText(@Nullable PsiElement element) {
            if (element == null) {
                return null;
            }
            if (element instanceof AssignmentExpression) {
                PhpPsiElement variable = ((AssignmentExpression)element).getVariable();
                if (variable instanceof Variable) {
                    return "$" + ((Variable)variable).getName() + PhpReplaceSwitchWithMatchExpressionFix.getAssignOpText(element);
                }
                if (variable instanceof FieldReference) {
                    return variable.getText() + PhpReplaceSwitchWithMatchExpressionFix.getAssignOpText(element);
                }
            }
            return element.getFirstChild().getText() + " ";
        }

        private static String getAssignOpText(@NotNull PsiElement element) {
            PsiElement op;
            if (element == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(4);
            }
            if (element instanceof SelfAssignmentExpression && (op = ((SelfAssignmentExpression)element).getOperation()) != null) {
                return op.getText();
            }
            return "=";
        }

        @Nullable
        private static String getMatchExpressionText(PhpSwitch switchStatement, List<PhpReplaceSwitchWithIfIntention.SwitchStatementBranch> branches) {
            PsiElement argument = switchStatement.getArgument();
            assert (argument != null);
            StringBuilder matchBuilder = new StringBuilder("match(" + argument.getText() + "){");
            boolean allThrows = ContainerUtil.all(branches, b -> PhpSwitchCanBeReplacedWithMatchExpressionInspection.destructureStatement((PsiElement)b.getBodyStatements().get((int)0)).first instanceof PhpThrowExpression);
            for (PhpReplaceSwitchWithIfIntention.SwitchStatementBranch branch : branches) {
                Pair<PsiElement, PhpExpression> destructuredStatement = PhpSwitchCanBeReplacedWithMatchExpressionInspection.destructureStatement(branch.getBodyStatements().get(0));
                PhpExpression expression = (PhpExpression)destructuredStatement.second;
                if (expression == null) {
                    return null;
                }
                if (branch.isDefault()) {
                    matchBuilder.append("default");
                } else {
                    matchBuilder.append(StringUtil.join(branch.getCaseValues(), (String)","));
                }
                matchBuilder.append("=>");
                if (!allThrows && branch.isDefault() && destructuredStatement.first instanceof PhpThrowExpression) {
                    matchBuilder.append("throw ");
                }
                matchBuilder.append(expression.getText());
                matchBuilder.append(",");
            }
            matchBuilder.append("};");
            return matchBuilder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpSwitchCanBeReplacedWithMatchExpressionInspection$PhpReplaceSwitchWithMatchExpressionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpSwitchCanBeReplacedWithMatchExpressionInspection$PhpReplaceSwitchWithMatchExpressionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "tryMoveOuterAssignmentToDefaultArm";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getAssignOpText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

