/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpArrayMapCanBeConvertedToLoopInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpStrFunctionsInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpStrFunctionsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference strFunctionReference) {
                if (!this.checkStrPosToStrContains(strFunctionReference)) {
                    this.checkSubstrToStartsWith(strFunctionReference);
                }
            }

            private boolean checkStrPosToStrContains(FunctionReference strFunctionReference) {
                PsiElement referenceParent;
                if (PhpArrayMapCanBeConvertedToLoopInspection.isGlobalFunctionCallWithName(strFunctionReference, "strpos") && (referenceParent = strFunctionReference.getParent()) instanceof BinaryExpression) {
                    if (!PhpStrFunctionsInspection.thirdParameterZeroOrAbsent(strFunctionReference)) {
                        return false;
                    }
                    BinaryExpression binaryExpression = (BinaryExpression)referenceParent;
                    IElementType operationType = binaryExpression.getOperationType();
                    if (PhpLangUtil.isFalse(PhpStrFunctionsInspection.getOppositeOperand(strFunctionReference, binaryExpression)) && (operationType == PhpTokenTypes.opNOT_IDENTICAL && this.registerStrContainsFix(strFunctionReference, binaryExpression, false) || operationType == PhpTokenTypes.opIDENTICAL && this.registerStrContainsFix(strFunctionReference, binaryExpression, true))) {
                        return true;
                    }
                }
                return false;
            }

            private boolean registerStrContainsFix(FunctionReference strFunctionReference, BinaryExpression binaryExpression, boolean negation) {
                LocalQuickFix fix = PhpReplaceWithStrFunctionQuickFixBase.createStrContainsFix(strFunctionReference, binaryExpression, negation);
                if (fix == null) {
                    return false;
                }
                holder.registerProblem((PsiElement)binaryExpression, PhpBundle.message("inspection.str.functions.strpos.call.can.be.converted.to.strcontains", new Object[0]), new LocalQuickFix[]{fix});
                return true;
            }

            private void checkSubstrToStartsWith(FunctionReference strFunctionReference) {
                PsiElement rightOperand;
                BinaryExpression binaryExpression = (BinaryExpression)ObjectUtils.tryCast((Object)strFunctionReference.getParent(), BinaryExpression.class);
                if (binaryExpression == null) {
                    return;
                }
                IElementType type = binaryExpression.getOperationType();
                if (type != PhpTokenTypes.opIDENTICAL && type != PhpTokenTypes.opNOT_IDENTICAL) {
                    return;
                }
                if (type == PhpTokenTypes.opIDENTICAL && PhpArrayMapCanBeConvertedToLoopInspection.isGlobalFunctionCallWithName(strFunctionReference, "substr") && (this.strStartsWith(strFunctionReference, binaryExpression, rightOperand = PhpStrFunctionsInspection.getOppositeOperand(strFunctionReference, binaryExpression)) || this.strEndsWith(strFunctionReference, binaryExpression, rightOperand))) {
                    return;
                }
                this.checkStrPosWithZeroComparison(strFunctionReference, binaryExpression, type == PhpTokenTypes.opNOT_IDENTICAL);
            }

            private void checkStrPosWithZeroComparison(FunctionReference strFunctionReference, BinaryExpression binaryExpression, boolean negation) {
                LocalQuickFix fix;
                if (!PhpStrFunctionsInspection.thirdParameterZeroOrAbsent(strFunctionReference)) {
                    return;
                }
                if (PhpArrayMapCanBeConvertedToLoopInspection.isGlobalFunctionCallWithName(strFunctionReference, "strpos") && PhpStrFunctionsInspection.isZero(PhpStrFunctionsInspection.getOppositeOperand(strFunctionReference, binaryExpression)) && (fix = PhpReplaceWithStrFunctionQuickFixBase.createStrStartsWithFix(strFunctionReference, strFunctionReference.getParameter(1), binaryExpression, negation)) != null) {
                    holder.registerProblem((PsiElement)binaryExpression, PhpBundle.message("inspection.str.functions.strpos.call.can.be.converted.to.strstartswith", new Object[0]), new LocalQuickFix[]{fix});
                }
            }

            private boolean strStartsWith(FunctionReference strFunctionReference, BinaryExpression binaryExpression, PsiElement needle) {
                LocalQuickFix fix;
                PsiElement firstParameter;
                FunctionReference strlenFunctionReference;
                PsiElement functionReferenceParameter = strFunctionReference.getParameter(2);
                if (functionReferenceParameter instanceof FunctionReference && PhpStrFunctionsInspection.isZero(strFunctionReference.getParameter(1)) && PhpArrayMapCanBeConvertedToLoopInspection.isGlobalFunctionCallWithName(strlenFunctionReference = (FunctionReference)functionReferenceParameter, "strlen") && (firstParameter = strlenFunctionReference.getParameter(0)) != null && needle != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)firstParameter, (PsiElement)needle) && (fix = PhpReplaceWithStrFunctionQuickFixBase.createStrStartsWithFix(strFunctionReference, needle, binaryExpression, false)) != null) {
                    holder.registerProblem((PsiElement)binaryExpression, PhpBundle.message("inspection.str.functions.substr.call.can.be.converted.to.strstartswith", new Object[0]), new LocalQuickFix[]{fix});
                    return true;
                }
                return false;
            }

            private boolean strEndsWith(FunctionReference strFunctionReference, BinaryExpression binaryExpression, PsiElement needle) {
                LocalQuickFix fix;
                PsiElement firstParameter;
                FunctionReference strlenFunctionReference;
                PsiElement functionReferenceParameter = strFunctionReference.getParameter(1);
                if (!(functionReferenceParameter instanceof UnaryExpression)) {
                    return false;
                }
                UnaryExpression unaryExpression = (UnaryExpression)functionReferenceParameter;
                if (PhpPsiUtil.isOfType(unaryExpression.getOperation(), PhpTokenTypes.opMINUS) && unaryExpression.getValue() instanceof FunctionReference && PhpArrayMapCanBeConvertedToLoopInspection.isGlobalFunctionCallWithName(strlenFunctionReference = (FunctionReference)unaryExpression.getValue(), "strlen") && (firstParameter = strlenFunctionReference.getParameter(0)) != null && needle != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)firstParameter, (PsiElement)needle) && (fix = PhpReplaceWithStrFunctionQuickFixBase.createStrEndsWithFix(strFunctionReference, needle, binaryExpression)) != null) {
                    holder.registerProblem((PsiElement)binaryExpression, PhpBundle.message("inspection.str.functions.substr.call.can.be.converted.to.strendswith", new Object[0]), new LocalQuickFix[]{fix});
                    return true;
                }
                return false;
            }
        };
    }

    private static boolean thirdParameterZeroOrAbsent(FunctionReference strFunctionReference) {
        PsiElement offsetParameter = strFunctionReference.getParameter(2);
        return offsetParameter == null || PhpStrFunctionsInspection.isZero(offsetParameter);
    }

    @Nullable
    private static PsiElement getOppositeOperand(FunctionReference currentOperand, BinaryExpression binaryExpression) {
        PsiElement left = binaryExpression.getLeftOperand();
        PsiElement right = binaryExpression.getRightOperand();
        return left == currentOperand ? right : left;
    }

    private static boolean isZero(@Nullable PsiElement startIndex) {
        return PhpPsiUtil.isOfType(startIndex, PhpElementTypes.NUMBER) && startIndex.getText().equals("0");
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpStrFunctionsInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithStrFunctionQuickFixBase
    extends LocalQuickFixOnPsiElement {
        private final String myFunctionName;
        private final SmartPsiElementPointer<PsiElement> myNeedle;
        private final boolean myNegation;

        protected PhpReplaceWithStrFunctionQuickFixBase(@NotNull String functionName, @NotNull PsiElement elementToReplace, @NotNull PsiElement haystack, @NotNull PsiElement needle, boolean negation) {
            if (functionName == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(0);
            }
            if (elementToReplace == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(1);
            }
            if (haystack == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(2);
            }
            if (needle == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(3);
            }
            super(elementToReplace, haystack);
            this.myFunctionName = functionName;
            this.myNeedle = SmartPointerManager.getInstance((Project)needle.getProject()).createSmartPsiElementPointer(needle);
            this.myNegation = negation;
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(4);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with", this.myFunctionName);
            if (string == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(5);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement elementToReplace, @NotNull PsiElement haystack) {
            PsiElement needle;
            if (project == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(6);
            }
            if (file == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(7);
            }
            if (elementToReplace == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(8);
            }
            if (haystack == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(9);
            }
            if ((needle = this.myNeedle.getElement()) == null) {
                return;
            }
            PsiElement createdReplacement = this.createElementToReplace(project, haystack, needle);
            if (this.myNegation) {
                createdReplacement = PhpPsiElementFactory.createPhpPsiFromText(project, UnaryExpression.class, "!" + createdReplacement.getText());
            }
            elementToReplace.replace(createdReplacement);
        }

        @NotNull
        protected PsiElement createElementToReplace(@NotNull Project project, @NotNull PsiElement haystack, PsiElement needle) {
            if (project == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(10);
            }
            if (haystack == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(11);
            }
            FunctionReference functionReference = PhpPsiElementFactory.createFunctionReference(project, String.format("%s(%s, %s)", this.myFunctionName, haystack.getText(), needle.getText()));
            if (functionReference == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(12);
            }
            return functionReference;
        }

        @Nullable
        public static LocalQuickFix createStrContainsFix(FunctionReference strFunctionReference, BinaryExpression binaryExpression, boolean negation) {
            PsiElement haystack = strFunctionReference.getParameter(0);
            PsiElement needle = strFunctionReference.getParameter(1);
            return haystack != null && needle != null ? new PhpReplaceWithStrFunctionQuickFixBase("str_contains", (PsiElement)binaryExpression, haystack, needle, negation) : null;
        }

        @Nullable
        public static LocalQuickFix createStrStartsWithFix(FunctionReference strFunctionReference, PsiElement needle, BinaryExpression binaryExpression, boolean negation) {
            PsiElement haystack = strFunctionReference.getParameter(0);
            return haystack != null && needle != null ? new PhpReplaceWithStrFunctionQuickFixBase("str_starts_with", (PsiElement)binaryExpression, haystack, needle, negation) : null;
        }

        @Nullable
        public static LocalQuickFix createStrEndsWithFix(FunctionReference strFunctionReference, PsiElement needle, BinaryExpression binaryExpression) {
            PsiElement haystack = strFunctionReference.getParameter(0);
            return haystack != null && needle != null ? new PhpReplaceWithStrFunctionQuickFixBase("str_ends_with", (PsiElement)binaryExpression, haystack, needle, false) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionName";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToReplace";
                    break;
                }
                case 2: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "haystack";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "needle";
                    break;
                }
                case 4: 
                case 5: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpStrFunctionsInspection$PhpReplaceWithStrFunctionQuickFixBase";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpStrFunctionsInspection$PhpReplaceWithStrFunctionQuickFixBase";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createElementToReplace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 12: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "createElementToReplace";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

