/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpShortOpenTagInspection
extends PhpInspection {
    private static final LocalQuickFix QUICK_FIX = new PhpReplaceShortTagWithPhpTagQuickFix();

    @NotNull
    private static Collection<PsiElement> collectShortOpenTags(@Nullable PsiFile file) {
        PsiElement groupStatement;
        PsiElement psiElement = groupStatement = file != null ? file.getFirstChild() : null;
        if (groupStatement == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PhpShortOpenTagInspection.$$$reportNull$$$0(0);
            }
            return list;
        }
        SmartList result = new SmartList();
        PhpShortOpenTagInspection.collectShortOpenTags(groupStatement, (Collection<PsiElement>)result);
        SmartList smartList = result;
        if (smartList == null) {
            PhpShortOpenTagInspection.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    private static void collectShortOpenTags(@NotNull PsiElement statement, Collection<PsiElement> result) {
        if (statement == null) {
            PhpShortOpenTagInspection.$$$reportNull$$$0(2);
        }
        for (PsiElement child = statement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (PhpPsiUtil.isOfType(child, PhpTokenTypes.PHP_OPENING_TAG) && child.textMatches((CharSequence)"<?")) {
                result.add(child);
                continue;
            }
            if (!(child instanceof Statement)) continue;
            PhpShortOpenTagInspection.collectShortOpenTags(child, result);
        }
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpShortOpenTagInspection.$$$reportNull$$$0(3);
        }
        return new PhpElementVisitor(){

            public void visitPhpFile(PhpFile PhpFile2) {
                PhpShortOpenTagInspection.collectShortOpenTags((PsiFile)PhpFile2).forEach(tag -> holder.registerProblem(tag, PhpBundle.message("inspection.php.short.open.tag.description", new Object[0]), new LocalQuickFix[]{QUICK_FIX}));
            }
        };
    }

    @Override
    @Nullable
    protected ProblemHighlightType getPhp8CustomSeverity() {
        return ProblemHighlightType.ERROR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpShortOpenTagInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectShortOpenTags";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpShortOpenTagInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectShortOpenTags";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpReplaceShortTagWithPhpTagQuickFix
    implements LocalQuickFix {
        private PhpReplaceShortTagWithPhpTagQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("replace.all.occurrences.with.php", new Object[0]);
            if (string == null) {
                PhpReplaceShortTagWithPhpTagQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpReplaceShortTagWithPhpTagQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpReplaceShortTagWithPhpTagQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement openingTag = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.PHP_OPENING_TAG, "<?php");
            PhpShortOpenTagInspection.collectShortOpenTags(descriptor.getStartElement().getContainingFile()).forEach(tag -> tag.replace(openingTag));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpShortOpenTagInspection$PhpReplaceShortTagWithPhpTagQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpShortOpenTagInspection$PhpReplaceShortTagWithPhpTagQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

