/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PhpPluralMixedCanBeReplacedWithArrayInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPluralMixedCanBeReplacedWithArrayInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpDocType(PhpDocType docType) {
                int dimension;
                String type = (String)ContainerUtil.getOnlyItem((Collection)docType.getType().getTypes());
                if (type != null && (dimension = PhpType.getPluralDimension((String)type)) > 0 && PhpType.isMixedType((String)PhpType.unpluralize((String)type, (int)dimension))) {
                    String arrayToReplace = PhpType.pluralise((String)"array", (int)(dimension - 1));
                    holder.registerProblem((PsiElement)docType, PhpBundle.message("inspection.message.can.be.replaced.with", arrayToReplace), new LocalQuickFix[]{new PhpReplaceWithArrayDocTypeQuickFix(arrayToReplace)});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpPluralMixedCanBeReplacedWithArrayInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithArrayDocTypeQuickFix
    implements LocalQuickFix {
        private final String myDocType;

        private PhpReplaceWithArrayDocTypeQuickFix(String docType) {
            this.myDocType = docType;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.with", this.myDocType);
            if (string == null) {
                PhpReplaceWithArrayDocTypeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpReplaceWithArrayDocTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpReplaceWithArrayDocTypeQuickFix.$$$reportNull$$$0(2);
            }
            descriptor.getStartElement().replace((PsiElement)PhpPsiElementFactory.createPhpDocType(project, this.myDocType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpPluralMixedCanBeReplacedWithArrayInspection$PhpReplaceWithArrayDocTypeQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpPluralMixedCanBeReplacedWithArrayInspection$PhpReplaceWithArrayDocTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

