/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpDefaultMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMatchExpressionCanBeReplacedWithTernaryInspection
extends PhpInspection {
    private static final LocalQuickFix REPLACE_WITH_TERNARY = new PhpReplaceMatchWithTernary();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMatchExpressionCanBeReplacedWithTernaryInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
                PhpMatchArm matchArm = (PhpMatchArm)ContainerUtil.getOnlyItem((Collection)matchExpression.getMatchArms());
                if (matchArm != null && matchArm.getConditions().size() == 1 && matchExpression.getDefaultMatchArm() != null) {
                    holder.registerProblem(matchExpression.getFirstChild(), PhpBundle.message("inspection.message.match.can.be.replaced.with.ternary", new Object[0]), new LocalQuickFix[]{REPLACE_WITH_TERNARY});
                }
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpMatchExpressionCanBeReplacedWithTernaryInspection", "buildVisitor"));
    }

    private static class PhpReplaceMatchWithTernary
    implements LocalQuickFix {
        private PhpReplaceMatchWithTernary() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.match.with.ternary", new Object[0]);
            if (string == null) {
                PhpReplaceMatchWithTernary.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpReplaceMatchWithTernary.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpReplaceMatchWithTernary.$$$reportNull$$$0(2);
            }
            PhpMatchExpression matchExpression = (PhpMatchExpression)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), (Condition<? super PsiElement>)((Condition)PhpMatchExpression.class::isInstance));
            if (matchExpression == null) {
                return;
            }
            PhpExpression argument = matchExpression.getArgument();
            if (argument == null) {
                return;
            }
            PhpDefaultMatchArm defaultArm = matchExpression.getDefaultMatchArm();
            if (defaultArm == null) {
                return;
            }
            PhpMatchArm matchArm = (PhpMatchArm)ContainerUtil.getOnlyItem((Collection)matchExpression.getMatchArms());
            if (matchArm == null) {
                return;
            }
            PhpExpression trueBody = matchArm.getBodyExpression();
            PhpExpression falseBody = defaultArm.getBodyExpression();
            if (trueBody == null || falseBody == null) {
                return;
            }
            PhpExpression condition = (PhpExpression)ContainerUtil.getOnlyItem((Collection)matchArm.getConditions());
            if (condition == null) {
                return;
            }
            matchExpression.replace((PsiElement)PhpReplaceMatchWithTernary.composeTernaryExpression(project, (PsiElement)argument, (PsiElement)condition, (PsiElement)trueBody, (PsiElement)falseBody));
        }

        @NotNull
        private static TernaryExpression composeTernaryExpression(@NotNull Project project, @NotNull PsiElement argument, @NotNull PsiElement condition, @NotNull PsiElement trueBody, @NotNull PsiElement falseBody) {
            if (project == null) {
                PhpReplaceMatchWithTernary.$$$reportNull$$$0(3);
            }
            if (argument == null) {
                PhpReplaceMatchWithTernary.$$$reportNull$$$0(4);
            }
            if (condition == null) {
                PhpReplaceMatchWithTernary.$$$reportNull$$$0(5);
            }
            if (trueBody == null) {
                PhpReplaceMatchWithTernary.$$$reportNull$$$0(6);
            }
            if (falseBody == null) {
                PhpReplaceMatchWithTernary.$$$reportNull$$$0(7);
            }
            String text = argument.getText() + "===" + condition.getText() + "?" + trueBody.getText() + ":" + falseBody.getText();
            TernaryExpression ternary = PhpPsiElementFactory.createFromText(project, TernaryExpression.class, text);
            assert (ternary != null);
            TernaryExpression ternaryExpression = ternary;
            if (ternaryExpression == null) {
                PhpReplaceMatchWithTernary.$$$reportNull$$$0(8);
            }
            return ternaryExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpMatchExpressionCanBeReplacedWithTernaryInspection$PhpReplaceMatchWithTernary";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trueBody";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "falseBody";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpMatchExpressionCanBeReplacedWithTernaryInspection$PhpReplaceMatchWithTernary";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "composeTernaryExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "composeTernaryExpression";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

