/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIssetCanBeReplacedWithCoalesceInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpIssetCanBeReplacedWithCoalesceInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpTernaryExpression(TernaryExpression expression) {
                if (expression.isShort()) {
                    return;
                }
                PhpPsiElement condition = expression.getCondition();
                PhpPsiElement variant = expression.getTrueVariant();
                if (expression.getFalseVariant() != null && PhpIssetCanBeReplacedWithCoalesceInspection.sameIssetElements(condition, variant) && !PhpSideEffectDetector.canContainSideEffect((PsiElement)variant)) {
                    holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.message.can.be.replaced.with.version", new Object[0]), new LocalQuickFix[]{PhpReplaceWithCoalesceQuickFix.INSTANCE});
                }
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP700;
    }

    private static boolean sameIssetElements(PhpPsiElement condition, PhpPsiElement variant) {
        PhpExpression[] variables;
        if (condition instanceof PhpIsset && (variables = ((PhpIsset)condition).getVariables()).length == 1) {
            return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)variables[0], (PsiElement)variant, (o1, o2) -> 0, null, null, (boolean)false);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpIssetCanBeReplacedWithCoalesceInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithCoalesceQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpReplaceWithCoalesceQuickFix();

        private PhpReplaceWithCoalesceQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.version", new Object[0]);
            if (string == null) {
                PhpReplaceWithCoalesceQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpReplaceWithCoalesceQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpReplaceWithCoalesceQuickFix.$$$reportNull$$$0(2);
            }
            TernaryExpression ternaryExpression = (TernaryExpression)descriptor.getStartElement();
            PhpPsiElement trueVariant = ternaryExpression.getTrueVariant();
            PhpPsiElement falseVariant = ternaryExpression.getFalseVariant();
            if (trueVariant == null || falseVariant == null) {
                return;
            }
            ternaryExpression.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, BinaryExpression.class, trueVariant.getText() + " ?? " + falseVariant.getText()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpIssetCanBeReplacedWithCoalesceInspection$PhpReplaceWithCoalesceQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpIssetCanBeReplacedWithCoalesceInspection$PhpReplaceWithCoalesceQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

