/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpGetClassCanBeReplacedWithClassNameLiteralInspection
extends PhpInspection {
    private static final LocalQuickFix FIX = new PhpReplaceGetClassCallWithClassNameLiteral();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpGetClassCanBeReplacedWithClassNameLiteralInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null || !nameNode.getText().equalsIgnoreCase("get_class")) {
                    return;
                }
                ParameterList parameterList = reference.getParameterList();
                if (parameterList == null || parameterList.getParameters().length != 1) {
                    return;
                }
                holder.registerProblem((PsiElement)reference, PhpBundle.message("inspection.message.get.class.call.can.be.replaced.with.class.name.literal", new Object[0]), new LocalQuickFix[]{FIX});
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpGetClassCanBeReplacedWithClassNameLiteralInspection", "buildVisitor"));
    }

    private static class PhpReplaceGetClassCallWithClassNameLiteral
    implements LocalQuickFix {
        private PhpReplaceGetClassCallWithClassNameLiteral() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.class.name.literal", new Object[0]);
            if (string == null) {
                PhpReplaceGetClassCallWithClassNameLiteral.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            FunctionReference getClassCall;
            if (project == null) {
                PhpReplaceGetClassCallWithClassNameLiteral.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpReplaceGetClassCallWithClassNameLiteral.$$$reportNull$$$0(2);
            }
            if ((getClassCall = (FunctionReference)ObjectUtils.tryCast((Object)descriptor.getStartElement(), FunctionReference.class)) == null) {
                return;
            }
            ParameterList parameterList = getClassCall.getParameterList();
            if (parameterList == null) {
                return;
            }
            PsiElement parameter = parameterList.getParameter(0);
            if (parameter == null) {
                return;
            }
            if (parameter instanceof NewExpression) {
                parameter = PhpCodeEditUtil.parenthesize(parameter);
            }
            FieldReference classNameLiteral = PhpPsiElementFactory.createFromText(project, FieldReference.class, parameter.getText() + "::class");
            assert (classNameLiteral != null);
            getClassCall.replace((PsiElement)classNameLiteral);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpGetClassCanBeReplacedWithClassNameLiteralInspection$PhpReplaceGetClassCallWithClassNameLiteral";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpGetClassCanBeReplacedWithClassNameLiteralInspection$PhpReplaceGetClassCallWithClassNameLiteral";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

