/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpParenthesesPrecedenceAnalyzer;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExpressionWithoutClarifyingParenthesesInspection
extends PhpInspection {
    private static final LocalQuickFix FIX = new PhpAddClarifyingParenthesesQuickFix();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpExpressionWithoutClarifyingParenthesesInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpElement(PhpPsiElement element) {
                if (element instanceof PhpExpression) {
                    PhpExpressionWithoutClarifyingParenthesesVisitor visitor = new PhpExpressionWithoutClarifyingParenthesesVisitor(PhpExpressionWithoutClarifyingParenthesesVisitor.Mode.FIND);
                    element.accept((PsiElementVisitor)visitor);
                    if (visitor.myUnclearExpressionWithoutClerifyingParentheses) {
                        holder.registerProblem((PsiElement)element, PhpBundle.message("inspection.message.expression.without.parentheses", new Object[0]), new LocalQuickFix[]{FIX});
                    }
                }
            }
        };
    }

    public static PsiElement wrapInParens(@Nullable PsiElement element) {
        if (element != null) {
            ParenthesizedExpression parenthesizedExpression = PhpPsiElementFactory.createPhpPsiFromText(element.getProject(), ParenthesizedExpression.class, "(" + element.getText() + ")");
            return element.replace((PsiElement)parenthesizedExpression);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpExpressionWithoutClarifyingParenthesesInspection", "buildVisitor"));
    }

    private static final class PhpExpressionWithoutClarifyingParenthesesVisitor
    extends PhpElementVisitor {
        private final Mode myMode;
        private boolean myUnclearExpressionWithoutClerifyingParentheses = false;

        private PhpExpressionWithoutClarifyingParenthesesVisitor(Mode mode) {
            this.myMode = mode;
        }

        public void visitPhpBinaryExpression(BinaryExpression expression) {
            PsiElement left = expression.getLeftOperand();
            PsiElement right = expression.getRightOperand();
            IElementType operationType = expression.getOperationType();
            if (PhpParenthesesPrecedenceAnalyzer.getAssociativity((PsiElement)expression) != PhpParenthesesPrecedenceAnalyzer.Associativity.NON_ASSOCIATIVE) {
                if (PhpExpressionWithoutClarifyingParenthesesVisitor.binaryExpressionWithDifferentOperation(left, operationType)) {
                    this.process(left);
                }
                if (PhpExpressionWithoutClarifyingParenthesesVisitor.binaryExpressionWithDifferentOperation(right, operationType)) {
                    this.process(right);
                }
            }
        }

        private static boolean binaryExpressionWithDifferentOperation(PsiElement element, IElementType operationType) {
            return element instanceof BinaryExpression && ((BinaryExpression)element).getOperationType() != operationType;
        }

        public void visitPhpUnaryExpression(UnaryExpression expression) {
            if (PhpParenthesesPrecedenceAnalyzer.getAssociativity((PsiElement)expression) != PhpParenthesesPrecedenceAnalyzer.Associativity.NON_ASSOCIATIVE) {
                this.process((PsiElement)expression.getValue());
            }
        }

        public void visitPhpTernaryExpression(TernaryExpression expression) {
            this.process((PsiElement)expression.getCondition());
            this.process((PsiElement)expression.getTrueVariant());
            this.process((PsiElement)expression.getFalseVariant());
        }

        private void process(PsiElement element) {
            if (PhpExpressionWithoutClarifyingParenthesesVisitor.isNonTrivialExpression(element)) {
                if (this.myMode == Mode.WRAP_IN_PARENTHESES) {
                    PhpExpressionWithoutClarifyingParenthesesInspection.wrapInParens(element);
                } else {
                    this.myUnclearExpressionWithoutClerifyingParentheses = true;
                }
            }
        }

        private static boolean isNonTrivialExpression(@Nullable PsiElement operand) {
            return operand instanceof BinaryExpression || operand instanceof UnaryExpression && PhpExpressionWithoutClarifyingParenthesesVisitor.isNonTrivialExpression((PsiElement)((UnaryExpression)operand).getValue()) || operand instanceof AssignmentExpression || operand instanceof TernaryExpression;
        }

        static enum Mode {
            FIND,
            WRAP_IN_PARENTHESES;

        }
    }

    private static class PhpAddClarifyingParenthesesQuickFix
    extends PhpQuickFixBase {
        private static final PhpExpressionWithoutClarifyingParenthesesVisitor ADD_CLARIFYING_PARENTHESES_VISITOR = new PhpExpressionWithoutClarifyingParenthesesVisitor(PhpExpressionWithoutClarifyingParenthesesVisitor.Mode.WRAP_IN_PARENTHESES);

        private PhpAddClarifyingParenthesesQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("add.clarifying.parentheses", new Object[0]);
            if (string == null) {
                PhpAddClarifyingParenthesesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpAddClarifyingParenthesesQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpAddClarifyingParenthesesQuickFix.$$$reportNull$$$0(2);
            }
            descriptor.getStartElement().accept((PsiElementVisitor)ADD_CLARIFYING_PARENTHESES_VISITOR);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpExpressionWithoutClarifyingParenthesesInspection$PhpAddClarifyingParenthesesQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpExpressionWithoutClarifyingParenthesesInspection$PhpAddClarifyingParenthesesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

