/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpPassByRefInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StatementWithArgument;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.StatementImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpRefactoringErrorException;
import com.jetbrains.php.refactoring.inline.PhpInlineVariableHandler;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnnecessaryLocalVariableInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnnecessaryLocalVariableInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                if (assignmentExpression instanceof SelfAssignmentExpression || !PhpUnnecessaryLocalVariableInspection.isSingleStatement(assignmentExpression)) {
                    return;
                }
                Variable variable = (Variable)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), Variable.class);
                if (variable == null) {
                    return;
                }
                if (PhpLangUtil.isSuperGlobal(variable.getName())) {
                    return;
                }
                Variable nextExitInstructionArgumentVariable = PhpUnnecessaryLocalVariableInspection.getNextExitInstructionArgumentVariable((PsiElement)variable);
                if (PhpUnnecessaryLocalVariableInspection.isImmediatelyUsedInExitInstruction(variable, nextExitInstructionArgumentVariable)) {
                    PhpPsiElement value;
                    Function function;
                    PsiElement resolvedAssignmentVariable = variable.resolve();
                    if (resolvedAssignmentVariable instanceof Parameter && ((Parameter)resolvedAssignmentVariable).isPassByRef()) {
                        return;
                    }
                    if (nextExitInstructionArgumentVariable.getParent() instanceof PhpReturn && (function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)nextExitInstructionArgumentVariable, (Condition<? super PsiElement>)Function.INSTANCEOF)) != null && function.isReturningByReference() && ((value = assignmentExpression.getValue()) == null || !PhpPassByRefInspection.canBePassByReference((PsiElement)value))) {
                        return;
                    }
                    holder.registerProblem((PsiElement)variable, PhpBundle.message("unnecessary.local.variable", new Object[0]), new LocalQuickFix[]{new PhpInlineVariableQuickFix(variable)});
                }
            }
        };
    }

    private static boolean isExitStatement(StatementWithArgument s) {
        return s instanceof PhpReturn || s.getFirstChild() instanceof PhpThrowExpression || s instanceof PhpYield;
    }

    private static boolean isSingleStatement(AssignmentExpression parentAssignmentExpression) {
        PsiElement parentStatement = parentAssignmentExpression.getParent();
        if (!(parentStatement instanceof Statement)) {
            return false;
        }
        PsiElement[] children = parentStatement.getChildren();
        return children.length == 1 && children[0] == parentAssignmentExpression;
    }

    @Nullable
    private static Variable getNextExitInstructionArgumentVariable(@NotNull PsiElement variable) {
        Object statement;
        StatementWithArgument nextStatementWithArgument;
        if (variable == null) {
            PhpUnnecessaryLocalVariableInspection.$$$reportNull$$$0(1);
        }
        if ((nextStatementWithArgument = PhpUnnecessaryLocalVariableInspection.getNextStatementWithArgument(statement = PhpPsiUtil.getParentByCondition(variable, (Condition<? super PsiElement>)Statement.INSTANCEOF))) == null || !PhpUnnecessaryLocalVariableInspection.isExitStatement(nextStatementWithArgument)) {
            return null;
        }
        return (Variable)ObjectUtils.tryCast((Object)nextStatementWithArgument.getArgument(), Variable.class);
    }

    @Nullable
    private static StatementWithArgument getNextStatementWithArgument(@Nullable PsiElement statement) {
        if (statement == null) {
            return null;
        }
        while ((statement = statement.getNextSibling()) instanceof PsiWhiteSpace || statement instanceof PsiComment) {
        }
        if (statement instanceof StatementWithArgument) {
            return (StatementWithArgument)statement;
        }
        if (statement instanceof StatementImpl && statement.getChildren().length == 1) {
            return (StatementWithArgument)ObjectUtils.tryCast((Object)statement.getChildren()[0], StatementWithArgument.class);
        }
        return null;
    }

    private static boolean isImmediatelyUsedInExitInstruction(@NotNull Variable variable, Variable exitInstructionArgumentVariable) {
        if (variable == null) {
            PhpUnnecessaryLocalVariableInspection.$$$reportNull$$$0(2);
        }
        return exitInstructionArgumentVariable != null && PhpLangUtil.equalsClassNames(exitInstructionArgumentVariable.getName(), variable.getName()) && PhpUnnecessaryLocalVariableInspection.isResolvedToVariable(exitInstructionArgumentVariable, variable);
    }

    private static boolean isResolvedToVariable(Variable exitInstructionArgumentVariable, final Variable variable) {
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)exitInstructionArgumentVariable, PhpAccessVariableInstruction.class);
        if (instruction == null) {
            return false;
        }
        final Ref res = new Ref((Object)true);
        PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (instruction.getAccess().isWrite()) {
                    if (instruction.getAnchor() != variable) {
                        res.set((Object)true);
                    }
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        return (Boolean)res.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessaryLocalVariableInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getNextExitInstructionArgumentVariable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImmediatelyUsedInExitInstruction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class PhpInlineVariableQuickFix
    extends LocalQuickFixOnPsiElement {
        private PhpInlineVariableQuickFix(Variable variable) {
            super((PsiElement)variable);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpInlineVariableQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Variable exitInstructionArgumentVariable;
            if (project == null) {
                PhpInlineVariableQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                PhpInlineVariableQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                PhpInlineVariableQuickFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                PhpInlineVariableQuickFix.$$$reportNull$$$0(4);
            }
            if ((exitInstructionArgumentVariable = PhpUnnecessaryLocalVariableInspection.getNextExitInstructionArgumentVariable(startElement)) == null) {
                return;
            }
            try {
                PhpInlineVariableHandler.invoke(project, null, exitInstructionArgumentVariable);
            }
            catch (PhpRefactoringErrorException phpRefactoringErrorException) {
                // empty catch block
            }
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.inline.variable.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpInlineVariableQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessaryLocalVariableInspection$PhpInlineVariableQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessaryLocalVariableInspection$PhpInlineVariableQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

