/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpArrayMapCanBeConvertedToLoopInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpUnnecessaryParenthesesInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpUnnecessaryCastInspectionBase
extends PhpInspection {
    public static final LocalQuickFix QUICK_FIX = new PhpUnwrapCastQuickFix();

    protected abstract IElementType getOperationType();

    protected abstract String getFunctionCallName();

    protected void doCheck(ProblemsHolder holder, PsiElement element) {
        PsiElement castElement = this.getCastElement(element);
        if (castElement != null) {
            holder.registerProblem(castElement, PhpBundle.message("inspection.message.unnecessary.cast.to.string", StringUtil.trimStart((String)StringUtil.trimEnd((String)element.getText(), (String)"("), (String)")")), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{QUICK_FIX});
        }
    }

    @Nullable
    private PsiElement getCastElement(@Nullable PsiElement element) {
        if (element instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)element).getOperation(), this.getOperationType())) {
            return ((UnaryExpression)element).getOperation();
        }
        if (element instanceof FunctionReference && PhpArrayMapCanBeConvertedToLoopInspection.isGlobalFunctionCallWithName((FunctionReference)element, this.getFunctionCallName())) {
            ASTNode nameNode = ((FunctionReference)element).getNameNode();
            return nameNode != null ? nameNode.getPsi() : null;
        }
        return null;
    }

    private static class PhpUnwrapCastQuickFix
    implements LocalQuickFix {
        private PhpUnwrapCastQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.unwrap.cast", new Object[0]);
            if (string == null) {
                PhpUnwrapCastQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement parameter;
            PsiElement element;
            if (project == null) {
                PhpUnwrapCastQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpUnwrapCastQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getStartElement().getParent()) instanceof UnaryExpression) {
                PsiElement replacedValue;
                PhpPsiElement value = ((UnaryExpression)element).getValue();
                if (value != null && (replacedValue = element.replace((PsiElement)value)) instanceof ParenthesizedExpression && PhpUnnecessaryParenthesesInspection.isParensUnnecessary((ParenthesizedExpression)replacedValue)) {
                    replacedValue.replace((PsiElement)((ParenthesizedExpression)replacedValue).unparenthesize());
                }
            } else if (element instanceof FunctionReference && (parameter = ((FunctionReference)element).getParameter(0)) != null) {
                element.replace(parameter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessaryCastInspectionBase$PhpUnwrapCastQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessaryCastInspectionBase$PhpUnwrapCastQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

