/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.inspections.codeSmell.PhpUnnecessaryCastInspectionBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnnecessaryBoolCastInspection
extends PhpUnnecessaryCastInspectionBase {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnnecessaryBoolCastInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpIf(If ifStatement) {
                this.doCheck((PsiElement)ifStatement.getCondition());
            }

            public void visitPhpElseIf(ElseIf elseIfStatement) {
                this.doCheck((PsiElement)elseIfStatement.getCondition());
            }

            public void visitPhpTernaryExpression(TernaryExpression expression) {
                this.doCheck((PsiElement)expression.getCondition());
            }

            public void visitPhpDoWhile(DoWhile doWhileStatement) {
                this.doCheck((PsiElement)doWhileStatement.getCondition());
            }

            public void visitPhpWhile(While whileStatement) {
                this.doCheck((PsiElement)whileStatement.getCondition());
            }

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                if (PhpTokenTypes.tsLOGICAL_OPS.contains(expression.getOperationType())) {
                    this.doCheck(expression.getLeftOperand());
                    this.doCheck(expression.getRightOperand());
                }
            }

            private void doCheck(@Nullable PsiElement element) {
                if (element instanceof ParenthesizedExpression) {
                    this.doCheck((PsiElement)((ParenthesizedExpression)element).getArgument());
                    return;
                }
                if (element == null) {
                    return;
                }
                PhpUnnecessaryBoolCastInspection.this.doCheck(holder, element);
            }
        };
    }

    @Override
    protected IElementType getOperationType() {
        return PhpTokenTypes.opBOOLEAN_CAST;
    }

    @Override
    protected String getFunctionCallName() {
        return "boolval";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessaryBoolCastInspection", "buildVisitor"));
    }
}

