/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTraitUseRuleInsideDifferentClassUseListInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpTraitUseRuleInsideDifferentClassUseListInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpTraitUseRule(PhpTraitUseRule type) {
                PhpClass resolvedClass;
                if (type.isInsteadOf() || type.getAlias() == null) {
                    return;
                }
                MethodReference reference = type.getOriginalReference();
                if (reference == null || reference.getFirstPsiChild() instanceof ClassReference) {
                    return;
                }
                Method method = (Method)ObjectUtils.tryCast((Object)reference.resolve(), Method.class);
                PhpClass phpClass = resolvedClass = method != null ? method.getContainingClass() : null;
                if (resolvedClass == null) {
                    return;
                }
                PhpUseList originalUseList = (PhpUseList)ObjectUtils.tryCast((Object)type.getParent(), PhpUseList.class);
                if (originalUseList == null) {
                    return;
                }
                String resolvedClassFQN = resolvedClass.getFQN();
                boolean suitableTargetDeclarationFound = Arrays.stream(originalUseList.getDeclarations()).map(PhpUse::getTargetReference).filter(Objects::nonNull).anyMatch(r -> PhpTraitUseRuleInsideDifferentClassUseListInspection.this.isTraitUsingClass((PhpReference)r, resolvedClassFQN));
                if (!suitableTargetDeclarationFound) {
                    LocalQuickFix[] localQuickFixArray;
                    PhpClass containingClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)type, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                    if (containingClass == null) {
                        return;
                    }
                    PhpReference referenceToMoveUseRule = PhpTraitUseRuleInsideDifferentClassUseListInspection.this.findTraitTargetReferenceToMoveUseRule(resolvedClassFQN, (PhpClassImpl)containingClass);
                    if (referenceToMoveUseRule != null) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = new PhpMoveUseRuleToTraitQuickFix(type, referenceToMoveUseRule);
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    holder.registerProblem((PsiElement)type, PhpBundle.message("inspection.message.method.reference.resolves.to.method.with.containing.class", PhpLangUtil.toPresentableFQN(resolvedClassFQN)), fixes);
                }
            }
        };
    }

    public PhpReference findTraitTargetReferenceToMoveUseRule(String resolvedClassFQN, PhpClassImpl containingClass) {
        return (PhpReference)ContainerUtil.find(containingClass.useListTargetReferences(), r -> this.isTraitUsingClass((PhpReference)r, resolvedClassFQN));
    }

    public boolean isTraitUsingClass(PhpReference traitUsingClass, String classFQNToUse) {
        String usingClassFQN = traitUsingClass.getFQN();
        PhpIndex index = PhpIndex.getInstance((Project)traitUsingClass.getProject());
        if (index.getAnyByFQN(usingClassFQN).isEmpty()) {
            return true;
        }
        return PhpLangUtil.equalsClassNames(usingClassFQN, classFQNToUse) || PhpType.findSuper((String)classFQNToUse, (String)usingClassFQN, (PhpIndex)index);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpTraitUseRuleInsideDifferentClassUseListInspection", "buildVisitor"));
    }

    private static class PhpMoveUseRuleToTraitQuickFix
    extends LocalQuickFixOnPsiElement {
        @Nullable
        private final String myTraitNameToMoveRuleTo;

        private PhpMoveUseRuleToTraitQuickFix(PhpTraitUseRule type, PhpReference rule) {
            super((PsiElement)type, (PsiElement)rule);
            this.myTraitNameToMoveRuleTo = rule.getName();
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = PhpBundle.message("intention.name.move.trait.use.rule.to.use.list", this.myTraitNameToMoveRuleTo);
            if (string == null) {
                PhpMoveUseRuleToTraitQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement useRuleToMove, @NotNull PsiElement targetTraitUse) {
            PhpUseList useList;
            if (project == null) {
                PhpMoveUseRuleToTraitQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                PhpMoveUseRuleToTraitQuickFix.$$$reportNull$$$0(2);
            }
            if (useRuleToMove == null) {
                PhpMoveUseRuleToTraitQuickFix.$$$reportNull$$$0(3);
            }
            if (targetTraitUse == null) {
                PhpMoveUseRuleToTraitQuickFix.$$$reportNull$$$0(4);
            }
            if ((useList = (PhpUseList)PhpPsiUtil.getParentByCondition(targetTraitUse, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF)) == null) {
                return;
            }
            Object originalUseListToCopyFrom = PhpPsiUtil.getParentByCondition(useRuleToMove, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
            if (originalUseListToCopyFrom == null) {
                return;
            }
            boolean singleUseRule = PhpPsiUtil.getChildren(originalUseListToCopyFrom, (Condition<? super PsiElement>)PhpTraitUseRule.INSTANCEOF).size() == 1;
            PsiElement movedRule = this.moveUseRule(project, useRuleToMove, useList);
            if (singleUseRule) {
                PsiComment[] comments = (PsiComment[])PsiTreeUtil.getChildrenOfType(originalUseListToCopyFrom, PsiComment.class);
                if (comments != null) {
                    for (PsiComment comment : comments) {
                        useList.addAfter((PsiElement)comment, movedRule);
                    }
                }
                this.compactUseList(project, (PsiElement)originalUseListToCopyFrom);
            }
        }

        public void compactUseList(@NotNull Project project, PsiElement useList) {
            if (project == null) {
                PhpMoveUseRuleToTraitQuickFix.$$$reportNull$$$0(5);
            }
            useList.deleteChildRange(PhpPsiUtil.getChildOfType(useList, PhpTokenTypes.chLBRACE), useList.getLastChild());
            useList.add(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.opSEMICOLON, ";"));
        }

        public PsiElement moveUseRule(@NotNull Project project, @NotNull PsiElement useRuleToMove, PhpUseList useList) {
            PsiElement movedRule;
            if (project == null) {
                PhpMoveUseRuleToTraitQuickFix.$$$reportNull$$$0(6);
            }
            if (useRuleToMove == null) {
                PhpMoveUseRuleToTraitQuickFix.$$$reportNull$$$0(7);
            }
            if (PhpPsiUtil.isOfType(useList.getLastChild(), PhpTokenTypes.chRBRACE)) {
                movedRule = useList.addBefore(useRuleToMove.copy(), useList.getLastChild());
            } else {
                PsiElement last = useList.getLastChild().replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.chRBRACE, "function f() {}"));
                movedRule = useList.addBefore(useRuleToMove.copy(), last);
                useList.addBefore(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.chLBRACE, "function f() {}"), movedRule);
            }
            useRuleToMove.delete();
            return movedRule;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.move.trait.use.rule.to.resolved.class.use.list", new Object[0]);
            if (string == null) {
                PhpMoveUseRuleToTraitQuickFix.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpTraitUseRuleInsideDifferentClassUseListInspection$PhpMoveUseRuleToTraitQuickFix";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "useRuleToMove";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetTraitUse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpTraitUseRuleInsideDifferentClassUseListInspection$PhpMoveUseRuleToTraitQuickFix";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "compactUseList";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "moveUseRule";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

