/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpInstanceofIsAlwaysTrueInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpParenthesesPrecedenceAnalyzer;
import com.jetbrains.php.lang.inspections.codeStyle.PhpUnnecessaryParenthesesInspection;
import com.jetbrains.php.lang.inspections.type.PhpExpressionAlwaysConstantInspection;
import com.jetbrains.php.lang.intentions.PhpNegateExpressionIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTernaryExpressionCanBeReplacedWithConditionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpTernaryExpressionCanBeReplacedWithConditionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpTernaryExpression(TernaryExpression expression) {
                PhpPsiElement condition = expression.getCondition();
                if (condition == null) {
                    return;
                }
                if (expression.isShort()) {
                    this.handleShortExpression(expression, condition);
                    return;
                }
                PhpPsiElement trueVariant = expression.getTrueVariant();
                PhpPsiElement falseVariant = expression.getFalseVariant();
                if (trueVariant == null || falseVariant == null) {
                    return;
                }
                boolean trueTrue = PhpLangUtil.isTrue((PsiElement)trueVariant);
                boolean falseFalse = PhpLangUtil.isFalse((PsiElement)falseVariant);
                boolean trueFalse = PhpLangUtil.isFalse((PsiElement)trueVariant);
                boolean falseTrue = PhpLangUtil.isTrue((PsiElement)falseVariant);
                if (trueTrue && falseFalse) {
                    PhpTernaryExpressionCanBeReplacedWithConditionInspection.registerProblem(expression, PhpPsiUtil.unparenthesize((PsiElement)condition), holder, false);
                } else if (trueFalse && falseTrue) {
                    PhpTernaryExpressionCanBeReplacedWithConditionInspection.registerProblem(expression, PhpPsiUtil.unparenthesize((PsiElement)condition), holder, true);
                } else if (!PhpTernaryExpressionCanBeReplacedWithConditionInspection.explicitTypeCastNeeded(expression, (PsiElement)trueVariant) && !PhpTernaryExpressionCanBeReplacedWithConditionInspection.explicitTypeCastNeeded(expression, (PsiElement)falseVariant) && (trueFalse || falseFalse || trueTrue || falseTrue)) {
                    String operationText = trueTrue || falseTrue ? " || " : " && ";
                    String left = trueFalse || falseTrue ? PhpTernaryExpressionCanBeReplacedWithConditionInspection.createNegationText(null, (PsiElement)condition) : condition.getText();
                    String right = falseFalse || falseTrue ? trueVariant.getText() : falseVariant.getText();
                    this.registerErrorReplaceWithBinary(expression, operationText, left, right);
                }
            }

            private void registerErrorReplaceWithBinary(TernaryExpression expression, String operationText, String left, String right) {
                String binaryExpressionText = left + operationText + right;
                String binaryExpressionTextWithParens = String.format("((%s) %s (%s))", left, operationText, right);
                holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.message.can.be.replaced.with", binaryExpressionText), new LocalQuickFix[]{new PhpReplaceWithBinaryExpressionQuickFix(binaryExpressionText, binaryExpressionTextWithParens)});
            }

            private void handleShortExpression(TernaryExpression expression, @NotNull PhpPsiElement condition) {
                PhpPsiElement falseVariant;
                if (condition == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((falseVariant = expression.getFalseVariant()) == null) {
                    return;
                }
                boolean falseFalse = PhpLangUtil.isFalse((PsiElement)falseVariant);
                boolean falseTrue = PhpLangUtil.isTrue((PsiElement)falseVariant);
                if (PhpTernaryExpressionCanBeReplacedWithConditionInspection.explicitTypeCastNeeded(expression, (PsiElement)condition) && !PhpTernaryExpressionCanBeReplacedWithConditionInspection.expressionIsImplicitlyCastedToBoolean(expression)) {
                    return;
                }
                if (falseFalse || falseTrue) {
                    if (falseFalse) {
                        PhpTernaryExpressionCanBeReplacedWithConditionInspection.registerProblem(expression, PhpPsiUtil.unparenthesize((PsiElement)condition), holder, false);
                    } else {
                        holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.message.can.be.replaced.with", "true"), new LocalQuickFix[]{PhpInstanceofIsAlwaysTrueInspection.getFixInternal(PhpExpressionAlwaysConstantInspection.ConstantValue.TRUE, (PsiElement)expression)});
                    }
                }
                if (!PhpTernaryExpressionCanBeReplacedWithConditionInspection.explicitTypeCastNeeded(expression, (PsiElement)falseVariant)) {
                    this.registerErrorReplaceWithBinary(expression, " || ", condition.getText(), falseVariant.getText());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/jetbrains/php/lang/inspections/codeSmell/PhpTernaryExpressionCanBeReplacedWithConditionInspection$1", "handleShortExpression"));
            }
        };
    }

    private static boolean expressionIsImplicitlyCastedToBoolean(@NotNull TernaryExpression ternaryExpression) {
        PhpPsiElement variable;
        PsiElement parent;
        if (ternaryExpression == null) {
            PhpTernaryExpressionCanBeReplacedWithConditionInspection.$$$reportNull$$$0(1);
        }
        if ((parent = ternaryExpression.getParent()) instanceof AssignmentExpression && ((AssignmentExpression)parent).getValue() == ternaryExpression && (variable = ((AssignmentExpression)parent).getVariable()) instanceof Variable) {
            return PhpTernaryExpressionCanBeReplacedWithConditionInspection.allUsagesOfVariableIsImplicitlyCastedToBoolean((Variable)variable);
        }
        return PhpTernaryExpressionCanBeReplacedWithConditionInspection.expressionIsImplicitlyCastedToBooleanImpl((PsiElement)ternaryExpression);
    }

    private static boolean allUsagesOfVariableIsImplicitlyCastedToBoolean(final Variable variable) {
        final Ref usageIsImplicitlyCasted = new Ref((Object)false);
        final Ref usageIsNotImplicitlyCasted = new Ref((Object)false);
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
        if (instruction != null) {
            PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    if (PhpLangUtil.equalsVariableNames(variable.getName(), instruction.getVariableName())) {
                        PhpAccessInstruction.Access access = instruction.getAccess();
                        if (access.isWrite() || access.isWriteRef()) {
                            return false;
                        }
                        if (PhpTernaryExpressionCanBeReplacedWithConditionInspection.expressionIsImplicitlyCastedToBooleanImpl((PsiElement)instruction.getAnchor())) {
                            usageIsImplicitlyCasted.set((Object)true);
                        } else {
                            usageIsNotImplicitlyCasted.set((Object)true);
                            return false;
                        }
                    }
                    return super.processAccessVariableInstruction(instruction);
                }
            });
        }
        return (Boolean)usageIsImplicitlyCasted.get() != false && (Boolean)usageIsNotImplicitlyCasted.get() == false;
    }

    private static boolean expressionIsImplicitlyCastedToBooleanImpl(@NotNull PsiElement ternaryExpression) {
        PsiElement expression;
        PsiElement parent;
        if (ternaryExpression == null) {
            PhpTernaryExpressionCanBeReplacedWithConditionInspection.$$$reportNull$$$0(2);
        }
        if ((parent = (expression = PhpTernaryExpressionCanBeReplacedWithConditionInspection.skipParentParenthesis(ternaryExpression)).getParent()) instanceof PhpCase || parent instanceof ForeachStatement) {
            return false;
        }
        if (parent instanceof ControlStatement && ((ControlStatement)parent).getCondition() == expression) {
            return true;
        }
        if (parent instanceof BinaryExpression && PhpTokenTypes.tsLOGICAL_OPS.contains(((BinaryExpression)parent).getOperationType())) {
            return ((BinaryExpression)parent).getLeftOperand() == expression || ((BinaryExpression)parent).getRightOperand() == expression;
        }
        return false;
    }

    @NotNull
    public static PsiElement skipParentParenthesis(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpTernaryExpressionCanBeReplacedWithConditionInspection.$$$reportNull$$$0(3);
        }
        while (expression.getParent() instanceof ParenthesizedExpression) {
            expression = expression.getParent();
        }
        PsiElement psiElement = expression;
        if (psiElement == null) {
            PhpTernaryExpressionCanBeReplacedWithConditionInspection.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    private static void registerProblem(TernaryExpression expression, PsiElement condition, @NotNull ProblemsHolder holder, boolean inverse) {
        String text;
        if (holder == null) {
            PhpTernaryExpressionCanBeReplacedWithConditionInspection.$$$reportNull$$$0(5);
        }
        if ((text = PhpTernaryExpressionCanBeReplacedWithConditionInspection.getTextToReplace(expression, condition, inverse)) == null) {
            return;
        }
        holder.registerProblem((PsiElement)expression, PhpBundle.message("ternary.condition.can.be.replaced.with.condition.expression", text), new LocalQuickFix[]{new PhpReplaceTernaryExpressionWithConditionQuickFix((PhpPsiElement)expression, inverse)});
    }

    @Nullable
    private static String getTextToReplace(@Nullable TernaryExpression expression, @Nullable PsiElement condition, boolean inverse) {
        if (condition == null) {
            return null;
        }
        return inverse ? PhpTernaryExpressionCanBeReplacedWithConditionInspection.createNegationText(expression, condition) : (PhpTernaryExpressionCanBeReplacedWithConditionInspection.explicitTypeCastNeeded(expression, condition) ? "(bool)" + condition.getText() : condition.getText());
    }

    private static String createNegationText(@Nullable TernaryExpression expression, @NotNull PsiElement condition) {
        if (condition == null) {
            PhpTernaryExpressionCanBeReplacedWithConditionInspection.$$$reportNull$$$0(6);
        }
        return PhpTernaryExpressionCanBeReplacedWithConditionInspection.isNegation(condition) ? PhpTernaryExpressionCanBeReplacedWithConditionInspection.getTextToReplace(expression, (PsiElement)((UnaryExpression)condition).getValue(), false) : (PhpParenthesesPrecedenceAnalyzer.getPrecedence(condition) > PhpParenthesesPrecedenceAnalyzer.getUnaryOperationPrecedence(PhpTokenTypes.opNOT) ? "!" + condition.getText() : "!(" + condition.getText() + ")");
    }

    private static boolean explicitTypeCastNeeded(TernaryExpression expression, PsiElement condition) {
        if (condition == null || expression == null || PhpTernaryExpressionCanBeReplacedWithConditionInspection.expressionIsImplicitlyCastedToBoolean(expression)) {
            return false;
        }
        if (!new PhpType().add(condition).global(condition.getProject()).isBoolean()) {
            return true;
        }
        PsiElement unparenthesized = PhpPsiUtil.unparenthesize(condition);
        return unparenthesized instanceof Variable || unparenthesized instanceof FieldReference;
    }

    private static boolean isNegation(PsiElement condition) {
        return condition instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)condition).getOperation(), PhpTokenTypes.opNOT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ternaryExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpTernaryExpressionCanBeReplacedWithConditionInspection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpTernaryExpressionCanBeReplacedWithConditionInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "skipParentParenthesis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "expressionIsImplicitlyCastedToBoolean";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "expressionIsImplicitlyCastedToBooleanImpl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "skipParentParenthesis";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNegationText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpReplaceWithBinaryExpressionQuickFix
    implements LocalQuickFix {
        private final String myText;
        private final String myBinaryExpressionTextWithParens;

        private PhpReplaceWithBinaryExpressionQuickFix(String text, String binaryExpressionTextWithParens) {
            this.myText = text;
            this.myBinaryExpressionTextWithParens = binaryExpressionTextWithParens;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.simplify.ternary.expression", new Object[0]);
            if (string == null) {
                PhpReplaceWithBinaryExpressionQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("php.replace.with", this.myText);
            if (string == null) {
                PhpReplaceWithBinaryExpressionQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement replacedParenthesizedBinaryExpression;
            PsiElement unwrapped;
            if (project == null) {
                PhpReplaceWithBinaryExpressionQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PhpReplaceWithBinaryExpressionQuickFix.$$$reportNull$$$0(3);
            }
            BinaryExpression binaryExpression = (unwrapped = PhpNegateExpressionIntention.unwrapIfNecessary(replacedParenthesizedBinaryExpression = descriptor.getStartElement().replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, ParenthesizedExpression.class, this.myBinaryExpressionTextWithParens)))) instanceof BinaryExpression ? (BinaryExpression)unwrapped : (BinaryExpression)((ParenthesizedExpression)unwrapped).getArgument();
            PhpNegateExpressionIntention.unwrapIfNecessary(binaryExpression.getLeftOperand());
            PhpNegateExpressionIntention.unwrapIfNecessary(binaryExpression.getRightOperand());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpTernaryExpressionCanBeReplacedWithConditionInspection$PhpReplaceWithBinaryExpressionQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpTernaryExpressionCanBeReplacedWithConditionInspection$PhpReplaceWithBinaryExpressionQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class PhpReplaceTernaryExpressionWithConditionQuickFix
    extends LocalQuickFixOnPsiElement {
        private final boolean myInverse;

        private PhpReplaceTernaryExpressionWithConditionQuickFix(PhpPsiElement condition, boolean inverse) {
            super((PsiElement)condition);
            this.myInverse = inverse;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getText() {
            TernaryExpression element = (TernaryExpression)ObjectUtils.tryCast((Object)this.getStartElement(), TernaryExpression.class);
            PsiElement condition = element != null ? PhpPsiUtil.unparenthesize((PsiElement)element.getCondition()) : null;
            String string = PhpBundle.message("php.replace.with", condition != null ? PhpTernaryExpressionCanBeReplacedWithConditionInspection.getTextToReplace(element, condition, this.myInverse) : "condition");
            if (string == null) {
                PhpReplaceTernaryExpressionWithConditionQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            TernaryExpression ternaryExpression;
            if (project == null) {
                PhpReplaceTernaryExpressionWithConditionQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                PhpReplaceTernaryExpressionWithConditionQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                PhpReplaceTernaryExpressionWithConditionQuickFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                PhpReplaceTernaryExpressionWithConditionQuickFix.$$$reportNull$$$0(4);
            }
            if ((ternaryExpression = (TernaryExpression)ObjectUtils.tryCast((Object)startElement, TernaryExpression.class)) == null) {
                return;
            }
            PsiElement condition = this.getConditionToReplace(project, ternaryExpression);
            if (condition == null) {
                return;
            }
            PsiElement replacedCondition = PhpTernaryExpressionCanBeReplacedWithConditionInspection.skipParentParenthesis(startElement).replace(PhpReplaceTernaryExpressionWithConditionQuickFix.castToBooleanIfNeeded(ternaryExpression, condition));
            PhpReplaceTernaryExpressionWithConditionQuickFix.unwrapIfNecessary(replacedCondition);
        }

        @Nullable
        private PsiElement getConditionToReplace(@NotNull Project project, TernaryExpression ternaryExpression) {
            if (project == null) {
                PhpReplaceTernaryExpressionWithConditionQuickFix.$$$reportNull$$$0(5);
            }
            PhpPsiElement condition = ternaryExpression.getCondition();
            if (this.myInverse && condition != null) {
                if (PhpTernaryExpressionCanBeReplacedWithConditionInspection.isNegation((PsiElement)condition)) {
                    return ((UnaryExpression)condition).getValue();
                }
                UnaryExpression notExpression = PhpPsiElementFactory.createPhpPsiFromText(project, UnaryExpression.class, "!(" + condition.getText() + ")");
                return PhpReplaceTernaryExpressionWithConditionQuickFix.unwrapValue(notExpression);
            }
            return condition;
        }

        @NotNull
        private static PsiElement unwrapIfNecessary(@NotNull PsiElement replacedCondition) {
            if (replacedCondition == null) {
                PhpReplaceTernaryExpressionWithConditionQuickFix.$$$reportNull$$$0(6);
            }
            while (replacedCondition instanceof ParenthesizedExpression && PhpUnnecessaryParenthesesInspection.isParensUnnecessary((ParenthesizedExpression)replacedCondition)) {
                replacedCondition = replacedCondition.replace((PsiElement)((ParenthesizedExpression)replacedCondition).extract());
            }
            PsiElement psiElement = replacedCondition;
            if (psiElement == null) {
                PhpReplaceTernaryExpressionWithConditionQuickFix.$$$reportNull$$$0(7);
            }
            return psiElement;
        }

        private static PsiElement castToBooleanIfNeeded(TernaryExpression ternaryExpression, PsiElement condition) {
            if (!PhpTernaryExpressionCanBeReplacedWithConditionInspection.explicitTypeCastNeeded(ternaryExpression, condition)) {
                return condition;
            }
            UnaryExpression unaryExpression = PhpPsiElementFactory.createPhpPsiFromText(condition.getProject(), UnaryExpression.class, String.format("(bool)(%s)", condition.getText()));
            return PhpReplaceTernaryExpressionWithConditionQuickFix.unwrapValue(unaryExpression);
        }

        private static PsiElement unwrapValue(UnaryExpression unaryExpression) {
            ParenthesizedExpression value = (ParenthesizedExpression)unaryExpression.getValue();
            return PhpReplaceTernaryExpressionWithConditionQuickFix.unwrapIfNecessary((PsiElement)value).getParent();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.simplify.ternary.expression", new Object[0]);
            if (string == null) {
                PhpReplaceTernaryExpressionWithConditionQuickFix.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpTernaryExpressionCanBeReplacedWithConditionInspection$PhpReplaceTernaryExpressionWithConditionQuickFix";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacedCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpTernaryExpressionCanBeReplacedWithConditionInspection$PhpReplaceTernaryExpressionWithConditionQuickFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unwrapIfNecessary";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getConditionToReplace";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "unwrapIfNecessary";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

