/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpYieldInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpReturnInstructionImpl;
import com.jetbrains.php.lang.inspections.PhpInconsistentReturnPointsInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpPrivateMethodsUsagesProcessInspectionBase;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.controlFlow.PhpUnnecessaryStopStatementInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PhpReturnValueOfMethodIsNeverUsedInspection
extends PhpPrivateMethodsUsagesProcessInspectionBase<Method, PsiElement> {
    private static final PhpType GENERATOR_TYPE = new PhpType().add(PhpInconsistentReturnPointsInspection.PROBABLY_GENERATOR_TYPE).add(PhpInconsistentReturnPointsInspection.GENERATOR_TYPE);

    @Override
    protected void putValuesFromPrivateMethodCalls(MultiMap<Method, PsiElement> values, @NotNull PhpReference reference, Method resolvedMethod, List<PsiElement> arguments) {
        if (reference == null) {
            PhpReturnValueOfMethodIsNeverUsedInspection.$$$reportNull$$$0(0);
        }
        values.putValue((Object)resolvedMethod, (Object)(PhpCodeInsightUtil.isResultUsed((PsiElement)reference) ? null : reference));
    }

    @Override
    protected MultiMap<Method, PsiElement> createInitialMap(PhpClass clazz, Collection<Method> candidatePrivateMethods) {
        return MultiMap.create();
    }

    @Override
    protected void processAllValuesFromMethodCalls(MultiMap<Method, PsiElement> values, Collection<Method> candidateMethods, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            PhpReturnValueOfMethodIsNeverUsedInspection.$$$reportNull$$$0(1);
        }
        for (Method method : values.keySet()) {
            PsiElement identifier;
            if (ContainerUtil.exists((Iterable)values.get((Object)method), Objects::isNull) || (identifier = method.getNameIdentifier()) == null) continue;
            holder.registerProblem(identifier, PhpBundle.message("inspection.message.return.value.method.never.used", new Object[0]), new LocalQuickFix[]{PhpMakeMethodVoidQuickFix.INSTANCE});
        }
    }

    @Override
    protected boolean isMethodSuitable(Method method) {
        return method.getMethodType(false) != Method.MethodType.CONSTRUCTOR && PhpReturnValueOfMethodIsNeverUsedInspection.hasReturnType(method);
    }

    private static boolean hasReturnType(Method method) {
        PhpType type = new PhpType().add((PsiElement)method.getTypeDeclaration()).add(method.getInferredType()).global(method.getProject());
        if (type.equals((Object)PhpType.VOID) || PhpType.intersects((PhpType)GENERATOR_TYPE, (PhpType)type)) {
            return false;
        }
        return !type.isEmpty() || PhpReturnValueOfMethodIsNeverUsedInspection.haveReturnsWithArgumentWithoutYield(method);
    }

    private static boolean haveReturnsWithArgumentWithoutYield(Method method) {
        final Ref haveReturn = new Ref((Object)false);
        final Ref haveYield = new Ref((Object)false);
        PhpControlFlowUtil.processFlow(method.getControlFlow(), new PhpInstructionProcessor(){

            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                if (instruction.getArgument() != null) {
                    haveReturn.set((Object)true);
                }
                return super.processReturnInstruction(instruction);
            }

            public boolean processYieldInstruction(PhpYieldInstruction instruction) {
                haveYield.set((Object)true);
                return false;
            }
        });
        return (Boolean)haveReturn.get() & (Boolean)haveYield.get() == false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpReturnValueOfMethodIsNeverUsedInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "putValuesFromPrivateMethodCalls";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllValuesFromMethodCalls";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpMakeMethodVoidQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpMakeMethodVoidQuickFix();

        private PhpMakeMethodVoidQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.make.method.void", new Object[0]);
            if (string == null) {
                PhpMakeMethodVoidQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Method method;
            if (project == null) {
                PhpMakeMethodVoidQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpMakeMethodVoidQuickFix.$$$reportNull$$$0(2);
            }
            if ((method = (Method)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)Method.INSTANCEOF)) == null) {
                return;
            }
            PhpMakeMethodVoidQuickFix.updateMethodDeclaration(method);
            PhpMakeMethodVoidQuickFix.updateReturnStatements(project, method);
        }

        private static void updateReturnStatements(@NotNull Project project, Method method) {
            if (project == null) {
                PhpMakeMethodVoidQuickFix.$$$reportNull$$$0(3);
            }
            final ArrayList returns = new ArrayList();
            PhpControlFlowUtil.processFlow(method.getControlFlow(), new PhpInstructionProcessor(){

                public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                    returns.add(((PhpReturnInstructionImpl)instruction).getReturnStatement());
                    return super.processReturnInstruction(instruction);
                }
            });
            ArrayList<PhpReturn> updatedReturns = new ArrayList<PhpReturn>();
            for (PhpReturn aReturn : returns) {
                PsiElement argument = aReturn.getArgument();
                if (argument == null) continue;
                updatedReturns.add(PhpMakeMethodVoidQuickFix.updateReturn(project, method, PhpMakeMethodVoidQuickFix.needBraces(aReturn) ? PhpMakeMethodVoidQuickFix.wrapInBraces(aReturn) : aReturn, argument));
            }
            for (PhpReturn updatedReturn : updatedReturns) {
                if (!PhpUnnecessaryStopStatementInspection.isUnnecessaryStopStatement((PsiElement)updatedReturn, (PsiElement)method)) continue;
                updatedReturn.delete();
            }
        }

        private static void updateMethodDeclaration(Method method) {
            PhpReturnType declaration = (PhpReturnType)method.getTypeDeclaration();
            if (declaration == null) {
                PhpChangeSignatureProcessor.addReturnType((Function)method, "void");
                declaration = (PhpReturnType)method.getTypeDeclaration();
            }
            assert (declaration != null);
            declaration.update(PhpType.VOID);
        }

        private static PhpReturn updateReturn(@NotNull Project project, Method method, PhpReturn aReturn, PsiElement argument) {
            if (project == null) {
                PhpMakeMethodVoidQuickFix.$$$reportNull$$$0(4);
            }
            if (PhpSideEffectDetector.canContainSideEffect(argument, true, true)) {
                aReturn.getParent().addBefore((PsiElement)PhpPsiElementFactory.createStatement(project, argument.getText() + ";"), (PsiElement)aReturn);
            }
            return (PhpReturn)aReturn.replace((PsiElement)PhpPsiElementFactory.createReturnStatement(project, ""));
        }

        private static PhpReturn wrapInBraces(PhpReturn aReturn) {
            If anIf = PhpPsiElementFactory.createPhpPsiFromText(aReturn.getProject(), If.class, "if($a){" + aReturn.getText() + "}");
            Statement statement = anIf.getStatement();
            Statement replacedStatement = (Statement)aReturn.replace((PsiElement)statement);
            return (PhpReturn)replacedStatement.getFirstPsiChild();
        }

        private static boolean needBraces(PhpReturn aReturn) {
            PsiElement parent = aReturn.getParent();
            return parent instanceof Else || parent instanceof ControlStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpReturnValueOfMethodIsNeverUsedInspection$PhpMakeMethodVoidQuickFix";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpReturnValueOfMethodIsNeverUsedInspection$PhpMakeMethodVoidQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updateReturnStatements";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "updateReturn";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

