/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpParametersDefaultValueMatchersIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PhpRedundantOptionalArgumentInspection
extends PhpInspection {
    private static final TIntHashSet EMPTY = new TIntHashSet();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRedundantOptionalArgumentInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethodReference(MethodReference reference) {
                this.visitPhpFunctionCall((FunctionReference)reference);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                super.visitPhpFunctionCall(reference);
                PsiElement[] arguments = reference.getParameters();
                if (arguments.length == 0) {
                    return;
                }
                List functions = StreamEx.of((Object[])reference.multiResolve(false)).map(ResolveResult::getElement).select(Function.class).toList();
                if (functions.isEmpty() || !PhpRedundantOptionalArgumentInspection.allFunctionsHaveSameOptionalSignatures(functions) || !PhpRedundantOptionalArgumentInspection.allFunctionsHaveMatchingSignatureToArgumentList(functions, arguments)) {
                    return;
                }
                int[] indexes = PhpRedundantOptionalArgumentInspection.getRedundantIndexes(Arrays.asList(arguments), functions);
                PhpRedundantOptionalArgumentInspection.registerProblemsOnMonotonicIndexesRanges(arguments, indexes, holder);
            }
        };
    }

    private static void registerProblemsOnMonotonicIndexesRanges(PsiElement[] arguments, int[] indexes, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            PhpRedundantOptionalArgumentInspection.$$$reportNull$$$0(1);
        }
        int l = 0;
        while (l < indexes.length) {
            int r;
            for (r = l; r < indexes.length - 1 && indexes[r + 1] == indexes[r] + 1; ++r) {
            }
            TextRange range = TextRange.create((int)PhpRedundantOptionalArgumentInspection.getFirstAnchorToDelete(arguments[indexes[l]]).getTextRangeInParent().getStartOffset(), (int)arguments[indexes[r]].getTextRangeInParent().getEndOffset());
            int singleArgumentMessageChoice = l == r ? 0 : 1;
            holder.registerProblem(arguments[l].getParent(), PhpBundle.message("inspection.message.redundant.argument", singleArgumentMessageChoice), ProblemHighlightType.LIKE_UNUSED_SYMBOL, range, new LocalQuickFix[]{new PhpDeleteRedundantArguments(indexes[l], indexes[r], singleArgumentMessageChoice)});
            l = r + 1;
        }
    }

    public static int[] getRedundantIndexes(List<PsiElement> arguments, List<Function> functions) {
        List allPossibleRedundantIndexes = ContainerUtil.map(functions, f -> PhpRedundantOptionalArgumentInspection.getRedundantArgumentIndexes(arguments, f, ContainerUtil.newArrayList((Object[])f.getParameters())));
        return IntStream.range(0, arguments.size()).filter(i -> ContainerUtil.all((Collection)allPossibleRedundantIndexes, t -> t.contains(i))).toArray();
    }

    private static boolean allFunctionsHaveMatchingSignatureToArgumentList(List<Function> functions, PsiElement[] arguments) {
        return ContainerUtil.all(functions, f -> f.getParameters().length >= arguments.length && ContainerUtil.find((Object[])f.getParameters(), Parameter::isVariadic) == null);
    }

    private static boolean allFunctionsHaveSameOptionalSignatures(List<Function> functions) {
        if (functions.isEmpty()) {
            return false;
        }
        Parameter[] parameters = functions.get(0).getParameters();
        return IntStream.range(1, functions.size()).allMatch(i -> PhpRedundantOptionalArgumentInspection.haveSameOptionalSignatures(((Function)functions.get(i)).getParameters(), parameters));
    }

    private static boolean haveSameOptionalSignatures(Parameter[] f, Parameter[] s) {
        return f.length == s.length && IntStream.range(0, f.length).noneMatch(i -> f[i].isOptional() != s[i].isOptional());
    }

    private static TIntHashSet getRedundantArgumentIndexes(List<PsiElement> arguments, Function function, List<Parameter> parameters) {
        int firstOptional = ContainerUtil.indexOf(parameters, Parameter::isOptional);
        if (firstOptional < 0 || firstOptional >= arguments.size()) {
            return EMPTY;
        }
        return PhpParametersDefaultValueMatchersIndex.getParameterDefaultValuesMatchers(function).stream().map(p -> PhpRedundantOptionalArgumentInspection.getRedundantArgumentIndexes(arguments, parameters, (TIntObjectHashMap<PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher>)p)).reduce(PhpRedundantOptionalArgumentInspection::intersection).orElseGet(TIntHashSet::new);
    }

    @NotNull
    private static TIntHashSet intersection(TIntHashSet a1, TIntHashSet a2) {
        TIntHashSet res = new TIntHashSet();
        if (a1.isEmpty() || a2.isEmpty()) {
            TIntHashSet tIntHashSet = res;
            if (tIntHashSet == null) {
                PhpRedundantOptionalArgumentInspection.$$$reportNull$$$0(2);
            }
            return tIntHashSet;
        }
        a1.forEach(i -> {
            if (a2.contains(i)) {
                res.add(i);
            }
            return true;
        });
        TIntHashSet tIntHashSet = res;
        if (tIntHashSet == null) {
            PhpRedundantOptionalArgumentInspection.$$$reportNull$$$0(3);
        }
        return tIntHashSet;
    }

    @NotNull
    private static TIntHashSet getRedundantArgumentIndexes(List<PsiElement> arguments, List<Parameter> parameters, TIntObjectHashMap<PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher> parameterDefaultValuesMatchers) {
        TIntHashSet res = new TIntHashSet();
        for (int i = 0; i < arguments.size(); ++i) {
            PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher matcher;
            Parameter param = PhpParamsInspection.getMappedParam(arguments, parameters, i);
            PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher phpParameterDefaultValueMatcher = matcher = param != null && param.isOptional() ? (PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher)parameterDefaultValuesMatchers.get(parameters.indexOf(param)) : null;
            if (matcher == null || !matcher.matches(arguments.get(i))) {
                if (ParameterListImpl.getNameIdentifier(arguments.get(i)) != null) continue;
                res.clear();
                continue;
            }
            res.add(i);
        }
        TIntHashSet tIntHashSet = res;
        if (tIntHashSet == null) {
            PhpRedundantOptionalArgumentInspection.$$$reportNull$$$0(4);
        }
        return tIntHashSet;
    }

    @NotNull
    private static PsiElement getFirstAnchorToDelete(@NotNull PsiElement parameter) {
        PsiElement nameIdentifier;
        if (parameter == null) {
            PhpRedundantOptionalArgumentInspection.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = (nameIdentifier = ParameterListImpl.getNameIdentifier(parameter)) != null ? nameIdentifier : parameter;
        if (psiElement == null) {
            PhpRedundantOptionalArgumentInspection.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpRedundantOptionalArgumentInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpRedundantOptionalArgumentInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRedundantArgumentIndexes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstAnchorToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerProblemsOnMonotonicIndexesRanges";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFirstAnchorToDelete";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpDeleteRedundantArguments
    implements LocalQuickFix {
        private final int myFirstRedundantIndex;
        private final int myLastRedundantIndex;
        @NotNull
        @IntentionFamilyName
        private final String myMessage;

        private PhpDeleteRedundantArguments(int firstRedundantIndex, int lastRedundantIndex, int singleArgumentMessageChoice) {
            this.myFirstRedundantIndex = firstRedundantIndex;
            this.myLastRedundantIndex = lastRedundantIndex;
            this.myMessage = PhpBundle.message("intention.family.name.remove.redundant.arguments", singleArgumentMessageChoice);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.myMessage;
            if (string == null) {
                PhpDeleteRedundantArguments.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpDeleteRedundantArguments.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpDeleteRedundantArguments.$$$reportNull$$$0(2);
            }
            ParameterList list = (ParameterList)descriptor.getStartElement();
            PsiElement[] parameters = list.getParameters();
            PsiElement firstAnchorToDelete = PhpRedundantOptionalArgumentInspection.getFirstAnchorToDelete(parameters[this.myFirstRedundantIndex]);
            PsiElement lastAnchorToDelete = parameters[this.myLastRedundantIndex];
            PsiElement prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(firstAnchorToDelete, true);
            PsiElement next = PhpPsiUtil.getNextSiblingIgnoreWhitespace(lastAnchorToDelete, true);
            if (PhpPsiUtil.isOfType(prev, PhpTokenTypes.opCOMMA)) {
                firstAnchorToDelete = prev;
            } else if (PhpPsiUtil.isOfType(next, PhpTokenTypes.opCOMMA)) {
                lastAnchorToDelete = next;
            }
            list.deleteChildRange(firstAnchorToDelete, lastAnchorToDelete);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpRedundantOptionalArgumentInspection$PhpDeleteRedundantArguments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpRedundantOptionalArgumentInspection$PhpDeleteRedundantArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

