/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessInstructionImpl;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpUnusedParameterInspection;
import com.jetbrains.php.lang.inspections.type.PhpExpressionAlwaysNullInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import gnu.trove.TIntObjectHashMap;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpParameterByRefIsNotUsedAsReferenceInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(com.jetbrains.php.lang.psi.elements.Function function) {
                PhpParameterByRefIsNotUsedAsReferenceInspection.doCheck(function, holder, PhpParameterByRefIsNotUsedAsReferenceInspection.getParametersByRefNames(function));
            }

            public void visitPhpMethod(Method method) {
                if (method instanceof PhpDocMethod) {
                    return;
                }
                Map<CharSequence, PsiElement> parametersByRefNames = PhpParameterByRefIsNotUsedAsReferenceInspection.getParametersByRefNames((com.jetbrains.php.lang.psi.elements.Function)method);
                PhpParameterByRefIsNotUsedAsReferenceInspection.removeParametersByRefInHierarchy(method, parametersByRefNames);
                PhpParameterByRefIsNotUsedAsReferenceInspection.doCheck((com.jetbrains.php.lang.psi.elements.Function)method, holder, parametersByRefNames);
            }

            public void visitPhpForeach(ForeachStatement foreach) {
                Object bitAnd;
                Variable value = foreach.getValue();
                if (value != null && PhpCodeInsightUtil.getAccess((PhpPsiElement)value).isWriteRef() && PhpParameterByRefIsNotUsedAsReferenceInspection.isForeachValuePassByRefIsNotUsed(foreach, value) && (bitAnd = PhpPsiUtil.getPrevSiblingByCondition((PsiElement)value, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opBIT_AND)))) != null) {
                    PhpParameterByRefIsNotUsedAsReferenceInspection.registerProblem(holder, bitAnd);
                }
            }
        };
    }

    private static boolean isForeachValuePassByRefIsNotUsed(@NotNull ForeachStatement foreach, Variable value) {
        PhpAccessVariableInstruction instruction;
        if (foreach == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(1);
        }
        if ((instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)value, PhpAccessVariableInstruction.class)) == null) {
            return false;
        }
        HashMap<String, Variable> foreachValueMap = new HashMap<String, Variable>(Collections.singletonMap(value.getName(), value));
        PhpParameterByRefIsNotUsedAsReferenceInspection.processSuccessorsIgnoringInitialBackEdge(instruction, PhpParameterByRefIsNotUsedAsReferenceInspection.createProcessorToRemoveUsedRefDeclarations(foreachValueMap));
        if (foreachValueMap.isEmpty()) {
            return false;
        }
        PsiElement array = foreach.getArray();
        if (array instanceof Variable) {
            return PhpParameterByRefIsNotUsedAsReferenceInspection.checkArrayChangesInsideForeach(foreach, instruction, array);
        }
        return true;
    }

    private static boolean checkArrayChangesInsideForeach(final @NotNull ForeachStatement foreach, PhpAccessVariableInstruction instruction, PsiElement array) {
        if (foreach == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(2);
        }
        HashMap<CharSequence, PsiElement> foreachArrayMap = new HashMap<CharSequence, PsiElement>(Collections.singletonMap(((Variable)array).getName(), array));
        final PhpInstructionProcessor processor = PhpParameterByRefIsNotUsedAsReferenceInspection.createProcessorToRemoveUsedRefDeclarations(foreachArrayMap);
        PhpParameterByRefIsNotUsedAsReferenceInspection.processSuccessorsIgnoringInitialBackEdge(instruction, new PhpInstructionProcessor(){

            public boolean processInstruction(PhpInstruction instruction) {
                PsiElement anchor = instruction.getAnchor();
                if (anchor != null && !PsiTreeUtil.isAncestor((PsiElement)foreach, (PsiElement)anchor, (boolean)false)) {
                    return false;
                }
                return instruction.process(processor);
            }
        });
        return !foreachArrayMap.isEmpty();
    }

    private static void processSuccessorsIgnoringInitialBackEdge(PhpAccessVariableInstruction instruction, PhpInstructionProcessor declarations) {
        BitSet visitedSetWithoutInitialEdge = new BitSet();
        visitedSetWithoutInitialEdge.set(instruction.num());
        PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, declarations, visitedSetWithoutInitialEdge);
    }

    private static void removeParametersByRefInHierarchy(Method method, Map<CharSequence, PsiElement> parametersByRefNames) {
        if (parametersByRefNames.isEmpty()) {
            return;
        }
        PhpClassHierarchyUtils.processSuperMethods((Method)method, (member, subClass, baseClass) -> {
            for (CharSequence parameterName : PhpParameterByRefIsNotUsedAsReferenceInspection.getParametersByRefNames((com.jetbrains.php.lang.psi.elements.Function)member).keySet()) {
                parametersByRefNames.remove(parameterName);
            }
            return false;
        });
        if (parametersByRefNames.isEmpty()) {
            return;
        }
        PhpClassHierarchyUtils.processOverridingMethods((Method)method, (member, subClass, baseClass) -> {
            for (CharSequence parameterName : PhpParameterByRefIsNotUsedAsReferenceInspection.getParametersByRefNames((com.jetbrains.php.lang.psi.elements.Function)member).keySet()) {
                parametersByRefNames.remove(parameterName);
            }
            return false;
        });
    }

    private static void doCheck(com.jetbrains.php.lang.psi.elements.Function function, @NotNull ProblemsHolder holder, Map<CharSequence, PsiElement> parametersByRefWithNames) {
        if (holder == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(3);
        }
        if (parametersByRefWithNames.isEmpty()) {
            return;
        }
        for (PsiElement parameter : PhpParameterByRefIsNotUsedAsReferenceInspection.getUnusedAsRefParameters(function, parametersByRefWithNames)) {
            PsiElement bitAnd = PhpPsiUtil.getChildOfType(parameter, PhpTokenTypes.opBIT_AND);
            if (bitAnd == null) continue;
            PhpParameterByRefIsNotUsedAsReferenceInspection.registerProblem(holder, bitAnd);
        }
    }

    private static void registerProblem(@NotNull ProblemsHolder holder, PsiElement bitAnd) {
        if (holder == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(4);
        }
        holder.registerProblem(bitAnd, PhpBundle.message("pass.by.ref.is.not.effectively.used.inside.body", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new PhpDeleteElementQuickFix(bitAnd, PhpBundle.message("remove.pass.by.ref", new Object[0]))});
    }

    @NotNull
    public static Collection<PsiElement> getUnusedAsRefParameters(com.jetbrains.php.lang.psi.elements.Function function, Map<CharSequence, PsiElement> parametersByRefWithNames) {
        HashMap<CharSequence, PsiElement> copy = new HashMap<CharSequence, PsiElement>(parametersByRefWithNames);
        PhpControlFlowUtil.processFlow(function.getControlFlow(), PhpParameterByRefIsNotUsedAsReferenceInspection.createProcessorToRemoveUsedRefDeclarations(copy));
        Collection<PsiElement> collection = copy.values();
        if (collection == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    private static PhpInstructionProcessor createProcessorToRemoveUsedRefDeclarations(final Map<CharSequence, PsiElement> declarationsByRefWithNames) {
        final HashSet<PsiElement> writeRefDeclarations = new HashSet<PsiElement>(declarationsByRefWithNames.values());
        return new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                Variable iteratedArray;
                PhpPsiElement anchor;
                ForeachStatement foreachStatement;
                CharSequence name = instruction.getVariableName();
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (declarationsByRefWithNames.containsKey(name) && PhpParameterByRefIsNotUsedAsReferenceInspection.mayBeRefAccess((PhpAccessInstruction)instruction)) {
                    declarationsByRefWithNames.remove(name);
                } else if (access.isWriteRef() && (foreachStatement = (ForeachStatement)ObjectUtils.tryCast((Object)(anchor = instruction.getAnchor()).getParent(), ForeachStatement.class)) != null && foreachStatement.getValue() == anchor && (iteratedArray = PhpParameterByRefIsNotUsedAsReferenceInspection.getBaseIteratedArray(foreachStatement)) != null && ContainerUtil.intersects((Collection)iteratedArray.resolveLocal(), (Collection)writeRefDeclarations)) {
                    declarationsByRefWithNames.remove(iteratedArray.getName());
                }
                return !declarationsByRefWithNames.isEmpty();
            }

            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                CharSequence name = PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction);
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (declarationsByRefWithNames.containsKey(name) && (PhpParameterByRefIsNotUsedAsReferenceInspection.mayBeRefAccess((PhpAccessInstruction)instruction) || access.isUnset())) {
                    declarationsByRefWithNames.remove(name);
                }
                return !declarationsByRefWithNames.isEmpty();
            }
        };
    }

    @Nullable
    private static Variable getBaseIteratedArray(ForeachStatement foreachStatement) {
        PsiElement array = foreachStatement.getArray();
        while (array instanceof ArrayAccessExpression) {
            array = ((ArrayAccessExpression)array).getValue();
        }
        return (Variable)ObjectUtils.tryCast((Object)array, Variable.class);
    }

    private static boolean parameterOfUnresolvedCall(PhpAccessInstruction instruction) {
        if (((PhpAccessInstructionImpl)instruction).isReadOrReadRefAccessLocalAware()) {
            FunctionReference functionReference = (FunctionReference)PhpPsiUtil.getParentByCondition((PsiElement)instruction.getAnchor(), (Condition<? super PsiElement>)FunctionReference.INSTANCEOF);
            return functionReference != null && (functionReference.getName() == null || functionReference.multiResolve(false).length == 0);
        }
        return false;
    }

    private static Map<CharSequence, PsiElement> getParametersByRefNames(com.jetbrains.php.lang.psi.elements.Function function) {
        if (!function.hasRefParams()) {
            return Collections.emptyMap();
        }
        TIntObjectHashMap<PhpUnusedParameterInspection.ParameterNotUsedReason> unusedParameters = PhpUnusedParameterInspection.getUnusedParameters(function.getParameters(), (PhpScopeHolder)function, false);
        Parameter[] parameters = function.getParameters();
        return PhpParameterByRefIsNotUsedAsReferenceInspection.getParametersByRefNames(parameters, unusedParameters.keys());
    }

    @NotNull
    public static Map<CharSequence, PsiElement> getParametersByRefNames(Parameter[] parameters, int[] keys) {
        Map<CharSequence, PsiElement> map = IntStream.range(0, parameters.length).filter(i -> ArrayUtil.indexOf((int[])keys, (int)i) < 0).mapToObj(i -> parameters[i]).filter(Parameter::isPassByRef).collect(Collectors.toMap(Parameter::getName, Function.identity(), (e, e2) -> e));
        if (map == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(6);
        }
        return map;
    }

    private static boolean mayBeRefAccess(@NotNull PhpAccessInstruction instruction) {
        PhpAccessInstruction.Access access;
        if (instruction == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(7);
        }
        return (access = instruction.getAccess()).isWriteRef() || access.isReadRef() || access.isWrite() || PhpParameterByRefIsNotUsedAsReferenceInspection.parameterOfUnresolvedCall(instruction) || PhpParameterByRefIsNotUsedAsReferenceInspection.isReturnFromRetByRefFunction(instruction);
    }

    private static boolean isReturnFromRetByRefFunction(@NotNull PhpAccessInstruction instruction) {
        PhpReturn phpReturn;
        if (instruction == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(8);
        }
        return (phpReturn = (PhpReturn)PhpPsiUtil.getParentByCondition((PsiElement)instruction.getAnchor(), (Condition<? super PsiElement>)PhpReturn.INSTANCEOF)) != null && PhpPsiUtil.unparenthesize(phpReturn.getArgument()) == instruction.getAnchor() && PhpExpressionAlwaysNullInspection.insideReturnByReferenceFunction(phpReturn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreach";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpParameterByRefIsNotUsedAsReferenceInspection";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpParameterByRefIsNotUsedAsReferenceInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedAsRefParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersByRefNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isForeachValuePassByRefIsNotUsed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayChangesInsideForeach";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCheck";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mayBeRefAccess";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isReturnFromRetByRefFunction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

