/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpLoopCanBeReplacedWithStrRepeatInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpLoopCanBeReplacedWithStrRepeatInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFor(For forStatement) {
                if (PhpLoopCanBeReplacedWithStrRepeatInspection.isCountLoop(forStatement) && PhpLoopCanBeReplacedWithStrRepeatInspection.getConcatenatedVariableName(forStatement) != null) {
                    holder.registerProblem(forStatement.getFirstChild(), PhpBundle.message("inspection.message.for.loop.can.be.replaced.with.str.repeat", new Object[0]), new LocalQuickFix[]{PhpReplaceWithStrRepeatCallQuickFix.INSTANCE});
                }
            }
        };
    }

    @Nullable
    private static String getConcatenatedVariableName(@NotNull For forStatement) {
        SelfAssignmentExpression singleExpression;
        if (forStatement == null) {
            PhpLoopCanBeReplacedWithStrRepeatInspection.$$$reportNull$$$0(1);
        }
        return (singleExpression = PhpLoopCanBeReplacedWithStrRepeatInspection.getSingleExpression(forStatement)) != null ? PhpLoopCanBeReplacedWithStrRepeatInspection.getImpotentlyConcatenatedVariable(PhpLoopCanBeReplacedWithStrRepeatInspection.getCountLoopVariableName(forStatement), singleExpression) : null;
    }

    @Nullable
    private static SelfAssignmentExpression getSingleExpression(@NotNull For forStatement) {
        Statement statement;
        if (forStatement == null) {
            PhpLoopCanBeReplacedWithStrRepeatInspection.$$$reportNull$$$0(2);
        }
        Statement innerStatement = (statement = forStatement.getStatement()) instanceof GroupStatement ? ((GroupStatement)statement).getOnlyStatement() : statement;
        return innerStatement instanceof Statement ? PhpLoopCanBeReplacedWithStrRepeatInspection.getOnlyItem(innerStatement.getChildren(), SelfAssignmentExpression.class) : null;
    }

    private static boolean isCountLoop(@NotNull For statement) {
        String countVariableName;
        if (statement == null) {
            PhpLoopCanBeReplacedWithStrRepeatInspection.$$$reportNull$$$0(3);
        }
        if ((countVariableName = PhpLoopCanBeReplacedWithStrRepeatInspection.getCountLoopVariableName(statement)) == null) {
            return false;
        }
        String limitText = PhpLoopCanBeReplacedWithStrRepeatInspection.getLimitText(statement, countVariableName);
        if (limitText == null) {
            return false;
        }
        UnaryExpression repeatedExpression = PhpLoopCanBeReplacedWithStrRepeatInspection.getOnlyItem(statement.getRepeatedExpressions(), UnaryExpression.class);
        if (repeatedExpression == null) {
            return false;
        }
        PhpPsiElement value = repeatedExpression.getValue();
        return value instanceof Variable && PhpLangUtil.equalsVariableNames(value.getName(), countVariableName) && PhpPsiUtil.isOfType(repeatedExpression.getOperation(), PhpTokenTypes.opINCREMENT);
    }

    private static String getCountLoopVariableName(@NotNull For statement) {
        AssignmentExpression assignmentExpression;
        if (statement == null) {
            PhpLoopCanBeReplacedWithStrRepeatInspection.$$$reportNull$$$0(4);
        }
        if ((assignmentExpression = PhpLoopCanBeReplacedWithStrRepeatInspection.getOnlyItem(statement.getInitialExpressions(), AssignmentExpression.class)) == null) {
            return null;
        }
        Variable variable = (Variable)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), Variable.class);
        PhpPsiElement value = assignmentExpression.getValue();
        if (variable == null || !PhpPsiUtil.isOfType((PsiElement)value, PhpElementTypes.NUMBER) || !value.getText().equals("0")) {
            return null;
        }
        return variable.getName();
    }

    private static String getLimitText(@NotNull For statement, @NotNull String countVariableName) {
        String rightText;
        BinaryExpression condition;
        if (statement == null) {
            PhpLoopCanBeReplacedWithStrRepeatInspection.$$$reportNull$$$0(5);
        }
        if (countVariableName == null) {
            PhpLoopCanBeReplacedWithStrRepeatInspection.$$$reportNull$$$0(6);
        }
        if ((condition = PhpLoopCanBeReplacedWithStrRepeatInspection.getOnlyItem(statement.getConditionalExpressions(), BinaryExpression.class)) == null) {
            return null;
        }
        IElementType type = condition.getOperationType();
        if (type != PhpTokenTypes.opLESS && type != PhpTokenTypes.opLESS_OR_EQUAL) {
            return null;
        }
        PsiElement left = condition.getLeftOperand();
        if (!(left instanceof Variable) || !PhpLangUtil.equalsVariableNames(((Variable)left).getName(), countVariableName)) {
            return null;
        }
        PsiElement right = condition.getRightOperand();
        if (PhpSideEffectDetector.canContainSideEffect(right, true, true)) {
            return null;
        }
        String string = rightText = right != null ? right.getText() : null;
        if (rightText == null) {
            return null;
        }
        return type == PhpTokenTypes.opLESS ? rightText : rightText + " + 1";
    }

    public static <T, C> C getOnlyItem(T[] values, Class<C> clazz) {
        return (C)(values.length == 1 ? ObjectUtils.tryCast(values[0], clazz) : null);
    }

    private static String getImpotentlyConcatenatedVariable(@NotNull String countLoopVariableName, @NotNull SelfAssignmentExpression singleExpression) {
        if (countLoopVariableName == null) {
            PhpLoopCanBeReplacedWithStrRepeatInspection.$$$reportNull$$$0(7);
        }
        if (singleExpression == null) {
            PhpLoopCanBeReplacedWithStrRepeatInspection.$$$reportNull$$$0(8);
        }
        if (singleExpression.getOperationType() != PhpTokenTypes.opCONCAT_ASGN) {
            return null;
        }
        PhpPsiElement variable = singleExpression.getVariable();
        return variable instanceof Variable && !PhpLoopCanBeReplacedWithStrRepeatInspection.canContainSideEffect(singleExpression.getValue(), countLoopVariableName, variable.getName()) ? variable.getName() : null;
    }

    private static boolean canContainSideEffect(@Nullable PhpPsiElement value, String ... variableNames) {
        Collection variables = PsiTreeUtil.findChildrenOfType((PsiElement)value, Variable.class);
        return ContainerUtil.exists((Iterable)variables, v -> PhpLoopCanBeReplacedWithStrRepeatInspection.isDependentVariable(v.getName(), variableNames)) || PhpSideEffectDetector.canContainSideEffect((PsiElement)value, true, true);
    }

    private static boolean isDependentVariable(@Nullable String name, String[] dependentVariableNames) {
        return ContainerUtil.exists((Object[])dependentVariableNames, n -> PhpLangUtil.equalsVariableNames(name, n));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "countVariableName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "countLoopVariableName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleExpression";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpLoopCanBeReplacedWithStrRepeatInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getConcatenatedVariableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSingleExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCountLoop";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCountLoopVariableName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getLimitText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getImpotentlyConcatenatedVariable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpReplaceWithStrRepeatCallQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpReplaceWithStrRepeatCallQuickFix();

        private PhpReplaceWithStrRepeatCallQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.str.repeat.call", new Object[0]);
            if (string == null) {
                PhpReplaceWithStrRepeatCallQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            For statement;
            String countVariableName;
            if (project == null) {
                PhpReplaceWithStrRepeatCallQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpReplaceWithStrRepeatCallQuickFix.$$$reportNull$$$0(2);
            }
            if ((countVariableName = PhpLoopCanBeReplacedWithStrRepeatInspection.getCountLoopVariableName(statement = (For)descriptor.getStartElement().getParent())) == null) {
                return;
            }
            String limitText = PhpLoopCanBeReplacedWithStrRepeatInspection.getLimitText(statement, countVariableName);
            if (limitText == null) {
                return;
            }
            SelfAssignmentExpression expression = PhpLoopCanBeReplacedWithStrRepeatInspection.getSingleExpression(statement);
            if (expression == null) {
                return;
            }
            PhpPsiElement variable = expression.getVariable();
            PhpPsiElement value = expression.getValue();
            if (variable == null || value == null) {
                return;
            }
            PsiElement statementToReplace = PhpPsiElementFactory.createPhpPsiFromText(project, SelfAssignmentExpression.class, String.format("%s .= str_repeat(%s, %s);", variable.getText(), value.getText(), limitText)).getParent();
            statement.replace(statementToReplace);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpLoopCanBeReplacedWithStrRepeatInspection$PhpReplaceWithStrRepeatCallQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpLoopCanBeReplacedWithStrRepeatInspection$PhpReplaceWithStrRepeatCallQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

